/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tools.attach.javaSE;

import com.ibm.oti.util.Msg;
import com.ibm.tools.attach.AttachNotSupportedException;
import com.ibm.tools.attach.AttachPermission;
import com.ibm.tools.attach.VirtualMachineDescriptor;
import com.ibm.tools.attach.javaSE.IPC;
import com.ibm.tools.attach.javaSE.VirtualMachine;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttachProvider
extends com.ibm.tools.attach.spi.AttachProvider {
    private static AttachPermission attachPerm = new AttachPermission("attachVirtualMachine", null);

    @Override
    public com.ibm.tools.attach.VirtualMachine attachVirtualMachine(String string) throws AttachNotSupportedException, IOException {
        AttachProvider.checkAttachSecurity();
        VirtualMachine virtualMachine = new VirtualMachine(this, string);
        virtualMachine.attachTarget();
        return virtualMachine;
    }

    @Override
    public com.ibm.tools.attach.VirtualMachine attachVirtualMachine(VirtualMachineDescriptor virtualMachineDescriptor) throws AttachNotSupportedException, IOException {
        AttachProvider.checkAttachSecurity();
        com.ibm.tools.attach.spi.AttachProvider attachProvider = virtualMachineDescriptor.provider();
        if (attachProvider.getClass() != this.getClass()) {
            throw new AttachNotSupportedException(Msg.getString("K0543"));
        }
        VirtualMachine virtualMachine = new VirtualMachine(this, virtualMachineDescriptor.id());
        virtualMachine.attachTarget();
        return virtualMachine;
    }

    @Override
    public List<VirtualMachineDescriptor> listVirtualMachines() {
        File file = IPC.getCommonDir();
        ArrayList<VirtualMachineDescriptor> arrayList = new ArrayList<VirtualMachineDescriptor>();
        if (!file.isDirectory()) {
            return null;
        }
        File[] fileArray = file.listFiles();
        if (null != fileArray) {
            for (File file2 : fileArray) {
                int n;
                com.ibm.tools.attach.javaSE.VirtualMachineDescriptor virtualMachineDescriptor;
                if (!file2.isDirectory()) continue;
                boolean bl = true;
                File file3 = new File(file2.getAbsolutePath() + File.separatorChar + IPC.getAdvertFilename());
                if (file3.exists() && null != (virtualMachineDescriptor = com.ibm.tools.attach.javaSE.VirtualMachineDescriptor.virtualMachineDescriptorFactory(this, file3)) && (0 == (n = virtualMachineDescriptor.getProcessId()) || IPC.processExists(n))) {
                    arrayList.add(virtualMachineDescriptor);
                    bl = false;
                }
                if (!bl) continue;
                IPC.deleteAdvertisementDir(file2.getName());
            }
        }
        return arrayList;
    }

    VirtualMachineDescriptor getDescriptor(String string) {
        List<VirtualMachineDescriptor> list = this.listVirtualMachines();
        if (null != list) {
            for (VirtualMachineDescriptor virtualMachineDescriptor : list) {
                if (!virtualMachineDescriptor.id().equalsIgnoreCase(string)) continue;
                return virtualMachineDescriptor;
            }
        }
        return null;
    }

    @Override
    public String name() {
        return "IBM";
    }

    @Override
    public String type() {
        return "Java SE";
    }

    private static void checkAttachSecurity() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(attachPerm);
        }
    }
}

