/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tools.attach.javaSE;

import com.ibm.oti.util.Msg;
import com.ibm.oti.util.Util;
import com.ibm.tools.attach.javaSE.AttachHandler;
import com.ibm.tools.attach.javaSE.BlockingFileLockManager;
import com.ibm.tools.attach.javaSE.FileLockManager;
import com.ibm.tools.attach.javaSE.NonBlockingFileLockManager;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.util.Properties;

class IPC {
    private static final String ATTACH_API_VERSION = "0.1";
    static final String KEY_REPLY_FILE = "replyFile";
    static final String KEY_ATTACH_SYNC_FILE = "attachNotificationSync";
    static final String KEY_NOTIFIER = "notifier";
    static final String KEY_DISPLAY_NAME = "displayName";
    static final String KEY_VM_ID = "vmId";
    static final String KEY_PROCESS_ID = "processId";
    static final String KEY_USER_ID = "userId";
    static final String KEY_VERSION_ID = "version";
    private static final String ADVERT_FILENAME = "attachInfo";
    private static final String REPLY_FILENAME = "replyInfo";
    private static final String ATTACH_NOTIFICATION_SYNC_FILENAME = "attachNotificationSync";
    private static final String MASTER_LOCKFILE = "_master";
    private static final String MASTER_NOTIFIER = "_notifier";
    private static final String ATTACH_LOCK = "_attachlock";
    private static final int cdPerms = 1023;
    private static final int mfPerms = 511;
    private static final int ndPerms = 969;
    private static final int nsfperms = 420;
    private static final int advertPerms = 384;
    private static final int replyPerms = 384;
    static final String COM_IBM_TOOLS_ATTACH_DIRECTORY = "com.ibm.tools.attach.directory";
    static final int JNI_OK = 0;
    static final int J9PORT_INFO_SHSEM_OPENED_STALE = 103;
    static final String notificationDirectoryName = ".com_ibm_tools_attach";
    private static String ipcDir = null;
    private static String systemTmpDir = IPC.getTmpDir();
    private static final File commonDir = IPC.initializeCommonDir();
    boolean semaphoreReady = false;
    private String vmId = null;
    private String semaphoreId = null;
    private FileLockManager masterLock;
    private FileLockManager attachLock;

    IPC(String string) {
        this.setVmId(string);
        if (null == this.getVmId()) {
            throw new NullPointerException();
        }
    }

    IPC() {
    }

    static String getIPCDir() {
        return ipcDir;
    }

    boolean prepareIPC(String string) {
        char c = File.separatorChar;
        if (string.indexOf(32) != -1) {
            return false;
        }
        if (c != string.charAt(string.length() - 1)) {
            string = string + c;
        }
        ipcDir = string;
        if (!this.semaphoreReady && this.setupSemaphore(ipcDir)) {
            this.semaphoreReady = true;
        }
        return true;
    }

    static int mkdirWithPermissions(String string, int n) throws IOException {
        int n2 = IPC.mkdirWithPermissionsImpl(string, n);
        if (0 != n2) {
            throw new IOException(string);
        }
        return n2;
    }

    static native int mkdirWithPermissionsImpl(String var0, int var1);

    boolean setupSemaphore(String string) {
        int n = this.setupSemaphoreImpl(string);
        return n == 0;
    }

    private native int setupSemaphoreImpl(String var1);

    String openSemaphore() throws IOException {
        if (null == this.getVmId()) {
            throw new IOException(Msg.getString("K0537"));
        }
        String string = this.getSemaphoreName();
        int n = this.openSemaphoreImpl(IPC.getCommonDir().getAbsolutePath(), string);
        if (0 != n) {
            throw new IOException(Msg.getString("K0538 ", string, n));
        }
        return string;
    }

    int reopenSemaphore() {
        int n = 0;
        this.closeSemaphore();
        n = this.openSemaphoreImpl(IPC.getCommonDir().getAbsolutePath(), this.getSemaphoreName());
        return n;
    }

    private native int openSemaphoreImpl(String var1, String var2);

    int waitSemaphore(String string) throws IOException {
        int n = this.waitSemaphoreImpl();
        if (0 != n) {
            AttachHandler.logMessage("waitSemaphore status != JNI_OK, ==" + n);
            throw new IOException(Msg.getString("K0536", this.getSemaphoreName(), Integer.toString(n)));
        }
        return n;
    }

    private native int waitSemaphoreImpl();

    int notifyVm(int n) {
        AttachHandler.logMessage("notifyVm " + n + " targets");
        return this.notifyVmImpl(IPC.getCommonDir().getAbsolutePath(), this.getSemaphoreName(), n);
    }

    private native int notifyVmImpl(String var1, String var2, int var3);

    int cancelNotify(int n) {
        return this.cancelNotifyImpl(IPC.getCommonDir().getAbsolutePath(), this.getSemaphoreName(), n);
    }

    private native int cancelNotifyImpl(String var1, String var2, int var3);

    void closeSemaphore() {
        this.closeSemaphoreImpl();
    }

    private native void closeSemaphoreImpl();

    void destroySemaphore() {
        this.destroySemaphoreImpl();
    }

    private native void destroySemaphoreImpl();

    public static int getProcessId() {
        return IPC.getProcessIdImpl();
    }

    private static native int getProcessIdImpl();

    public static boolean processExists(int n) {
        int n2 = IPC.processExistsImpl(n);
        return n2 > 0;
    }

    private static native int processExistsImpl(int var0);

    static void createCommonIPCDir() throws IOException {
        File file = IPC.getCommonDir();
        if (file.exists()) {
            if (!file.canWrite()) {
                throw new IOException(file.getAbsolutePath());
            }
            if (!file.isDirectory()) {
                file.delete();
                IPC.mkdirWithPermissions(file.getAbsolutePath(), 1023);
            }
        } else {
            IPC.mkdirWithPermissions(file.getAbsolutePath(), 1023);
        }
    }

    String createTargetIPCDir(String string, boolean bl) throws IOException {
        String string2 = string;
        File file = new File(IPC.getTargetDirectoryPath(string2));
        int n = 0;
        if (!bl) {
            while (file.exists() & n < 100) {
                string2 = string + '_' + n;
                file = new File(IPC.getTargetDirectoryPath(string2));
                ++n;
            }
        }
        if (file.exists()) {
            throw new IOException();
        }
        IPC.mkdirWithPermissions(file.getAbsolutePath(), 969);
        IPC.createNotificationSyncFile(string2);
        return string2;
    }

    void obtainMasterLock(File file) throws IOException {
        File file2 = IPC.getMasterLockfile();
        if (!file2.exists()) {
            file2.createNewFile();
            IPC.chmod(file2.getAbsolutePath(), 511);
        }
        this.masterLock = new BlockingFileLockManager(file2);
        this.masterLock.obtainLock();
        File file3 = new File(commonDir.getAbsolutePath(), MASTER_NOTIFIER);
        if (!file3.exists()) {
            file3.createNewFile();
            IPC.chmod(file3.getAbsolutePath(), 511);
        }
    }

    private static File getMasterLockfile() {
        return new File(commonDir.getAbsolutePath(), MASTER_LOCKFILE);
    }

    void obtainAttachLock(File file) throws IOException {
        File file2 = IPC.getAttachLockfile();
        if (!file2.exists()) {
            file2.createNewFile();
            IPC.chmod(file2.getAbsolutePath(), 511);
        }
        this.attachLock = new BlockingFileLockManager(file2);
        this.attachLock.obtainLock();
    }

    void obtainAttachLock() throws IOException {
        this.obtainAttachLock(IPC.getCommonDir());
    }

    private static File getAttachLockfile() {
        return new File(commonDir.getAbsolutePath(), ATTACH_LOCK);
    }

    boolean tryObtainMasterLock() {
        try {
            this.masterLock = new NonBlockingFileLockManager(IPC.getMasterLockfile());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return this.masterLock.obtainLock();
    }

    void obtainMasterLock() throws IOException {
        this.obtainMasterLock(IPC.getCommonDir());
    }

    void releaseMasterLock() {
        this.masterLock.releaseLock();
    }

    void releaseAttachLock() {
        if (null != this.attachLock) {
            this.attachLock.releaseLock();
        }
    }

    static File getCommonDir() {
        return commonDir;
    }

    static File initializeCommonDir() {
        String string = System.getProperty(COM_IBM_TOOLS_ATTACH_DIRECTORY);
        if (null == string) {
            string = new File(systemTmpDir, notificationDirectoryName).getPath();
        }
        File file = new File(string);
        return file;
    }

    Properties createAdvertContent(String string, String string2) {
        if (null == string2 || string2.length() == 0) {
            string2 = string;
        }
        String string3 = Integer.toString(IPC.getProcessId());
        String string4 = System.getProperty("user.name");
        Properties properties = new Properties();
        properties.setProperty(KEY_VERSION_ID, ATTACH_API_VERSION);
        properties.setProperty(KEY_USER_ID, string4);
        properties.setProperty(KEY_PROCESS_ID, string3);
        properties.setProperty(KEY_VM_ID, string);
        properties.setProperty(KEY_DISPLAY_NAME, string2);
        properties.setProperty(KEY_NOTIFIER, this.getSemaphoreName());
        properties.setProperty(KEY_REPLY_FILE, IPC.getReplyPath(string));
        properties.setProperty("attachNotificationSync", IPC.getNotificationSyncFile(string).getAbsolutePath());
        return properties;
    }

    static void createAdvertisementFile(String string, Properties properties) throws IOException {
        String string2 = new File(IPC.getTargetDirectoryPath(string), ADVERT_FILENAME).getPath();
        File file = new File(string2);
        try {
            file.deleteOnExit();
        }
        catch (IllegalStateException illegalStateException) {
            AttachHandler.logMessage("createAdvertisementFile state exception");
            return;
        }
        IPC.createFileWithPermissions(file.getAbsolutePath(), 384);
        try {
            PrintStream printStream = new PrintStream(file);
            properties.store(printStream, null);
            printStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            IOException iOException = new IOException(file.getAbsolutePath());
            throw iOException;
        }
        AttachHandler.logMessage("createAdvertisementFile " + string);
    }

    static Properties readAdvertisementFile(InputStream inputStream) {
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        catch (IOException iOException) {
            properties = null;
        }
        return properties;
    }

    static void createNotificationSyncFile(String string) throws IOException {
        File file = IPC.getNotificationSyncFile(string);
        if (!file.exists()) {
            file.createNewFile();
            IPC.chmod(file.getAbsolutePath(), 420);
        }
        try {
            file.deleteOnExit();
        }
        catch (IllegalStateException illegalStateException) {
            AttachHandler.logMessage("createAdvertisementFile state exception");
        }
    }

    static File getNotificationSyncFile(String string) {
        File file = new File(IPC.getTargetDirectoryPath(string), "attachNotificationSync");
        return file;
    }

    File getNotificationSyncFile() {
        String string = new File(IPC.getTargetDirectoryPath(this.getVmId()), "attachNotificationSync").getPath();
        File file = new File(string);
        return file;
    }

    static void deleteAdvertisementDir(String string) {
        if (null != string) {
            File file = new File(IPC.getTargetDirectoryPath(string));
            File[] fileArray = file.listFiles();
            if (null != fileArray) {
                for (File file2 : fileArray) {
                    file2.delete();
                }
            }
            file.delete();
        }
    }

    static ReplyContent readReply(String string) throws IOException {
        String string2 = IPC.getReplyPath(string);
        try {
            int n;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string2));
            String string3 = bufferedReader.readLine();
            String string4 = bufferedReader.readLine();
            bufferedReader.close();
            try {
                n = Integer.parseInt(string4);
            }
            catch (NumberFormatException numberFormatException) {
                int n2 = -1;
                throw new IOException(numberFormatException.getMessage());
            }
            ReplyContent replyContent = new ReplyContent(n, string3);
            return replyContent;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    static int chmod(String string, int n) {
        return IPC.chmodImpl(string, n);
    }

    private static native int chmodImpl(String var0, int var1);

    private static void createFileWithPermissions(String string, int n) throws IOException {
        int n2 = IPC.createFileWithPermissionsImpl(string, n);
        if (0 != n2) {
            throw new IOException(string);
        }
    }

    private static native int createFileWithPermissionsImpl(String var0, int var1);

    static String getTmpDir() {
        byte[] byArray = IPC.getTmpDirImpl();
        String string = null;
        string = null != byArray ? Util.toString(byArray, 0, byArray.length) : System.getProperty("java.io.tmpdir");
        return string;
    }

    private static native byte[] getTmpDirImpl();

    String getSemaphoreName() {
        if (null == this.semaphoreId) {
            this.semaphoreId = MASTER_NOTIFIER;
        }
        return this.semaphoreId;
    }

    void setSemaphoreName(String string) {
        this.semaphoreId = string;
    }

    static String getAdvertFilename() {
        return ADVERT_FILENAME;
    }

    static String getTargetDirectoryPath(String string) {
        return new File(IPC.getCommonDir().getAbsolutePath(), string).getPath();
    }

    static String getReplyPath(String string) {
        return new File(IPC.getTargetDirectoryPath(string), REPLY_FILENAME).getPath();
    }

    synchronized String getVmId() {
        return this.vmId;
    }

    synchronized void setVmId(String string) {
        this.vmId = string;
    }

    static void streamSend(OutputStream outputStream, String string) throws IOException {
        AttachHandler.logMessage("streamSend " + string);
        if (null == outputStream) {
            throw new IOException();
        }
        outputStream.write(string.getBytes("UTF8"));
        outputStream.write(0);
        outputStream.flush();
    }

    static String streamReceiveString(InputStream inputStream) throws IOException {
        byte[] byArray = IPC.streamReceiveBytes(inputStream);
        String string = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(byArray), "UTF8")).readLine();
        return string;
    }

    static byte[] streamReceiveBytes(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[100000];
        int n = 0;
        boolean bl = false;
        if (null == inputStream) {
            throw new IOException();
        }
        while (!bl && n < 100000) {
            int n2 = inputStream.read(byArray, n, 100000 - n);
            if (n2 > 0) {
                if (byArray[(n += n2) - 1] != 0) continue;
                bl = true;
                continue;
            }
            throw new IOException();
        }
        if (!bl) {
            n = 0;
        }
        return byArray;
    }

    static int CountTargetDirectories() {
        File file = IPC.getCommonDir();
        if (!file.isDirectory()) {
            return 0;
        }
        File[] fileArray = file.listFiles();
        if (null == fileArray) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < fileArray.length; ++i) {
            if (ATTACH_LOCK.equalsIgnoreCase(fileArray[i].getName()) || MASTER_LOCKFILE.equalsIgnoreCase(fileArray[i].getName()) || MASTER_NOTIFIER.equalsIgnoreCase(fileArray[i].getName())) continue;
            ++n;
        }
        return n;
    }

    static class ReplyFileset {
        private final File replyFile;
        private RandomAccessFile replyChannelRAF;

        ReplyFileset(String string) {
            File file = null;
            file = new File(string, IPC.REPLY_FILENAME);
            try {
                file.deleteOnExit();
            }
            catch (IllegalStateException illegalStateException) {
                AttachHandler.logMessage("ReplyFileset state exception");
            }
            this.replyFile = file;
        }

        void writeReply(String string, String string2) throws IOException {
            if (null != this.replyFile) {
                try {
                    this.replyChannelRAF = new RandomAccessFile(this.replyFile, "rw");
                    IPC.chmod(this.replyFile.getAbsolutePath(), 384);
                    this.replyChannelRAF.setLength(0L);
                    this.replyChannelRAF.writeBytes(string + '\n');
                    this.replyChannelRAF.writeBytes(string2 + '\n');
                    this.replyChannelRAF.close();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new IOException(this.replyFile.getAbsolutePath());
                }
            }
        }

        void eraseReply() {
            if (null != this.replyFile) {
                this.replyFile.delete();
            }
        }
    }

    static class ReplyContent {
        private final int portNumber;
        private final String key;

        ReplyContent(int n, String string) {
            this.portNumber = n;
            this.key = string;
        }

        synchronized int getPortNumber() {
            return this.portNumber;
        }

        synchronized String getKey() {
            return this.key;
        }
    }
}

