/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tools.attach.javaSE;

import com.ibm.tools.attach.javaSE.FileLockManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;

class NonBlockingFileLockManager
implements FileLockManager {
    final File myLockFile;
    private RandomAccessFile lockRAF;
    private FileChannel lockChannel;
    private FileLock myLock;

    public NonBlockingFileLockManager(File file) {
        this.myLockFile = file;
        try {
            this.openLockChannel();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.lockChannel = null;
        }
    }

    public synchronized boolean obtainLock() {
        try {
            if (null != this.lockChannel) {
                this.myLock = this.lockChannel.tryLock();
            }
        }
        catch (OverlappingFileLockException overlappingFileLockException) {
            return true;
        }
        catch (ClosedChannelException closedChannelException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
        return null != this.myLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void releaseLock() {
        try {
            if (null != this.myLock) {
                this.myLock.release();
            }
        }
        catch (IOException iOException) {
            this.myLock = null;
        }
        finally {
            this.closeLockChannel();
        }
    }

    private void openLockChannel() throws FileNotFoundException {
        this.lockRAF = new RandomAccessFile(this.myLockFile, "rw");
        this.lockChannel = this.lockRAF.getChannel();
    }

    private void closeLockChannel() {
        try {
            if (null != this.lockChannel) {
                this.lockChannel.close();
                this.lockChannel = null;
            }
            if (null != this.lockRAF) {
                this.lockRAF.close();
            }
        }
        catch (IOException iOException) {
            return;
        }
    }
}

