/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tools.attach.javaSE;

import com.ibm.tools.attach.javaSE.IPC;
import com.ibm.tools.attach.spi.AttachProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

class VirtualMachineDescriptor
extends com.ibm.tools.attach.VirtualMachineDescriptor {
    private final String notifierId;
    private final String replyFile;
    private final String attachSyncFileValue;
    private final int processId;

    public VirtualMachineDescriptor(AttachProvider attachProvider, String string, String string2) {
        super(attachProvider, string, string2);
        this.notifierId = null;
        this.attachSyncFileValue = null;
        this.replyFile = null;
        this.processId = 0;
    }

    public VirtualMachineDescriptor(AttachProvider attachProvider, String string) {
        super(attachProvider, string);
        this.notifierId = null;
        this.attachSyncFileValue = null;
        this.replyFile = null;
        this.processId = 0;
    }

    public VirtualMachineDescriptor(AttachProvider attachProvider, String string, String string2, String string3, String string4, String string5, String string6) {
        super(attachProvider, string, null == string2 ? string : string2);
        int n;
        this.notifierId = string3;
        this.attachSyncFileValue = string5;
        this.replyFile = string4;
        try {
            n = Integer.parseInt(string6);
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        this.processId = n;
    }

    int getProcessId() {
        return this.processId;
    }

    static VirtualMachineDescriptor virtualMachineDescriptorFactory(AttachProvider attachProvider, File file) {
        String string = "";
        String string2 = null;
        String string3 = "";
        String string4 = "";
        String string5 = "";
        VirtualMachineDescriptor virtualMachineDescriptor = null;
        String string6 = "0";
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            Properties properties = IPC.readAdvertisementFile(fileInputStream);
            fileInputStream.close();
            if (null != properties) {
                string = properties.getProperty("vmId");
                string2 = properties.getProperty("displayName");
                string3 = properties.getProperty("notifier");
                string4 = properties.getProperty("replyFile");
                string5 = properties.getProperty("attachNotificationSync");
                string6 = properties.getProperty("processId");
                if (null != string && null != string2) {
                    virtualMachineDescriptor = new VirtualMachineDescriptor(attachProvider, string, string2, string3, string4, string5, string6);
                }
            }
        }
        catch (IOException iOException) {
            virtualMachineDescriptor = null;
        }
        return virtualMachineDescriptor;
    }

    String getNotifierId() {
        return this.notifierId;
    }

    String getReplyFile() {
        return this.replyFile;
    }

    String getAttachSyncFileValue() {
        String string = this.attachSyncFileValue;
        if (null == string) {
            string = IPC.getNotificationSyncFile(this.id()).getAbsolutePath();
        }
        return string;
    }
}

