/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tools.attach.spi;

import com.ibm.oti.util.Msg;
import com.ibm.tools.attach.AttachNotSupportedException;
import com.ibm.tools.attach.AttachPermission;
import com.ibm.tools.attach.VirtualMachine;
import com.ibm.tools.attach.VirtualMachineDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AttachProvider {
    private static final String ATTACH_PROVIDERS_PROPERTY = "com.ibm.attach.providers";
    private static ArrayList<AttachProvider> providerList = null;
    private static final AttachPermission providePerm = new AttachPermission("createAttachProvider", null);
    private static Object myProvidersInitLock = new ProvidersInitLock();

    protected AttachProvider() {
        this.checkProvideSecurity();
    }

    public abstract String name();

    public abstract String type();

    public abstract VirtualMachine attachVirtualMachine(String var1) throws AttachNotSupportedException, IOException;

    public abstract VirtualMachine attachVirtualMachine(VirtualMachineDescriptor var1) throws AttachNotSupportedException, IOException;

    public abstract List<VirtualMachineDescriptor> listVirtualMachines();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<AttachProvider> providers() {
        Object object = myProvidersInitLock;
        synchronized (object) {
            if (null == providerList) {
                providerList = new ArrayList();
                AttachProvider attachProvider = null;
                String string = System.getProperty(ATTACH_PROVIDERS_PROPERTY);
                if (null == string || string.length() == 0) {
                    attachProvider = new com.ibm.tools.attach.javaSE.AttachProvider();
                    providerList.add(attachProvider);
                } else {
                    StringTokenizer stringTokenizer = new StringTokenizer(string, ":;");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string2 = stringTokenizer.nextToken();
                        try {
                            Class<?> clazz = Class.forName(string2);
                            attachProvider = (AttachProvider)clazz.newInstance();
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            String string3 = Msg.getString("K0540", string2, "ClassNotFoundException");
                            throw new IllegalArgumentException(string3);
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            String string4 = Msg.getString("K0540", string2, "IllegalAccessException");
                            throw new IllegalArgumentException(string4);
                        }
                        catch (InstantiationException instantiationException) {
                            String string5 = Msg.getString("K0540", string2, "InstantiationException");
                            throw new IllegalArgumentException(string5);
                        }
                    }
                    providerList.add(attachProvider);
                }
            }
        }
        return providerList;
    }

    private void checkProvideSecurity() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(providePerm);
        }
    }

    private static class ProvidersInitLock {
        private ProvidersInitLock() {
        }
    }
}

