/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.ibm.oti.util.Msg;
import com.ibm.oti.util.Util;
import com.ibm.oti.vm.AbstractClassLoader;
import com.ibm.oti.vm.BootstrapClassLoader;
import com.ibm.oti.vm.VM;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import sun.misc.Launcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClassLoader {
    static ClassLoader systemClassLoader;
    private static ClassLoader applicationClassLoader;
    private static boolean initSystemClassLoader;
    private static boolean reflectCacheEnabled;
    private static boolean reflectCacheAppOnly;
    private static boolean reflectCacheDebug;
    private long vmRef;
    ClassLoader parent;
    private boolean initDone = false;
    private static String[] cachedVMArgs;
    private static boolean checkAssertionOptions;
    private Object assertionLock = new AssertionLock();
    private boolean defaultAssertionStatus;
    private Map packageAssertionStatus;
    private Map classAssertionStatus;
    private Hashtable genericRepository;
    private Hashtable annotationCache;
    private Hashtable packages = new Hashtable();
    private Object lazyInitLock = new LazyInitLock();
    private Hashtable classSigners = null;
    private Hashtable packageSigners = new Hashtable();
    private static Certificate[] emptyCertificates;
    private ProtectionDomain defaultProtectionDomain;
    private final Hashtable methodCache;
    private final Hashtable fieldCache;
    private final Hashtable constructorCache;

    static final void initializeClassLoaders() {
        String string;
        Object object;
        if (systemClassLoader != null) {
            return;
        }
        String string2 = System.getProperty("reflect.cache");
        if (string2 != null) {
            string2 = string2.toLowerCase();
        }
        if (!"false".equals(string2)) {
            reflectCacheEnabled = true;
            if (string2 != null) {
                object = new StringTokenizer(string2, ",");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    string = ((StringTokenizer)object).nextToken();
                    if ("boot".equals(string)) {
                        reflectCacheAppOnly = false;
                    }
                    if (!"debug".equals(string)) continue;
                    reflectCacheDebug = true;
                }
            }
        }
        object = null;
        string = System.getProperty("systemClassLoader");
        if (null == string) {
            object = BootstrapClassLoader.singleton();
        } else {
            try {
                object = (ClassLoader)Class.forName(string, true, null).newInstance();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                System.exit(1);
            }
        }
        systemClassLoader = object;
        AbstractClassLoader.setBootstrapClassLoader(systemClassLoader);
        applicationClassLoader = systemClassLoader;
        applicationClassLoader = Launcher.getLauncher().getClassLoader();
        if (reflectCacheEnabled) {
            Class.initCacheIds();
        }
    }

    protected ClassLoader() {
        this(applicationClassLoader);
    }

    protected ClassLoader(ClassLoader classLoader) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
        if (reflectCacheEnabled) {
            this.methodCache = new Hashtable();
            this.fieldCache = new Hashtable();
            this.constructorCache = new Hashtable();
        } else {
            this.methodCache = null;
            this.fieldCache = null;
            this.constructorCache = null;
        }
        if (classLoader != null && !classLoader.initDone) {
            throw new SecurityException(Msg.getString("K0546"));
        }
        this.parent = classLoader;
        if (systemClassLoader != null) {
            VM.initializeClassLoader(this, false);
        }
        this.initializeClassLoaderAssertStatus();
        this.initDone = true;
    }

    @Deprecated
    protected final Class<?> defineClass(byte[] byArray, int n, int n2) throws ClassFormatError {
        return this.defineClass(null, byArray, n, n2);
    }

    protected final Class<?> defineClass(String string, byte[] byArray, int n, int n2) throws ClassFormatError {
        return this.defineClass(string, byArray, n, n2, null);
    }

    private String checkClassName(String string) {
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            String string2 = string.substring(0, n);
            if (string.startsWith("java.")) {
                throw new SecurityException(Msg.getString("K01d2", string2, string));
            }
            return string2;
        }
        return "";
    }

    protected final Class<?> defineClass(String string, byte[] byArray, int n, int n2, ProtectionDomain protectionDomain) throws ClassFormatError {
        Object object;
        Object[] objectArray = null;
        if (protectionDomain != null && (object = protectionDomain.getCodeSource()) != null) {
            objectArray = ((CodeSource)object).getCertificates();
        }
        if (string != null) {
            object = this.checkClassName(string);
            this.checkPackageSigners((String)object, string, (Certificate[])objectArray);
        }
        if (n < 0 || n2 < 0 || n > byArray.length || n2 > byArray.length - n) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (protectionDomain == null) {
            protectionDomain = this.getDefaultProtectionDomain();
        }
        object = protectionDomain;
        Class clazz = this.defineClassImpl(string, byArray, n, n2, object);
        if (this.isVerboseImpl()) {
            URL uRL;
            CodeSource codeSource;
            String string2 = "<unknown>";
            if (object != null && (codeSource = ((ProtectionDomain)object).getCodeSource()) != null && (uRL = codeSource.getLocation()) != null) {
                string2 = uRL.toString();
            }
            VM.dumpString("class load: " + clazz.getName() + " from: " + string2 + "\n");
        }
        if (objectArray != null) {
            this.setSigners(clazz, objectArray);
        }
        return clazz;
    }

    private native boolean isVerboseImpl();

    private void checkPackageSigners(String string, String string2, Certificate[] certificateArray) {
        Certificate[] certificateArray2 = (Certificate[])this.packageSigners.get(string);
        if (certificateArray2 == null) {
            if (certificateArray == null) {
                this.packageSigners.put(string, emptyCertificates);
            } else {
                this.packageSigners.put(string, certificateArray);
            }
        } else {
            if (certificateArray == null && certificateArray2.length == 0 || certificateArray == certificateArray2) {
                return;
            }
            if (certificateArray != null && certificateArray.length == certificateArray2.length) {
                boolean bl = true;
                block0: for (int i = 0; i < certificateArray.length; ++i) {
                    if (certificateArray[i] == certificateArray2[i] || certificateArray[i].equals(certificateArray2[i])) continue;
                    for (int j = 0; j < certificateArray2.length; ++j) {
                        if (j != i && (certificateArray[i] == certificateArray2[j] || certificateArray[i].equals(certificateArray2[j]))) continue block0;
                    }
                    bl = false;
                    break;
                }
                if (bl) {
                    return;
                }
            }
            throw new SecurityException(Msg.getString("K01d1", string2));
        }
    }

    private final ProtectionDomain getDefaultProtectionDomain() {
        if (this.defaultProtectionDomain == null) {
            CodeSource codeSource = new CodeSource(null, (Certificate[])null);
            this.defaultProtectionDomain = new ProtectionDomain(codeSource, null, this, null);
        }
        return this.defaultProtectionDomain;
    }

    private final native Class defineClassImpl(String var1, byte[] var2, int var3, int var4, Object var5);

    protected Class<?> findClass(String string) throws ClassNotFoundException {
        throw new ClassNotFoundException();
    }

    protected final Class<?> findLoadedClass(String string) {
        return this.findLoadedClassImpl(string);
    }

    private native Class findLoadedClassImpl(String var1);

    protected final Class<?> findSystemClass(String string) throws ClassNotFoundException {
        return applicationClassLoader.loadClass(string);
    }

    public final ClassLoader getParent() {
        ClassLoader classLoader;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && (classLoader = ClassLoader.callerClassLoader()) != null && classLoader != this && !classLoader.isAncestorOf(this)) {
            securityManager.checkPermission(RuntimePermission.permissionToGetClassLoader);
        }
        return this.parent;
    }

    public URL getResource(String string) {
        URL uRL;
        URL uRL2 = uRL = this.parent == null ? systemClassLoader.findResource(string) : this.parent.getResource(string);
        if (uRL != null) {
            return uRL;
        }
        return this.findResource(string);
    }

    public Enumeration<URL> getResources(String string) throws IOException {
        ClassLoader classLoader = this;
        final Vector<Enumeration<URL>> vector = new Vector<Enumeration<URL>>();
        while (true) {
            Enumeration<URL> enumeration;
            if ((enumeration = classLoader.findResources(string)) != null && enumeration.hasMoreElements()) {
                vector.addElement(enumeration);
            }
            if (classLoader == systemClassLoader) break;
            classLoader = classLoader.parent;
            if (classLoader != null) continue;
            classLoader = systemClassLoader;
        }
        return new Enumeration<URL>(){
            int index;
            {
                this.index = vector.size() - 1;
            }

            @Override
            public boolean hasMoreElements() {
                while (this.index >= 0) {
                    if (((Enumeration)vector.elementAt(this.index)).hasMoreElements()) {
                        return true;
                    }
                    --this.index;
                }
                return false;
            }

            @Override
            public URL nextElement() {
                while (this.index >= 0) {
                    Enumeration enumeration = (Enumeration)vector.elementAt(this.index);
                    if (enumeration.hasMoreElements()) {
                        return (URL)enumeration.nextElement();
                    }
                    --this.index;
                }
                throw new NoSuchElementException();
            }
        };
    }

    public InputStream getResourceAsStream(String string) {
        URL uRL = this.getResource(string);
        try {
            if (uRL != null) {
                return uRL.openStream();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    static void completeInitialization() {
        initSystemClassLoader = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassLoader getSystemClassLoader() {
        Object object;
        Object object2;
        if (initSystemClassLoader) {
            object = object2 = ClassLoader.class;
            synchronized (object) {
                if (initSystemClassLoader) {
                    initSystemClassLoader = false;
                    String string = System.getProperty("java.system.class.loader");
                    if (string != null) {
                        try {
                            Class<?> clazz = Class.forName(string, true, applicationClassLoader);
                            Constructor<?> constructor = clazz.getConstructor(new Class[]{object2});
                            applicationClassLoader = (ClassLoader)constructor.newInstance(applicationClassLoader);
                        }
                        catch (Throwable throwable) {
                            throw new Error(throwable);
                        }
                    }
                }
            }
        }
        if ((object2 = System.getSecurityManager()) != null && (object = ClassLoader.callerClassLoader()) != null && object != applicationClassLoader && !((ClassLoader)object).isAncestorOf(applicationClassLoader)) {
            ((SecurityManager)object2).checkPermission(RuntimePermission.permissionToGetClassLoader);
        }
        return applicationClassLoader;
    }

    public static URL getSystemResource(String string) {
        return ClassLoader.getSystemClassLoader().getResource(string);
    }

    public static Enumeration<URL> getSystemResources(String string) throws IOException {
        return ClassLoader.getSystemClassLoader().getResources(string);
    }

    public static InputStream getSystemResourceAsStream(String string) {
        return ClassLoader.getSystemClassLoader().getResourceAsStream(string);
    }

    public Class<?> loadClass(String string) throws ClassNotFoundException {
        return this.loadClass(string, false);
    }

    protected synchronized Class<?> loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(string);
        if (clazz == null) {
            try {
                clazz = this.parent == null ? systemClassLoader.loadClass(string) : this.parent.loadClass(string, bl);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (clazz == null) {
                clazz = this.findClass(string);
            }
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    protected final void resolveClass(Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException();
        }
    }

    private void setParent(ClassLoader classLoader) {
        this.parent = classLoader;
    }

    final boolean isSystemClassLoader() {
        if (this == systemClassLoader) {
            return true;
        }
        ClassLoader classLoader = applicationClassLoader;
        while (classLoader != null) {
            if (this == classLoader) {
                return true;
            }
            classLoader = classLoader.parent;
        }
        return false;
    }

    final boolean isAncestorOf(ClassLoader classLoader) {
        if (classLoader == null) {
            return false;
        }
        if (this == systemClassLoader) {
            return true;
        }
        ClassLoader classLoader2 = classLoader.parent;
        while (classLoader2 != null) {
            if (this == classLoader2) {
                return true;
            }
            classLoader2 = classLoader2.parent;
        }
        return false;
    }

    protected URL findResource(String string) {
        return null;
    }

    protected Enumeration<URL> findResources(String string) throws IOException {
        return new Vector().elements();
    }

    protected String findLibrary(String string) {
        return null;
    }

    protected Package getPackage(String string) {
        if (this != systemClassLoader) {
            Package package_;
            ClassLoader classLoader = this.parent;
            if (classLoader == null) {
                classLoader = systemClassLoader;
            }
            if ((package_ = classLoader.getPackage(string)) != null) {
                return package_;
            }
        }
        return (Package)this.packages.get(string);
    }

    protected Package[] getPackages() {
        Package[] packageArray = null;
        if (this.parent == null) {
            if (this != systemClassLoader) {
                packageArray = systemClassLoader.getPackages();
            }
        } else {
            packageArray = this.parent.getPackages();
        }
        int n = this.packages.size();
        if (packageArray != null) {
            n += packageArray.length;
        }
        Package[] packageArray2 = new Package[n];
        Enumeration enumeration = this.packages.elements();
        if (packageArray != null) {
            for (int i = 0; i < packageArray.length; ++i) {
                packageArray2[i] = packageArray[i];
            }
        }
        while (enumeration.hasMoreElements()) {
            packageArray2[i++] = (Package)enumeration.nextElement();
        }
        return packageArray2;
    }

    protected Package definePackage(String string, String string2, String string3, String string4, String string5, String string6, String string7, URL uRL) throws IllegalArgumentException {
        Hashtable hashtable = this.packages;
        synchronized (hashtable) {
            if (this.getPackage(string) == null) {
                Package package_ = new Package(string, string2, string3, string4, string5, string6, string7, uRL, this);
                this.packages.put(string, package_);
                return package_;
            }
            throw new IllegalArgumentException(Msg.getString("K0053", string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Object[] getSigners(Class clazz) {
        Object object = this.lazyInitLock;
        synchronized (object) {
            if (this.classSigners == null) {
                return null;
            }
        }
        try {
            object = this.classSigners.get(clazz);
            if (object != null) {
                return (Object[])object.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setSigners(Class<?> clazz, Object[] objectArray) {
        if (clazz.getClassLoaderImpl() == this) {
            if (objectArray == null) {
                Object object = this.lazyInitLock;
                synchronized (object) {
                    if (this.classSigners == null) {
                        return;
                    }
                }
                this.classSigners.remove(clazz);
            } else {
                Object object = this.lazyInitLock;
                synchronized (object) {
                    if (this.classSigners == null) {
                        this.classSigners = new Hashtable();
                    }
                }
                this.classSigners.put(clazz, objectArray);
            }
        } else {
            clazz.getClassLoaderImpl().setSigners(clazz, objectArray);
        }
    }

    static ClassLoader getCallerClassLoader() {
        ClassLoader classLoader = ClassLoader.getStackClassLoader(2);
        if (classLoader == systemClassLoader) {
            return null;
        }
        return classLoader;
    }

    static final native ClassLoader getStackClassLoader(int var0);

    static ClassLoader callerClassLoader() {
        ClassLoader classLoader = ClassLoader.getStackClassLoader(2);
        if (classLoader == systemClassLoader) {
            return null;
        }
        return classLoader;
    }

    static synchronized void loadLibraryWithClassLoader(String string, ClassLoader classLoader) {
        String string2;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkLink(string);
        }
        if (classLoader != null && (string2 = classLoader.findLibrary(string)) != null) {
            ClassLoader.loadLibraryWithPath(string2, classLoader, null);
            return;
        }
        ClassLoader.loadLibraryWithPath(string, classLoader, System.internalGetProperties().getProperty(classLoader == null ? "com.ibm.oti.vm.bootstrap.library.path" : "java.library.path"));
    }

    static void loadLibraryWithPath(String string, ClassLoader classLoader, String string2) {
        byte[] byArray;
        if (File.separatorChar == '\\' && string.startsWith("/") && Util.startsWithDriveLetter(string.substring(1))) {
            string = string.substring(1);
        }
        if ((byArray = ClassLoader.loadLibraryWithPath(Util.getBytes(string), classLoader, string2 == null ? null : Util.getBytes(string2))) != null) {
            String string3;
            try {
                string3 = Util.convertFromUTF8(byArray, 0, byArray.length);
            }
            catch (IOException iOException) {
                string3 = Util.toString(byArray);
            }
            throw new UnsatisfiedLinkError(string + " (" + string3 + ")");
        }
    }

    private static native byte[] loadLibraryWithPath(byte[] var0, ClassLoader var1, byte[] var2);

    static void loadLibrary(Class clazz, String string, boolean bl) {
        if (bl) {
            ClassLoader.loadLibraryWithPath(string, clazz.getClassLoaderImpl(), null);
        } else {
            ClassLoader.loadLibraryWithClassLoader(string, clazz.getClassLoaderImpl());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClassAssertionStatus(String string, boolean bl) {
        Object object = this.assertionLock;
        synchronized (object) {
            if (this.classAssertionStatus == null) {
                this.classAssertionStatus = new HashMap();
            }
            this.classAssertionStatus.put(string, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPackageAssertionStatus(String string, boolean bl) {
        Object object = this.assertionLock;
        synchronized (object) {
            if (this.packageAssertionStatus == null) {
                this.packageAssertionStatus = new HashMap();
            }
            this.packageAssertionStatus.put(string, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultAssertionStatus(boolean bl) {
        Object object = this.assertionLock;
        synchronized (object) {
            this.defaultAssertionStatus = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAssertionStatus() {
        Object object = this.assertionLock;
        synchronized (object) {
            this.defaultAssertionStatus = false;
            this.classAssertionStatus = null;
            this.packageAssertionStatus = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getClassAssertionStatus(String string) {
        Object object = this.assertionLock;
        synchronized (object) {
            int n = -1;
            if (this.classAssertionStatus != null) {
                Boolean bl = (Boolean)this.classAssertionStatus.get(string);
                if (bl != null) {
                    return bl;
                }
                n = string.indexOf(36);
                if (n > 0 && (bl = (Boolean)this.classAssertionStatus.get(string.substring(0, n))) != null) {
                    return bl;
                }
            }
            if ((n = string.lastIndexOf(46)) > 0) {
                return this.getPackageAssertionStatus(string.substring(0, n));
            }
            return this.getDefaultAssertionStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getPackageAssertionStatus(String string) {
        Object object = this.assertionLock;
        synchronized (object) {
            int n = -1;
            if (this.packageAssertionStatus != null) {
                Boolean bl = (Boolean)this.packageAssertionStatus.get(string);
                if (bl != null) {
                    return bl;
                }
                n = string.lastIndexOf(46);
                if (n > 0) {
                    return this.getPackageAssertionStatus(string.substring(0, n));
                }
            }
            return this.getDefaultAssertionStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getDefaultAssertionStatus() {
        Object object = this.assertionLock;
        synchronized (object) {
            return this.defaultAssertionStatus;
        }
    }

    private void initializeClassLoaderAssertStatus() {
        boolean bl;
        boolean bl2 = bl = systemClassLoader == null;
        if (!bl && !checkAssertionOptions) {
            return;
        }
        boolean bl3 = false;
        String[] stringArray = cachedVMArgs;
        for (int i = 0; i < stringArray.length; ++i) {
            boolean bl4;
            String string;
            String string2;
            if (!stringArray[i].startsWith("-e") && !stringArray[i].startsWith("-d")) continue;
            int n = stringArray[i].indexOf(58);
            if (n == -1) {
                string2 = stringArray[i];
                string = null;
            } else {
                string2 = stringArray[i].substring(0, n);
                string = stringArray[i].substring(n + 1);
            }
            if (string2.compareTo("-ea") == 0 || string2.compareTo("-enableassertions") == 0 || string2.compareTo("-da") == 0 || string2.compareTo("-disableassertions") == 0) {
                bl3 = true;
                boolean bl5 = bl4 = string2.charAt(1) == 'e';
                if (string == null) {
                    if (bl) continue;
                    this.setDefaultAssertionStatus(bl4);
                    continue;
                }
                String string3 = string;
                int n2 = string3.length();
                if (n2 > 3 && string3.charAt(n2 - 1) == '.' && string3.charAt(n2 - 2) == '.' && string3.charAt(n2 - 3) == '.') {
                    string3 = string3.substring(0, n2 - 3);
                    this.setPackageAssertionStatus(string3, bl4);
                    continue;
                }
                this.setClassAssertionStatus(string3, bl4);
                continue;
            }
            if (string2.compareTo("-esa") != 0 && string2.compareTo("-enablesystemassertions") != 0 && string2.compareTo("-dsa") != 0 && string2.compareTo("-disablesystemassertions") != 0 || !bl) continue;
            bl4 = string2.charAt(1) == 'e';
            this.setDefaultAssertionStatus(bl4);
        }
        if (bl && bl3) {
            checkAssertionOptions = true;
        }
    }

    protected final Class<?> defineClass(String string, ByteBuffer byteBuffer, ProtectionDomain protectionDomain) throws ClassFormatError {
        if (byteBuffer.hasArray()) {
            return this.defineClass(string, byteBuffer.array(), byteBuffer.position(), byteBuffer.limit() - byteBuffer.position(), protectionDomain);
        }
        int n = byteBuffer.limit() - byteBuffer.position();
        byte[] byArray = new byte[n];
        byteBuffer.get(byArray);
        return this.defineClass(string, byArray, 0, byArray.length, protectionDomain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Hashtable getGenericRepository() {
        Object object = this.lazyInitLock;
        synchronized (object) {
            if (this.genericRepository == null) {
                this.genericRepository = new Hashtable();
            }
        }
        return this.genericRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Hashtable getAnnotationCache() {
        Object object = this.lazyInitLock;
        synchronized (object) {
            if (this.annotationCache == null) {
                this.annotationCache = new Hashtable();
            }
        }
        return this.annotationCache;
    }

    static boolean isReflectCacheEnabled() {
        return reflectCacheEnabled;
    }

    static boolean isReflectCacheAppOnly() {
        return reflectCacheAppOnly;
    }

    static boolean isReflectCacheDebug() {
        return reflectCacheDebug;
    }

    final Hashtable getMethodCache() {
        return this.methodCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final CacheTable getMethodCache(Class clazz) {
        Hashtable hashtable = this.methodCache;
        synchronized (hashtable) {
            CacheTable cacheTable = (CacheTable)this.methodCache.get(clazz);
            if (cacheTable == null) {
                cacheTable = new CacheTable(this.methodCache, clazz);
                this.methodCache.put(clazz, cacheTable);
            }
            cacheTable.used();
            return cacheTable;
        }
    }

    final Hashtable getFieldCache() {
        return this.fieldCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final CacheTable getFieldCache(Class clazz) {
        Hashtable hashtable = this.fieldCache;
        synchronized (hashtable) {
            CacheTable cacheTable = (CacheTable)this.fieldCache.get(clazz);
            if (cacheTable == null) {
                cacheTable = new CacheTable(this.fieldCache, clazz);
                this.fieldCache.put(clazz, cacheTable);
            }
            cacheTable.used();
            return cacheTable;
        }
    }

    final Hashtable getConstructorCache() {
        return this.constructorCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final CacheTable getConstructorCache(Class clazz) {
        Hashtable hashtable = this.constructorCache;
        synchronized (hashtable) {
            CacheTable cacheTable = (CacheTable)this.constructorCache.get(clazz);
            if (cacheTable == null) {
                cacheTable = new CacheTable(this.constructorCache, clazz);
                this.constructorCache.put(clazz, cacheTable);
            }
            cacheTable.used();
            return cacheTable;
        }
    }

    static {
        initSystemClassLoader = false;
        reflectCacheEnabled = false;
        reflectCacheAppOnly = true;
        reflectCacheDebug = false;
        cachedVMArgs = VM.getVMArgs();
        checkAssertionOptions = false;
        emptyCertificates = new Certificate[0];
    }

    static class CacheTable
    extends Hashtable {
        Hashtable parent;
        Object key;
        int useCount;

        public CacheTable(Hashtable hashtable, Object object) {
            this.parent = hashtable;
            this.key = object;
        }

        public Object get(Object object) {
            SoftReference softReference = (SoftReference)super.get(object);
            return softReference != null ? softReference.get() : null;
        }

        public Object getRef(Object object) {
            return super.get(object);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeEmpty() {
            Hashtable hashtable = this.parent;
            synchronized (hashtable) {
                CacheTable cacheTable = this;
                synchronized (cacheTable) {
                    if (this.isEmpty() && this.useCount == 0) {
                        if (ClassLoader.isReflectCacheDebug()) {
                            System.err.println("Removed reflect cache for: " + this.key);
                        }
                        this.parent.remove(this.key);
                    } else if (ClassLoader.isReflectCacheDebug()) {
                        System.err.println("Reflect cache size: " + this.size() + " and useCount: " + this.useCount + " for: " + this.key);
                    }
                }
            }
        }

        public synchronized void used() {
            ++this.useCount;
        }

        public synchronized void free() {
            --this.useCount;
        }
    }

    private static class LazyInitLock {
        private LazyInitLock() {
        }
    }

    private static class AssertionLock {
        private AssertionLock() {
        }
    }
}

