/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.ibm.oti.util.Msg;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import sun.nio.ch.Interruptible;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Thread
implements Runnable {
    public static final int MAX_PRIORITY = 10;
    public static final int MIN_PRIORITY = 1;
    public static final int NORM_PRIORITY = 5;
    private static int createCount = -1;
    private static Object uniqueIdLock = new UniqueIdLock();
    private static long uniqueIdCount = 1L;
    private static final int NANOS_MAX = 999999;
    private static final int INITIAL_LOCAL_STORAGE_CAPACITY = 5;
    static final long NO_REF = 0L;
    private long threadRef;
    long stackSize = 0L;
    private volatile boolean started;
    private String name = null;
    private int priority = 5;
    private boolean isDaemon = false;
    ThreadGroup threadGroup = null;
    private Runnable runnable = null;
    private Throwable stopThrowable = null;
    private ClassLoader contextClassLoader = null;
    ThreadLocal.ThreadLocalMap threadLocals;
    private AccessControlContext accessControlContext;
    private Object lock = new ThreadLock();
    ThreadLocal.ThreadLocalMap inheritableThreadLocals;
    private volatile Interruptible blockOn;
    private volatile UncaughtExceptionHandler exceptionHandler;
    private long uniqueId;
    volatile Object parkBlocker;
    private static ThreadGroup systemThreadGroup;
    private static ThreadGroup mainGroup;
    private static volatile UncaughtExceptionHandler defaultExceptionHandler;

    public Thread() {
        this(null, null, Thread.newName());
    }

    private Thread(String string, Object object, int n, boolean bl) {
        this.name = string == null ? Thread.newName() : string;
        this.isDaemon = bl;
        this.priority = n;
        ThreadGroup threadGroup = null;
        boolean bl2 = false;
        if (mainGroup == null) {
            bl2 = true;
            mainGroup = new ThreadGroup(systemThreadGroup);
        }
        threadGroup = object == null ? mainGroup : (ThreadGroup)object;
        this.initialize(bl2, threadGroup, null);
        this.threadGroup.add(this);
        if (bl2) {
            System.completeInitialization();
        }
    }

    void completeInitialization() {
        this.contextClassLoader = ClassLoader.getSystemClassLoader();
    }

    public Thread(Runnable runnable) {
        this(null, runnable, Thread.newName());
    }

    public Thread(Runnable runnable, String string) {
        this(null, runnable, string);
    }

    public Thread(String string) {
        this(null, null, string);
    }

    public Thread(ThreadGroup threadGroup, Runnable runnable) {
        this(threadGroup, runnable, Thread.newName());
    }

    public Thread(ThreadGroup threadGroup, Runnable runnable, String string, long l) {
        this(threadGroup, runnable, string);
        this.stackSize = l;
    }

    public Thread(ThreadGroup threadGroup, Runnable runnable, String string) {
        SecurityManager securityManager;
        if (string == null) {
            throw new NullPointerException();
        }
        this.name = string;
        this.runnable = runnable;
        Thread thread = Thread.currentThread();
        this.isDaemon = thread.isDaemon();
        if (threadGroup == null && (securityManager = System.getSecurityManager()) != null) {
            threadGroup = securityManager.getThreadGroup();
        }
        if (threadGroup == null) {
            threadGroup = thread.getThreadGroup();
        }
        this.initialize(false, threadGroup, thread);
        this.setPriority(thread.getPriority());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(boolean bl, ThreadGroup threadGroup, Thread thread) {
        Object object = uniqueIdLock;
        synchronized (object) {
            this.uniqueId = uniqueIdCount++;
        }
        this.threadGroup = threadGroup;
        if (thread != null) {
            boolean bl2;
            if (thread.inheritableThreadLocals != null) {
                this.inheritableThreadLocals = ThreadLocal.createInheritedMap(thread.inheritableThreadLocals);
            }
            object = System.getSecurityManager();
            final Class<? extends Object> clazz = this.getClass();
            final Class<Thread> clazz2 = Thread.class;
            if (object != null && clazz != clazz2 && (bl2 = ((Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Method method;
                    try {
                        method = clazz.getMethod("getContextClassLoader", new Class[0]);
                        if (method.getDeclaringClass() != clazz2) {
                            return Boolean.TRUE;
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                    try {
                        method = clazz.getDeclaredMethod("setContextClassLoader", ClassLoader.class);
                        if (method.getDeclaringClass() != clazz2) {
                            return Boolean.TRUE;
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                    return Boolean.FALSE;
                }
            })).booleanValue())) {
                ((SecurityManager)object).checkPermission(new RuntimePermission("enableContextClassLoaderOverride"));
            }
            this.contextClassLoader = thread.getContextClassLoader();
        } else {
            if (bl) {
                ClassLoader.initializeClassLoaders();
            }
            this.contextClassLoader = ClassLoader.getSystemClassLoader();
        }
        threadGroup.checkAccess();
        threadGroup.checkNewThread(this);
        this.accessControlContext = AccessController.getContext();
    }

    public Thread(ThreadGroup threadGroup, String string) {
        this(threadGroup, null, string);
    }

    public static int activeCount() {
        return Thread.currentThread().getThreadGroup().activeCount();
    }

    public final void checkAccess() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkAccess(this);
        }
    }

    @Deprecated
    public int countStackFrames() {
        return 0;
    }

    public static native Thread currentThread();

    @Deprecated
    public void destroy() {
        throw new NoSuchMethodError();
    }

    public static void dumpStack() {
        new Throwable().printStackTrace();
    }

    public static int enumerate(Thread[] threadArray) {
        return Thread.currentThread().getThreadGroup().enumerate(threadArray, true);
    }

    public ClassLoader getContextClassLoader() {
        ClassLoader classLoader;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && (classLoader = ClassLoader.callerClassLoader()) != null && this.contextClassLoader != classLoader && !classLoader.isAncestorOf(this.contextClassLoader)) {
            securityManager.checkPermission(RuntimePermission.permissionToGetClassLoader);
        }
        return this.contextClassLoader;
    }

    public final String getName() {
        return String.valueOf(this.name);
    }

    public final int getPriority() {
        return this.priority;
    }

    public final ThreadGroup getThreadGroup() {
        return this.threadGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interrupt() {
        this.checkAccess();
        Object object = this.lock;
        synchronized (object) {
            this.interruptImpl();
            Interruptible interruptible = this.blockOn;
            if (interruptible != null) {
                interruptible.interrupt();
            }
        }
    }

    public static native boolean interrupted();

    private native void interruptImpl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isAlive() {
        Object object = this.lock;
        synchronized (object) {
            return this.threadRef != 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDead() {
        Object object = this.lock;
        synchronized (object) {
            return this.started && this.threadRef == 0L;
        }
    }

    public final boolean isDaemon() {
        return this.isDaemon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInterrupted() {
        Object object = this.lock;
        synchronized (object) {
            return this.isInterruptedImpl();
        }
    }

    private native boolean isInterruptedImpl();

    public final synchronized void join() throws InterruptedException {
        if (this.started) {
            while (!this.isDead()) {
                this.wait(0L);
            }
        }
    }

    public final void join(long l) throws InterruptedException {
        this.join(l, 0);
    }

    public final synchronized void join(long l, int n) throws InterruptedException {
        if (l < 0L || n < 0 || n > 999999) {
            throw new IllegalArgumentException();
        }
        if (!this.started || this.isDead()) {
            return;
        }
        long l2 = 0L;
        long l3 = l;
        boolean bl = false;
        if (l == 0L & n > 0) {
            if (n < 500000) {
                bl = true;
            } else {
                l3 = 1L;
            }
        }
        while (!bl && !this.isDead()) {
            long l4 = System.currentTimeMillis();
            this.wait(l3);
            long l5 = System.currentTimeMillis() - l4;
            l3 -= l5;
            bl = (l2 += l5) >= l;
        }
    }

    private static synchronized String newName() {
        if (createCount == -1) {
            ++createCount;
            return "main";
        }
        return "Thread-" + createCount++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public final void resume() {
        this.checkAccess();
        Object object = this.lock;
        synchronized (object) {
            this.resumeImpl();
        }
    }

    private native void resumeImpl();

    @Override
    public void run() {
        if (this.runnable != null) {
            this.runnable.run();
        }
    }

    public void setContextClassLoader(ClassLoader classLoader) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(RuntimePermission.permissionToSetContextClassLoader);
        }
        this.contextClassLoader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setDaemon(boolean bl) {
        this.checkAccess();
        Object object = this.lock;
        synchronized (object) {
            if (!this.started) {
                this.isDaemon = bl;
            } else if (this.isAlive()) {
                throw new IllegalThreadStateException();
            }
        }
    }

    public final void setName(String string) {
        this.checkAccess();
        if (string == null) {
            throw new NullPointerException();
        }
        this.name = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setPriority(int n) {
        this.checkAccess();
        if (1 <= n && n <= 10) {
            int n2 = n;
            int n3 = this.getThreadGroup().getMaxPriority();
            if (n3 < n) {
                n2 = n3;
            }
            this.priority = n2;
            Object object = this.lock;
            synchronized (object) {
                if (this.started && this.threadRef != 0L) {
                    this.setPriorityNoVMAccessImpl(this.threadRef, n2);
                }
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    private native void setPriorityNoVMAccessImpl(long var1, int var3);

    public static void sleep(long l) throws InterruptedException {
        Thread.sleep(l, 0);
    }

    public static native void sleep(long var0, int var2) throws InterruptedException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start() {
        Object object = this.lock;
        synchronized (object) {
            if (this.started) {
                throw new IllegalThreadStateException(Msg.getString("K0341"));
            }
            boolean bl = false;
            this.threadGroup.add(this);
            try {
                this.startImpl();
                bl = true;
            }
            finally {
                if (!bl) {
                    this.threadGroup.remove(this);
                }
            }
        }
    }

    private native void startImpl();

    @Deprecated
    public final void stop() {
        if (!this.isAlive()) {
            return;
        }
        this.stop(new ThreadDeath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public final synchronized void stop(Throwable throwable) {
        Object object;
        this.checkAccess();
        if (!(Thread.currentThread() == this && throwable instanceof ThreadDeath || (object = System.getSecurityManager()) == null)) {
            ((SecurityManager)object).checkPermission(RuntimePermission.permissionToStopThread);
        }
        object = this.lock;
        synchronized (object) {
            if (throwable == null) {
                throw new NullPointerException();
            }
            this.stopImpl(throwable);
        }
    }

    private native void stopImpl(Throwable var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public final void suspend() {
        this.checkAccess();
        if (Thread.currentThread() == this) {
            this.suspendImpl();
        } else {
            Object object = this.lock;
            synchronized (object) {
                this.suspendImpl();
            }
        }
    }

    private native void suspendImpl();

    public String toString() {
        return "Thread[" + this.getName() + "," + this.getPriority() + "," + (this.getThreadGroup() == null ? "" : this.getThreadGroup().getName()) + "]";
    }

    public static native void yield();

    public static native boolean holdsLock(Object var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void blockedOn(Interruptible interruptible) {
        Object object = this.lock;
        synchronized (object) {
            this.blockOn = interruptible;
        }
    }

    private native Throwable getStackTraceImpl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StackTraceElement[] getStackTrace() {
        Object object;
        if (Thread.currentThread() != this && (object = System.getSecurityManager()) != null) {
            ((SecurityManager)object).checkPermission(new RuntimePermission("getStackTrace"));
        }
        Object object2 = this.lock;
        synchronized (object2) {
            if (!this.isAlive()) {
                return new StackTraceElement[0];
            }
            object = this.getStackTraceImpl();
        }
        return J9VMInternals.getStackTrace((Throwable)object, false);
    }

    public static Map<Thread, StackTraceElement[]> getAllStackTraces() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("getStackTrace"));
            securityManager.checkPermission(RuntimePermission.permissionToModifyThreadGroup);
        }
        int n = systemThreadGroup.activeCount() + 20;
        Thread[] threadArray = new Thread[n];
        n = systemThreadGroup.enumerate(threadArray);
        HashMap<Thread, StackTraceElement[]> hashMap = new HashMap<Thread, StackTraceElement[]>(n * 4 / 3);
        for (int i = 0; i < n; ++i) {
            hashMap.put(threadArray[i], threadArray[i].getStackTrace());
        }
        return hashMap;
    }

    public long getId() {
        return this.uniqueId;
    }

    public UncaughtExceptionHandler getUncaughtExceptionHandler() {
        if (this.exceptionHandler == null) {
            return this.getThreadGroup();
        }
        return this.exceptionHandler;
    }

    public void setUncaughtExceptionHandler(UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.exceptionHandler = uncaughtExceptionHandler;
    }

    public static UncaughtExceptionHandler getDefaultUncaughtExceptionHandler() {
        return defaultExceptionHandler;
    }

    public static void setDefaultUncaughtExceptionHandler(UncaughtExceptionHandler uncaughtExceptionHandler) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("setDefaultUncaughtExceptionHandler"));
        }
        defaultExceptionHandler = uncaughtExceptionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State getState() {
        Object object = this.lock;
        synchronized (object) {
            if (this.threadRef == 0L) {
                if (this.isDead()) {
                    return State.TERMINATED;
                }
                return State.NEW;
            }
            return State.values()[this.getStateImpl(this.threadRef)];
        }
    }

    private native int getStateImpl(long var1);

    private void uncaughtException(Throwable throwable) {
        UncaughtExceptionHandler uncaughtExceptionHandler = this.getUncaughtExceptionHandler();
        if (uncaughtExceptionHandler != null) {
            uncaughtExceptionHandler.uncaughtException(this, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanup() {
        this.threadGroup = null;
        this.runnable = null;
        this.accessControlContext = null;
        this.threadLocals = null;
        this.inheritableThreadLocals = null;
        Object object = this.lock;
        synchronized (object) {
            this.threadRef = 0L;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        NEW,
        RUNNABLE,
        BLOCKED,
        WAITING,
        TIMED_WAITING,
        TERMINATED;

    }

    public static interface UncaughtExceptionHandler {
        public void uncaughtException(Thread var1, Throwable var2);
    }

    private static class ThreadLock {
        private ThreadLock() {
        }
    }

    private static class UniqueIdLock {
        private UniqueIdLock() {
        }
    }
}

