/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Array {
    private Array() {
    }

    public static native Object get(Object var0, int var1) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    public static native boolean getBoolean(Object var0, int var1) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    public static native byte getByte(Object var0, int var1) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    public static native char getChar(Object var0, int var1) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    public static native double getDouble(Object var0, int var1) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    public static native float getFloat(Object var0, int var1) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    public static native int getInt(Object var0, int var1) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    public static native int getLength(Object var0) throws IllegalArgumentException;

    public static native long getLong(Object var0, int var1) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    public static native short getShort(Object var0, int var1) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    private static native Object multiNewArrayImpl(Class var0, int var1, int[] var2);

    private static native Object newArrayImpl(Class var0, int var1);

    public static Object newInstance(Class<?> clazz, int[] nArray) throws NegativeArraySizeException, IllegalArgumentException {
        if (clazz == null) {
            throw new NullPointerException();
        }
        int n = nArray.length;
        if (n < 1) {
            throw new IllegalArgumentException();
        }
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            if (nArray[i] < 0) {
                throw new NegativeArraySizeException();
            }
            nArray2[n - i - 1] = nArray[i];
        }
        return Array.multiNewArrayImpl(clazz, n, nArray2);
    }

    public static Object newInstance(Class<?> clazz, int n) throws NegativeArraySizeException {
        if (clazz == null) {
            throw new NullPointerException();
        }
        if (n < 0) {
            throw new NegativeArraySizeException();
        }
        return Array.newArrayImpl(clazz, n);
    }

    public static void set(Object object, int n, Object object2) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (object2 == null && object != null && object.getClass().getComponentType().isPrimitive()) {
            throw new IllegalArgumentException();
        }
        Array.setImpl(object, n, object2);
    }

    private static native void setImpl(Object var0, int var1, Object var2) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    public static native void setBoolean(Object var0, int var1, boolean var2) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    public static native void setByte(Object var0, int var1, byte var2) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    public static native void setChar(Object var0, int var1, char var2) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    public static native void setDouble(Object var0, int var1, double var2) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    public static native void setFloat(Object var0, int var1, float var2) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    public static native void setInt(Object var0, int var1, int var2) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    public static native void setLong(Object var0, int var1, long var2) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    public static native void setShort(Object var0, int var1, short var2) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;
}

