/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import tcl.lang.Command;
import tcl.lang.ExecInputStreamReader;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.Util;

class ExecCmd
implements Command {
    private static Method execMethod;

    ExecCmd() {
    }

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        String argStr;
        int firstWord;
        int argLen = argv.length;
        boolean background = false;
        boolean keepNewline = false;
        String childEncoding = Util.tryGetSystemProperty("char.encoding", null);
        String OS400Result = "";
        for (firstWord = 1; firstWord < argLen && (argStr = argv[firstWord].toString()).length() > 0 && argStr.charAt(0) == '-'; ++firstWord) {
            if (!argStr.equals("-keepnewline")) {
                if (argStr.equals("--")) {
                    ++firstWord;
                    break;
                }
                throw new TclException(interp, "bad switch \"" + argStr + "\": must be -keepnewline or --");
            }
            keepNewline = true;
        }
        if (argLen <= firstWord) {
            throw new TclNumArgsException(interp, 1, argv, "?switches? arg ?arg ...?");
        }
        if (argv[argLen - 1].toString().equals("&")) {
            --argLen;
            background = true;
        }
        try {
            int errorBytes;
            int exit;
            Process p = execMethod != null ? this.execReflection(interp, argv, firstWord, argLen) : (Util.isUnix() || Util.isOS400() ? this.execUnix(interp, argv, firstWord, argLen) : (Util.isWindows() ? this.execWin(interp, argv, firstWord, argLen) : this.execDefault(interp, argv, firstWord, argLen)));
            if (background) {
                interp.setResult("pid0");
                return;
            }
            StringBuffer sbuf = new StringBuffer();
            if (execMethod != null) {
                ExecInputStreamReader reader = new ExecInputStreamReader(p.getInputStream(), p.getErrorStream(), sbuf);
                reader.start();
                exit = p.waitFor();
                reader.join();
                errorBytes = reader.getErrorBytes();
            } else {
                exit = p.waitFor();
                ExecCmd.readStreamIntoBuffer(p.getInputStream(), sbuf);
                errorBytes = ExecCmd.readStreamIntoBuffer(p.getErrorStream(), sbuf);
            }
            if (Util.isOS400()) {
                String encodedResult = sbuf.toString();
                byte[] byteResult = encodedResult.getBytes();
                try {
                    OS400Result = new String(byteResult, childEncoding);
                }
                catch (UnsupportedEncodingException e) {
                    OS400Result = encodedResult;
                }
            }
            if (errorBytes == 0 && exit != 0) {
                sbuf.append("child process exited abnormally");
            }
            int length = sbuf.length();
            if (!keepNewline && length > 0 && sbuf.charAt(length - 1) == '\n') {
                sbuf.setLength(length - 1);
            }
            if (exit != 0) {
                TclObject childstatus = TclList.newInstance();
                TclList.append(interp, childstatus, TclString.newInstance((String)"CHILDSTATUS"));
                TclList.append(interp, childstatus, TclString.newInstance((String)"?PID?"));
                TclList.append(interp, childstatus, TclInteger.newInstance((int)exit));
                interp.setErrorCode(childstatus);
            }
            if (exit != 0 || errorBytes != 0) {
                if (Util.isOS400()) {
                    if (errorBytes == 0 && exit != 0) {
                        throw new TclException(interp, OS400Result + "child process exited abnormally");
                    }
                    throw new TclException(interp, OS400Result);
                }
                throw new TclException(interp, sbuf.toString());
            }
            if (Util.isOS400()) {
                interp.setResult(OS400Result);
            } else {
                interp.setResult(sbuf.toString());
            }
        }
        catch (IOException e) {
            throw new TclException(interp, "couldn't execute \"" + argv[firstWord].toString() + "\": no such file or directory");
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int readStreamIntoBuffer(InputStream in, StringBuffer sbuf) {
        int numRead = 0;
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        try {
            String line = br.readLine();
            while (line != null) {
                sbuf.append(line);
                numRead += line.length();
                sbuf.append('\n');
                ++numRead;
                line = br.readLine();
            }
        }
        catch (IOException e) {
        }
        finally {
            try {
                br.close();
            }
            catch (IOException e) {}
        }
        return numRead;
    }

    static String escapeWinString(String str) {
        if (str.indexOf(37) == -1) {
            return str;
        }
        char[] arr = str.toCharArray();
        StringBuffer sb = new StringBuffer(50);
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] == '%') {
                sb.append('%');
            }
            sb.append(arr[i]);
        }
        return sb.toString();
    }

    private Process execUnix(Interp interp, TclObject[] argv, int first, int last) throws IOException {
        String[] argStrs = new String[3];
        argStrs[0] = "sh";
        argStrs[1] = "-c";
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("cd '");
        sbuf.append(interp.getWorkingDir().toString());
        sbuf.append("'; ");
        for (int i = first; i < last; ++i) {
            sbuf.append('\'');
            sbuf.append(argv[i].toString());
            sbuf.append('\'');
            sbuf.append(' ');
        }
        sbuf.setLength(sbuf.length() - 1);
        argStrs[2] = sbuf.toString();
        return Runtime.getRuntime().exec(argStrs);
    }

    private Process execWin(Interp interp, TclObject[] argv, int first, int last) throws IOException {
        File out_file;
        File tmp = new File("C:\\TEMP");
        if (!tmp.exists() && !tmp.mkdirs()) {
            throw new IOException("could not create C:\\TEMP");
        }
        String jacl1 = "C:\\TEMP\\jacl1.bat";
        String jacl2 = "C:\\TEMP\\jacl2.bat";
        String os_name = System.getProperty("os.name");
        boolean isNT = os_name.equalsIgnoreCase("windows xp") || os_name.equalsIgnoreCase("windows nt") || os_name.equalsIgnoreCase("windows 2000");
        File jacl1_file = new File(jacl1);
        File jacl2_file = new File(jacl2);
        if (isNT) {
            if (jacl1_file.exists()) {
                jacl1_file.delete();
            }
            PrintWriter jacl_out = new PrintWriter(new BufferedWriter(new FileWriter(jacl1_file)));
            jacl_out.println("@echo off");
            jacl_out.println("cmd.exe /C " + jacl2);
            jacl_out.close();
            out_file = jacl2_file;
        } else {
            out_file = jacl1_file;
        }
        if (out_file.exists()) {
            out_file.delete();
        }
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(out_file)));
        out.println("@echo off");
        String path = interp.getWorkingDir().toString();
        out.println(path.substring(0, 2));
        out.println("cd " + ExecCmd.escapeWinString(path.substring(2)));
        out.print(ExecCmd.escapeWinString(argv[first].toString()));
        out.print(' ');
        for (int i = first + 1; i < last; ++i) {
            out.print('\"');
            out.print(ExecCmd.escapeWinString(argv[i].toString()));
            out.print('\"');
            out.print(' ');
        }
        out.println();
        out.close();
        String[] argStrs = new String[]{"command.com", "/C", jacl1};
        return Runtime.getRuntime().exec(argStrs);
    }

    private Process execDefault(Interp interp, TclObject[] argv, int first, int last) throws IOException {
        String[] strv = new String[last - first];
        int j = 0;
        for (int i = first; i < last; ++i) {
            strv[j] = argv[i].toString();
            ++j;
        }
        return Runtime.getRuntime().exec(strv);
    }

    private Process execReflection(Interp interp, TclObject[] argv, int first, int last) throws IOException {
        String[] strv = new String[last - first];
        int j = 0;
        for (int i = first; i < last; ++i) {
            strv[j] = argv[i].toString();
            ++j;
        }
        Object[] methodArgs = new Object[]{strv, null, interp.getWorkingDir()};
        try {
            return (Process)execMethod.invoke((Object)Runtime.getRuntime(), methodArgs);
        }
        catch (IllegalAccessException ex) {
            throw new TclRuntimeError("IllegalAccessException in execReflection");
        }
        catch (IllegalArgumentException ex) {
            throw new TclRuntimeError("IllegalArgumentException in execReflection");
        }
        catch (InvocationTargetException ex) {
            Throwable t = ex.getTargetException();
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new TclRuntimeError("unexected exception in execReflection");
        }
    }

    static {
        Class[] parameterTypes = new Class[]{String[].class, String[].class, File.class};
        try {
            execMethod = Runtime.getRuntime().getClass().getMethod("exec", parameterTypes);
        }
        catch (NoSuchMethodException e) {
            execMethod = null;
        }
    }
}

