/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import tcl.lang.CallFrame;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.NamespaceCmd;
import tcl.lang.Procedure;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.Util;
import tcl.lang.Var;
import tcl.lang.WrappedCommand;

class InfoCmd
implements Command {
    private static final String[] validCmds = new String[]{"args", "body", "cmdcount", "commands", "complete", "default", "exists", "globals", "hostname", "level", "library", "loaded", "locals", "nameofexecutable", "patchlevel", "procs", "script", "sharedlibextension", "tclversion", "vars"};
    static final int OPT_ARGS = 0;
    static final int OPT_BODY = 1;
    static final int OPT_CMDCOUNT = 2;
    static final int OPT_COMMANDS = 3;
    static final int OPT_COMPLETE = 4;
    static final int OPT_DEFAULT = 5;
    static final int OPT_EXISTS = 6;
    static final int OPT_GLOBALS = 7;
    static final int OPT_HOSTNAME = 8;
    static final int OPT_LEVEL = 9;
    static final int OPT_LIBRARY = 10;
    static final int OPT_LOADED = 11;
    static final int OPT_LOCALS = 12;
    static final int OPT_NAMEOFEXECUTABLE = 13;
    static final int OPT_PATCHLEVEL = 14;
    static final int OPT_PROCS = 15;
    static final int OPT_SCRIPT = 16;
    static final int OPT_SHAREDLIBEXTENSION = 17;
    static final int OPT_TCLVERSION = 18;
    static final int OPT_VARS = 19;

    InfoCmd() {
    }

    public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
        if (objv.length < 2) {
            throw new TclNumArgsException(interp, 1, objv, "option ?arg arg ...?");
        }
        int index = TclIndex.get((Interp)interp, (TclObject)objv[1], (String[])validCmds, (String)"option", (int)0);
        switch (index) {
            case 0: {
                InfoCmd.InfoArgsCmd(interp, objv);
                break;
            }
            case 1: {
                InfoCmd.InfoBodyCmd(interp, objv);
                break;
            }
            case 2: {
                InfoCmd.InfoCmdCountCmd(interp, objv);
                break;
            }
            case 3: {
                InfoCmd.InfoCommandsCmd(interp, objv);
                break;
            }
            case 4: {
                InfoCmd.InfoCompleteCmd(interp, objv);
                break;
            }
            case 5: {
                InfoCmd.InfoDefaultCmd(interp, objv);
                break;
            }
            case 6: {
                InfoCmd.InfoExistsCmd(interp, objv);
                break;
            }
            case 7: {
                InfoCmd.InfoGlobalsCmd(interp, objv);
                break;
            }
            case 8: {
                InfoCmd.InfoHostnameCmd(interp, objv);
                break;
            }
            case 9: {
                InfoCmd.InfoLevelCmd(interp, objv);
                break;
            }
            case 10: {
                InfoCmd.InfoLibraryCmd(interp, objv);
                break;
            }
            case 11: {
                InfoCmd.InfoLoadedCmd(interp, objv);
                break;
            }
            case 12: {
                InfoCmd.InfoLocalsCmd(interp, objv);
                break;
            }
            case 13: {
                InfoCmd.InfoNameOfExecutableCmd(interp, objv);
                break;
            }
            case 14: {
                InfoCmd.InfoPatchLevelCmd(interp, objv);
                break;
            }
            case 15: {
                InfoCmd.InfoProcsCmd(interp, objv);
                break;
            }
            case 16: {
                InfoCmd.InfoScriptCmd(interp, objv);
                break;
            }
            case 17: {
                InfoCmd.InfoSharedlibCmd(interp, objv);
                break;
            }
            case 18: {
                InfoCmd.InfoTclVersionCmd(interp, objv);
                break;
            }
            case 19: {
                InfoCmd.InfoVarsCmd(interp, objv);
            }
        }
    }

    private static void InfoArgsCmd(Interp interp, TclObject[] objv) throws TclException {
        if (objv.length != 3) {
            throw new TclNumArgsException(interp, 2, objv, "procname");
        }
        String name = objv[2].toString();
        Procedure proc = Procedure.findProc(interp, name);
        if (proc == null) {
            throw new TclException(interp, "\"" + name + "\" isn't a procedure");
        }
        TclObject listObj = TclList.newInstance();
        for (int i = 0; i < proc.argList.length; ++i) {
            TclObject s = TclString.newInstance((Object)proc.argList[i][0]);
            TclList.append(interp, listObj, s);
        }
        interp.setResult(listObj);
    }

    private static void InfoBodyCmd(Interp interp, TclObject[] objv) throws TclException {
        if (objv.length != 3) {
            throw new TclNumArgsException(interp, 2, objv, "procname");
        }
        String name = objv[2].toString();
        Procedure proc = Procedure.findProc(interp, name);
        if (proc == null) {
            throw new TclException(interp, "\"" + name + "\" isn't a procedure");
        }
        interp.setResult(proc.body.toString());
    }

    private static void InfoCmdCountCmd(Interp interp, TclObject[] objv) throws TclException {
        if (objv.length != 2) {
            throw new TclNumArgsException(interp, 2, objv, null);
        }
        interp.setResult(interp.cmdCount);
    }

    private static void InfoCommandsCmd(Interp interp, TclObject[] objv) throws TclException {
        NamespaceCmd.Namespace ns;
        String simplePattern;
        NamespaceCmd.Namespace globalNs = NamespaceCmd.getGlobalNamespace(interp);
        NamespaceCmd.Namespace currNs = NamespaceCmd.getCurrentNamespace(interp);
        boolean specificNsInPattern = false;
        if (objv.length == 2) {
            simplePattern = null;
            ns = currNs;
            specificNsInPattern = false;
        } else if (objv.length == 3) {
            String pattern = objv[2].toString();
            NamespaceCmd.Namespace[] nsArr = new NamespaceCmd.Namespace[1];
            NamespaceCmd.Namespace[] dummy1Arr = new NamespaceCmd.Namespace[1];
            NamespaceCmd.Namespace[] dummy2Arr = new NamespaceCmd.Namespace[1];
            String[] simplePatternArr = new String[1];
            NamespaceCmd.getNamespaceForQualName(interp, pattern, null, 0, nsArr, dummy1Arr, dummy2Arr, simplePatternArr);
            ns = nsArr[0];
            simplePattern = simplePatternArr[0];
            if (ns != null) {
                specificNsInPattern = simplePattern.compareTo(pattern) != 0;
            }
        } else {
            throw new TclNumArgsException(interp, 2, objv, "?pattern?");
        }
        TclObject list = TclList.newInstance();
        if (ns != null) {
            String cmdName;
            Enumeration search = ns.cmdTable.keys();
            while (search.hasMoreElements()) {
                TclObject elemObj;
                cmdName = (String)search.nextElement();
                if (simplePattern != null && !Util.stringMatch(cmdName, simplePattern)) continue;
                if (specificNsInPattern) {
                    WrappedCommand cmd = (WrappedCommand)ns.cmdTable.get(cmdName);
                    elemObj = TclString.newInstance((String)interp.getCommandFullName(cmd));
                } else {
                    elemObj = TclString.newInstance((String)cmdName);
                }
                TclList.append(interp, list, elemObj);
            }
            if (ns != globalNs && !specificNsInPattern) {
                search = globalNs.cmdTable.keys();
                while (search.hasMoreElements()) {
                    cmdName = (String)search.nextElement();
                    if (simplePattern != null && !Util.stringMatch(cmdName, simplePattern) || ns.cmdTable.get(cmdName) != null) continue;
                    TclList.append(interp, list, TclString.newInstance((String)cmdName));
                }
            }
        }
        interp.setResult(list);
    }

    private static void InfoCompleteCmd(Interp interp, TclObject[] objv) throws TclException {
        if (objv.length != 3) {
            throw new TclNumArgsException(interp, 2, objv, "command");
        }
        interp.setResult(Interp.commandComplete(objv[2].toString()));
    }

    private static void InfoDefaultCmd(Interp interp, TclObject[] objv) throws TclException {
        if (objv.length != 5) {
            throw new TclNumArgsException(interp, 2, objv, "procname arg varname");
        }
        String procName = objv[2].toString();
        String argName = objv[3].toString();
        Procedure proc = Procedure.findProc(interp, procName);
        if (proc == null) {
            throw new TclException(interp, "\"" + procName + "\" isn't a procedure");
        }
        for (int i = 0; i < proc.argList.length; ++i) {
            if (!argName.equals(proc.argList[i][0].toString())) continue;
            String varName = objv[4].toString();
            try {
                if (proc.argList[i][1] != null) {
                    interp.setVar(varName, proc.argList[i][1], 0);
                    interp.setResult(1);
                } else {
                    interp.setVar(varName, "", 0);
                    interp.setResult(0);
                }
            }
            catch (TclException excp) {
                throw new TclException(interp, "couldn't store default value in variable \"" + varName + "\"");
            }
            return;
        }
        throw new TclException(interp, "procedure \"" + procName + "\" doesn't have an argument \"" + argName + "\"");
    }

    private static void InfoExistsCmd(Interp interp, TclObject[] objv) throws TclException {
        Var var = null;
        if (objv.length != 3) {
            throw new TclNumArgsException(interp, 2, objv, "varName");
        }
        String varName = objv[2].toString();
        Var[] result = Var.lookupVar(interp, varName, null, 0, "access", false, false);
        if (result != null) {
            var = result[0];
        }
        if (var != null && !var.isVarUndefined()) {
            interp.setResult(true);
        } else {
            interp.setResult(false);
        }
    }

    private static void InfoGlobalsCmd(Interp interp, TclObject[] objv) throws TclException {
        String pattern;
        NamespaceCmd.Namespace globalNs = NamespaceCmd.getGlobalNamespace(interp);
        if (objv.length == 2) {
            pattern = null;
        } else if (objv.length == 3) {
            pattern = objv[2].toString();
        } else {
            throw new TclNumArgsException(interp, 2, objv, "?pattern?");
        }
        TclObject list = TclList.newInstance();
        Enumeration search = globalNs.varTable.keys();
        while (search.hasMoreElements()) {
            String varName = (String)search.nextElement();
            Var var = (Var)globalNs.varTable.get(varName);
            if (var.isVarUndefined() || pattern != null && !Util.stringMatch(varName, pattern)) continue;
            TclList.append(interp, list, TclString.newInstance((String)varName));
        }
        interp.setResult(list);
    }

    private static void InfoHostnameCmd(Interp interp, TclObject[] objv) throws TclException {
        String name = null;
        if (objv.length != 2) {
            throw new TclNumArgsException(interp, 2, objv, null);
        }
        try {
            name = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (name != null) {
            interp.setResult(name);
            return;
        }
        interp.setResult("unable to determine name of host");
    }

    private static void InfoLevelCmd(Interp interp, TclObject[] objv) throws TclException {
        if (objv.length == 2) {
            if (interp.varFrame == null) {
                interp.setResult(0);
            } else {
                interp.setResult(interp.varFrame.level);
            }
            return;
        }
        if (objv.length == 3) {
            int level = TclInteger.get((Interp)interp, (TclObject)objv[2]);
            if (level <= 0) {
                if (interp.varFrame == null) {
                    throw new TclException(interp, "bad level \"" + objv[2].toString() + "\"");
                }
                level += interp.varFrame.level;
            }
            CallFrame frame = interp.varFrame;
            while (frame != null && frame.level != level) {
                frame = frame.callerVar;
            }
            if (frame == null || frame.objv == null) {
                throw new TclException(interp, "bad level \"" + objv[2].toString() + "\"");
            }
            TclObject list = TclList.newInstance();
            for (int i = 0; i < frame.objv.length; ++i) {
                TclList.append(interp, list, TclString.newInstance((Object)frame.objv[i]));
            }
            interp.setResult(list);
            return;
        }
        throw new TclNumArgsException(interp, 2, objv, "?number?");
    }

    private static void InfoLibraryCmd(Interp interp, TclObject[] objv) throws TclException {
        if (objv.length != 2) {
            throw new TclNumArgsException(interp, 2, objv, null);
        }
        try {
            interp.setResult(interp.getVar("tcl_library", 1));
            return;
        }
        catch (TclException e) {
            throw new TclException(interp, "no library has been specified for Tcl");
        }
    }

    private static void InfoLoadedCmd(Interp interp, TclObject[] objv) throws TclException {
        if (objv.length != 2 && objv.length != 3) {
            throw new TclNumArgsException(interp, 2, objv, "?interp?");
        }
        throw new TclException(interp, "info loaded not implemented");
    }

    private static void InfoLocalsCmd(Interp interp, TclObject[] objv) throws TclException {
        String pattern;
        if (objv.length == 2) {
            pattern = null;
        } else if (objv.length == 3) {
            pattern = objv[2].toString();
        } else {
            throw new TclNumArgsException(interp, 2, objv, "?pattern?");
        }
        if (interp.varFrame == null || !interp.varFrame.isProcCallFrame) {
            return;
        }
        TclObject list = TclList.newInstance();
        InfoCmd.AppendLocals(interp, list, pattern, false);
        interp.setResult(list);
    }

    private static void AppendLocals(Interp interp, TclObject list, String pattern, boolean includeLinks) throws TclException {
        Hashtable localVarTable = interp.varFrame.varTable;
        if (localVarTable != null) {
            Enumeration search = localVarTable.keys();
            while (search.hasMoreElements()) {
                String varName = (String)search.nextElement();
                Var var = (Var)localVarTable.get(varName);
                if (var.isVarUndefined() || !includeLinks && var.isVarLink() || pattern != null && !Util.stringMatch(varName, pattern)) continue;
                TclList.append(interp, list, TclString.newInstance((String)varName));
            }
        }
    }

    private static void InfoNameOfExecutableCmd(Interp interp, TclObject[] objv) throws TclException {
        if (objv.length != 2) {
            throw new TclNumArgsException(interp, 2, objv, null);
        }
        String nameOfExecutable = System.getProperty("JAVA");
        if (nameOfExecutable != null) {
            TclObject result = TclList.newInstance();
            TclList.append(interp, result, TclString.newInstance((String)nameOfExecutable));
            TclList.append(interp, result, TclString.newInstance((String)"tcl.lang.Shell"));
            interp.setResult(result);
        }
    }

    private static void InfoPatchLevelCmd(Interp interp, TclObject[] objv) throws TclException {
        if (objv.length != 2) {
            throw new TclNumArgsException(interp, 2, objv, null);
        }
        interp.setResult(interp.getVar("tcl_patchLevel", 1));
    }

    private static void InfoProcsCmd(Interp interp, TclObject[] objv) throws TclException {
        String pattern;
        NamespaceCmd.Namespace currNs = NamespaceCmd.getCurrentNamespace(interp);
        if (objv.length == 2) {
            pattern = null;
        } else if (objv.length == 3) {
            pattern = objv[2].toString();
        } else {
            throw new TclNumArgsException(interp, 2, objv, "?pattern?");
        }
        TclObject list = TclList.newInstance();
        Enumeration search = currNs.cmdTable.keys();
        while (search.hasMoreElements()) {
            String cmdName = (String)search.nextElement();
            WrappedCommand cmd = (WrappedCommand)currNs.cmdTable.get(cmdName);
            WrappedCommand realCmd = NamespaceCmd.getOriginalCommand(cmd);
            if (!Procedure.isProc(cmd) && (realCmd == null || !Procedure.isProc(realCmd)) || pattern != null && !Util.stringMatch(cmdName, pattern)) continue;
            TclList.append(interp, list, TclString.newInstance((String)cmdName));
        }
        interp.setResult(list);
    }

    private static void InfoScriptCmd(Interp interp, TclObject[] objv) throws TclException {
        if (objv.length != 2) {
            throw new TclNumArgsException(interp, 2, objv, null);
        }
        interp.setResult(interp.scriptFile);
    }

    private static void InfoSharedlibCmd(Interp interp, TclObject[] objv) throws TclException {
        if (objv.length != 2) {
            throw new TclNumArgsException(interp, 2, objv, null);
        }
        interp.setResult(".jar");
    }

    private static void InfoTclVersionCmd(Interp interp, TclObject[] objv) throws TclException {
        if (objv.length != 2) {
            throw new TclNumArgsException(interp, 2, objv, null);
        }
        interp.setResult(interp.getVar("tcl_version", 1));
    }

    private static void InfoVarsCmd(Interp interp, TclObject[] objv) throws TclException {
        NamespaceCmd.Namespace ns;
        String simplePattern;
        NamespaceCmd.Namespace globalNs = NamespaceCmd.getGlobalNamespace(interp);
        NamespaceCmd.Namespace currNs = NamespaceCmd.getCurrentNamespace(interp);
        boolean specificNsInPattern = false;
        if (objv.length == 2) {
            simplePattern = null;
            ns = currNs;
            specificNsInPattern = false;
        } else if (objv.length == 3) {
            String pattern = objv[2].toString();
            NamespaceCmd.Namespace[] nsArr = new NamespaceCmd.Namespace[1];
            NamespaceCmd.Namespace[] dummy1Arr = new NamespaceCmd.Namespace[1];
            NamespaceCmd.Namespace[] dummy2Arr = new NamespaceCmd.Namespace[1];
            String[] simplePatternArr = new String[1];
            NamespaceCmd.getNamespaceForQualName(interp, pattern, null, 0, nsArr, dummy1Arr, dummy2Arr, simplePatternArr);
            ns = nsArr[0];
            simplePattern = simplePatternArr[0];
            if (ns != null) {
                specificNsInPattern = simplePattern.compareTo(pattern) != 0;
            }
        } else {
            throw new TclNumArgsException(interp, 2, objv, "?pattern?");
        }
        if (ns == null) {
            return;
        }
        TclObject list = TclList.newInstance();
        if (interp.varFrame == null || !interp.varFrame.isProcCallFrame || specificNsInPattern) {
            Var var;
            String varName;
            Enumeration search = ns.varTable.keys();
            while (search.hasMoreElements()) {
                varName = (String)search.nextElement();
                var = (Var)ns.varTable.get(varName);
                if (var.isVarUndefined() && (var.flags & 0x80) == 0 || simplePattern != null && !Util.stringMatch(varName, simplePattern)) continue;
                TclObject elemObj = specificNsInPattern ? TclString.newInstance((String)Var.getVariableFullName(interp, var)) : TclString.newInstance((String)varName);
                TclList.append(interp, list, elemObj);
            }
            if (ns != globalNs && !specificNsInPattern) {
                search = globalNs.varTable.keys();
                while (search.hasMoreElements()) {
                    varName = (String)search.nextElement();
                    var = (Var)globalNs.varTable.get(varName);
                    if (var.isVarUndefined() && (var.flags & 0x80) == 0 || simplePattern != null && !Util.stringMatch(varName, simplePattern) || ns.varTable.get(varName) != null) continue;
                    TclList.append(interp, list, TclString.newInstance((String)varName));
                }
            }
        } else {
            InfoCmd.AppendLocals(interp, list, simplePattern, true);
        }
        interp.setResult(list);
    }
}

