/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownServiceException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import tcl.lang.AssocData;
import tcl.lang.BackSlashResult;
import tcl.lang.BgErrorMgr;
import tcl.lang.CallFrame;
import tcl.lang.Channel;
import tcl.lang.CharPointer;
import tcl.lang.Command;
import tcl.lang.CommandWithDispose;
import tcl.lang.DebugInfo;
import tcl.lang.Env;
import tcl.lang.EventuallyFreed;
import tcl.lang.Expression;
import tcl.lang.Extension;
import tcl.lang.FileChannel;
import tcl.lang.FileUtil;
import tcl.lang.ImportRef;
import tcl.lang.ImportedCmdData;
import tcl.lang.InterpAliasCmd;
import tcl.lang.InterpSlaveCmd;
import tcl.lang.NamespaceCmd;
import tcl.lang.Notifier;
import tcl.lang.PackageCmd;
import tcl.lang.Parser;
import tcl.lang.Procedure;
import tcl.lang.ReadInputStreamChannel;
import tcl.lang.RegexpCmd;
import tcl.lang.Resolver;
import tcl.lang.TclBoolean;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclIO;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclParse;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.TclToken;
import tcl.lang.Util;
import tcl.lang.Var;
import tcl.lang.VarTrace;
import tcl.lang.WrappedCommand;

public class Interp
extends EventuallyFreed {
    Hashtable reflectObjTable = new Hashtable();
    long reflectObjCount = 0L;
    Hashtable reflectConflictTable = new Hashtable();
    private static final int MAX_ERR_LENGTH = 200;
    static final String TCL_VERSION = "8.0";
    static final String TCL_PATCH_LEVEL = "8.0";
    protected int cmdCount;
    Hashtable interpChanTable;
    private Notifier notifier;
    Hashtable assocData;
    private File workingDir;
    CallFrame frame;
    CallFrame varFrame;
    NamespaceCmd.Namespace globalNs;
    Hashtable hiddenCmdTable;
    Hashtable slaveTable;
    Hashtable targetTable;
    InterpSlaveCmd slave;
    Hashtable aliasTable;
    String scriptFile;
    int nestLevel;
    int maxNestingDepth;
    int evalFlags;
    int flags;
    boolean isSafe;
    int termOffset;
    Vector resolvers;
    Expression expr;
    int noEval;
    boolean randSeedInit;
    long randSeed;
    String errorInfo;
    String errorCode;
    protected int returnCode;
    protected boolean deleted;
    protected boolean errInProgress;
    protected boolean errAlreadyLogged;
    protected boolean errCodeSet;
    int errorLine = 0;
    private TclObject m_result;
    private TclObject m_nullResult;
    private Thread cThread;
    Hashtable packageTable;
    String packageUnknown;
    TclObject[][][] parserObjv;
    int[] parserObjvUsed;
    TclToken[] parserTokens;
    int parserTokensUsed;
    Hashtable[] importTable = new Hashtable[]{new Hashtable(), new Hashtable()};
    static final String[] unsafeCmds = new String[]{"encoding", "exit", "load", "cd", "fconfigure", "file", "glob", "open", "pwd", "socket", "beep", "echo", "ls", "resource", "source", "exec", "source"};
    static final int INVOKE_HIDDEN = 1;
    static final int INVOKE_NO_UNKNOWN = 2;
    static final int INVOKE_NO_TRACEBACK = 4;
    protected DebugInfo dbg;

    public Interp() {
        this.m_nullResult = TclString.newInstance((String)"");
        this.m_nullResult.preserve();
        this.m_nullResult.preserve();
        this.m_result = this.m_nullResult;
        this.expr = new Expression();
        this.nestLevel = 0;
        this.maxNestingDepth = 1000;
        this.frame = null;
        this.varFrame = null;
        this.returnCode = 0;
        this.errorInfo = null;
        this.errorCode = null;
        this.packageTable = new Hashtable();
        this.packageUnknown = null;
        this.cmdCount = 0;
        this.termOffset = 0;
        this.resolvers = null;
        this.evalFlags = 0;
        this.scriptFile = null;
        this.flags = 0;
        this.isSafe = false;
        this.assocData = null;
        this.globalNs = null;
        this.globalNs = NamespaceCmd.createNamespace(this, null, null);
        if (this.globalNs == null) {
            throw new TclRuntimeError("Interp(): can't create global namespace");
        }
        this.workingDir = new File(Util.tryGetSystemProperty("user.dir", "."));
        this.noEval = 0;
        this.cThread = Thread.currentThread();
        this.notifier = Notifier.getNotifierForThread(this.cThread);
        this.notifier.preserve();
        this.randSeedInit = false;
        this.deleted = false;
        this.errInProgress = false;
        this.errAlreadyLogged = false;
        this.errCodeSet = false;
        this.dbg = this.initDebugInfo();
        this.slaveTable = new Hashtable();
        this.targetTable = new Hashtable();
        this.aliasTable = new Hashtable();
        Parser.init(this);
        TclParse.init(this);
        this.interpChanTable = TclIO.getInterpChanTable(this);
        Util.setupPrecisionTrace(this);
        this.createCommands();
        try {
            this.setVar("tcl_platform", "platform", "java", 1);
            this.setVar("tcl_platform", "byteOrder", "bigEndian", 1);
            this.setVar("tcl_platform", "os", Util.tryGetSystemProperty("os.name", "?"), 1);
            this.setVar("tcl_platform", "osVersion", Util.tryGetSystemProperty("os.version", "?"), 1);
            this.setVar("tcl_platform", "machine", Util.tryGetSystemProperty("os.arch", "?"), 1);
            this.setVar("tcl_version", "8.0", 1);
            this.setVar("tcl_patchLevel", "8.0", 1);
            this.setVar("tcl_library", "resource:/tcl/lang/library", 1);
            if (Util.isWindows()) {
                this.setVar("tcl_platform", "host_platform", "windows", 1);
            } else if (Util.isMac()) {
                this.setVar("tcl_platform", "host_platform", "macintosh", 1);
            } else {
                this.setVar("tcl_platform", "host_platform", "unix", 1);
            }
            Env.initialize(this);
            this.pkgProvide("Tcl", "8.0");
            this.evalResource("/tcl/lang/library/init.tcl");
        }
        catch (TclException e) {
            System.out.println(this.getResult());
            e.printStackTrace();
            throw new TclRuntimeError("unexpected TclException: " + (Object)((Object)e));
        }
    }

    public void dispose() {
        if (Thread.currentThread() != this.cThread) {
            throw new TclRuntimeError("Interp.dispose() invoked in thread other than the one it was created in");
        }
        super.dispose();
    }

    public void eventuallyDispose() {
        if (this.deleted) {
            return;
        }
        this.deleted = true;
        if (this.nestLevel > 0) {
            throw new TclRuntimeError("dispose() called with active evals");
        }
        if (this.notifier != null) {
            this.notifier.release();
            this.notifier = null;
        }
        NamespaceCmd.teardownNamespace(this.globalNs);
        TclObject errorInfoObj = null;
        TclObject errorCodeObj = null;
        try {
            errorInfoObj = this.getVar("errorInfo", null, 1);
        }
        catch (TclException e) {
            // empty catch block
        }
        if (errorInfoObj != null) {
            errorInfoObj.preserve();
        }
        try {
            errorCodeObj = this.getVar("errorCode", null, 1);
        }
        catch (TclException e) {
            // empty catch block
        }
        if (errorCodeObj != null) {
            errorCodeObj.preserve();
        }
        this.frame = null;
        this.varFrame = null;
        try {
            if (errorInfoObj != null) {
                this.setVar("errorInfo", null, errorInfoObj, 1);
                errorInfoObj.release();
            }
            if (errorCodeObj != null) {
                this.setVar("errorCode", null, errorCodeObj, 1);
                errorCodeObj.release();
            }
        }
        catch (TclException e) {
            // empty catch block
        }
        this.expr = null;
        while (this.assocData != null) {
            Hashtable table = this.assocData;
            this.assocData = null;
            Enumeration e = table.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                AssocData data = (AssocData)table.get(key);
                data.disposeAssocData(this);
                table.remove(key);
            }
        }
        Enumeration e = this.interpChanTable.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Channel chan = (Channel)this.interpChanTable.get(key);
            try {
                chan.close();
            }
            catch (IOException ex) {}
        }
        NamespaceCmd.deleteNamespace(this.globalNs);
        this.globalNs = null;
        this.frame = null;
        this.varFrame = null;
        this.resolvers = null;
        this.resetResult();
    }

    protected void finalize() {
        this.dispose();
    }

    protected void createCommands() {
        Extension.loadOnDemand((Interp)this, (String)"after", (String)"tcl.lang.AfterCmd");
        Extension.loadOnDemand((Interp)this, (String)"append", (String)"tcl.lang.AppendCmd");
        Extension.loadOnDemand((Interp)this, (String)"array", (String)"tcl.lang.ArrayCmd");
        Extension.loadOnDemand((Interp)this, (String)"binary", (String)"tcl.lang.BinaryCmd");
        Extension.loadOnDemand((Interp)this, (String)"break", (String)"tcl.lang.BreakCmd");
        Extension.loadOnDemand((Interp)this, (String)"case", (String)"tcl.lang.CaseCmd");
        Extension.loadOnDemand((Interp)this, (String)"catch", (String)"tcl.lang.CatchCmd");
        Extension.loadOnDemand((Interp)this, (String)"cd", (String)"tcl.lang.CdCmd");
        Extension.loadOnDemand((Interp)this, (String)"clock", (String)"tcl.lang.ClockCmd");
        Extension.loadOnDemand((Interp)this, (String)"close", (String)"tcl.lang.CloseCmd");
        Extension.loadOnDemand((Interp)this, (String)"continue", (String)"tcl.lang.ContinueCmd");
        Extension.loadOnDemand((Interp)this, (String)"concat", (String)"tcl.lang.ConcatCmd");
        Extension.loadOnDemand((Interp)this, (String)"encoding", (String)"tcl.lang.EncodingCmd");
        Extension.loadOnDemand((Interp)this, (String)"eof", (String)"tcl.lang.EofCmd");
        Extension.loadOnDemand((Interp)this, (String)"eval", (String)"tcl.lang.EvalCmd");
        Extension.loadOnDemand((Interp)this, (String)"error", (String)"tcl.lang.ErrorCmd");
        if (!Util.isMac()) {
            Extension.loadOnDemand((Interp)this, (String)"exec", (String)"tcl.lang.ExecCmd");
        }
        Extension.loadOnDemand((Interp)this, (String)"exit", (String)"tcl.lang.ExitCmd");
        Extension.loadOnDemand((Interp)this, (String)"expr", (String)"tcl.lang.ExprCmd");
        Extension.loadOnDemand((Interp)this, (String)"fblocked", (String)"tcl.lang.FblockedCmd");
        Extension.loadOnDemand((Interp)this, (String)"fconfigure", (String)"tcl.lang.FconfigureCmd");
        Extension.loadOnDemand((Interp)this, (String)"file", (String)"tcl.lang.FileCmd");
        Extension.loadOnDemand((Interp)this, (String)"flush", (String)"tcl.lang.FlushCmd");
        Extension.loadOnDemand((Interp)this, (String)"for", (String)"tcl.lang.ForCmd");
        Extension.loadOnDemand((Interp)this, (String)"foreach", (String)"tcl.lang.ForeachCmd");
        Extension.loadOnDemand((Interp)this, (String)"format", (String)"tcl.lang.FormatCmd");
        Extension.loadOnDemand((Interp)this, (String)"gets", (String)"tcl.lang.GetsCmd");
        Extension.loadOnDemand((Interp)this, (String)"global", (String)"tcl.lang.GlobalCmd");
        Extension.loadOnDemand((Interp)this, (String)"glob", (String)"tcl.lang.GlobCmd");
        Extension.loadOnDemand((Interp)this, (String)"if", (String)"tcl.lang.IfCmd");
        Extension.loadOnDemand((Interp)this, (String)"incr", (String)"tcl.lang.IncrCmd");
        Extension.loadOnDemand((Interp)this, (String)"info", (String)"tcl.lang.InfoCmd");
        Extension.loadOnDemand((Interp)this, (String)"interp", (String)"tcl.lang.InterpCmd");
        Extension.loadOnDemand((Interp)this, (String)"list", (String)"tcl.lang.ListCmd");
        Extension.loadOnDemand((Interp)this, (String)"join", (String)"tcl.lang.JoinCmd");
        Extension.loadOnDemand((Interp)this, (String)"lappend", (String)"tcl.lang.LappendCmd");
        Extension.loadOnDemand((Interp)this, (String)"lindex", (String)"tcl.lang.LindexCmd");
        Extension.loadOnDemand((Interp)this, (String)"linsert", (String)"tcl.lang.LinsertCmd");
        Extension.loadOnDemand((Interp)this, (String)"llength", (String)"tcl.lang.LlengthCmd");
        Extension.loadOnDemand((Interp)this, (String)"lrange", (String)"tcl.lang.LrangeCmd");
        Extension.loadOnDemand((Interp)this, (String)"lreplace", (String)"tcl.lang.LreplaceCmd");
        Extension.loadOnDemand((Interp)this, (String)"lsearch", (String)"tcl.lang.LsearchCmd");
        Extension.loadOnDemand((Interp)this, (String)"lsort", (String)"tcl.lang.LsortCmd");
        Extension.loadOnDemand((Interp)this, (String)"namespace", (String)"tcl.lang.NamespaceCmd");
        Extension.loadOnDemand((Interp)this, (String)"open", (String)"tcl.lang.OpenCmd");
        Extension.loadOnDemand((Interp)this, (String)"package", (String)"tcl.lang.PackageCmd");
        Extension.loadOnDemand((Interp)this, (String)"proc", (String)"tcl.lang.ProcCmd");
        Extension.loadOnDemand((Interp)this, (String)"puts", (String)"tcl.lang.PutsCmd");
        Extension.loadOnDemand((Interp)this, (String)"pwd", (String)"tcl.lang.PwdCmd");
        Extension.loadOnDemand((Interp)this, (String)"read", (String)"tcl.lang.ReadCmd");
        Extension.loadOnDemand((Interp)this, (String)"regsub", (String)"tcl.lang.RegsubCmd");
        Extension.loadOnDemand((Interp)this, (String)"rename", (String)"tcl.lang.RenameCmd");
        Extension.loadOnDemand((Interp)this, (String)"return", (String)"tcl.lang.ReturnCmd");
        Extension.loadOnDemand((Interp)this, (String)"scan", (String)"tcl.lang.ScanCmd");
        Extension.loadOnDemand((Interp)this, (String)"seek", (String)"tcl.lang.SeekCmd");
        Extension.loadOnDemand((Interp)this, (String)"set", (String)"tcl.lang.SetCmd");
        Extension.loadOnDemand((Interp)this, (String)"socket", (String)"tcl.lang.SocketCmd");
        Extension.loadOnDemand((Interp)this, (String)"source", (String)"tcl.lang.SourceCmd");
        Extension.loadOnDemand((Interp)this, (String)"split", (String)"tcl.lang.SplitCmd");
        Extension.loadOnDemand((Interp)this, (String)"string", (String)"tcl.lang.StringCmd");
        Extension.loadOnDemand((Interp)this, (String)"subst", (String)"tcl.lang.SubstCmd");
        Extension.loadOnDemand((Interp)this, (String)"switch", (String)"tcl.lang.SwitchCmd");
        Extension.loadOnDemand((Interp)this, (String)"tell", (String)"tcl.lang.TellCmd");
        Extension.loadOnDemand((Interp)this, (String)"time", (String)"tcl.lang.TimeCmd");
        Extension.loadOnDemand((Interp)this, (String)"trace", (String)"tcl.lang.TraceCmd");
        Extension.loadOnDemand((Interp)this, (String)"unset", (String)"tcl.lang.UnsetCmd");
        Extension.loadOnDemand((Interp)this, (String)"update", (String)"tcl.lang.UpdateCmd");
        Extension.loadOnDemand((Interp)this, (String)"uplevel", (String)"tcl.lang.UplevelCmd");
        Extension.loadOnDemand((Interp)this, (String)"upvar", (String)"tcl.lang.UpvarCmd");
        Extension.loadOnDemand((Interp)this, (String)"variable", (String)"tcl.lang.VariableCmd");
        Extension.loadOnDemand((Interp)this, (String)"vwait", (String)"tcl.lang.VwaitCmd");
        Extension.loadOnDemand((Interp)this, (String)"while", (String)"tcl.lang.WhileCmd");
        RegexpCmd.init(this);
        Extension.loadOnDemand((Interp)this, (String)"jaclloadjava", (String)"tcl.lang.JaclLoadJavaCmd");
        try {
            this.eval("package ifneeded java 1.3.2 jaclloadjava");
        }
        catch (TclException e) {
            System.out.println(this.getResult());
            e.printStackTrace();
            throw new TclRuntimeError("unexpected TclException: " + (Object)((Object)e));
        }
    }

    public void setAssocData(String name, AssocData data) {
        if (this.assocData == null) {
            this.assocData = new Hashtable();
        }
        this.assocData.put(name, data);
    }

    public void deleteAssocData(String name) {
        if (this.assocData == null) {
            return;
        }
        this.assocData.remove(name);
    }

    public AssocData getAssocData(String name) {
        if (this.assocData == null) {
            return null;
        }
        return (AssocData)this.assocData.get(name);
    }

    public void backgroundError() {
        BgErrorMgr mgr = (BgErrorMgr)this.getAssocData("tclBgError");
        if (mgr == null) {
            mgr = new BgErrorMgr(this);
            this.setAssocData("tclBgError", mgr);
        }
        mgr.addBgError();
    }

    final TclObject setVar(TclObject nameObj, TclObject value, int flags) throws TclException {
        return Var.setVar(this, nameObj, value, flags | 0x200);
    }

    public final TclObject setVar(String name, TclObject value, int flags) throws TclException {
        return Var.setVar(this, name, value, flags | 0x200);
    }

    public final TclObject setVar(String name1, String name2, TclObject value, int flags) throws TclException {
        return Var.setVar(this, name1, name2, value, flags | 0x200);
    }

    final void setVar(String name, String strValue, int flags) throws TclException {
        Var.setVar(this, name, TclString.newInstance((String)strValue), flags | 0x200);
    }

    final void setVar(String name1, String name2, String strValue, int flags) throws TclException {
        Var.setVar(this, name1, name2, TclString.newInstance((String)strValue), flags | 0x200);
    }

    final TclObject getVar(TclObject nameObj, int flags) throws TclException {
        return Var.getVar(this, nameObj, flags | 0x200);
    }

    public final TclObject getVar(String name, int flags) throws TclException {
        return Var.getVar(this, name, flags | 0x200);
    }

    public final TclObject getVar(String name1, String name2, int flags) throws TclException {
        return Var.getVar(this, name1, name2, flags | 0x200);
    }

    final void unsetVar(TclObject nameObj, int flags) throws TclException {
        Var.unsetVar(this, nameObj, flags | 0x200);
    }

    public final void unsetVar(String name, int flags) throws TclException {
        Var.unsetVar(this, name, flags | 0x200);
    }

    public final void unsetVar(String name1, String name2, int flags) throws TclException {
        Var.unsetVar(this, name1, name2, flags | 0x200);
    }

    void traceVar(TclObject nameObj, VarTrace trace, int flags) throws TclException {
        Var.traceVar(this, nameObj, flags, trace);
    }

    public void traceVar(String name, VarTrace trace, int flags) throws TclException {
        Var.traceVar(this, name, flags, trace);
    }

    public void traceVar(String part1, String part2, VarTrace trace, int flags) throws TclException {
        Var.traceVar(this, part1, part2, flags, trace);
    }

    void untraceVar(TclObject nameObj, VarTrace trace, int flags) {
        Var.untraceVar(this, nameObj, flags, trace);
    }

    public void untraceVar(String name, VarTrace trace, int flags) {
        Var.untraceVar(this, name, flags, trace);
    }

    public void untraceVar(String part1, String part2, VarTrace trace, int flags) {
        Var.untraceVar(this, part1, part2, flags, trace);
    }

    public void createCommand(String cmdName, Command cmdImpl) {
        WrappedCommand cmd;
        String tail;
        NamespaceCmd.Namespace ns;
        ImportRef oldRef = null;
        if (this.deleted) {
            return;
        }
        if (cmdName.indexOf("::") != -1) {
            NamespaceCmd.Namespace[] nsArr = new NamespaceCmd.Namespace[1];
            NamespaceCmd.Namespace[] dummyArr = new NamespaceCmd.Namespace[1];
            String[] tailArr = new String[1];
            NamespaceCmd.getNamespaceForQualName(this, cmdName, null, 2048, nsArr, dummyArr, dummyArr, tailArr);
            ns = nsArr[0];
            tail = tailArr[0];
            if (ns == null || tail == null) {
                return;
            }
        } else {
            ns = this.globalNs;
            tail = cmdName;
        }
        if ((cmd = (WrappedCommand)ns.cmdTable.get(tail)) != null) {
            oldRef = cmd.importRef;
            cmd.importRef = null;
            this.deleteCommandFromToken(cmd);
            cmd = (WrappedCommand)ns.cmdTable.get(tail);
            if (cmd != null) {
                cmd.table.remove(cmd.hashKey);
            }
        }
        cmd = new WrappedCommand();
        ns.cmdTable.put(tail, cmd);
        cmd.table = ns.cmdTable;
        cmd.hashKey = tail;
        cmd.ns = ns;
        cmd.cmd = cmdImpl;
        cmd.deleted = false;
        if (oldRef != null) {
            cmd.importRef = oldRef;
            while (oldRef != null) {
                WrappedCommand refCmd = oldRef.importedCmd;
                ImportedCmdData data = (ImportedCmdData)refCmd.cmd;
                data.realCmd = cmd;
                oldRef = oldRef.next;
            }
        }
    }

    String getCommandFullName(WrappedCommand cmd) {
        Interp interp = this;
        StringBuffer name = new StringBuffer();
        if (cmd != null) {
            if (cmd.ns != null) {
                name.append(cmd.ns.fullName);
                if (cmd.ns != interp.globalNs) {
                    name.append("::");
                }
            }
            if (cmd.table != null) {
                name.append(cmd.hashKey);
            }
        }
        return name.toString();
    }

    public int deleteCommand(String cmdName) {
        WrappedCommand cmd;
        try {
            cmd = NamespaceCmd.findCommand(this, cmdName, null, 0);
        }
        catch (TclException e) {
            throw new TclRuntimeError("unexpected TclException: " + (Object)((Object)e));
        }
        if (cmd == null) {
            return -1;
        }
        return this.deleteCommandFromToken(cmd);
    }

    protected int deleteCommandFromToken(WrappedCommand cmd) {
        if (cmd == null) {
            return -1;
        }
        if (cmd.deleted) {
            if (cmd.hashKey != null && cmd.table != null) {
                cmd.table.remove(cmd.hashKey);
                cmd.table = null;
                cmd.hashKey = null;
            }
            return 0;
        }
        cmd.deleted = true;
        if (cmd.cmd instanceof CommandWithDispose) {
            ((CommandWithDispose)cmd.cmd).disposeCmd();
        }
        ImportRef ref = cmd.importRef;
        while (ref != null) {
            ImportRef nextRef = ref.next;
            WrappedCommand importCmd = ref.importedCmd;
            this.deleteCommandFromToken(importCmd);
            ref = nextRef;
        }
        if (cmd.table != null) {
            cmd.table.remove(cmd.hashKey);
            cmd.table = null;
            cmd.hashKey = null;
        }
        cmd.cmd = null;
        return 0;
    }

    protected void renameCommand(String oldName, String newName) throws TclException {
        Interp interp = this;
        WrappedCommand cmd = NamespaceCmd.findCommand(interp, oldName, null, 0);
        if (cmd == null) {
            throw new TclException(interp, "can't " + (newName == null || newName.length() == 0 ? "delete" : "rename") + " \"" + oldName + "\": command doesn't exist");
        }
        NamespaceCmd.Namespace cmdNs = cmd.ns;
        if (newName == null || newName.length() == 0) {
            this.deleteCommandFromToken(cmd);
            return;
        }
        NamespaceCmd.Namespace[] newNsArr = new NamespaceCmd.Namespace[1];
        NamespaceCmd.Namespace[] dummyArr = new NamespaceCmd.Namespace[1];
        String[] newTailArr = new String[1];
        NamespaceCmd.getNamespaceForQualName(interp, newName, null, 2048, newNsArr, dummyArr, dummyArr, newTailArr);
        NamespaceCmd.Namespace newNs = newNsArr[0];
        String newTail = newTailArr[0];
        if (newNs == null || newTail == null) {
            throw new TclException(interp, "can't rename to \"" + newName + "\": bad command name");
        }
        if (newNs.cmdTable.get(newTail) != null) {
            throw new TclException(interp, "can't rename to \"" + newName + "\": command already exists");
        }
        Hashtable oldTable = cmd.table;
        String oldHashKey = cmd.hashKey;
        newNs.cmdTable.put(newTail, cmd);
        cmd.table = newNs.cmdTable;
        cmd.hashKey = newTail;
        cmd.ns = newNs;
        if (cmd.cmd instanceof Procedure) {
            Procedure p = (Procedure)cmd.cmd;
            p.ns = cmd.ns;
        }
        try {
            interp.preventAliasLoop(interp, cmd);
        }
        catch (TclException e) {
            newNs.cmdTable.remove(newTail);
            cmd.table = oldTable;
            cmd.hashKey = oldHashKey;
            cmd.ns = cmdNs;
            throw e;
        }
        oldTable.remove(oldHashKey);
    }

    void preventAliasLoop(Interp cmdInterp, WrappedCommand cmd) throws TclException {
        InterpAliasCmd alias;
        if (!(cmd.cmd instanceof InterpAliasCmd)) {
            return;
        }
        InterpAliasCmd nextAlias = alias = (InterpAliasCmd)cmd.cmd;
        WrappedCommand aliasCmd;
        while ((aliasCmd = nextAlias.getTargetCmd(this)) != null) {
            if (aliasCmd.cmd == cmd.cmd) {
                throw new TclException(this, "cannot define or rename alias \"" + alias.name + "\": would create a loop");
            }
            if (!(aliasCmd.cmd instanceof InterpAliasCmd)) {
                return;
            }
            nextAlias = (InterpAliasCmd)aliasCmd.cmd;
        }
        return;
    }

    public Command getCommand(String cmdName) {
        WrappedCommand cmd;
        try {
            cmd = NamespaceCmd.findCommand(this, cmdName, null, 0);
        }
        catch (TclException e) {
            throw new TclRuntimeError("unexpected TclException: " + (Object)((Object)e));
        }
        return cmd == null ? null : cmd.cmd;
    }

    public static boolean commandComplete(String string) {
        return Parser.commandComplete(string, string.length());
    }

    public final TclObject getResult() {
        return this.m_result;
    }

    public final void setResult(TclObject r) {
        if (r == null) {
            throw new NullPointerException("Interp.setResult() called with null TclObject argument.");
        }
        if (r == this.m_result) {
            return;
        }
        if (this.m_result != this.m_nullResult) {
            this.m_result.release();
        }
        this.m_result = r;
        if (this.m_result != this.m_nullResult) {
            this.m_result.preserve();
        }
    }

    public final void setResult(String r) {
        if (r == null) {
            this.resetResult();
        } else {
            this.setResult(TclString.newInstance((String)r));
        }
    }

    public final void setResult(int r) {
        this.setResult(TclInteger.newInstance((int)r));
    }

    public final void setResult(double r) {
        this.setResult(TclDouble.newInstance((double)r));
    }

    public final void setResult(boolean r) {
        this.setResult(TclBoolean.newInstance((boolean)r));
    }

    public final void resetResult() {
        if (this.m_result != this.m_nullResult) {
            this.m_result.release();
            this.m_result = this.m_nullResult;
            if (!this.m_nullResult.isShared()) {
                throw new TclRuntimeError("m_nullResult is not shared");
            }
        }
        this.errAlreadyLogged = false;
        this.errInProgress = false;
        this.errCodeSet = false;
        this.returnCode = 0;
    }

    void appendElement(String string) throws TclException {
        TclObject result = this.getResult();
        if (result.isShared()) {
            result = result.duplicate();
        }
        TclList.append(this, result, TclString.newInstance((String)string));
        this.setResult(result);
    }

    public void eval(String string, int flags) throws TclException {
        block5: {
            int evalFlags = this.evalFlags;
            this.evalFlags &= 0xFFFFFFFB;
            CharPointer script = new CharPointer(string);
            try {
                Parser.eval2(this, script.array, script.index, script.length(), flags);
            }
            catch (TclException e) {
                if (this.nestLevel != 0) {
                    throw e;
                }
                int result = e.getCompletionCode();
                if (result == 2) {
                    result = this.updateReturnInfo();
                }
                if (result != 0 && result != 1 && (evalFlags & 4) == 0) {
                    this.processUnexpectedResult(result);
                }
                if (result == 0) break block5;
                e.setCompletionCode(result);
                throw e;
            }
        }
    }

    public void eval(String script) throws TclException {
        this.eval(script, 0);
    }

    public void eval(TclObject tobj, int flags) throws TclException {
        this.eval(tobj.toString(), flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordAndEval(TclObject script, int flags) throws TclException {
        TclObject cmd = null;
        try {
            cmd = TclList.newInstance();
            TclList.append(this, cmd, TclString.newInstance((String)"history"));
            TclList.append(this, cmd, TclString.newInstance((String)"add"));
            TclList.append(this, cmd, script);
            cmd.preserve();
            this.eval(cmd, 131072);
        }
        catch (Exception e) {
        }
        finally {
            cmd.release();
        }
        if ((flags & 0x10000) == 0) {
            this.eval(script, flags & 0x20000);
        }
    }

    public void evalFile(String s) throws TclException {
        String fileContent = this.readScriptFromFile(s);
        if (fileContent == null) {
            throw new TclException(this, "couldn't read file \"" + s + "\"");
        }
        String oldScript = this.scriptFile;
        this.scriptFile = s;
        try {
            this.pushDebugStack(s, 1);
            this.eval(fileContent, 0);
        }
        catch (TclException e) {
            if (e.getCompletionCode() == 1) {
                this.addErrorInfo("\n    (file \"" + s + "\" line " + this.errorLine + ")");
            }
            throw e;
        }
        finally {
            this.scriptFile = oldScript;
            this.popDebugStack();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void evalURL(URL context, String s) throws TclException {
        String fileContent = this.readScriptFromURL(context, s);
        if (fileContent == null) {
            throw new TclException(this, "cannot read URL \"" + s + "\"");
        }
        String oldScript = this.scriptFile;
        this.scriptFile = s;
        try {
            this.eval(fileContent, 0);
        }
        finally {
            this.scriptFile = oldScript;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readScriptFromFile(String s) {
        FileChannel fchan = new FileChannel();
        boolean wasOpened = false;
        TclObject result = TclString.newInstance((StringBuffer)new StringBuffer(64));
        try {
            File sourceFile = FileUtil.getNewFileObj(this, s);
            fchan.open(this, sourceFile.getPath(), 1);
            wasOpened = true;
            fchan.read(this, result, 1, 0);
            String string = result.toString();
            return string;
        }
        catch (TclException e) {
            this.resetResult();
            String string = null;
            return string;
        }
        catch (FileNotFoundException e) {
            String string = null;
            return string;
        }
        catch (IOException e) {
            String string = null;
            return string;
        }
        catch (SecurityException e) {
            String string = null;
            return string;
        }
        finally {
            if (wasOpened) {
                this.closeChannel(fchan);
            }
        }
    }

    private String readScriptFromURL(URL context, String s) {
        URL url;
        Object content = null;
        try {
            url = new URL(context, s);
        }
        catch (MalformedURLException e) {
            return null;
        }
        try {
            content = url.getContent();
        }
        catch (UnknownServiceException e) {
            URLConnection jar;
            Class<?> jar_class;
            try {
                jar_class = Class.forName("java.net.JarURLConnection");
            }
            catch (Exception e2) {
                return null;
            }
            try {
                jar = url.openConnection();
            }
            catch (IOException e2) {
                return null;
            }
            if (jar == null) {
                return null;
            }
            try {
                Method m = jar_class.getMethod("openConnection", null);
                content = m.invoke((Object)jar, null);
            }
            catch (Exception e2) {
                return null;
            }
        }
        catch (IOException e) {
            return null;
        }
        catch (SecurityException e) {
            return null;
        }
        if (content instanceof String) {
            return this.convertStringCRLF((String)content);
        }
        if (content instanceof InputStream) {
            return this.readScriptFromInputStream((InputStream)content);
        }
        return null;
    }

    String convertStringCRLF(String inStr) {
        String str = inStr;
        StringBuffer sb = new StringBuffer(str.length());
        int prev = 10;
        boolean foundCRLF = false;
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            if (c == '\n' && prev == 13) {
                sb.setCharAt(sb.length() - 1, '\n');
                prev = 10;
                foundCRLF = true;
                continue;
            }
            sb.append(c);
            prev = c;
        }
        if (foundCRLF) {
            return sb.toString();
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readScriptFromInputStream(InputStream s) {
        TclObject result = TclString.newInstance((StringBuffer)new StringBuffer(64));
        ReadInputStreamChannel rc = new ReadInputStreamChannel(this, s);
        try {
            rc.read(this, result, 1, 0);
            String string = result.toString();
            return string;
        }
        catch (TclException e) {
            this.resetResult();
            String string = null;
            return string;
        }
        catch (FileNotFoundException e) {
            String string = null;
            return string;
        }
        catch (IOException e) {
            String string = null;
            return string;
        }
        catch (SecurityException e) {
            String string = null;
            return string;
        }
        finally {
            this.closeChannel(rc);
            this.closeInputStream(s);
        }
    }

    private void closeInputStream(InputStream fs) {
        try {
            fs.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void closeChannel(Channel chan) {
        try {
            chan.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void evalResource(String resName) throws TclException {
        InputStream stream = null;
        try {
            stream = Interp.class.getResourceAsStream(resName);
        }
        catch (SecurityException e2) {
            System.err.println("evalResource: Ignoring SecurityException, it is likely we are running in an applet: cannot read resource \"" + resName + "\"" + e2);
            return;
        }
        if (stream == null) {
            throw new TclException(this, "cannot read resource \"" + resName + "\"");
        }
        String script = this.readScriptFromInputStream(stream);
        this.eval(script, 0);
    }

    static BackSlashResult backslash(String s, int i, int len) {
        CharPointer script = new CharPointer(s.substring(0, len));
        script.index = i;
        return Parser.backslash(script.array, script.index);
    }

    public void setErrorCode(TclObject code) {
        try {
            this.setVar("errorCode", null, code, 1);
            this.errCodeSet = true;
        }
        catch (TclException tclException) {
            // empty catch block
        }
    }

    public void addErrorInfo(String message) {
        if (!this.errInProgress) {
            this.errInProgress = true;
            try {
                this.setVar("errorInfo", null, this.getResult().toString(), 1);
            }
            catch (TclException e1) {
                // empty catch block
            }
            if (!this.errCodeSet) {
                try {
                    this.setVar("errorCode", null, "NONE", 1);
                }
                catch (TclException e1) {
                    // empty catch block
                }
            }
        }
        try {
            this.setVar("errorInfo", null, message, 5);
        }
        catch (TclException tclException) {
            // empty catch block
        }
    }

    void processUnexpectedResult(int returnCode) throws TclException {
        this.resetResult();
        if (returnCode == 3) {
            throw new TclException(this, "invoked \"break\" outside of a loop");
        }
        if (returnCode == 4) {
            throw new TclException(this, "invoked \"continue\" outside of a loop");
        }
        throw new TclException(this, "command returned bad code: " + returnCode);
    }

    protected int updateReturnInfo() {
        int code = this.returnCode;
        this.returnCode = 0;
        if (code == 1) {
            try {
                this.setVar("errorCode", null, this.errorCode != null ? this.errorCode : "NONE", 1);
            }
            catch (TclException e) {
                // empty catch block
            }
            this.errCodeSet = true;
            if (this.errorInfo != null) {
                try {
                    this.setVar("errorInfo", null, this.errorInfo, 1);
                }
                catch (TclException tclException) {
                    // empty catch block
                }
                this.errInProgress = true;
            }
        }
        return code;
    }

    protected CallFrame newCallFrame(Procedure proc, TclObject[] objv) throws TclException {
        return new CallFrame(this, proc, objv);
    }

    protected CallFrame newCallFrame() {
        return new CallFrame(this);
    }

    File getWorkingDir() {
        if (this.workingDir == null) {
            try {
                String dirName = this.getVar("env", "HOME", 0).toString();
                this.workingDir = FileUtil.getNewFileObj(this, dirName);
            }
            catch (TclException e) {
                this.resetResult();
            }
            this.workingDir = new File(Util.tryGetSystemProperty("user.home", "."));
        }
        return this.workingDir;
    }

    void setWorkingDir(String dirName) throws TclException {
        File dirObj = FileUtil.getNewFileObj(this, dirName);
        try {
            dirObj = new File(dirObj.getCanonicalPath());
        }
        catch (IOException e) {
            // empty catch block
        }
        if (!dirObj.isDirectory()) {
            String dname = FileUtil.translateFileName(this, dirName);
            dname = FileUtil.getPathType(dname) == 0 ? dirName : dirObj.getPath();
            throw new TclException(this, "couldn't change working directory to \"" + dname + "\": no such file or directory");
        }
        this.workingDir = dirObj;
    }

    public Notifier getNotifier() {
        return this.notifier;
    }

    public final void pkgProvide(String name, String version) throws TclException {
        PackageCmd.pkgProvide(this, name, version);
    }

    public final String pkgRequire(String pkgname, String version, boolean exact) throws TclException {
        return PackageCmd.pkgRequire(this, pkgname, version, exact);
    }

    protected DebugInfo initDebugInfo() {
        return new DebugInfo(null, 1);
    }

    void pushDebugStack(String fileName, int lineNumber) {
    }

    void popDebugStack() throws TclRuntimeError {
    }

    String getScriptFile() {
        return this.dbg.fileName;
    }

    int getArgLineNumber(int index) {
        return 0;
    }

    void transferResult(Interp sourceInterp, int result) throws TclException {
        if (sourceInterp == this) {
            return;
        }
        if (result == 1) {
            if (!sourceInterp.errAlreadyLogged) {
                sourceInterp.addErrorInfo("");
            }
            sourceInterp.errAlreadyLogged = true;
            this.resetResult();
            TclObject obj = sourceInterp.getVar("errorInfo", 1);
            this.setVar("errorInfo", obj, 1);
            obj = sourceInterp.getVar("errorCode", 1);
            this.setVar("errorCode", obj, 1);
            this.errInProgress = true;
            this.errCodeSet = true;
        }
        this.returnCode = result;
        this.setResult(sourceInterp.getResult());
        sourceInterp.resetResult();
        if (result != 0) {
            throw new TclException(this, this.getResult().toString(), result);
        }
    }

    void hideCommand(String cmdName, String hiddenCmdToken) throws TclException {
        if (this.deleted) {
            return;
        }
        if (hiddenCmdToken.indexOf("::") >= 0) {
            throw new TclException(this, "cannot use namespace qualifiers as hidden commandtoken (rename)");
        }
        WrappedCommand cmd = NamespaceCmd.findCommand(this, cmdName, null, 513);
        if (cmd.ns != this.globalNs) {
            throw new TclException(this, "can only hide global namespace commands (use rename then hide)");
        }
        if (this.hiddenCmdTable == null) {
            this.hiddenCmdTable = new Hashtable();
        }
        if (this.hiddenCmdTable.containsKey(hiddenCmdToken)) {
            throw new TclException(this, "hidden command named \"" + hiddenCmdToken + "\" already exists");
        }
        if (cmd.table.containsKey(cmd.hashKey)) {
            cmd.table.remove(cmd.hashKey);
        }
        cmd.table = this.hiddenCmdTable;
        cmd.hashKey = hiddenCmdToken;
        this.hiddenCmdTable.put(hiddenCmdToken, cmd);
    }

    void exposeCommand(String hiddenCmdToken, String cmdName) throws TclException {
        if (this.deleted) {
            return;
        }
        if (cmdName.indexOf("::") >= 0) {
            throw new TclException(this, "can not expose to a namespace (use expose to toplevel, then rename)");
        }
        if (this.hiddenCmdTable == null || !this.hiddenCmdTable.containsKey(hiddenCmdToken)) {
            throw new TclException(this, "unknown hidden command \"" + hiddenCmdToken + "\"");
        }
        WrappedCommand cmd = (WrappedCommand)this.hiddenCmdTable.get(hiddenCmdToken);
        if (cmd.ns != this.globalNs) {
            throw new TclException(this, "trying to expose a non global command name space command");
        }
        NamespaceCmd.Namespace ns = cmd.ns;
        if (ns.cmdTable.containsKey(cmdName)) {
            throw new TclException(this, "exposed command \"" + cmdName + "\" already exists");
        }
        if (cmd.hashKey != null) {
            cmd.table.remove(cmd.hashKey);
            cmd.table = ns.cmdTable;
            cmd.hashKey = cmdName;
        }
        ns.cmdTable.put(cmdName, cmd);
    }

    void hideUnsafeCommands() throws TclException {
        for (int ix = 0; ix < unsafeCmds.length; ++ix) {
            try {
                this.hideCommand(unsafeCmds[ix], unsafeCmds[ix]);
                continue;
            }
            catch (TclException e) {
                if (e.getMessage().startsWith("unknown command")) continue;
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int invokeGlobal(TclObject[] objv, int flags) throws TclException {
        CallFrame savedVarFrame = this.varFrame;
        try {
            this.varFrame = null;
            int n = this.invoke(objv, flags);
            return n;
        }
        finally {
            this.varFrame = savedVarFrame;
        }
    }

    int invoke(TclObject[] objv, int flags) throws TclException {
        WrappedCommand cmd;
        if (objv.length < 1 || objv == null) {
            throw new TclException(this, "illegal argument vector");
        }
        String cmdName = objv[0].toString();
        TclObject[] localObjv = null;
        if ((flags & 1) != 0) {
            if (this.hiddenCmdTable == null || !this.hiddenCmdTable.containsKey(cmdName)) {
                throw new TclException(this, "invalid hidden command name \"" + cmdName + "\"");
            }
            cmd = (WrappedCommand)this.hiddenCmdTable.get(cmdName);
        } else {
            cmd = NamespaceCmd.findCommand(this, cmdName, null, 1);
            if (cmd == null) {
                if ((flags & 2) == 0 && (cmd = NamespaceCmd.findCommand(this, "unknown", null, 1)) != null) {
                    localObjv = new TclObject[objv.length + 1];
                    localObjv[0] = TclString.newInstance((String)"unknown");
                    localObjv[0].preserve();
                    for (int i = 0; i < objv.length; ++i) {
                        localObjv[i + 1] = objv[i];
                    }
                    objv = localObjv;
                }
                if (cmd == null) {
                    throw new TclException(this, "invalid command name \"" + cmdName + "\"");
                }
            }
        }
        this.resetResult();
        ++this.cmdCount;
        int result = 0;
        try {
            cmd.cmd.cmdProc(this, objv);
        }
        catch (TclException e) {
            result = e.getCompletionCode();
        }
        if ((flags & 1) != 0 && (cmd = NamespaceCmd.findCommand(this, cmdName, null, 1)) != null) {
            cmd.table.remove(cmd.hashKey);
            cmd.table = this.hiddenCmdTable;
            cmd.hashKey = cmdName;
            this.hiddenCmdTable.put(cmdName, cmd);
        }
        if (result == 1 && (flags & 4) == 0 && !this.errAlreadyLogged) {
            StringBuffer ds = this.errInProgress ? new StringBuffer("\n    while invoking\n\"") : new StringBuffer("\n    invoked from within\n\"");
            for (int i = 0; i < objv.length; ++i) {
                ds.append(objv[i].toString());
                if (i < objv.length - 1) {
                    ds.append(" ");
                    continue;
                }
                if (ds.length() <= 100) continue;
                ds.append("...");
                break;
            }
            ds.append("\"");
            this.addErrorInfo(ds.toString());
            this.errInProgress = true;
        }
        if (localObjv != null) {
            localObjv[0].release();
        }
        return result;
    }

    void allowExceptions() {
        this.evalFlags |= 4;
    }

    public void addInterpResolver(String name, Resolver resolver) {
        ResolverScheme res;
        if (this.resolvers != null) {
            Enumeration e = this.resolvers.elements();
            while (e.hasMoreElements()) {
                res = (ResolverScheme)e.nextElement();
                if (!name.equals(res.name)) continue;
                res.resolver = resolver;
                return;
            }
        }
        if (this.resolvers == null) {
            this.resolvers = new Vector();
        }
        res = new ResolverScheme(name, resolver);
        this.resolvers.insertElementAt(res, 0);
    }

    public Resolver getInterpResolver(String name) {
        if (this.resolvers != null) {
            Enumeration e = this.resolvers.elements();
            while (e.hasMoreElements()) {
                ResolverScheme res = (ResolverScheme)e.nextElement();
                if (!name.equals(res.name)) continue;
                return res.resolver;
            }
        }
        return null;
    }

    boolean removeInterpResolver(String name) {
        boolean found = false;
        if (this.resolvers != null) {
            Enumeration e = this.resolvers.elements();
            while (!found && e.hasMoreElements()) {
                ResolverScheme res = (ResolverScheme)e.nextElement();
                if (!name.equals(res.name)) continue;
                found = true;
            }
        }
        if (found) {
            this.resolvers.removeElement(name);
        }
        return found;
    }

    class ResolverScheme {
        String name;
        Resolver resolver;

        ResolverScheme(String name, Resolver resolver) {
            this.name = name;
            this.resolver = resolver;
        }
    }
}

