/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.Enumeration;
import java.util.Hashtable;
import tcl.lang.CallFrame;
import tcl.lang.Command;
import tcl.lang.ImportRef;
import tcl.lang.ImportedCmdData;
import tcl.lang.InternalRep;
import tcl.lang.Interp;
import tcl.lang.Resolver;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.Util;
import tcl.lang.Var;
import tcl.lang.WrappedCommand;

public class NamespaceCmd
implements InternalRep,
Command {
    static final int FIND_ONLY_NS = 4096;
    private static long numNsCreated = 0L;
    private static Object nsMutex = new Object();
    static final int NS_DYING = 1;
    static final int NS_DEAD = 2;
    static final int CREATE_NS_IF_UNKNOWN = 2048;
    private ResolvedNsName otherValue = null;
    private static final String[] validCmds = new String[]{"children", "code", "current", "delete", "eval", "export", "forget", "import", "inscope", "origin", "parent", "qualifiers", "tail", "which"};
    private static final int OPT_CHILDREN = 0;
    private static final int OPT_CODE = 1;
    private static final int OPT_CURRENT = 2;
    private static final int OPT_DELETE = 3;
    private static final int OPT_EVAL = 4;
    private static final int OPT_EXPORT = 5;
    private static final int OPT_FORGET = 6;
    private static final int OPT_IMPORT = 7;
    private static final int OPT_INSCOPE = 8;
    private static final int OPT_ORIGIN = 9;
    private static final int OPT_PARENT = 10;
    private static final int OPT_QUALIFIERS = 11;
    private static final int OPT_TAIL = 12;
    private static final int OPT_WHICH = 13;

    static Namespace getCurrentNamespace(Interp interp) {
        if (interp.varFrame != null) {
            return interp.varFrame.ns;
        }
        return interp.globalNs;
    }

    static Namespace getGlobalNamespace(Interp interp) {
        return interp.globalNs;
    }

    static void pushCallFrame(Interp interp, CallFrame frame, Namespace namespace, boolean isProcCallFrame) {
        Namespace ns;
        if (namespace == null) {
            ns = NamespaceCmd.getCurrentNamespace(interp);
        } else {
            ns = namespace;
            if ((ns.flags & 2) != 0) {
                throw new TclRuntimeError("Trying to push call frame for dead namespace");
            }
        }
        ++ns.activationCount;
        frame.ns = ns;
        frame.isProcCallFrame = isProcCallFrame;
        frame.objv = null;
        frame.caller = interp.frame;
        frame.callerVar = interp.varFrame;
        frame.level = interp.varFrame != null ? interp.varFrame.level + 1 : 1;
        frame.varTable = null;
        interp.frame = frame;
        interp.varFrame = frame;
    }

    static void popCallFrame(Interp interp) {
        CallFrame frame = interp.frame;
        interp.frame = frame.caller;
        interp.varFrame = frame.callerVar;
        int saveErrFlag = interp.flags & 2;
        if (frame.varTable != null) {
            Var.deleteVars(interp, frame.varTable);
            frame.varTable = null;
        }
        interp.flags |= saveErrFlag;
        Namespace ns = frame.ns;
        --ns.activationCount;
        if ((ns.flags & 1) != 0 && ns.activationCount == 0) {
            NamespaceCmd.deleteNamespace(ns);
        }
        frame.ns = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Namespace createNamespace(Interp interp, String name, DeleteProc deleteProc) {
        String simpleName;
        Namespace parent;
        Namespace globalNs = NamespaceCmd.getGlobalNamespace(interp);
        if (globalNs == null && interp.varFrame == null) {
            parent = null;
            simpleName = "";
        } else {
            if (name.length() == 0) {
                interp.setResult("can't create namespace \"\": only global namespace can have empty name");
                return null;
            }
            Namespace[] parentArr = new Namespace[1];
            Namespace[] dummyArr = new Namespace[1];
            String[] simpleArr = new String[1];
            NamespaceCmd.getNamespaceForQualName(interp, name, null, 2560, parentArr, dummyArr, dummyArr, simpleArr);
            parent = parentArr[0];
            simpleName = simpleArr[0];
            if (simpleName.length() == 0) {
                return parent;
            }
            if (parent.childTable.get(simpleName) != null) {
                interp.setResult("can't create namespace \"" + name + "\": already exists");
                return null;
            }
        }
        Namespace ns = new Namespace();
        ns.name = simpleName;
        ns.fullName = null;
        ns.deleteProc = deleteProc;
        ns.parent = parent;
        ns.childTable = new Hashtable();
        Object object = nsMutex;
        synchronized (object) {
            ns.nsId = ++numNsCreated;
        }
        ns.interp = interp;
        ns.flags = 0;
        ns.activationCount = 0;
        ns.refCount = 1;
        ns.cmdTable = new Hashtable();
        ns.varTable = new Hashtable();
        ns.exportArray = null;
        ns.numExportPatterns = 0;
        ns.maxExportPatterns = 0;
        ns.resolver = null;
        if (parent != null) {
            parent.childTable.put(simpleName, ns);
        }
        StringBuffer buffer1 = new StringBuffer();
        StringBuffer buffer2 = new StringBuffer();
        Namespace ancestor = ns;
        while (ancestor != null) {
            if (ancestor != globalNs) {
                buffer1.append("::");
                buffer1.append(ancestor.name);
            }
            buffer1.append(buffer2);
            buffer2.setLength(0);
            buffer2.append(buffer1);
            buffer1.setLength(0);
            ancestor = ancestor.parent;
        }
        ns.fullName = name = buffer2.toString();
        return ns;
    }

    static void deleteNamespace(Namespace namespace) {
        Namespace ns = namespace;
        Interp interp = ns.interp;
        Namespace globalNs = NamespaceCmd.getGlobalNamespace(interp);
        if (ns.activationCount > 0) {
            ns.flags |= 1;
            if (ns.parent != null) {
                ns.parent.childTable.remove(ns.name);
            }
            ns.parent = null;
        } else {
            NamespaceCmd.teardownNamespace(ns);
            if (ns != globalNs || (interp.flags & 1) != 0) {
                Var.deleteVars(ns.interp, ns.varTable);
                ns.childTable.clear();
                ns.cmdTable.clear();
                if (ns.refCount == 0) {
                    NamespaceCmd.free(ns);
                } else {
                    ns.flags |= 2;
                }
            }
        }
    }

    static void teardownNamespace(Namespace ns) {
        Interp interp = ns.interp;
        Namespace globalNs = NamespaceCmd.getGlobalNamespace(interp);
        if (ns == globalNs) {
            String errorCodeStr;
            String errorInfoStr;
            try {
                errorInfoStr = interp.getVar("errorInfo", 1).toString();
            }
            catch (TclException e) {
                errorInfoStr = null;
            }
            try {
                errorCodeStr = interp.getVar("errorCode", 1).toString();
            }
            catch (TclException e) {
                errorCodeStr = null;
            }
            Var.deleteVars(interp, ns.varTable);
            if (errorInfoStr != null) {
                try {
                    interp.setVar("errorInfo", errorInfoStr, 1);
                }
                catch (TclException e) {
                    // empty catch block
                }
            }
            if (errorCodeStr != null) {
                try {
                    interp.setVar("errorCode", errorCodeStr, 1);
                }
                catch (TclException e) {}
            }
        } else {
            Var.deleteVars(interp, ns.varTable);
        }
        if (ns.parent != null) {
            ns.parent.childTable.remove(ns.name);
        }
        ns.parent = null;
        Enumeration search = ns.childTable.elements();
        while (search.hasMoreElements()) {
            Namespace childNs = (Namespace)search.nextElement();
            NamespaceCmd.deleteNamespace(childNs);
        }
        search = ns.cmdTable.elements();
        while (search.hasMoreElements()) {
            WrappedCommand cmd = (WrappedCommand)search.nextElement();
            interp.deleteCommandFromToken(cmd);
        }
        ns.cmdTable.clear();
        if (ns.exportArray != null) {
            ns.exportArray = null;
            ns.numExportPatterns = 0;
            ns.maxExportPatterns = 0;
        }
        if (ns.deleteProc != null) {
            ns.deleteProc.delete();
        }
        ns.deleteProc = null;
        ns.nsId = 0L;
    }

    static void free(Namespace ns) {
        ns.name = null;
        ns.fullName = null;
    }

    static void exportList(Interp interp, Namespace namespace, String pattern, boolean resetListFirst) throws TclException {
        int INIT_EXPORT_PATTERNS = 5;
        Namespace currNs = NamespaceCmd.getCurrentNamespace(interp);
        Namespace ns = namespace == null ? currNs : namespace;
        if (resetListFirst && ns.exportArray != null) {
            for (int i = 0; i < ns.numExportPatterns; ++i) {
                ns.exportArray[i] = null;
            }
            ns.exportArray = null;
            ns.numExportPatterns = 0;
            ns.maxExportPatterns = 0;
        }
        Namespace[] exportNsArr = new Namespace[1];
        Namespace[] dummyArr = new Namespace[1];
        String[] simplePatternArr = new String[1];
        NamespaceCmd.getNamespaceForQualName(interp, pattern, ns, 512, exportNsArr, dummyArr, dummyArr, simplePatternArr);
        Namespace exportNs = exportNsArr[0];
        String simplePattern = simplePatternArr[0];
        if (exportNs != ns || pattern.compareTo(simplePattern) != 0) {
            throw new TclException(interp, "invalid export pattern \"" + pattern + "\": pattern can't specify a namespace");
        }
        int neededElems = ns.numExportPatterns + 1;
        if (ns.exportArray == null) {
            ns.exportArray = new String[5];
            ns.numExportPatterns = 0;
            ns.maxExportPatterns = 5;
        } else if (neededElems > ns.maxExportPatterns) {
            int numNewElems = 2 * ns.maxExportPatterns;
            String[] newArray = new String[numNewElems];
            System.arraycopy(ns.exportArray, 0, newArray, 0, ns.numExportPatterns);
            ns.exportArray = newArray;
            ns.maxExportPatterns = numNewElems;
        }
        ns.exportArray[ns.numExportPatterns] = pattern;
        ++ns.numExportPatterns;
    }

    static void appendExportList(Interp interp, Namespace namespace, TclObject obj) throws TclException {
        Namespace ns = namespace == null ? NamespaceCmd.getCurrentNamespace(interp) : namespace;
        for (int i = 0; i < ns.numExportPatterns; ++i) {
            TclList.append(interp, obj, TclString.newInstance((String)ns.exportArray[i]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void importList(Interp interp, Namespace namespace, String pattern, boolean allowOverwrite) throws TclException {
        WrappedCommand cmd;
        Namespace currNs = NamespaceCmd.getCurrentNamespace(interp);
        Namespace ns = namespace == null ? currNs : namespace;
        WrappedCommand autoCmd = NamespaceCmd.findCommand(interp, "auto_import", null, 1);
        if (autoCmd != null) {
            TclObject[] objv = new TclObject[2];
            objv[0] = TclString.newInstance((String)"auto_import");
            objv[0].preserve();
            objv[1] = TclString.newInstance((String)pattern);
            objv[1].preserve();
            cmd = autoCmd;
            try {
                cmd.cmd.cmdProc(interp, objv);
            }
            finally {
                objv[0].release();
                objv[1].release();
            }
            interp.resetResult();
        }
        if (pattern.length() == 0) {
            throw new TclException(interp, "empty import pattern");
        }
        Namespace[] importNsArr = new Namespace[1];
        Namespace[] dummyArr = new Namespace[1];
        String[] simplePatternArr = new String[1];
        NamespaceCmd.getNamespaceForQualName(interp, pattern, ns, 512, importNsArr, dummyArr, dummyArr, simplePatternArr);
        Namespace importNs = importNsArr[0];
        String simplePattern = simplePatternArr[0];
        if (importNs == null) {
            throw new TclException(interp, "unknown namespace in import pattern \"" + pattern + "\"");
        }
        if (importNs == ns) {
            if (pattern == simplePattern) {
                throw new TclException(interp, "no namespace specified in import pattern \"" + pattern + "\"");
            }
            throw new TclException(interp, "import pattern \"" + pattern + "\" tries to import from namespace \"" + importNs.name + "\" into itself");
        }
        Enumeration search = importNs.cmdTable.keys();
        while (search.hasMoreElements()) {
            String cmdName = (String)search.nextElement();
            if (!Util.stringMatch(cmdName, simplePattern)) continue;
            boolean wasExported = false;
            for (int i = 0; i < importNs.numExportPatterns; ++i) {
                if (!Util.stringMatch(cmdName, importNs.exportArray[i])) continue;
                wasExported = true;
                break;
            }
            if (!wasExported) continue;
            if (ns.cmdTable.get(cmdName) == null || allowOverwrite) {
                WrappedCommand realCmd;
                StringBuffer ds = new StringBuffer();
                ds.append(ns.fullName);
                if (ns != interp.globalNs) {
                    ds.append("::");
                }
                ds.append(cmdName);
                cmd = (WrappedCommand)importNs.cmdTable.get(cmdName);
                if (cmd.cmd instanceof ImportedCmdData && (realCmd = NamespaceCmd.getOriginalCommand(cmd)) != null && realCmd.ns == currNs && currNs.cmdTable.get(cmdName) != null) {
                    throw new TclException(interp, "import pattern \"" + pattern + "\" would create a loop containing command \"" + ds.toString() + "\"");
                }
                ImportedCmdData data = new ImportedCmdData();
                interp.createCommand(ds.toString(), data);
                WrappedCommand importedCmd = NamespaceCmd.findCommand(interp, ds.toString(), ns, 514);
                data.realCmd = cmd;
                data.self = importedCmd;
                ImportRef ref = new ImportRef();
                ref.importedCmd = importedCmd;
                ref.next = cmd.importRef;
                cmd.importRef = ref;
                continue;
            }
            throw new TclException(interp, "can't import command \"" + cmdName + "\": already exists");
        }
    }

    static void forgetImport(Interp interp, Namespace namespace, String pattern) throws TclException {
        Namespace ns = namespace == null ? NamespaceCmd.getCurrentNamespace(interp) : namespace;
        Namespace[] importNsArr = new Namespace[1];
        Namespace[] dummyArr = new Namespace[1];
        Namespace[] actualCtxArr = new Namespace[1];
        String[] simplePatternArr = new String[1];
        NamespaceCmd.getNamespaceForQualName(interp, pattern, ns, 512, importNsArr, dummyArr, actualCtxArr, simplePatternArr);
        Namespace importNs = importNsArr[0];
        Namespace actualCtx = actualCtxArr[0];
        String simplePattern = simplePatternArr[0];
        if (importNs == null) {
            throw new TclException(interp, "unknown namespace in namespace forget pattern \"" + pattern + "\"");
        }
        Enumeration search = importNs.cmdTable.keys();
        while (search.hasMoreElements()) {
            WrappedCommand cmd;
            String cmdName = (String)search.nextElement();
            if (!Util.stringMatch(cmdName, simplePattern) || (cmd = (WrappedCommand)ns.cmdTable.get(cmdName)) == null || !(cmd.cmd instanceof ImportedCmdData)) continue;
            interp.deleteCommandFromToken(cmd);
        }
    }

    static WrappedCommand getOriginalCommand(WrappedCommand command) {
        WrappedCommand cmd = command;
        if (!(cmd.cmd instanceof ImportedCmdData)) {
            return null;
        }
        while (cmd.cmd instanceof ImportedCmdData) {
            ImportedCmdData data = (ImportedCmdData)cmd.cmd;
            cmd = data.realCmd;
        }
        return cmd;
    }

    static void invokeImportedCmd(Interp interp, ImportedCmdData data, TclObject[] objv) throws TclException {
        WrappedCommand realCmd = data.realCmd;
        realCmd.cmd.cmdProc(interp, objv);
    }

    static void deleteImportedCmd(ImportedCmdData data) {
        WrappedCommand realCmd = data.realCmd;
        WrappedCommand self = data.self;
        ImportRef prev = null;
        ImportRef ref = realCmd.importRef;
        while (ref != null) {
            if (ref.importedCmd == self) {
                if (prev == null) {
                    realCmd.importRef = ref.next;
                } else {
                    prev.next = ref.next;
                }
                ref = null;
                data = null;
                return;
            }
            prev = ref;
            ref = ref.next;
        }
        throw new TclRuntimeError("DeleteImportedCmd: did not find cmd in real cmd's list of import references");
    }

    /*
     * Enabled aggressive block sorting
     */
    static void getNamespaceForQualName(Interp interp, String qualName, Namespace cxtNsPtr, int flags, Namespace[] nsPtrPtr, Namespace[] altNsPtrPtr, Namespace[] actualCxtPtrPtr, String[] simpleNamePtr) {
        if (nsPtrPtr == null || nsPtrPtr.length != 1) {
            throw new RuntimeException("nsPtrPtr " + nsPtrPtr);
        }
        if (altNsPtrPtr == null || altNsPtrPtr.length != 1) {
            throw new RuntimeException("altNsPtrPtr " + altNsPtrPtr);
        }
        if (actualCxtPtrPtr == null || actualCxtPtrPtr.length != 1) {
            throw new RuntimeException("actualCxtPtrPtr " + actualCxtPtrPtr);
        }
        if (simpleNamePtr == null || simpleNamePtr.length != 1) {
            throw new RuntimeException("simpleNamePtr " + simpleNamePtr);
        }
        Namespace ns = cxtNsPtr;
        Namespace globalNs = NamespaceCmd.getGlobalNamespace(interp);
        if ((flags & 0x1002) != 0) {
            ns = NamespaceCmd.getCurrentNamespace(interp);
        } else if ((flags & 1) != 0) {
            ns = globalNs;
        } else if (ns == null) {
            ns = interp.varFrame != null ? interp.varFrame.ns : interp.globalNs;
        }
        int start_ind = 0;
        int name_len = qualName.length();
        if (name_len >= 2 && qualName.charAt(0) == ':' && qualName.charAt(1) == ':') {
            for (start_ind = 2; start_ind < name_len && qualName.charAt(start_ind) == ':'; ++start_ind) {
            }
            ns = globalNs;
            if (start_ind >= name_len) {
                nsPtrPtr[0] = globalNs;
                altNsPtrPtr[0] = null;
                actualCxtPtrPtr[0] = globalNs;
                simpleNamePtr[0] = "";
                return;
            }
        }
        actualCxtPtrPtr[0] = ns;
        Namespace altNs = globalNs;
        if (ns == globalNs || (flags & 0x1002) != 0) {
            altNs = null;
        }
        int end_ind = start_ind;
        while (true) {
            String nsName;
            int len;
            if (start_ind < name_len) {
                len = 0;
            } else {
                simpleNamePtr[0] = (flags & 0x1000) != 0 || end_ind > start_ind && qualName.charAt(end_ind - 1) != ':' ? null : qualName.substring(end_ind);
                if ((flags & 0x1000) != 0 && name_len == 0 && ns != globalNs) {
                    ns = null;
                }
                nsPtrPtr[0] = ns;
                altNsPtrPtr[0] = altNs;
                return;
            }
            for (end_ind = start_ind; end_ind < name_len; ++len, ++end_ind) {
                if (name_len - end_ind <= 1 || qualName.charAt(end_ind) != ':' || qualName.charAt(end_ind + 1) != ':') continue;
                end_ind += 2;
                while (end_ind < name_len && qualName.charAt(end_ind) == ':') {
                    ++end_ind;
                }
                break;
            }
            if (end_ind == name_len && (end_ind - start_ind < 2 || qualName.charAt(end_ind - 1) != ':' || qualName.charAt(end_ind - 2) != ':')) {
                if ((flags & 0x1000) == 0) {
                    nsPtrPtr[0] = ns;
                    altNsPtrPtr[0] = altNs;
                    simpleNamePtr[0] = qualName.substring(start_ind);
                    return;
                }
                nsName = qualName.substring(start_ind);
            } else {
                nsName = qualName.substring(start_ind, start_ind + len);
            }
            if (ns != null) {
                Namespace entryNs = (Namespace)ns.childTable.get(nsName);
                if (entryNs != null) {
                    ns = entryNs;
                } else if ((flags & 0x800) != 0) {
                    CallFrame frame = interp.newCallFrame();
                    NamespaceCmd.pushCallFrame(interp, frame, ns, false);
                    ns = NamespaceCmd.createNamespace(interp, nsName, null);
                    NamespaceCmd.popCallFrame(interp);
                    if (ns == null) {
                        throw new RuntimeException("Could not create namespace " + nsName);
                    }
                } else {
                    ns = null;
                }
            }
            if (altNs != null) {
                altNs = (Namespace)altNs.childTable.get(nsName);
            }
            if (ns == null && altNs == null) {
                nsPtrPtr[0] = null;
                altNsPtrPtr[0] = null;
                simpleNamePtr[0] = null;
                return;
            }
            start_ind = end_ind;
        }
    }

    static Namespace findNamespace(Interp interp, String name, Namespace contextNs, int flags) throws TclException {
        Namespace[] nsArr = new Namespace[1];
        Namespace[] dummy1Arr = new Namespace[1];
        String[] dummy2Arr = new String[1];
        NamespaceCmd.getNamespaceForQualName(interp, name, contextNs, flags | 0x1000, nsArr, dummy1Arr, dummy1Arr, dummy2Arr);
        Namespace ns = nsArr[0];
        if (ns != null) {
            return ns;
        }
        if ((flags & 0x200) != 0) {
            interp.setResult("unknown namespace \"" + name + "\"");
        }
        return null;
    }

    static WrappedCommand findCommand(Interp interp, String name, Namespace contextNs, int flags) throws TclException {
        WrappedCommand cmd;
        Namespace[] ns = new Namespace[2];
        Namespace cxtNs = (flags & 1) != 0 ? NamespaceCmd.getGlobalNamespace(interp) : (contextNs != null ? contextNs : NamespaceCmd.getCurrentNamespace(interp));
        if (cxtNs.resolver != null || interp.resolvers != null) {
            try {
                cmd = cxtNs.resolver != null ? cxtNs.resolver.resolveCmd(interp, name, cxtNs, flags) : null;
                if (cmd == null && interp.resolvers != null) {
                    Enumeration e = interp.resolvers.elements();
                    while (cmd == null && e.hasMoreElements()) {
                        Interp.ResolverScheme res = (Interp.ResolverScheme)e.nextElement();
                        cmd = res.resolver.resolveCmd(interp, name, cxtNs, flags);
                    }
                }
                if (cmd != null) {
                    return cmd;
                }
            }
            catch (TclException e) {
                return null;
            }
        }
        Namespace[] ns0Arr = new Namespace[1];
        Namespace[] ns1Arr = new Namespace[1];
        Namespace[] cxtNsArr = new Namespace[1];
        String[] simpleNameArr = new String[1];
        NamespaceCmd.getNamespaceForQualName(interp, name, contextNs, flags, ns0Arr, ns1Arr, cxtNsArr, simpleNameArr);
        ns[0] = ns0Arr[0];
        ns[1] = ns1Arr[0];
        cxtNs = cxtNsArr[0];
        String simpleName = simpleNameArr[0];
        cmd = null;
        for (int search = 0; search < 2 && cmd == null; ++search) {
            if (ns[search] == null || simpleName == null) continue;
            cmd = (WrappedCommand)ns[search].cmdTable.get(simpleName);
        }
        if (cmd != null) {
            return cmd;
        }
        if ((flags & 0x200) != 0) {
            throw new TclException(interp, "unknown command \"" + name + "\"");
        }
        return null;
    }

    static Var findNamespaceVar(Interp interp, String name, Namespace contextNs, int flags) throws TclException {
        Var var;
        Namespace[] ns = new Namespace[2];
        Namespace cxtNs = (flags & 1) != 0 ? NamespaceCmd.getGlobalNamespace(interp) : (contextNs != null ? contextNs : NamespaceCmd.getCurrentNamespace(interp));
        if (cxtNs.resolver != null || interp.resolvers != null) {
            try {
                var = cxtNs.resolver != null ? cxtNs.resolver.resolveVar(interp, name, cxtNs, flags) : null;
                if (var == null && interp.resolvers != null) {
                    Enumeration e = interp.resolvers.elements();
                    while (var == null && e.hasMoreElements()) {
                        Interp.ResolverScheme res = (Interp.ResolverScheme)e.nextElement();
                        var = res.resolver.resolveVar(interp, name, cxtNs, flags);
                    }
                }
                if (var != null) {
                    return var;
                }
            }
            catch (TclException e) {
                return null;
            }
        }
        Namespace[] ns0Arr = new Namespace[1];
        Namespace[] ns1Arr = new Namespace[1];
        Namespace[] cxtNsArr = new Namespace[1];
        String[] simpleNameArr = new String[1];
        NamespaceCmd.getNamespaceForQualName(interp, name, contextNs, flags, ns0Arr, ns1Arr, cxtNsArr, simpleNameArr);
        ns[0] = ns0Arr[0];
        ns[1] = ns1Arr[0];
        cxtNs = cxtNsArr[0];
        String simpleName = simpleNameArr[0];
        var = null;
        for (int search = 0; search < 2 && var == null; ++search) {
            if (ns[search] == null || simpleName == null) continue;
            var = (Var)ns[search].varTable.get(simpleName);
        }
        if (var != null) {
            return var;
        }
        if ((flags & 0x200) != 0) {
            interp.setResult("unknown variable \"" + name + "\"");
        }
        return null;
    }

    static Namespace getNamespaceFromObj(Interp interp, TclObject obj) throws TclException {
        Namespace currNs = NamespaceCmd.getCurrentNamespace(interp);
        if (!(obj.getInternalRep() instanceof NamespaceCmd)) {
            NamespaceCmd.setNsNameFromAny(interp, obj);
        }
        ResolvedNsName resName = ((NamespaceCmd)obj.getInternalRep()).otherValue;
        Namespace ns = null;
        if (resName != null && resName.refNs == currNs && resName.nsId == resName.ns.nsId) {
            ns = resName.ns;
            if ((ns.flags & 2) != 0) {
                ns = null;
            }
        }
        if (ns == null) {
            NamespaceCmd.setNsNameFromAny(interp, obj);
            resName = ((NamespaceCmd)obj.getInternalRep()).otherValue;
            if (resName != null) {
                ns = resName.ns;
                if ((ns.flags & 2) != 0) {
                    ns = null;
                }
            }
        }
        return ns;
    }

    static void setNamespaceResolver(Namespace namespace, Resolver resolver) {
        namespace.resolver = resolver;
    }

    static Resolver getNamespaceResolver(Namespace namespace) {
        return namespace.resolver;
    }

    public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
        if (objv.length < 2) {
            throw new TclNumArgsException(interp, 1, objv, "subcommand ?arg ...?");
        }
        int opt = TclIndex.get((Interp)interp, (TclObject)objv[1], (String[])validCmds, (String)"option", (int)0);
        switch (opt) {
            case 0: {
                NamespaceCmd.childrenCmd(interp, objv);
                return;
            }
            case 1: {
                NamespaceCmd.codeCmd(interp, objv);
                return;
            }
            case 2: {
                NamespaceCmd.currentCmd(interp, objv);
                return;
            }
            case 3: {
                NamespaceCmd.deleteCmd(interp, objv);
                return;
            }
            case 4: {
                NamespaceCmd.evalCmd(interp, objv);
                return;
            }
            case 5: {
                NamespaceCmd.exportCmd(interp, objv);
                return;
            }
            case 6: {
                NamespaceCmd.forgetCmd(interp, objv);
                return;
            }
            case 7: {
                NamespaceCmd.importCmd(interp, objv);
                return;
            }
            case 8: {
                NamespaceCmd.inscopeCmd(interp, objv);
                return;
            }
            case 9: {
                NamespaceCmd.originCmd(interp, objv);
                return;
            }
            case 10: {
                NamespaceCmd.parentCmd(interp, objv);
                return;
            }
            case 11: {
                NamespaceCmd.qualifiersCmd(interp, objv);
                return;
            }
            case 12: {
                NamespaceCmd.tailCmd(interp, objv);
                return;
            }
            case 13: {
                NamespaceCmd.whichCmd(interp, objv);
                return;
            }
        }
    }

    private static void childrenCmd(Interp interp, TclObject[] objv) throws TclException {
        Namespace ns;
        Namespace globalNs = NamespaceCmd.getGlobalNamespace(interp);
        String pattern = null;
        if (objv.length == 2) {
            ns = NamespaceCmd.getCurrentNamespace(interp);
        } else if (objv.length == 3 || objv.length == 4) {
            ns = NamespaceCmd.getNamespaceFromObj(interp, objv[2]);
            if (ns == null) {
                throw new TclException(interp, "unknown namespace \"" + objv[2].toString() + "\" in namespace children command");
            }
        } else {
            throw new TclNumArgsException(interp, 2, objv, "?name? ?pattern?");
        }
        StringBuffer buffer = new StringBuffer();
        if (objv.length == 4) {
            String name = objv[3].toString();
            if (name.startsWith("::")) {
                pattern = name;
            } else {
                buffer.append(ns.fullName);
                if (ns != globalNs) {
                    buffer.append("::");
                }
                buffer.append(name);
                pattern = buffer.toString();
            }
        }
        TclObject list = TclList.newInstance();
        Enumeration search = ns.childTable.elements();
        while (search.hasMoreElements()) {
            Namespace childNs = (Namespace)search.nextElement();
            if (pattern != null && !Util.stringMatch(childNs.fullName, pattern)) continue;
            TclObject elem = TclString.newInstance((String)childNs.fullName);
            TclList.append(interp, list, elem);
        }
        interp.setResult(list);
    }

    private static void codeCmd(Interp interp, TclObject[] objv) throws TclException {
        if (objv.length != 3) {
            throw new TclNumArgsException(interp, 2, objv, "arg");
        }
        String arg = objv[2].toString();
        int length = arg.length();
        if (length > 17 && arg.charAt(0) == 'n' && arg.startsWith("namespace")) {
            int p_ind;
            for (p_ind = 9; p_ind < length && arg.charAt(p_ind) == ' '; ++p_ind) {
            }
            if (length - p_ind >= 7 && arg.charAt(p_ind) == 'i' && arg.startsWith("inscope", p_ind)) {
                interp.setResult(objv[2]);
                return;
            }
        }
        TclObject list = TclList.newInstance();
        TclList.append(interp, list, TclString.newInstance((String)"namespace"));
        TclList.append(interp, list, TclString.newInstance((String)"inscope"));
        Namespace currNs = NamespaceCmd.getCurrentNamespace(interp);
        TclObject obj = currNs == NamespaceCmd.getGlobalNamespace(interp) ? TclString.newInstance((String)"::") : TclString.newInstance((String)currNs.fullName);
        TclList.append(interp, list, obj);
        TclList.append(interp, list, objv[2]);
        interp.setResult(list);
    }

    private static void currentCmd(Interp interp, TclObject[] objv) throws TclException {
        if (objv.length != 2) {
            throw new TclNumArgsException(interp, 2, objv, null);
        }
        Namespace currNs = NamespaceCmd.getCurrentNamespace(interp);
        if (currNs == NamespaceCmd.getGlobalNamespace(interp)) {
            interp.setResult("::");
        } else {
            interp.setResult(currNs.fullName);
        }
    }

    private static void deleteCmd(Interp interp, TclObject[] objv) throws TclException {
        Namespace namespace;
        String name;
        int i;
        if (objv.length < 2) {
            throw new TclNumArgsException(interp, 2, objv, "?name name...?");
        }
        for (i = 2; i < objv.length; ++i) {
            name = objv[i].toString();
            namespace = NamespaceCmd.findNamespace(interp, name, null, 0);
            if (namespace != null) continue;
            throw new TclException(interp, "unknown namespace \"" + objv[i].toString() + "\" in namespace delete command");
        }
        for (i = 2; i < objv.length; ++i) {
            name = objv[i].toString();
            namespace = NamespaceCmd.findNamespace(interp, name, null, 0);
            if (namespace == null) continue;
            NamespaceCmd.deleteNamespace(namespace);
        }
    }

    private static void evalCmd(Interp interp, TclObject[] objv) throws TclException {
        String name;
        if (objv.length < 4) {
            throw new TclNumArgsException(interp, 2, objv, "name arg ?arg...?");
        }
        Namespace namespace = NamespaceCmd.getNamespaceFromObj(interp, objv[2]);
        if (namespace == null && (namespace = NamespaceCmd.createNamespace(interp, name = objv[2].toString(), null)) == null) {
            throw new TclException(interp, interp.getResult().toString());
        }
        CallFrame frame = interp.newCallFrame();
        NamespaceCmd.pushCallFrame(interp, frame, namespace, false);
        try {
            if (objv.length == 4) {
                interp.eval(objv[3], 0);
            } else {
                String cmd = Util.concat(3, objv.length, objv);
                interp.eval(cmd);
            }
        }
        catch (TclException ex) {
            if (ex.getCompletionCode() == 1) {
                interp.addErrorInfo("\n    (in namespace eval \"" + namespace.fullName + "\" script line " + interp.errorLine + ")");
            }
            throw ex;
        }
        finally {
            NamespaceCmd.popCallFrame(interp);
        }
    }

    private static void exportCmd(Interp interp, TclObject[] objv) throws TclException {
        int patternCt;
        String string;
        Namespace currNs = NamespaceCmd.getCurrentNamespace(interp);
        boolean resetListFirst = false;
        if (objv.length < 2) {
            throw new TclNumArgsException(interp, 2, objv, "?-clear? ?pattern pattern...?");
        }
        int firstArg = 2;
        if (firstArg < objv.length && (string = objv[firstArg].toString()).equals("-clear")) {
            resetListFirst = true;
            ++firstArg;
        }
        if ((patternCt = objv.length - firstArg) == 0) {
            if (firstArg > 2) {
                return;
            }
            TclObject list = TclList.newInstance();
            NamespaceCmd.appendExportList(interp, currNs, list);
            interp.setResult(list);
            return;
        }
        for (int i = firstArg; i < objv.length; ++i) {
            String pattern = objv[i].toString();
            NamespaceCmd.exportList(interp, currNs, pattern, i == firstArg ? resetListFirst : false);
        }
    }

    private static void forgetCmd(Interp interp, TclObject[] objv) throws TclException {
        if (objv.length < 2) {
            throw new TclNumArgsException(interp, 2, objv, "?pattern pattern...?");
        }
        for (int i = 2; i < objv.length; ++i) {
            String pattern = objv[i].toString();
            NamespaceCmd.forgetImport(interp, null, pattern);
        }
    }

    private static void importCmd(Interp interp, TclObject[] objv) throws TclException {
        String string;
        boolean allowOverwrite = false;
        if (objv.length < 2) {
            throw new TclNumArgsException(interp, 2, objv, "?-force? ?pattern pattern...?");
        }
        int firstArg = 2;
        if (firstArg < objv.length && (string = objv[firstArg].toString()).equals("-force")) {
            allowOverwrite = true;
            ++firstArg;
        }
        for (int i = firstArg; i < objv.length; ++i) {
            String pattern = objv[i].toString();
            NamespaceCmd.importList(interp, null, pattern, allowOverwrite);
        }
    }

    private static void inscopeCmd(Interp interp, TclObject[] objv) throws TclException {
        if (objv.length < 4) {
            throw new TclNumArgsException(interp, 2, objv, "name arg ?arg...?");
        }
        Namespace namespace = NamespaceCmd.getNamespaceFromObj(interp, objv[2]);
        if (namespace == null) {
            throw new TclException(interp, "unknown namespace \"" + objv[2].toString() + "\" in inscope namespace command");
        }
        CallFrame frame = interp.newCallFrame();
        NamespaceCmd.pushCallFrame(interp, frame, namespace, false);
        try {
            if (objv.length == 4) {
                interp.eval(objv[3], 0);
            } else {
                TclObject[] concatObjv = new TclObject[2];
                TclObject list = TclList.newInstance();
                for (int i = 4; i < objv.length; ++i) {
                    try {
                        TclList.append(interp, list, objv[i]);
                        continue;
                    }
                    catch (TclException ex) {
                        list.release();
                        throw ex;
                    }
                }
                concatObjv[0] = objv[3];
                concatObjv[1] = list;
                String cmd = Util.concat(0, 1, concatObjv);
                interp.eval(cmd);
                list.release();
            }
        }
        catch (TclException ex) {
            if (ex.getCompletionCode() == 1) {
                interp.addErrorInfo("\n    (in namespace inscope \"" + namespace.fullName + "\" script line " + interp.errorLine + ")");
            }
            throw ex;
        }
        finally {
            NamespaceCmd.popCallFrame(interp);
        }
    }

    private static void originCmd(Interp interp, TclObject[] objv) throws TclException {
        if (objv.length != 3) {
            throw new TclNumArgsException(interp, 2, objv, "name");
        }
        WrappedCommand command = NamespaceCmd.findCommand(interp, objv[2].toString(), null, 0);
        if (command == null) {
            throw new TclException(interp, "invalid command name \"" + objv[2].toString() + "\"");
        }
        WrappedCommand origCommand = NamespaceCmd.getOriginalCommand(command);
        if (origCommand == null) {
            interp.setResult(interp.getCommandFullName(command));
        } else {
            interp.setResult(interp.getCommandFullName(origCommand));
        }
    }

    private static void parentCmd(Interp interp, TclObject[] objv) throws TclException {
        Namespace ns;
        if (objv.length == 2) {
            ns = NamespaceCmd.getCurrentNamespace(interp);
        } else if (objv.length == 3) {
            ns = NamespaceCmd.getNamespaceFromObj(interp, objv[2]);
            if (ns == null) {
                throw new TclException(interp, "unknown namespace \"" + objv[2].toString() + "\" in namespace parent command");
            }
        } else {
            throw new TclNumArgsException(interp, 2, objv, "?name?");
        }
        if (ns.parent != null) {
            interp.setResult(ns.parent.fullName);
        }
    }

    private static void qualifiersCmd(Interp interp, TclObject[] objv) throws TclException {
        if (objv.length != 3) {
            throw new TclNumArgsException(interp, 2, objv, "string");
        }
        String name = objv[2].toString();
        int p = name.length();
        while (--p >= 0) {
            if (name.charAt(p) != ':' || p <= 0 || name.charAt(p - 1) != ':') continue;
            p -= 2;
            while (p >= 0 && name.charAt(p) == ':') {
                --p;
            }
            break block0;
        }
        if (p >= 0) {
            interp.setResult(name.substring(0, p + 1));
        }
    }

    private static void tailCmd(Interp interp, TclObject[] objv) throws TclException {
        if (objv.length != 3) {
            throw new TclNumArgsException(interp, 2, objv, "string");
        }
        String name = objv[2].toString();
        int p = name.length();
        while (--p > 0) {
            if (name.charAt(p) != ':' || name.charAt(p - 1) != ':') continue;
            ++p;
            break;
        }
        if (p >= 0) {
            interp.setResult(name.substring(p));
        }
    }

    private static void whichCmd(Interp interp, TclObject[] objv) throws TclException {
        if (objv.length < 3) {
            throw new TclNumArgsException(interp, 2, objv, "?-command? ?-variable? name");
        }
        int argIndex = 2;
        int lookup = 0;
        String arg = objv[2].toString();
        if (arg.length() > 1 && arg.charAt(0) == '-') {
            if (arg.equals("-command")) {
                lookup = 0;
            } else if (arg.equals("-variable")) {
                lookup = 1;
            } else {
                throw new TclNumArgsException(interp, 2, objv, "?-command? ?-variable? name");
            }
            argIndex = 3;
        }
        if (objv.length != argIndex + 1) {
            throw new TclNumArgsException(interp, 2, objv, "?-command? ?-variable? name");
        }
        switch (lookup) {
            case 0: {
                arg = objv[argIndex].toString();
                WrappedCommand cmd = NamespaceCmd.findCommand(interp, arg, null, 0);
                if (cmd == null) {
                    return;
                }
                interp.setResult(interp.getCommandFullName(cmd));
                return;
            }
            case 1: {
                arg = objv[argIndex].toString();
                Var variable = NamespaceCmd.findNamespaceVar(interp, arg, null, 0);
                if (variable != null) {
                    interp.setResult(Var.getVariableFullName(interp, variable));
                }
                return;
            }
        }
    }

    public void dispose() {
        boolean debug = false;
        ResolvedNsName resName = this.otherValue;
        if (resName != null) {
            --resName.refCount;
            if (resName.refCount == 0) {
                Namespace ns = resName.ns;
                --ns.refCount;
                if (ns.refCount == 0 && (ns.flags & 2) != 0) {
                    NamespaceCmd.free(ns);
                }
                this.otherValue = null;
            }
        }
    }

    public InternalRep duplicate() {
        boolean debug = false;
        ResolvedNsName resName = this.otherValue;
        if (resName != null) {
            ++resName.refCount;
        }
        return this;
    }

    private static void setNsNameFromAny(Interp interp, TclObject tobj) throws TclException {
        ResolvedNsName resName;
        Namespace[] nsArr = new Namespace[1];
        Namespace[] dummy1Arr = new Namespace[1];
        String[] dummy2Arr = new String[1];
        String name = tobj.toString();
        NamespaceCmd.getNamespaceForQualName(interp, name, null, 4096, nsArr, dummy1Arr, dummy1Arr, dummy2Arr);
        Namespace ns = nsArr[0];
        if (ns != null) {
            Namespace currNs = NamespaceCmd.getCurrentNamespace(interp);
            ++ns.refCount;
            resName = new ResolvedNsName();
            resName.ns = ns;
            resName.nsId = ns.nsId;
            resName.refNs = currNs;
            resName.refCount = 1;
        } else {
            resName = null;
        }
        NamespaceCmd wrap = new NamespaceCmd();
        wrap.otherValue = resName;
        tobj.setInternalRep((InternalRep)wrap);
    }

    public String toString() {
        boolean debug = false;
        ResolvedNsName resName = this.otherValue;
        String name = "";
        if (resName != null && resName.nsId == resName.ns.nsId) {
            Namespace ns = resName.ns;
            if ((ns.flags & 2) != 0) {
                ns = null;
            }
            if (ns != null) {
                name = ns.fullName;
            }
        }
        return name;
    }

    static class ResolvedNsName {
        Namespace ns;
        long nsId;
        Namespace refNs;
        int refCount;

        ResolvedNsName() {
        }
    }

    static class Namespace {
        String name;
        String fullName;
        DeleteProc deleteProc;
        Namespace parent;
        Hashtable childTable;
        long nsId;
        Interp interp;
        int flags;
        int activationCount;
        int refCount;
        Hashtable cmdTable;
        Hashtable varTable;
        String[] exportArray;
        int numExportPatterns;
        int maxExportPatterns;
        Resolver resolver;

        Namespace() {
        }

        public String toString() {
            return this.fullName;
        }
    }

    static interface DeleteProc {
        public void delete();
    }
}

