/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.Enumeration;
import java.util.Vector;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.Util;

class PackageCmd
implements Command {
    private static final String[] validCmds = new String[]{"forget", "ifneeded", "names", "present", "provide", "require", "unknown", "vcompare", "versions", "vsatisfies"};
    private static final int OPT_FORGET = 0;
    private static final int OPT_IFNEEDED = 1;
    private static final int OPT_NAMES = 2;
    private static final int OPT_PRESENT = 3;
    private static final int OPT_PROVIDE = 4;
    private static final int OPT_REQUIRE = 5;
    private static final int OPT_UNKNOWN = 6;
    private static final int OPT_VCOMPARE = 7;
    private static final int OPT_VERSIONS = 8;
    private static final int OPT_VSATISFIES = 9;

    PackageCmd() {
    }

    static void pkgProvide(Interp interp, String pkgName, String version) throws TclException {
        PackageCmd.checkVersion(interp, version);
        Package pkg = PackageCmd.findPackage(interp, pkgName);
        if (pkg.version == null) {
            pkg.version = version;
            return;
        }
        if (PackageCmd.compareVersions(pkg.version, version, null) != 0) {
            throw new TclException(interp, "conflicting versions provided for package \"" + pkgName + "\": " + pkg.version + ", then " + version);
        }
    }

    static String pkgRequire(Interp interp, String pkgName, String version, boolean exact) throws TclException {
        StringBuffer sbuf;
        int result;
        Package pkg;
        if (version == null && exact) {
            throw new TclException(interp, "conflicting arguments : version == null and exact == true");
        }
        if (version != null) {
            PackageCmd.checkVersion(interp, version);
        }
        VersionSatisfiesResult vsres = new VersionSatisfiesResult();
        int pass = 1;
        while (true) {
            String script;
            pkg = PackageCmd.findPackage(interp, pkgName);
            if (pkg.version != null) break;
            PkgAvail best = null;
            PkgAvail avail = pkg.avail;
            while (avail != null) {
                if (!(best != null && PackageCmd.compareVersions(avail.version, best.version, null) <= 0 || version != null && ((result = PackageCmd.compareVersions(avail.version, version, vsres)) != 0 && exact || !vsres.satisfies))) {
                    best = avail;
                }
                avail = avail.next;
            }
            if (best != null) {
                script = best.script;
                try {
                    interp.eval(script, 131072);
                }
                catch (TclException e) {
                    interp.addErrorInfo("\n    (\"package ifneeded\" script)");
                    throw e;
                }
                interp.resetResult();
                pkg = PackageCmd.findPackage(interp, pkgName);
                break;
            }
            if (pass > 1) break;
            script = interp.packageUnknown;
            if (script != null) {
                sbuf = new StringBuffer();
                try {
                    Util.appendElement(interp, sbuf, script);
                    Util.appendElement(interp, sbuf, pkgName);
                    if (version == null) {
                        Util.appendElement(interp, sbuf, "");
                    } else {
                        Util.appendElement(interp, sbuf, version);
                    }
                    if (exact) {
                        Util.appendElement(interp, sbuf, "-exact");
                    }
                }
                catch (TclException e) {
                    throw new TclRuntimeError("unexpected TclException: " + (Object)((Object)e));
                }
                try {
                    interp.eval(sbuf.toString(), 131072);
                }
                catch (TclException e) {
                    interp.addErrorInfo("\n    (\"package unknown\" script)");
                    throw e;
                }
                interp.resetResult();
            }
            ++pass;
        }
        if (pkg.version == null) {
            sbuf = new StringBuffer();
            sbuf.append("can't find package " + pkgName);
            if (version != null) {
                sbuf.append(" " + version);
            }
            throw new TclException(interp, sbuf.toString());
        }
        if (version == null) {
            return pkg.version;
        }
        result = PackageCmd.compareVersions(pkg.version, version, vsres);
        if (vsres.satisfies && !exact || result == 0) {
            return pkg.version;
        }
        throw new TclException(interp, "version conflict for package \"" + pkgName + "\": have " + pkg.version + ", need " + version);
    }

    static String pkgPresent(Interp interp, String pkgName, String version, boolean exact) throws TclException {
        VersionSatisfiesResult vsres = new VersionSatisfiesResult();
        Package pkg = (Package)interp.packageTable.get(pkgName);
        if (pkg != null && pkg.version != null) {
            if (version == null) {
                return pkg.version;
            }
            int result = PackageCmd.compareVersions(pkg.version, version, vsres);
            if (vsres.satisfies && !exact || result == 0) {
                return pkg.version;
            }
            throw new TclException(interp, "version conflict for package \"" + pkgName + "\": have " + pkg.version + ", need " + version);
        }
        if (version != null) {
            throw new TclException(interp, "package " + pkgName + " " + version + " is not present");
        }
        throw new TclException(interp, "package " + pkgName + " is not present");
    }

    public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
        if (objv.length < 2) {
            throw new TclNumArgsException(interp, 1, objv, "option ?arg arg ...?");
        }
        int opt = TclIndex.get((Interp)interp, (TclObject)objv[1], (String[])validCmds, (String)"option", (int)0);
        switch (opt) {
            case 0: {
                for (int i = 2; i < objv.length; ++i) {
                    String pkgName = objv[i].toString();
                    Package pkg = (Package)interp.packageTable.get(pkgName);
                    if (pkg == null) continue;
                    interp.packageTable.remove(pkgName);
                    while (pkg.avail != null) {
                        PkgAvail avail = pkg.avail;
                        pkg.avail = avail.next;
                        avail = null;
                    }
                    pkg = null;
                }
                return;
            }
            case 1: {
                Package pkg;
                if (objv.length < 4 || objv.length > 5) {
                    throw new TclNumArgsException(interp, 1, objv, "ifneeded package version ?script?");
                }
                String pkgName = objv[2].toString();
                String version = objv[3].toString();
                PackageCmd.checkVersion(interp, version);
                if (objv.length == 4) {
                    pkg = (Package)interp.packageTable.get(pkgName);
                    if (pkg == null) {
                        return;
                    }
                } else {
                    pkg = PackageCmd.findPackage(interp, pkgName);
                }
                PkgAvail avail = pkg.avail;
                PkgAvail prev = null;
                while (avail != null) {
                    if (PackageCmd.compareVersions(avail.version, version, null) == 0) {
                        if (objv.length != 4) break;
                        interp.setResult(avail.script);
                        return;
                    }
                    prev = avail;
                    avail = avail.next;
                }
                if (objv.length == 4) {
                    return;
                }
                if (avail == null) {
                    avail = new PkgAvail();
                    avail.version = version;
                    if (prev == null) {
                        avail.next = pkg.avail;
                        pkg.avail = avail;
                    } else {
                        avail.next = prev.next;
                        prev.next = avail;
                    }
                }
                avail.script = objv[4].toString();
                return;
            }
            case 2: {
                if (objv.length != 2) {
                    throw new TclNumArgsException(interp, 1, objv, "names");
                }
                try {
                    StringBuffer sbuf = new StringBuffer();
                    Enumeration e = interp.packageTable.keys();
                    boolean once = false;
                    while (e.hasMoreElements()) {
                        once = true;
                        String key = (String)e.nextElement();
                        Package pkg = (Package)interp.packageTable.get(key);
                        if (pkg.version == null && pkg.avail == null) continue;
                        Util.appendElement(interp, sbuf, key);
                    }
                    if (once) {
                        interp.setResult(sbuf.toString());
                    }
                }
                catch (TclException ex) {
                    throw new TclRuntimeError("unexpected TclException: " + (Object)((Object)ex));
                }
                return;
            }
            case 3: {
                if (objv.length < 3) {
                    throw new TclNumArgsException(interp, 2, objv, "?-exact? package ?version?");
                }
                int exact = objv[2].toString().equals("-exact") ? 1 : 0;
                String version = null;
                if (objv.length == 4 + exact) {
                    version = objv[3 + exact].toString();
                    PackageCmd.checkVersion(interp, version);
                } else if (objv.length != 3 || exact == 1) {
                    throw new TclNumArgsException(interp, 2, objv, "?-exact? package ?version?");
                }
                version = exact == 1 ? PackageCmd.pkgPresent(interp, objv[3].toString(), version, true) : PackageCmd.pkgPresent(interp, objv[2].toString(), version, false);
                interp.setResult(version);
                break;
            }
            case 4: {
                if (objv.length < 3 || objv.length > 4) {
                    throw new TclNumArgsException(interp, 1, objv, "provide package ?version?");
                }
                if (objv.length == 3) {
                    Package pkg = (Package)interp.packageTable.get(objv[2].toString());
                    if (pkg != null && pkg.version != null) {
                        interp.setResult(pkg.version);
                    }
                    return;
                }
                PackageCmd.pkgProvide(interp, objv[2].toString(), objv[3].toString());
                return;
            }
            case 5: {
                if (objv.length < 3 || objv.length > 5) {
                    throw new TclNumArgsException(interp, 1, objv, "require ?-exact? package ?version?");
                }
                int exact = objv[2].toString().equals("-exact") ? 1 : 0;
                String version = null;
                if (objv.length == 4 + exact) {
                    version = objv[3 + exact].toString();
                    PackageCmd.checkVersion(interp, version);
                } else if (objv.length != 3 || exact == 1) {
                    throw new TclNumArgsException(interp, 1, objv, "require ?-exact? package ?version?");
                }
                version = exact == 1 ? PackageCmd.pkgRequire(interp, objv[3].toString(), version, true) : PackageCmd.pkgRequire(interp, objv[2].toString(), version, false);
                interp.setResult(version);
                return;
            }
            case 6: {
                if (objv.length > 3) {
                    throw new TclNumArgsException(interp, 1, objv, "unknown ?command?");
                }
                if (objv.length == 2) {
                    if (interp.packageUnknown != null) {
                        interp.setResult(interp.packageUnknown);
                    }
                } else if (objv.length == 3) {
                    interp.packageUnknown = null;
                    String cmd = objv[2].toString();
                    if (cmd.length() > 0) {
                        interp.packageUnknown = cmd;
                    }
                }
                return;
            }
            case 7: {
                if (objv.length != 4) {
                    throw new TclNumArgsException(interp, 1, objv, "vcompare version1 version2");
                }
                String ver1 = objv[2].toString();
                String ver2 = objv[3].toString();
                PackageCmd.checkVersion(interp, ver1);
                PackageCmd.checkVersion(interp, ver2);
                interp.setResult(PackageCmd.compareVersions(ver1, ver2, null));
                return;
            }
            case 8: {
                if (objv.length != 3) {
                    throw new TclNumArgsException(interp, 1, objv, "versions package");
                }
                Package pkg = (Package)interp.packageTable.get(objv[2].toString());
                if (pkg != null) {
                    try {
                        StringBuffer sbuf = new StringBuffer();
                        boolean once = false;
                        PkgAvail avail = pkg.avail;
                        while (avail != null) {
                            once = true;
                            Util.appendElement(interp, sbuf, avail.version);
                            avail = avail.next;
                        }
                        if (once) {
                            interp.setResult(sbuf.toString());
                        }
                    }
                    catch (TclException ex) {
                        throw new TclRuntimeError("unexpected TclException: " + (Object)((Object)ex));
                    }
                }
                return;
            }
            case 9: {
                if (objv.length != 4) {
                    throw new TclNumArgsException(interp, 1, objv, "vsatisfies version1 version2");
                }
                String ver1 = objv[2].toString();
                String ver2 = objv[3].toString();
                PackageCmd.checkVersion(interp, ver1);
                PackageCmd.checkVersion(interp, ver2);
                VersionSatisfiesResult vsres = new VersionSatisfiesResult();
                PackageCmd.compareVersions(ver1, ver2, vsres);
                interp.setResult(vsres.satisfies);
                return;
            }
            default: {
                throw new TclRuntimeError("TclIndex.get() error");
            }
        }
    }

    private static Package findPackage(Interp interp, String pkgName) throws TclException {
        if (pkgName == null || pkgName.length() == 0) {
            throw new TclException(interp, "expected package name but got \"\"");
        }
        Package pkg = (Package)interp.packageTable.get(pkgName);
        if (pkg == null) {
            pkg = new Package();
            interp.packageTable.put(pkgName, pkg);
        }
        return pkg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkVersion(Interp interp, String version) throws TclException {
        boolean error = true;
        try {
            if (version == null || version.length() == 0) {
                version = "";
                return;
            }
            if (!Character.isDigit(version.charAt(0))) {
                return;
            }
            int len = version.length();
            for (int i = 1; i < len; ++i) {
                char c = version.charAt(i);
                if (Character.isDigit(c) || c == '.') continue;
                return;
            }
        }
        finally {
            if (error) {
                throw new TclException(interp, "expected version number but got \"" + version + "\"");
            }
        }
    }

    private static int compareVersions(String v1, String v2, VersionSatisfiesResult vsres) {
        int n1 = 0;
        int n2 = 0;
        boolean thisIsMajor = true;
        if (v1 == null || v2 == null) {
            throw new TclRuntimeError("null version in package version compare");
        }
        String[] v1ns = PackageCmd.split(v1, '.');
        String[] v2ns = PackageCmd.split(v2, '.');
        if (v1ns.length == 0 || v2ns.length == 0) {
            throw new TclRuntimeError("version length is 0");
        }
        int max = v1ns.length > v2ns.length ? v1ns.length : v2ns.length;
        for (int i = 0; i < max; ++i) {
            n2 = 0;
            n1 = 0;
            try {
                if (i < v1ns.length) {
                    n1 = Integer.parseInt(v1ns[i]);
                }
                if (i < v2ns.length) {
                    n2 = Integer.parseInt(v2ns[i]);
                }
            }
            catch (NumberFormatException ex) {
                throw new TclRuntimeError("NumberFormatException for package versions \"" + v1 + "\" or \"" + v2 + "\"");
            }
            if (n1 != n2) break;
            thisIsMajor = false;
        }
        if (vsres != null) {
            boolean bl = vsres.satisfies = n1 == n2 || n1 > n2 && !thisIsMajor;
        }
        if (n1 > n2) {
            return 1;
        }
        if (n1 == n2) {
            return 0;
        }
        return -1;
    }

    static String[] split(String in, char splitchar) {
        int wordstart = 0;
        int len = in.length();
        char[] str = new char[len + 1];
        in.getChars(0, len, str, 0);
        str[len++] = splitchar;
        Vector<String> words = new Vector<String>(5);
        for (int i = 0; i < len; ++i) {
            if (str[i] != splitchar) continue;
            if (wordstart <= i - 1) {
                words.addElement(new String(str, wordstart, i - wordstart));
            }
            wordstart = i + 1;
        }
        Object[] ret = new String[words.size()];
        words.copyInto(ret);
        return ret;
    }

    static class Package {
        String version = null;
        PkgAvail avail = null;

        Package() {
        }
    }

    static class PkgAvail {
        String version = null;
        String script = null;
        PkgAvail next = null;

        PkgAvail() {
        }
    }

    static class VersionSatisfiesResult {
        boolean satisfies = false;

        VersionSatisfiesResult() {
        }
    }
}

