/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Command;
import tcl.lang.Expression;
import tcl.lang.Interp;
import tcl.lang.StrtodResult;
import tcl.lang.StrtoulResult;
import tcl.lang.TclBoolean;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.Util;

class StringCmd
implements Command {
    private static final String[] options = new String[]{"bytelength", "compare", "equal", "first", "index", "is", "last", "length", "map", "match", "range", "repeat", "replace", "tolower", "toupper", "totitle", "trim", "trimleft", "trimright", "wordend", "wordstart"};
    private static final int STR_BYTELENGTH = 0;
    private static final int STR_COMPARE = 1;
    private static final int STR_EQUAL = 2;
    private static final int STR_FIRST = 3;
    private static final int STR_INDEX = 4;
    private static final int STR_IS = 5;
    private static final int STR_LAST = 6;
    private static final int STR_LENGTH = 7;
    private static final int STR_MAP = 8;
    private static final int STR_MATCH = 9;
    private static final int STR_RANGE = 10;
    private static final int STR_REPEAT = 11;
    private static final int STR_REPLACE = 12;
    private static final int STR_TOLOWER = 13;
    private static final int STR_TOUPPER = 14;
    private static final int STR_TOTITLE = 15;
    private static final int STR_TRIM = 16;
    private static final int STR_TRIMLEFT = 17;
    private static final int STR_TRIMRIGHT = 18;
    private static final int STR_WORDEND = 19;
    private static final int STR_WORDSTART = 20;
    private static final String[] isOptions = new String[]{"alnum", "alpha", "ascii", "control", "boolean", "digit", "double", "false", "graph", "integer", "lower", "print", "punct", "space", "true", "upper", "wordchar", "xdigit"};
    private static final int STR_IS_ALNUM = 0;
    private static final int STR_IS_ALPHA = 1;
    private static final int STR_IS_ASCII = 2;
    private static final int STR_IS_CONTROL = 3;
    private static final int STR_IS_BOOL = 4;
    private static final int STR_IS_DIGIT = 5;
    private static final int STR_IS_DOUBLE = 6;
    private static final int STR_IS_FALSE = 7;
    private static final int STR_IS_GRAPH = 8;
    private static final int STR_IS_INT = 9;
    private static final int STR_IS_LOWER = 10;
    private static final int STR_IS_PRINT = 11;
    private static final int STR_IS_PUNCT = 12;
    private static final int STR_IS_SPACE = 13;
    private static final int STR_IS_TRUE = 14;
    private static final int STR_IS_UPPER = 15;
    private static final int STR_IS_WORD = 16;
    private static final int STR_IS_XDIGIT = 17;
    private static final int ALPHA_BITS = 62;
    private static final int PUNCT_BITS = 0x1F00000;
    private static final int PRINT_BITS = 535855102;
    private static final int WORD_BITS = 8389182;

    StringCmd() {
    }

    public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
        if (objv.length < 2) {
            throw new TclNumArgsException(interp, 1, objv, "option arg ?arg ...?");
        }
        int index = TclIndex.get((Interp)interp, (TclObject)objv[1], (String[])options, (String)"option", (int)0);
        switch (index) {
            case 1: 
            case 2: {
                int match;
                int length2;
                int length;
                String string2;
                if (objv.length < 4 || objv.length > 7) {
                    throw new TclNumArgsException(interp, 2, objv, "?-nocase? ?-length int? string1 string2");
                }
                boolean nocase = false;
                int reqlength = -1;
                for (int i = 2; i < objv.length - 2; ++i) {
                    string2 = objv[i].toString();
                    int length22 = string2.length();
                    if (length22 > 1 && "-nocase".startsWith(string2)) {
                        nocase = true;
                        continue;
                    }
                    if (length22 > 1 && "-length".startsWith(string2)) {
                        if (i + 1 >= objv.length - 2) {
                            throw new TclNumArgsException(interp, 2, objv, "?-nocase? ?-length int? string1 string2");
                        }
                        reqlength = TclInteger.get((Interp)interp, (TclObject)objv[++i]);
                        continue;
                    }
                    throw new TclException(interp, "bad option \"" + string2 + "\": must be -nocase or -length");
                }
                String string1 = objv[objv.length - 2].toString();
                string2 = objv[objv.length - 1].toString();
                int length1 = string1.length();
                int n = length = length1 < (length2 = string2.length()) ? length1 : length2;
                if (reqlength == 0) {
                    match = 0;
                } else if (nocase || reqlength > 0 && reqlength <= length) {
                    if (reqlength > 0 && reqlength < length) {
                        length = reqlength;
                    } else if (reqlength < 0) {
                        int n2 = reqlength = length1 > length2 ? length1 : length2;
                    }
                    if (nocase) {
                        string1 = string1.toLowerCase();
                        string2 = string2.toLowerCase();
                    }
                    if ((match = string1.substring(0, length).compareTo(string2.substring(0, length))) == 0 && reqlength > length) {
                        match = length1 - length2;
                    }
                } else {
                    match = string1.substring(0, length).compareTo(string2.substring(0, length));
                    if (match == 0) {
                        match = length1 - length2;
                    }
                }
                if (index == 2) {
                    interp.setResult(match == 0);
                    break;
                }
                interp.setResult(match > 0 ? 1 : (match < 0 ? -1 : 0));
                break;
            }
            case 3: {
                if (objv.length < 4 || objv.length > 5) {
                    throw new TclNumArgsException(interp, 2, objv, "subString string ?startIndex?");
                }
                String string1 = objv[2].toString();
                String string2 = objv[3].toString();
                int length2 = string2.length();
                int start = 0;
                if (objv.length == 5 && (start = Util.getIntForIndex(interp, objv[4], length2 - 1)) >= length2) {
                    interp.setResult(-1);
                    return;
                }
                if (string1.length() == 0) {
                    interp.setResult(-1);
                    break;
                }
                interp.setResult(string2.indexOf(string1, start));
                break;
            }
            case 4: {
                if (objv.length != 4) {
                    throw new TclNumArgsException(interp, 2, objv, "string charIndex");
                }
                String string1 = objv[2].toString();
                int length1 = string1.length();
                int i = Util.getIntForIndex(interp, objv[3], length1 - 1);
                if (i < 0 || i >= length1) break;
                interp.setResult(string1.substring(i, i + 1));
                break;
            }
            case 5: {
                if (objv.length < 4 || objv.length > 7) {
                    throw new TclNumArgsException(interp, 2, objv, "class ?-strict? ?-failindex var? str");
                }
                index = TclIndex.get((Interp)interp, (TclObject)objv[2], (String[])isOptions, (String)"class", (int)0);
                boolean strict = false;
                TclObject failVarObj = null;
                if (objv.length != 4) {
                    for (int i = 3; i < objv.length - 1; ++i) {
                        String string2 = objv[i].toString();
                        int length2 = string2.length();
                        if (length2 > 1 && "-strict".startsWith(string2)) {
                            strict = true;
                            continue;
                        }
                        if (length2 > 1 && "-failindex".startsWith(string2)) {
                            if (i + 1 >= objv.length - 1) {
                                throw new TclNumArgsException(interp, 3, objv, "?-strict? ?-failindex var? str");
                            }
                            failVarObj = objv[++i];
                            continue;
                        }
                        throw new TclException(interp, "bad option \"" + string2 + "\": must be -strict or -failindex");
                    }
                }
                boolean result = true;
                int failat = 0;
                TclObject obj = objv[objv.length - 1];
                String string1 = obj.toString();
                int length1 = string1.length();
                if (length1 == 0) {
                    if (strict) {
                        result = false;
                    }
                    interp.setResult(result);
                    return;
                }
                block22 : switch (index) {
                    case 4: 
                    case 7: 
                    case 14: {
                        if (obj.getInternalRep() instanceof TclBoolean) {
                            if ((index != 14 || TclBoolean.get((Interp)interp, (TclObject)obj)) && (index != 7 || !TclBoolean.get((Interp)interp, (TclObject)obj))) break;
                            result = false;
                            break;
                        }
                        try {
                            boolean i = TclBoolean.get(null, (TclObject)obj);
                            if ((index != 14 || i) && (index != 7 || !i)) break;
                            result = false;
                        }
                        catch (TclException e) {
                            result = false;
                        }
                        break;
                    }
                    case 6: {
                        Object res;
                        int signIx;
                        char c;
                        if (obj.getInternalRep() instanceof TclDouble || obj.getInternalRep() instanceof TclInteger) break;
                        if (Expression.looksLikeInt(string1, length1, 0)) {
                            c = string1.charAt(0);
                            signIx = c == '-' || c == '+' ? 1 : 0;
                            res = Util.strtoul(string1, signIx, 0);
                            if (((StrtoulResult)res).index == length1) {
                                if (((StrtoulResult)res).errno != -2) break;
                                result = false;
                                failat = -1;
                                break;
                            }
                        }
                        signIx = (c = string1.charAt(0)) == '-' || c == '+' ? 1 : 0;
                        res = Util.strtod(string1, signIx);
                        if (((StrtodResult)res).errno == -4) {
                            result = false;
                            failat = -1;
                            break;
                        }
                        if (((StrtodResult)res).index == 0) {
                            result = false;
                            failat = 0;
                            break;
                        }
                        failat = ((StrtodResult)res).index;
                        for (int i = ((StrtodResult)res).index; i < length1; ++i) {
                            if (Character.isWhitespace(string1.charAt(i))) continue;
                            result = false;
                            break block22;
                        }
                        break;
                    }
                    case 9: {
                        if (obj.getInternalRep() instanceof TclInteger) break;
                        boolean isInteger = true;
                        try {
                            TclInteger.get(null, (TclObject)obj);
                        }
                        catch (TclException e) {
                            isInteger = false;
                        }
                        if (isInteger) break;
                        char c = string1.charAt(0);
                        int signIx = c == '-' || c == '+' ? 1 : 0;
                        StrtoulResult res = Util.strtoul(string1, signIx, 0);
                        if (res.errno == -2) {
                            result = false;
                            failat = -1;
                            break;
                        }
                        if (res.index == 0) {
                            result = false;
                            failat = 0;
                            break;
                        }
                        failat = res.index;
                        for (int i = res.index; i < length1; ++i) {
                            if (Character.isWhitespace(string1.charAt(i))) continue;
                            result = false;
                            break block22;
                        }
                        break;
                    }
                    default: {
                        for (failat = 0; failat < length1; ++failat) {
                            char c = string1.charAt(failat);
                            switch (index) {
                                case 2: {
                                    result = c < '\u0080';
                                    break;
                                }
                                case 0: {
                                    result = Character.isLetterOrDigit(c);
                                    break;
                                }
                                case 1: {
                                    result = Character.isLetter(c);
                                    break;
                                }
                                case 5: {
                                    result = Character.isDigit(c);
                                    break;
                                }
                                case 8: {
                                    result = (1 << Character.getType(c) & 0x1FF07FFE) != 0 && c != ' ';
                                    break;
                                }
                                case 11: {
                                    result = (1 << Character.getType(c) & 0x1FF07FFE) != 0;
                                    break;
                                }
                                case 12: {
                                    result = (1 << Character.getType(c) & 0x1F00000) != 0;
                                    break;
                                }
                                case 15: {
                                    result = Character.isUpperCase(c);
                                    break;
                                }
                                case 13: {
                                    result = Character.isWhitespace(c);
                                    break;
                                }
                                case 3: {
                                    result = Character.isISOControl(c);
                                    break;
                                }
                                case 10: {
                                    result = Character.isLowerCase(c);
                                    break;
                                }
                                case 16: {
                                    result = (1 << Character.getType(c) & 0x80023E) != 0;
                                    break;
                                }
                                case 17: {
                                    result = Character.digit(c, 16) >= 0;
                                    break;
                                }
                                default: {
                                    throw new TclRuntimeError("unimplemented");
                                }
                            }
                            if (!result) break block22;
                        }
                    }
                }
                if (!result && failVarObj != null) {
                    interp.setVar(failVarObj, TclInteger.newInstance((int)failat), 0);
                }
                interp.setResult(result);
                break;
            }
            case 6: {
                if (objv.length < 4 || objv.length > 5) {
                    throw new TclNumArgsException(interp, 2, objv, "subString string ?startIndex?");
                }
                String string1 = objv[2].toString();
                String string2 = objv[3].toString();
                int length2 = string2.length();
                int start = 0;
                if (objv.length == 5) {
                    start = Util.getIntForIndex(interp, objv[4], length2 - 1);
                    if (start < 0) {
                        interp.setResult(-1);
                        break;
                    }
                    if (start < length2) {
                        string2 = string2.substring(0, start + 1);
                    }
                }
                if (string1.length() == 0) {
                    interp.setResult(-1);
                    break;
                }
                interp.setResult(string2.lastIndexOf(string1));
                break;
            }
            case 0: {
                if (objv.length != 3) {
                    throw new TclNumArgsException(interp, 2, objv, "string");
                }
                interp.setResult(this.Utf8Count(objv[2].toString()));
                break;
            }
            case 7: {
                if (objv.length != 3) {
                    throw new TclNumArgsException(interp, 2, objv, "string");
                }
                interp.setResult(objv[2].toString().length());
                break;
            }
            case 8: {
                int str1;
                String[] cmpStrings;
                TclObject[] mapElemv;
                if (objv.length < 4 || objv.length > 5) {
                    throw new TclNumArgsException(interp, 2, objv, "?-nocase? charMap string");
                }
                boolean nocase = false;
                if (objv.length == 5) {
                    String string2 = objv[2].toString();
                    int length2 = string2.length();
                    if (length2 > 1 && "-nocase".startsWith(string2)) {
                        nocase = true;
                    } else {
                        throw new TclException(interp, "bad option \"" + string2 + "\": must be -nocase");
                    }
                }
                if ((mapElemv = TclList.getElements(interp, objv[objv.length - 2])).length == 0) {
                    interp.setResult(objv[objv.length - 1]);
                } else if (mapElemv.length % 2 != 0) {
                    throw new TclException(interp, "char map list unbalanced");
                }
                String string1 = objv[objv.length - 1].toString();
                String cmpString1 = nocase ? string1.toLowerCase() : string1;
                int length1 = string1.length();
                if (length1 == 0) break;
                String[] mapStrings = new String[mapElemv.length];
                int[] mapLens = new int[mapElemv.length];
                for (int ix = 0; ix < mapElemv.length; ++ix) {
                    mapStrings[ix] = mapElemv[ix].toString();
                    mapLens[ix] = mapStrings[ix].length();
                }
                if (nocase) {
                    cmpStrings = new String[mapStrings.length];
                    for (int ix = 0; ix < mapStrings.length; ++ix) {
                        cmpStrings[ix] = mapStrings[ix].toLowerCase();
                    }
                } else {
                    cmpStrings = mapStrings;
                }
                TclObject result = TclString.newInstance((String)"");
                int p = 0;
                block51: for (str1 = 0; str1 < length1; ++str1) {
                    for (index = 0; index < mapStrings.length; index += 2) {
                        String string2 = mapStrings[index];
                        int length2 = mapLens[index];
                        if (length2 <= 0 || !cmpString1.substring(str1).startsWith(cmpStrings[index])) continue;
                        if (p != str1) {
                            TclString.append((TclObject)result, (String)string1.substring(p, str1));
                            p = str1 + length2;
                        } else {
                            p += length2;
                        }
                        str1 = p - 1;
                        TclString.append((TclObject)result, (String)mapStrings[index + 1]);
                        continue block51;
                    }
                }
                if (p != str1) {
                    TclString.append((TclObject)result, (String)string1.substring(p, str1));
                }
                interp.setResult(result);
                break;
            }
            case 9: {
                String string2;
                String string1;
                if (objv.length < 4 || objv.length > 5) {
                    throw new TclNumArgsException(interp, 2, objv, "?-nocase? pattern string");
                }
                if (objv.length == 5) {
                    String string = objv[2].toString();
                    if (string.length() <= 1 || !"-nocase".startsWith(string)) {
                        throw new TclException(interp, "bad option \"" + string + "\": must be -nocase");
                    }
                    string1 = objv[4].toString().toLowerCase();
                    string2 = objv[3].toString().toLowerCase();
                } else {
                    string1 = objv[3].toString();
                    string2 = objv[2].toString();
                }
                interp.setResult(Util.stringMatch(string1, string2));
                break;
            }
            case 10: {
                int last;
                if (objv.length != 5) {
                    throw new TclNumArgsException(interp, 2, objv, "string first last");
                }
                String string1 = objv[2].toString();
                int length1 = string1.length();
                int first = Util.getIntForIndex(interp, objv[3], length1 - 1);
                if (first < 0) {
                    first = 0;
                }
                if ((last = Util.getIntForIndex(interp, objv[4], length1 - 1)) >= length1) {
                    last = length1 - 1;
                }
                if (first > last) {
                    interp.resetResult();
                    break;
                }
                interp.setResult(string1.substring(first, last + 1));
                break;
            }
            case 11: {
                if (objv.length != 4) {
                    throw new TclNumArgsException(interp, 2, objv, "string count");
                }
                int count = TclInteger.get((Interp)interp, (TclObject)objv[3]);
                String string1 = objv[2].toString();
                if (string1.length() <= 0) break;
                TclObject tstr = TclString.newInstance((String)"");
                for (index = 0; index < count; ++index) {
                    TclString.append((TclObject)tstr, (String)string1);
                }
                interp.setResult(tstr);
                break;
            }
            case 12: {
                if (objv.length < 5 || objv.length > 6) {
                    throw new TclNumArgsException(interp, 2, objv, "string first last ?string?");
                }
                String string1 = objv[2].toString();
                int length1 = string1.length() - 1;
                int first = Util.getIntForIndex(interp, objv[3], length1);
                int last = Util.getIntForIndex(interp, objv[4], length1);
                if (last < first || first > length1 || last < 0) {
                    interp.setResult(objv[2]);
                    break;
                }
                if (first < 0) {
                    first = 0;
                }
                String start = string1.substring(first);
                int ind = (last > length1 ? length1 : last) - first + 1;
                String end = ind <= 0 ? start : (ind >= start.length() ? "" : start.substring(ind));
                TclObject tstr = TclString.newInstance((String)string1.substring(0, first));
                if (objv.length == 6) {
                    TclString.append((TclObject)tstr, (TclObject)objv[5]);
                }
                if (last < length1) {
                    TclString.append((TclObject)tstr, (String)end);
                }
                interp.setResult(tstr);
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                if (objv.length < 3 || objv.length > 5) {
                    throw new TclNumArgsException(interp, 2, objv, "string ?first? ?last?");
                }
                String string1 = objv[2].toString();
                if (objv.length == 3) {
                    if (index == 13) {
                        interp.setResult(string1.toLowerCase());
                        break;
                    }
                    if (index == 14) {
                        interp.setResult(string1.toUpperCase());
                        break;
                    }
                    interp.setResult(Util.toTitle(string1));
                    break;
                }
                int length1 = string1.length() - 1;
                int first = Util.getIntForIndex(interp, objv[3], length1);
                if (first < 0) {
                    first = 0;
                }
                int last = first;
                if (objv.length == 5) {
                    last = Util.getIntForIndex(interp, objv[4], length1);
                }
                if (last >= length1) {
                    last = length1;
                }
                if (last < first) {
                    interp.setResult(objv[2]);
                    break;
                }
                StringBuffer buf = new StringBuffer();
                buf.append(string1.substring(0, first));
                String string2 = last + 1 > length1 ? string1.substring(first) : string1.substring(first, last + 1);
                if (index == 13) {
                    buf.append(string2.toLowerCase());
                } else if (index == 14) {
                    buf.append(string2.toUpperCase());
                } else {
                    buf.append(Util.toTitle(string2));
                }
                if (last + 1 <= length1) {
                    buf.append(string1.substring(last + 1));
                }
                interp.setResult(buf.toString());
                break;
            }
            case 16: {
                if (objv.length == 3) {
                    interp.setResult(objv[2].toString().trim());
                    break;
                }
                if (objv.length == 4) {
                    String tmp = Util.TrimLeft(objv[2].toString(), objv[3].toString());
                    interp.setResult(Util.TrimRight(tmp, objv[3].toString()));
                    break;
                }
                throw new TclNumArgsException(interp, 2, objv, "string ?chars?");
            }
            case 17: {
                if (objv.length == 3) {
                    interp.setResult(Util.TrimLeft(objv[2].toString()));
                    break;
                }
                if (objv.length == 4) {
                    interp.setResult(Util.TrimLeft(objv[2].toString(), objv[3].toString()));
                    break;
                }
                throw new TclNumArgsException(interp, 2, objv, "string ?chars?");
            }
            case 18: {
                if (objv.length == 3) {
                    interp.setResult(Util.TrimRight(objv[2].toString()));
                    break;
                }
                if (objv.length == 4) {
                    interp.setResult(Util.TrimRight(objv[2].toString(), objv[3].toString()));
                    break;
                }
                throw new TclNumArgsException(interp, 2, objv, "string ?chars?");
            }
            case 19: {
                char c;
                int cur;
                if (objv.length != 4) {
                    throw new TclNumArgsException(interp, 2, objv, "string index");
                }
                String string1 = objv[2].toString();
                char[] strArray = string1.toCharArray();
                int length1 = string1.length();
                index = Util.getIntForIndex(interp, objv[3], length1 - 1);
                if (index < 0) {
                    index = 0;
                }
                if (index >= length1) {
                    interp.setResult(length1);
                    return;
                }
                for (cur = index; cur < length1 && (1 << Character.getType(c = strArray[cur]) & 0x80023E) != 0; ++cur) {
                }
                if (cur == index) {
                    cur = index + 1;
                }
                interp.setResult(cur);
                break;
            }
            case 20: {
                char c;
                int cur;
                if (objv.length != 4) {
                    throw new TclNumArgsException(interp, 2, objv, "string index");
                }
                String string1 = objv[2].toString();
                char[] strArray = string1.toCharArray();
                int length1 = string1.length();
                index = Util.getIntForIndex(interp, objv[3], length1 - 1);
                if (index > length1) {
                    index = length1 - 1;
                }
                if (index < 0) {
                    interp.setResult(0);
                    return;
                }
                for (cur = index; cur >= 0 && (1 << Character.getType(c = strArray[cur]) & 0x80023E) != 0; --cur) {
                }
                if (cur != index) {
                    ++cur;
                }
                interp.setResult(cur);
                break;
            }
        }
    }

    private final int Utf8Count(String s) {
        int p = 0;
        int len = s.length();
        int sum = 0;
        while (p < len) {
            char c;
            if ((c = s.charAt(p++)) > '\u0000' && c < '\u0080') {
                ++sum;
                continue;
            }
            if (c <= '\u07ff') {
                sum += 2;
                continue;
            }
            if (c > '\uffff') continue;
            sum += 3;
        }
        return sum;
    }
}

