/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import tcl.lang.CallFrame;
import tcl.lang.Interp;
import tcl.lang.NamespaceCmd;
import tcl.lang.SearchId;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.TclVarException;
import tcl.lang.TraceRecord;
import tcl.lang.Util;
import tcl.lang.VarTrace;

class Var {
    static final int SCALAR = 1;
    static final int ARRAY = 2;
    static final int LINK = 4;
    static final int UNDEFINED = 8;
    static final int IN_HASHTABLE = 16;
    static final int TRACE_ACTIVE = 32;
    static final int ARRAY_ELEMENT = 64;
    static final int NAMESPACE_VAR = 128;
    Object value = null;
    Vector traces = null;
    Vector sidVec = null;
    int flags = 25;
    Hashtable table = null;
    String hashKey = null;
    int refCount = 0;
    NamespaceCmd.Namespace ns = null;
    static final String noSuchVar = "no such variable";
    static final String isArray = "variable is array";
    static final String needArray = "variable isn't array";
    static final String noSuchElement = "no such element in array";
    static final String danglingElement = "upvar refers to element in deleted array";
    static final String danglingVar = "upvar refers to variable in deleted namespace";
    static final String badNamespace = "parent namespace doesn't exist";
    static final String missingName = "missing variable name";

    final boolean isVarScalar() {
        return (this.flags & 1) != 0;
    }

    final boolean isVarLink() {
        return (this.flags & 4) != 0;
    }

    final boolean isVarArray() {
        return (this.flags & 2) != 0;
    }

    final boolean isVarUndefined() {
        return (this.flags & 8) != 0;
    }

    final boolean isVarArrayElement() {
        return (this.flags & 0x40) != 0;
    }

    final void setVarScalar() {
        this.flags = this.flags & 0xFFFFFFF9 | 1;
    }

    final void setVarArray() {
        this.flags = this.flags & 0xFFFFFFFA | 2;
    }

    final void setVarLink() {
        this.flags = this.flags & 0xFFFFFFFC | 4;
    }

    final void setVarArrayElement() {
        this.flags = this.flags & 0xFFFFFFFD | 0x40;
    }

    final void setVarUndefined() {
        this.flags |= 8;
    }

    final void clearVarUndefined() {
        this.flags &= 0xFFFFFFF7;
    }

    Var() {
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.ns);
        if (sb.length() == 2) {
            sb.append(this.hashKey);
        } else {
            sb.append("::");
            sb.append(this.hashKey);
        }
        return sb.toString();
    }

    protected synchronized int getNextIndex() {
        if (this.sidVec.size() == 0) {
            return 1;
        }
        SearchId sid = (SearchId)this.sidVec.lastElement();
        return sid.getIndex() + 1;
    }

    protected Enumeration getSearch(String s) {
        for (int i = 0; i < this.sidVec.size(); ++i) {
            SearchId sid = (SearchId)this.sidVec.elementAt(i);
            if (!sid.equals(s)) continue;
            return sid.getEnum();
        }
        return null;
    }

    protected boolean removeSearch(String sid) {
        for (int i = 0; i < this.sidVec.size(); ++i) {
            SearchId curSid = (SearchId)this.sidVec.elementAt(i);
            if (!curSid.equals(sid)) continue;
            this.sidVec.removeElementAt(i);
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Var[] lookupVar(Interp interp, String part1, String part2, int flags, String msg, boolean createPart1, boolean createPart2) throws TclException {
        CallFrame varFrame = interp.varFrame;
        Var var = null;
        int openParen = -1;
        NamespaceCmd.Namespace varNs = null;
        String elName = part2;
        int len = part1.length();
        for (int p = 0; p < len; ++p) {
            if (part1.charAt(p) != '(') continue;
            openParen = p;
            p = len - 1;
            if (part1.charAt(p) != ')') break;
            if (part2 != null) {
                if ((flags & 0x200) != 0) {
                    throw new TclVarException(interp, part1, part2, msg, needArray);
                }
                return null;
            }
            part2 = elName = part1.substring(openParen + 1, len - 1);
            part1 = part1.substring(0, openParen);
            break;
        }
        NamespaceCmd.Namespace cxtNs = (flags & 1) != 0 || interp.varFrame == null ? interp.globalNs : interp.varFrame.ns;
        if (cxtNs.resolver != null || interp.resolvers != null) {
            try {
                var = cxtNs.resolver != null ? cxtNs.resolver.resolveVar(interp, part1, cxtNs, flags) : null;
                if (var == null && interp.resolvers != null) {
                    Enumeration e = interp.resolvers.elements();
                    while (var == null && e.hasMoreElements()) {
                        Interp.ResolverScheme res = (Interp.ResolverScheme)e.nextElement();
                        var = res.resolver.resolveVar(interp, part1, cxtNs, flags);
                    }
                }
            }
            catch (TclException e) {
                var = null;
            }
        }
        if ((flags & 3) != 0 || varFrame == null || !varFrame.isProcCallFrame || part1.indexOf("::") != -1) {
            var = NamespaceCmd.findNamespaceVar(interp, part1, null, flags & 0xFFFFFDFF);
            if (var == null) {
                if (createPart1) {
                    NamespaceCmd.Namespace[] varNsArr = new NamespaceCmd.Namespace[1];
                    NamespaceCmd.Namespace[] dummyArr = new NamespaceCmd.Namespace[1];
                    String[] tailArr = new String[1];
                    NamespaceCmd.getNamespaceForQualName(interp, part1, null, flags, varNsArr, dummyArr, dummyArr, tailArr);
                    varNs = varNsArr[0];
                    String tail = tailArr[0];
                    if (varNs == null) {
                        if ((flags & 0x200) != 0) {
                            throw new TclVarException(interp, part1, part2, msg, badNamespace);
                        }
                        return null;
                    }
                    if (tail == null) {
                        if ((flags & 0x200) != 0) {
                            throw new TclVarException(interp, part1, part2, msg, missingName);
                        }
                        return null;
                    }
                    var = new Var();
                    varNs.varTable.put(tail, var);
                    var.hashKey = tail;
                    var.table = varNs.varTable;
                    var.ns = varNs;
                } else {
                    if ((flags & 0x200) != 0) {
                        throw new TclVarException(interp, part1, part2, msg, noSuchVar);
                    }
                    return null;
                }
            }
        } else if (var == null) {
            Hashtable<String, Var> table = varFrame.varTable;
            if (createPart1) {
                if (table == null) {
                    varFrame.varTable = table = new Hashtable<String, Var>();
                }
                if ((var = (Var)table.get(part1)) == null) {
                    var = new Var();
                    table.put(part1, var);
                    var.hashKey = part1;
                    var.table = table;
                    var.ns = null;
                }
            } else {
                if (table != null) {
                    var = (Var)table.get(part1);
                }
                if (var == null) {
                    if ((flags & 0x200) != 0) {
                        throw new TclVarException(interp, part1, part2, msg, noSuchVar);
                    }
                    return null;
                }
            }
        }
        while (var.isVarLink()) {
            var = (Var)var.value;
        }
        if (elName == null) {
            Var[] ret = new Var[]{var, null};
            return ret;
        }
        if (var.isVarUndefined() && !var.isVarArrayElement()) {
            if (!createPart1) {
                if ((flags & 0x200) != 0) {
                    throw new TclVarException(interp, part1, part2, msg, noSuchVar);
                }
                return null;
            }
            if ((var.flags & 0x10) != 0 && var.table == null) {
                if ((flags & 0x200) != 0) {
                    throw new TclVarException(interp, part1, part2, msg, danglingVar);
                }
                return null;
            }
            var.setVarArray();
            var.clearVarUndefined();
            var.value = new Hashtable();
        } else if (!var.isVarArray()) {
            if ((flags & 0x200) != 0) {
                throw new TclVarException(interp, part1, part2, msg, needArray);
            }
            return null;
        }
        Var arrayVar = var;
        Hashtable arrayTable = (Hashtable)var.value;
        if (createPart2) {
            Var searchvar = (Var)arrayTable.get(elName);
            if (searchvar == null) {
                if (var.sidVec != null) {
                    Var.deleteSearches(var);
                }
                var = new Var();
                arrayTable.put(elName, var);
                var.hashKey = elName;
                var.table = arrayTable;
                var.ns = varNs;
                var.setVarArrayElement();
            } else {
                var = searchvar;
            }
        } else {
            var = (Var)arrayTable.get(elName);
            if (var == null) {
                if ((flags & 0x200) != 0) {
                    throw new TclVarException(interp, part1, part2, msg, noSuchElement);
                }
                return null;
            }
        }
        Var[] ret = new Var[]{var, arrayVar};
        return ret;
    }

    static TclObject getVar(Interp interp, TclObject nameObj, int flags) throws TclException {
        return Var.getVar(interp, nameObj.toString(), null, flags);
    }

    static TclObject getVar(Interp interp, String name, int flags) throws TclException {
        return Var.getVar(interp, name, null, flags);
    }

    static TclObject getVar(Interp interp, TclObject part1Obj, TclObject part2Obj, int flags) throws TclException {
        String part1 = part1Obj.toString();
        String part2 = part2Obj != null ? part2Obj.toString() : null;
        return Var.getVar(interp, part1, part2, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static TclObject getVar(Interp interp, String part1, String part2, int flags) throws TclException {
        Var[] result = Var.lookupVar(interp, part1, part2, flags, "read", false, true);
        if (result == null) {
            return null;
        }
        Var var = result[0];
        Var array = result[1];
        try {
            String msg;
            if ((var.traces != null || array != null && array.traces != null) && (msg = Var.callTraces(interp, array, var, part1, part2, flags & 3 | 0x10)) != null) {
                if ((flags & 0x200) != 0) {
                    throw new TclVarException(interp, part1, part2, "read", msg);
                }
                TclObject tclObject = null;
                return tclObject;
            }
            if (var.isVarScalar() && !var.isVarUndefined()) {
                msg = (TclObject)var.value;
                return msg;
            }
            if ((flags & 0x200) != 0) {
                msg = var.isVarUndefined() && array != null && !array.isVarUndefined() ? noSuchElement : (var.isVarArray() ? isArray : noSuchVar);
                throw new TclVarException(interp, part1, part2, "read", msg);
            }
        }
        finally {
            if (var.isVarUndefined()) {
                Var.cleanupVar(var, array);
            }
        }
        return null;
    }

    static TclObject setVar(Interp interp, TclObject nameObj, TclObject value, int flags) throws TclException {
        return Var.setVar(interp, nameObj.toString(), null, value, flags);
    }

    static TclObject setVar(Interp interp, String name, TclObject value, int flags) throws TclException {
        return Var.setVar(interp, name, null, value, flags);
    }

    static TclObject setVar(Interp interp, TclObject part1Obj, TclObject part2Obj, TclObject newValue, int flags) throws TclException {
        String part1 = part1Obj.toString();
        String part2 = part2Obj != null ? part2Obj.toString() : null;
        return Var.setVar(interp, part1, part2, newValue, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static TclObject setVar(Interp interp, String part1, String part2, TclObject newValue, int flags) throws TclException {
        Var[] result = Var.lookupVar(interp, part1, part2, flags, "set", true, true);
        if (result == null) {
            return null;
        }
        Var var = result[0];
        Var array = result[1];
        if ((var.flags & 0x10) != 0 && var.table == null) {
            if ((flags & 0x200) != 0) {
                if (var.isVarArrayElement()) {
                    throw new TclVarException(interp, part1, part2, "set", danglingElement);
                }
                throw new TclVarException(interp, part1, part2, "set", danglingVar);
            }
            return null;
        }
        if (var.isVarArray() && !var.isVarUndefined()) {
            if ((flags & 0x200) != 0) {
                throw new TclVarException(interp, part1, part2, "set", isArray);
            }
            return null;
        }
        try {
            String msg;
            TclObject oldValue = (TclObject)var.value;
            if ((flags & 4) != 0) {
                if (var.isVarUndefined() && oldValue != null) {
                    oldValue.release();
                    var.value = null;
                    oldValue = null;
                }
                if ((flags & 8) != 0) {
                    if (oldValue == null) {
                        oldValue = TclList.newInstance();
                        var.value = oldValue;
                        oldValue.preserve();
                    } else if (oldValue.isShared()) {
                        var.value = oldValue.duplicate();
                        oldValue.release();
                        oldValue = (TclObject)var.value;
                        oldValue.preserve();
                    }
                    TclList.append(interp, oldValue, newValue);
                } else {
                    String bytes = newValue.toString();
                    if (oldValue == null) {
                        var.value = TclString.newInstance((String)bytes);
                        ((TclObject)var.value).preserve();
                    } else {
                        if (oldValue.isShared()) {
                            var.value = oldValue.duplicate();
                            oldValue.release();
                            oldValue = (TclObject)var.value;
                            oldValue.preserve();
                        }
                        TclString.append((TclObject)oldValue, (TclObject)newValue);
                    }
                }
            } else if ((flags & 8) != 0) {
                if (oldValue != null) {
                    oldValue.release();
                }
                String bytes = newValue.toString();
                int listFlags = Util.scanElement(interp, bytes);
                oldValue = TclString.newInstance((String)Util.convertElement(bytes, listFlags));
                var.value = oldValue;
                ((TclObject)var.value).preserve();
            } else if (newValue != oldValue) {
                var.value = newValue;
                newValue.preserve();
                if (oldValue != null) {
                    oldValue.release();
                }
            }
            var.setVarScalar();
            var.clearVarUndefined();
            if (array != null) {
                array.clearVarUndefined();
            }
            if ((var.traces != null || array != null && array.traces != null) && (msg = Var.callTraces(interp, array, var, part1, part2, flags & 3 | 0x20)) != null) {
                if ((flags & 0x200) != 0) {
                    throw new TclVarException(interp, part1, part2, "set", msg);
                }
                TclObject tclObject = null;
                return tclObject;
            }
            if (var.isVarScalar() && !var.isVarUndefined()) {
                TclObject tclObject = (TclObject)var.value;
                return tclObject;
            }
            TclObject tclObject = TclString.newInstance((String)"");
            return tclObject;
        }
        finally {
            if (var.isVarUndefined()) {
                Var.cleanupVar(var, array);
            }
        }
    }

    static TclObject incrVar(Interp interp, TclObject part1, TclObject part2, int incrAmount, int flags) throws TclException {
        int i;
        TclObject varValue = null;
        boolean err = false;
        try {
            varValue = Var.getVar(interp, part1, part2, flags);
        }
        catch (TclException e) {
            err = true;
            throw e;
        }
        finally {
            if (err || varValue == null) {
                interp.addErrorInfo("\n    (reading value of variable to increment)");
            }
        }
        boolean createdNewObj = false;
        if (varValue.isShared()) {
            varValue = varValue.duplicate();
            createdNewObj = true;
        }
        try {
            i = TclInteger.get((Interp)interp, (TclObject)varValue);
        }
        catch (TclException e) {
            if (createdNewObj) {
                varValue.release();
            }
            throw e;
        }
        TclInteger.set((TclObject)varValue, (int)(i + incrAmount));
        return Var.setVar(interp, part1, part2, varValue, flags);
    }

    static void unsetVar(Interp interp, TclObject nameObj, int flags) throws TclException {
        Var.unsetVar(interp, nameObj.toString(), null, flags);
    }

    static void unsetVar(Interp interp, String name, int flags) throws TclException {
        Var.unsetVar(interp, name, null, flags);
    }

    static void unsetVar(Interp interp, String part1, String part2, int flags) throws TclException {
        boolean result;
        Var[] lookup_result = Var.lookupVar(interp, part1, part2, flags, "unset", false, false);
        if (lookup_result == null) {
            throw new TclRuntimeError("unexpected null reference");
        }
        Var var = lookup_result[0];
        Var array = lookup_result[1];
        boolean bl = result = var.isVarUndefined();
        if (array != null && array.sidVec != null) {
            Var.deleteSearches(array);
        }
        Var dummyVar = new Var();
        dummyVar.value = var.value;
        dummyVar.traces = var.traces;
        dummyVar.flags = var.flags;
        dummyVar.hashKey = var.hashKey;
        dummyVar.table = var.table;
        dummyVar.refCount = var.refCount;
        dummyVar.ns = var.ns;
        var.setVarUndefined();
        var.setVarScalar();
        var.value = null;
        var.traces = null;
        var.sidVec = null;
        if (dummyVar.traces != null || array != null && array.traces != null) {
            ++var.refCount;
            dummyVar.flags &= 0xFFFFFFDF;
            Var.callTraces(interp, array, dummyVar, part1, part2, flags & 3 | 0x40);
            dummyVar.traces = null;
            --var.refCount;
        }
        if (dummyVar.isVarArray() && !dummyVar.isVarUndefined()) {
            Var.deleteArray(interp, part1, dummyVar, flags & 3 | 0x40);
        }
        if (dummyVar.isVarScalar() && dummyVar.value != null) {
            TclObject obj = (TclObject)dummyVar.value;
            obj.release();
            dummyVar.value = null;
        }
        if ((var.flags & 0x80) != 0) {
            var.flags &= 0xFFFFFF7F;
            --var.refCount;
        }
        Var.cleanupVar(var, array);
        if (result && (flags & 0x200) != 0) {
            throw new TclVarException(interp, part1, part2, "unset", array == null ? noSuchVar : noSuchElement);
        }
    }

    static void traceVar(Interp interp, TclObject nameObj, int flags, VarTrace proc) throws TclException {
        Var.traceVar(interp, nameObj.toString(), null, flags, proc);
    }

    static void traceVar(Interp interp, String name, int flags, VarTrace proc) throws TclException {
        Var.traceVar(interp, name, null, flags, proc);
    }

    static void traceVar(Interp interp, String part1, String part2, int flags, VarTrace proc) throws TclException {
        Var[] result = Var.lookupVar(interp, part1, part2, flags | 0x200, "trace", true, true);
        if (result == null) {
            throw new TclException(interp, "");
        }
        Var var = result[0];
        Var array = result[1];
        if (var.traces == null) {
            var.traces = new Vector();
        }
        TraceRecord rec = new TraceRecord();
        rec.trace = proc;
        rec.flags = flags & 0x870;
        var.traces.insertElementAt(rec, 0);
    }

    static void untraceVar(Interp interp, TclObject nameObj, int flags, VarTrace proc) {
        Var.untraceVar(interp, nameObj.toString(), null, flags, proc);
    }

    static void untraceVar(Interp interp, String name, int flags, VarTrace proc) {
        Var.untraceVar(interp, name, null, flags, proc);
    }

    static void untraceVar(Interp interp, String part1, String part2, int flags, VarTrace proc) {
        Var[] result = null;
        try {
            result = Var.lookupVar(interp, part1, part2, flags & 3, null, false, false);
            if (result == null) {
                return;
            }
        }
        catch (TclException e) {
            throw new TclRuntimeError("unexpected TclException: " + (Object)((Object)e));
        }
        Var var = result[0];
        if (var.traces != null) {
            int len = var.traces.size();
            for (int i = 0; i < len; ++i) {
                TraceRecord rec = (TraceRecord)var.traces.elementAt(i);
                if (rec.trace != proc) continue;
                var.traces.removeElementAt(i);
                break;
            }
        }
        if (var.isVarUndefined()) {
            Var.cleanupVar(var, null);
        }
    }

    protected static Vector getTraces(Interp interp, String name, int flags) throws TclException {
        return Var.getTraces(interp, name, null, flags);
    }

    protected static Vector getTraces(Interp interp, String part1, String part2, int flags) throws TclException {
        Var[] result = Var.lookupVar(interp, part1, part2, flags & 3, null, false, false);
        if (result == null) {
            return null;
        }
        return result[0].traces;
    }

    protected static void makeUpvar(Interp interp, CallFrame frame, String otherP1, String otherP2, int otherFlags, String myName, int myFlags) throws TclException {
        Var var;
        CallFrame savedFrame = null;
        boolean newvar = false;
        if ((otherFlags & 2) == 0) {
            savedFrame = interp.varFrame;
            interp.varFrame = frame;
        }
        Var[] result = Var.lookupVar(interp, otherP1, otherP2, otherFlags | 0x200, "access", true, true);
        if ((otherFlags & 2) == 0) {
            interp.varFrame = savedFrame;
        }
        Var other = result[0];
        Var array = result[1];
        if (other == null) {
            throw new TclRuntimeError("unexpected null reference");
        }
        CallFrame varFrame = interp.varFrame;
        if ((myFlags & 3) != 0 || varFrame == null || !varFrame.isProcCallFrame || myName.indexOf("::") != -1) {
            NamespaceCmd.Namespace[] nsArr = new NamespaceCmd.Namespace[1];
            NamespaceCmd.Namespace[] altNsArr = new NamespaceCmd.Namespace[1];
            NamespaceCmd.Namespace[] dummyNsArr = new NamespaceCmd.Namespace[1];
            String[] tailArr = new String[1];
            NamespaceCmd.getNamespaceForQualName(interp, myName, null, myFlags, nsArr, altNsArr, dummyNsArr, tailArr);
            NamespaceCmd.Namespace ns = nsArr[0];
            NamespaceCmd.Namespace altNs = altNsArr[0];
            String tail = tailArr[0];
            if (ns == null) {
                ns = altNs;
            }
            if (ns == null) {
                throw new TclException(interp, "bad variable name \"" + myName + "\": unknown namespace");
            }
            if ((otherP2 != null ? array.ns : other.ns) == null) {
                throw new TclException(interp, "bad variable name \"" + myName + "\": upvar won't create namespace variable that refers to procedure variable");
            }
            var = (Var)ns.varTable.get(tail);
            if (var == null) {
                newvar = true;
                var = new Var();
                ns.varTable.put(tail, var);
                var.hashKey = tail;
                var.table = ns.varTable;
                var.ns = ns;
            }
        } else {
            var = null;
            if (var == null) {
                Hashtable<String, Var> table = varFrame.varTable;
                if (table == null) {
                    varFrame.varTable = table = new Hashtable<String, Var>();
                }
                if ((var = (Var)table.get(myName)) == null) {
                    newvar = true;
                    var = new Var();
                    table.put(myName, var);
                    var.hashKey = myName;
                    var.table = table;
                    var.ns = varFrame.ns;
                }
            }
        }
        if (!newvar) {
            if (var == other) {
                throw new TclException(interp, "can't upvar from variable to itself");
            }
            if (var.isVarLink()) {
                Var link = (Var)var.value;
                if (link == other) {
                    return;
                }
                --link.refCount;
                if (link.isVarUndefined()) {
                    Var.cleanupVar(link, null);
                }
            } else {
                if (!var.isVarUndefined()) {
                    throw new TclException(interp, "variable \"" + myName + "\" already exists");
                }
                if (var.traces != null) {
                    throw new TclException(interp, "variable \"" + myName + "\" has traces: can't use for upvar");
                }
            }
        }
        var.setVarLink();
        var.clearVarUndefined();
        var.value = other;
        ++other.refCount;
    }

    static String getVariableFullName(Interp interp, Var var) {
        StringBuffer buff = new StringBuffer();
        if (var != null && !var.isVarArrayElement()) {
            if (var.ns != null) {
                buff.append(var.ns.fullName);
                if (var.ns != interp.globalNs) {
                    buff.append("::");
                }
            }
            if (var.hashKey != null) {
                buff.append(var.hashKey);
            }
        }
        return buff.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String callTraces(Interp interp, Var array, Var var, String part1, String part2, int flags) {
        int i;
        int len;
        if ((var.flags & 0x20) != 0) {
            return null;
        }
        var.flags |= 0x20;
        ++var.refCount;
        if (part2 == null && (len = part1.length()) > 0 && part1.charAt(len - 1) == ')') {
            for (i = 0; i < len - 1 && part1.charAt(i) != '('; ++i) {
            }
            if (i < len - 1 && i < len - 2) {
                part2 = part1.substring(i + 1, len - 1);
                part1 = part1.substring(0, i);
            }
        }
        TclObject oldResult = interp.getResult();
        oldResult.preserve();
        interp.resetResult();
        try {
            if (array != null) {
                ++array.refCount;
            }
            if (array != null && array.traces != null) {
                for (i = 0; array.traces != null && i < array.traces.size(); ++i) {
                    TraceRecord rec = (TraceRecord)array.traces.elementAt(i);
                    if ((rec.flags & flags) == 0) continue;
                    try {
                        rec.trace.traceProc(interp, part1, part2, flags);
                        continue;
                    }
                    catch (TclException e) {
                        if ((flags & 0x40) != 0) continue;
                        String string = interp.getResult().toString();
                        if (array != null) {
                            --array.refCount;
                        }
                        var.flags &= 0xFFFFFFDF;
                        --var.refCount;
                        interp.setResult(oldResult);
                        oldResult.release();
                        return string;
                    }
                }
            }
            if ((flags & 0x40) != 0) {
                flags |= 0x80;
            }
            for (i = 0; var.traces != null && i < var.traces.size(); ++i) {
                TraceRecord rec = (TraceRecord)var.traces.elementAt(i);
                if ((rec.flags & flags) == 0) continue;
                try {
                    rec.trace.traceProc(interp, part1, part2, flags);
                    continue;
                }
                catch (TclException e) {
                    if ((flags & 0x40) != 0) continue;
                    String string = interp.getResult().toString();
                    if (array != null) {
                        --array.refCount;
                    }
                    var.flags &= 0xFFFFFFDF;
                    --var.refCount;
                    interp.setResult(oldResult);
                    oldResult.release();
                    return string;
                }
            }
            String string = null;
            return string;
        }
        finally {
            if (array != null) {
                --array.refCount;
            }
            var.flags &= 0xFFFFFFDF;
            --var.refCount;
            interp.setResult(oldResult);
            oldResult.release();
        }
    }

    protected static void deleteSearches(Var arrayVar) {
        arrayVar.sidVec = null;
    }

    protected static void deleteVars(Interp interp, Hashtable table) {
        NamespaceCmd.Namespace currNs = NamespaceCmd.getCurrentNamespace(interp);
        int flags = 64;
        if (table == interp.globalNs.varTable) {
            flags |= 0x101;
        } else if (table == currNs.varTable) {
            flags |= 2;
        }
        Enumeration search = table.elements();
        while (search.hasMoreElements()) {
            Var var = (Var)search.nextElement();
            if (var.isVarLink()) {
                Var link = (Var)var.value;
                --link.refCount;
                if (link.refCount == 0 && link.isVarUndefined() && link.traces == null && (link.flags & 0x10) != 0) {
                    if (link.hashKey == null) {
                        var.value = null;
                    } else if (link.table != table) {
                        link.table.remove(link.hashKey);
                        link.table = null;
                        var.value = null;
                    }
                }
            }
            if (var.traces != null) {
                String fullname = Var.getVariableFullName(interp, var);
                Var.callTraces(interp, null, var, fullname, null, flags);
            }
            if (var.isVarArray()) {
                Var.deleteArray(interp, var.hashKey, var, flags);
                var.value = null;
            }
            if (var.isVarScalar() && var.value != null) {
                TclObject obj = (TclObject)var.value;
                obj.release();
                var.value = null;
            }
            var.hashKey = null;
            var.table = null;
            var.traces = null;
            var.setVarUndefined();
            var.setVarScalar();
            if ((var.flags & 0x80) != 0) {
                var.flags &= 0xFFFFFF7F;
                --var.refCount;
            }
            if (var.refCount != 0) continue;
        }
        table.clear();
    }

    protected static void deleteArray(Interp interp, String arrayName, Var var, int flags) {
        Var.deleteSearches(var);
        Hashtable table = (Hashtable)var.value;
        Object dummyVar = null;
        Enumeration search = table.elements();
        while (search.hasMoreElements()) {
            Var el = (Var)search.nextElement();
            if (el.isVarScalar() && el.value != null) {
                TclObject obj = (TclObject)el.value;
                obj.release();
                el.value = null;
            }
            String tmpkey = el.hashKey;
            el.hashKey = null;
            el.table = null;
            if (el.traces != null) {
                el.flags &= 0xFFFFFFDF;
                Var.callTraces(interp, null, el, arrayName, tmpkey, flags);
                el.traces = null;
            }
            el.setVarUndefined();
            el.setVarScalar();
            if (el.refCount != 0) continue;
        }
        ((Hashtable)var.value).clear();
        var.value = null;
    }

    protected static void cleanupVar(Var var, Var array) {
        if (var.isVarUndefined() && var.refCount == 0 && var.traces == null && (var.flags & 0x10) != 0 && var.table != null) {
            var.table.remove(var.hashKey);
            var.table = null;
            var.hashKey = null;
        }
        if (array != null && array.isVarUndefined() && array.refCount == 0 && array.traces == null && (array.flags & 0x10) != 0 && array.table != null) {
            array.table.remove(array.hashKey);
            array.table = null;
            array.hashKey = null;
        }
    }
}

