/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CaseStatement;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.CaptureBinding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ImportBinding;
import org.eclipse.jdt.internal.compiler.lookup.ImportConflictBinding;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedGenericMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemFieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Substitution;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeIds;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.UpdatedMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.jdt.internal.compiler.util.ObjectVector;
import org.eclipse.jdt.internal.compiler.util.SimpleSet;

public abstract class Scope
implements TypeConstants,
TypeIds {
    public static final int BLOCK_SCOPE = 1;
    public static final int CLASS_SCOPE = 3;
    public static final int COMPILATION_UNIT_SCOPE = 4;
    public static final int METHOD_SCOPE = 2;
    public static final int NOT_COMPATIBLE = -1;
    public static final int COMPATIBLE = 0;
    public static final int AUTOBOX_COMPATIBLE = 1;
    public static final int VARARGS_COMPATIBLE = 2;
    public static final int EQUAL_OR_MORE_SPECIFIC = -1;
    public static final int NOT_RELATED = 0;
    public static final int MORE_GENERIC = 1;
    public int kind;
    public Scope parent;

    public static int compareTypes(TypeBinding left, TypeBinding right) {
        if (left.isCompatibleWith(right)) {
            return -1;
        }
        if (right.isCompatibleWith(left)) {
            return 1;
        }
        return 0;
    }

    public static TypeBinding getBaseType(char[] name) {
        int length = name.length;
        if (length > 2 && length < 8) {
            switch (name[0]) {
                case 'i': {
                    if (length != 3 || name[1] != 'n' || name[2] != 't') break;
                    return TypeBinding.INT;
                }
                case 'v': {
                    if (length != 4 || name[1] != 'o' || name[2] != 'i' || name[3] != 'd') break;
                    return TypeBinding.VOID;
                }
                case 'b': {
                    if (length == 7 && name[1] == 'o' && name[2] == 'o' && name[3] == 'l' && name[4] == 'e' && name[5] == 'a' && name[6] == 'n') {
                        return TypeBinding.BOOLEAN;
                    }
                    if (length != 4 || name[1] != 'y' || name[2] != 't' || name[3] != 'e') break;
                    return TypeBinding.BYTE;
                }
                case 'c': {
                    if (length != 4 || name[1] != 'h' || name[2] != 'a' || name[3] != 'r') break;
                    return TypeBinding.CHAR;
                }
                case 'd': {
                    if (length != 6 || name[1] != 'o' || name[2] != 'u' || name[3] != 'b' || name[4] != 'l' || name[5] != 'e') break;
                    return TypeBinding.DOUBLE;
                }
                case 'f': {
                    if (length != 5 || name[1] != 'l' || name[2] != 'o' || name[3] != 'a' || name[4] != 't') break;
                    return TypeBinding.FLOAT;
                }
                case 'l': {
                    if (length != 4 || name[1] != 'o' || name[2] != 'n' || name[3] != 'g') break;
                    return TypeBinding.LONG;
                }
                case 's': {
                    if (length != 5 || name[1] != 'h' || name[2] != 'o' || name[3] != 'r' || name[4] != 't') break;
                    return TypeBinding.SHORT;
                }
            }
        }
        return null;
    }

    public static ReferenceBinding[] greaterLowerBound(ReferenceBinding[] types) {
        if (types == null) {
            return null;
        }
        int length = types.length;
        if (length == 0) {
            return null;
        }
        ReferenceBinding[] result = types;
        int removed = 0;
        int i = 0;
        while (i < length) {
            ReferenceBinding iType = result[i];
            if (iType != null) {
                int j = 0;
                while (j < length) {
                    ReferenceBinding jType;
                    if (i != j && (jType = result[j]) != null && iType.isCompatibleWith(jType)) {
                        if (result == types) {
                            ReferenceBinding[] referenceBindingArray = result;
                            result = new ReferenceBinding[length];
                            System.arraycopy(referenceBindingArray, 0, result, 0, length);
                        }
                        result[j] = null;
                        ++removed;
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (removed == 0) {
            return result;
        }
        if (length == removed) {
            return null;
        }
        ReferenceBinding[] trimmedResult = new ReferenceBinding[length - removed];
        int i2 = 0;
        int index = 0;
        while (i2 < length) {
            ReferenceBinding iType = result[i2];
            if (iType != null) {
                trimmedResult[index++] = iType;
            }
            ++i2;
        }
        return trimmedResult;
    }

    public static TypeBinding[] greaterLowerBound(TypeBinding[] types) {
        if (types == null) {
            return null;
        }
        int length = types.length;
        if (length == 0) {
            return null;
        }
        TypeBinding[] result = types;
        int removed = 0;
        int i = 0;
        while (i < length) {
            TypeBinding iType = result[i];
            if (iType != null) {
                int j = 0;
                while (j < length) {
                    TypeBinding jType;
                    if (i != j && (jType = result[j]) != null && iType.isCompatibleWith(jType)) {
                        if (result == types) {
                            TypeBinding[] typeBindingArray = result;
                            result = new TypeBinding[length];
                            System.arraycopy(typeBindingArray, 0, result, 0, length);
                        }
                        result[j] = null;
                        ++removed;
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (removed == 0) {
            return result;
        }
        if (length == removed) {
            return null;
        }
        TypeBinding[] trimmedResult = new TypeBinding[length - removed];
        int i2 = 0;
        int index = 0;
        while (i2 < length) {
            TypeBinding iType = result[i2];
            if (iType != null) {
                trimmedResult[index++] = iType;
            }
            ++i2;
        }
        return trimmedResult;
    }

    public static ReferenceBinding[] substitute(Substitution substitution, ReferenceBinding[] originalTypes) {
        if (originalTypes == null) {
            return null;
        }
        ReferenceBinding[] substitutedTypes = originalTypes;
        int i = 0;
        int length = originalTypes.length;
        while (i < length) {
            ReferenceBinding originalType = originalTypes[i];
            ReferenceBinding substitutedParameter = (ReferenceBinding)Scope.substitute(substitution, originalType);
            if (substitutedParameter != originalType) {
                if (substitutedTypes == originalTypes) {
                    substitutedTypes = new ReferenceBinding[length];
                    System.arraycopy(originalTypes, 0, substitutedTypes, 0, i);
                }
                substitutedTypes[i] = substitutedParameter;
            } else if (substitutedTypes != originalTypes) {
                substitutedTypes[i] = originalType;
            }
            ++i;
        }
        return substitutedTypes;
    }

    public static TypeBinding substitute(Substitution substitution, TypeBinding originalType) {
        if (originalType == null) {
            return null;
        }
        switch (originalType.kind()) {
            case 4100: {
                return substitution.substitute((TypeVariableBinding)originalType);
            }
            case 260: {
                TypeBinding[] originalArguments;
                ReferenceBinding originalEnclosing;
                ParameterizedTypeBinding originalParameterizedType = (ParameterizedTypeBinding)originalType;
                ReferenceBinding substitutedEnclosing = originalEnclosing = originalType.enclosingType();
                if (originalEnclosing != null) {
                    substitutedEnclosing = (ReferenceBinding)Scope.substitute(substitution, originalEnclosing);
                }
                TypeBinding[] substitutedArguments = originalArguments = originalParameterizedType.arguments;
                if (originalArguments != null) {
                    if (substitution.isRawSubstitution()) {
                        return originalParameterizedType.environment.createRawType(originalParameterizedType.type, substitutedEnclosing);
                    }
                    substitutedArguments = Scope.substitute(substitution, originalArguments);
                }
                if (substitutedArguments == originalArguments && substitutedEnclosing == originalEnclosing) break;
                return originalParameterizedType.environment.createParameterizedType(originalParameterizedType.type, substitutedArguments, substitutedEnclosing);
            }
            case 68: {
                ArrayBinding originalArrayType = (ArrayBinding)originalType;
                TypeBinding originalLeafComponentType = originalArrayType.leafComponentType;
                TypeBinding substitute = Scope.substitute(substitution, originalLeafComponentType);
                if (substitute == originalLeafComponentType) break;
                return originalArrayType.environment.createArrayType(substitute.leafComponentType(), substitute.dimensions() + originalType.dimensions());
            }
            case 516: {
                WildcardBinding wildcard = (WildcardBinding)originalType;
                if (wildcard.boundKind == 0) break;
                TypeBinding originalBound = wildcard.bound;
                TypeBinding substitutedBound = Scope.substitute(substitution, originalBound);
                TypeBinding[] originalOtherBounds = wildcard.otherBounds;
                TypeBinding[] substitutedOtherBounds = Scope.substitute(substitution, originalOtherBounds);
                if (substitutedBound == originalBound && originalOtherBounds == substitutedOtherBounds) break;
                return wildcard.environment.createWildcard(wildcard.genericType, wildcard.rank, substitutedBound, substitutedOtherBounds, wildcard.boundKind);
            }
            case 4: {
                ReferenceBinding originalEnclosing;
                if (!originalType.isMemberType()) break;
                ReferenceBinding originalReferenceType = (ReferenceBinding)originalType;
                ReferenceBinding substitutedEnclosing = originalEnclosing = originalType.enclosingType();
                if (originalEnclosing != null) {
                    substitutedEnclosing = (ReferenceBinding)Scope.substitute(substitution, originalEnclosing);
                }
                if (substitutedEnclosing == originalEnclosing) break;
                return substitution.isRawSubstitution() ? substitution.environment().createRawType(originalReferenceType, substitutedEnclosing) : substitution.environment().createParameterizedType(originalReferenceType, null, substitutedEnclosing);
            }
            case 2052: {
                ReferenceBinding originalEnclosing;
                ReferenceBinding originalReferenceType = (ReferenceBinding)originalType;
                ReferenceBinding substitutedEnclosing = originalEnclosing = originalType.enclosingType();
                if (originalEnclosing != null) {
                    substitutedEnclosing = (ReferenceBinding)Scope.substitute(substitution, originalEnclosing);
                }
                if (substitution.isRawSubstitution()) {
                    return substitution.environment().createRawType(originalReferenceType, substitutedEnclosing);
                }
                TypeBinding[] originalArguments = originalReferenceType.typeVariables();
                TypeBinding[] substitutedArguments = Scope.substitute(substitution, originalArguments);
                return substitution.environment().createParameterizedType(originalReferenceType, substitutedArguments, substitutedEnclosing);
            }
        }
        return originalType;
    }

    public static TypeBinding[] substitute(Substitution substitution, TypeBinding[] originalTypes) {
        if (originalTypes == null) {
            return null;
        }
        TypeBinding[] substitutedTypes = originalTypes;
        int i = 0;
        int length = originalTypes.length;
        while (i < length) {
            TypeBinding originalType = originalTypes[i];
            TypeBinding substitutedParameter = Scope.substitute(substitution, originalType);
            if (substitutedParameter != originalType) {
                if (substitutedTypes == originalTypes) {
                    substitutedTypes = new TypeBinding[length];
                    System.arraycopy(originalTypes, 0, substitutedTypes, 0, i);
                }
                substitutedTypes[i] = substitutedParameter;
            } else if (substitutedTypes != originalTypes) {
                substitutedTypes[i] = originalType;
            }
            ++i;
        }
        return substitutedTypes;
    }

    protected Scope(int kind, Scope parent) {
        this.kind = kind;
        this.parent = parent;
    }

    public TypeBinding boxing(TypeBinding type) {
        if (type.isBaseType()) {
            return this.environment().computeBoxingType(type);
        }
        return type;
    }

    public final ClassScope classScope() {
        Scope scope = this;
        do {
            if (!(scope instanceof ClassScope)) continue;
            return (ClassScope)scope;
        } while ((scope = scope.parent) != null);
        return null;
    }

    public final CompilationUnitScope compilationUnitScope() {
        Scope lastScope = null;
        Scope scope = this;
        do {
            lastScope = scope;
        } while ((scope = scope.parent) != null);
        return (CompilationUnitScope)lastScope;
    }

    public final CompilerOptions compilerOptions() {
        return this.compilationUnitScope().environment.globalOptions;
    }

    protected final MethodBinding computeCompatibleMethod(MethodBinding method, TypeBinding[] arguments, InvocationSite invocationSite) {
        TypeBinding[] genericTypeArguments = invocationSite.genericTypeArguments();
        TypeBinding[] parameters = method.parameters;
        TypeVariableBinding[] typeVariables = method.typeVariables;
        if (parameters == arguments && (method.returnType.tagBits & 0x20000000L) == 0L && genericTypeArguments == null && typeVariables == Binding.NO_TYPE_VARIABLES) {
            return method;
        }
        int argLength = arguments.length;
        int paramLength = parameters.length;
        boolean isVarArgs = method.isVarargs();
        if (!(argLength == paramLength || isVarArgs && argLength >= paramLength - 1)) {
            return null;
        }
        if (typeVariables != Binding.NO_TYPE_VARIABLES) {
            TypeBinding[] newArgs = null;
            int i = 0;
            while (i < argLength) {
                TypeBinding param;
                TypeBinding typeBinding = param = i < paramLength ? parameters[i] : parameters[paramLength - 1];
                if (arguments[i].isBaseType() != param.isBaseType()) {
                    if (newArgs == null) {
                        newArgs = new TypeBinding[argLength];
                        System.arraycopy(arguments, 0, newArgs, 0, argLength);
                    }
                    newArgs[i] = this.environment().computeBoxingType(arguments[i]);
                }
                ++i;
            }
            if (newArgs != null) {
                arguments = newArgs;
            }
            if ((method = ParameterizedGenericMethodBinding.computeCompatibleMethod(method, arguments, this, invocationSite)) == null) {
                return null;
            }
            if (!method.isValidBinding()) {
                return method;
            }
            parameters = method.parameters;
        } else if (genericTypeArguments != null) {
            if (method instanceof ParameterizedGenericMethodBinding) {
                if (!((ParameterizedGenericMethodBinding)method).wasInferred) {
                    return new ProblemMethodBinding(method, method.selector, genericTypeArguments, 13);
                }
            } else {
                return new ProblemMethodBinding(method, method.selector, genericTypeArguments, 11);
            }
        }
        if (this.parameterCompatibilityLevel(method, arguments) > -1) {
            return method;
        }
        if (genericTypeArguments != null) {
            return new ProblemMethodBinding(method, method.selector, arguments, 12);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean connectTypeVariables(TypeParameter[] typeParameters, boolean checkForErasedCandidateCollisions) {
        if (typeParameters == null || this.compilerOptions().sourceLevel < 0x310000L) {
            return true;
        }
        noProblems = true;
        invocations = new HashMap<K, V>(2);
        i = 0;
        paramLength = typeParameters.length;
        while (i < paramLength) {
            block17: {
                block19: {
                    block18: {
                        typeParameter = typeParameters[i];
                        typeVariable = typeParameter.binding;
                        if (typeVariable == null) {
                            return false;
                        }
                        typeVariable.superclass = this.getJavaLangObject();
                        typeVariable.superInterfaces = Binding.NO_SUPERINTERFACES;
                        typeVariable.firstBound = null;
                        typeRef = typeParameter.type;
                        if (typeRef == null) break block17;
                        v0 = superType = this.kind == 2 ? typeRef.resolveType((BlockScope)this, false) : typeRef.resolveType((ClassScope)this);
                        if (superType != null) break block18;
                        typeVariable.tagBits |= 131072L;
                        noProblems = false;
                        break block17;
                    }
                    typeRef.resolvedType = superType;
                    if (!superType.isArrayType()) break block19;
                    this.problemReporter().boundCannotBeArray(typeRef, superType);
                    break block17;
                }
                isTypeVariableFirstBound = superType.isTypeVariable();
                if (!isTypeVariableFirstBound) ** GOTO lbl-1000
                varSuperType = (TypeVariableBinding)superType;
                if (varSuperType.rank >= typeVariable.rank && varSuperType.declaringElement == typeVariable.declaringElement) {
                    this.problemReporter().forwardTypeVariableReference(typeParameter, varSuperType);
                    typeVariable.tagBits |= 131072L;
                    noProblems = false;
                } else lbl-1000:
                // 2 sources

                {
                    if ((superRefType = (ReferenceBinding)superType).isFinal()) {
                        this.problemReporter().finalVariableBound(typeVariable, typeRef);
                    }
                    if (!superType.isInterface()) {
                        typeVariable.superclass = superRefType;
                    } else {
                        typeVariable.superInterfaces = new ReferenceBinding[]{superRefType};
                    }
                    typeVariable.firstBound = superRefType;
                    boundRefs = typeParameter.bounds;
                    if (boundRefs != null) {
                        j = 0;
                        boundLength = boundRefs.length;
                        block1: while (j < boundLength) {
                            typeRef = boundRefs[j];
                            v1 = superType = this.kind == 2 ? typeRef.resolveType((BlockScope)this, false) : typeRef.resolveType((ClassScope)this);
                            if (superType == null) {
                                typeVariable.tagBits |= 131072L;
                                noProblems = false;
                                break;
                            }
                            typeRef.resolvedType = superType;
                            if (isTypeVariableFirstBound && j == 0) {
                                this.problemReporter().noAdditionalBoundAfterTypeVariable(typeRef);
                            }
                            if (superType.isArrayType()) {
                                this.problemReporter().boundCannotBeArray(typeRef, superType);
                                break;
                            }
                            superRefType = (ReferenceBinding)superType;
                            if (!superType.isInterface()) {
                                this.problemReporter().boundMustBeAnInterface(typeRef, superType);
                                typeVariable.tagBits |= 131072L;
                                noProblems = false;
                                break;
                            }
                            if (checkForErasedCandidateCollisions && typeVariable.firstBound == typeVariable.superclass && this.hasErasedCandidatesCollisions(superType, typeVariable.superclass, invocations, typeVariable, typeRef)) {
                                noProblems = false;
                                break;
                            }
                            index = typeVariable.superInterfaces.length;
                            while (--index >= 0) {
                                previousInterface = typeVariable.superInterfaces[index];
                                if (previousInterface == superRefType) {
                                    this.problemReporter().duplicateBounds(typeRef, superType);
                                    typeVariable.tagBits |= 131072L;
                                    noProblems = false;
                                    break block1;
                                }
                                if (!checkForErasedCandidateCollisions || !this.hasErasedCandidatesCollisions(superType, previousInterface, invocations, typeVariable, typeRef)) continue;
                                noProblems = false;
                                break block1;
                            }
                            size = typeVariable.superInterfaces.length;
                            typeVariable.superInterfaces = new ReferenceBinding[size + 1];
                            System.arraycopy(typeVariable.superInterfaces, 0, typeVariable.superInterfaces, 0, size);
                            typeVariable.superInterfaces[size] = superRefType;
                            ++j;
                        }
                    }
                }
            }
            ++i;
        }
        return noProblems;
    }

    public ArrayBinding createArrayType(TypeBinding type, int dimension) {
        if (type.isValidBinding()) {
            return this.environment().createArrayType(type, dimension);
        }
        return new ArrayBinding(type, dimension, this.environment());
    }

    public TypeVariableBinding[] createTypeVariables(TypeParameter[] typeParameters, Binding declaringElement) {
        if (typeParameters == null || this.compilerOptions().sourceLevel < 0x310000L) {
            return Binding.NO_TYPE_VARIABLES;
        }
        TypeVariableBinding[] typeVariableBindings = Binding.NO_TYPE_VARIABLES;
        PackageBinding unitPackage = this.compilationUnitScope().fPackage;
        int length = typeParameters.length;
        typeVariableBindings = new TypeVariableBinding[length];
        int count = 0;
        int i = 0;
        while (i < length) {
            TypeParameter typeParameter = typeParameters[i];
            TypeVariableBinding parameterBinding = new TypeVariableBinding(typeParameter.name, declaringElement, i);
            parameterBinding.fPackage = unitPackage;
            typeParameter.binding = parameterBinding;
            int j = 0;
            while (j < count) {
                TypeVariableBinding knownVar = typeVariableBindings[j];
                if (CharOperation.equals(knownVar.sourceName, typeParameter.name)) {
                    this.problemReporter().duplicateTypeParameterInType(typeParameter);
                }
                ++j;
            }
            typeVariableBindings[count++] = parameterBinding;
            ++i;
        }
        if (count != length) {
            TypeVariableBinding[] typeVariableBindingArray = typeVariableBindings;
            typeVariableBindings = new TypeVariableBinding[count];
            System.arraycopy(typeVariableBindingArray, 0, typeVariableBindings, 0, count);
        }
        return typeVariableBindings;
    }

    public final ClassScope enclosingClassScope() {
        Scope scope = this;
        while ((scope = scope.parent) != null) {
            if (!(scope instanceof ClassScope)) continue;
            return (ClassScope)scope;
        }
        return null;
    }

    public final MethodScope enclosingMethodScope() {
        Scope scope = this;
        while ((scope = scope.parent) != null) {
            if (!(scope instanceof MethodScope)) continue;
            return (MethodScope)scope;
        }
        return null;
    }

    public final ReferenceBinding enclosingReceiverType() {
        Scope scope = this;
        do {
            if (!(scope instanceof ClassScope)) continue;
            return this.environment().convertToParameterizedType(((ClassScope)scope).referenceContext.binding);
        } while ((scope = scope.parent) != null);
        return null;
    }

    public ReferenceContext enclosingReferenceContext() {
        Scope current = this;
        while ((current = current.parent) != null) {
            switch (current.kind) {
                case 2: {
                    return ((MethodScope)current).referenceContext;
                }
                case 3: {
                    return ((ClassScope)current).referenceContext;
                }
                case 4: {
                    return ((CompilationUnitScope)current).referenceContext;
                }
            }
        }
        return null;
    }

    public final SourceTypeBinding enclosingSourceType() {
        Scope scope = this;
        do {
            if (!(scope instanceof ClassScope)) continue;
            return ((ClassScope)scope).referenceContext.binding;
        } while ((scope = scope.parent) != null);
        return null;
    }

    public final LookupEnvironment environment() {
        Scope scope;
        Scope unitScope = this;
        while ((scope = unitScope.parent) != null) {
            unitScope = scope;
        }
        return ((CompilationUnitScope)unitScope).environment;
    }

    protected MethodBinding findDefaultAbstractMethod(ReferenceBinding receiverType, char[] selector, TypeBinding[] argumentTypes, InvocationSite invocationSite, ReferenceBinding classHierarchyStart, ObjectVector found, MethodBinding concreteMatch) {
        int startFoundSize = found.size;
        ReferenceBinding currentType = classHierarchyStart;
        while (currentType != null) {
            this.findMethodInSuperInterfaces(currentType, selector, found);
            currentType = currentType.superclass();
        }
        MethodBinding[] candidates = null;
        int candidatesCount = 0;
        MethodBinding problemMethod = null;
        int foundSize = found.size;
        if (foundSize > startFoundSize) {
            int i = startFoundSize;
            while (i < foundSize) {
                MethodBinding methodBinding = (MethodBinding)found.elementAt(i);
                MethodBinding compatibleMethod = this.computeCompatibleMethod(methodBinding, argumentTypes, invocationSite);
                if (compatibleMethod != null) {
                    if (compatibleMethod.isValidBinding()) {
                        if (candidatesCount == 0) {
                            candidates = new MethodBinding[foundSize - startFoundSize + 1];
                            if (concreteMatch != null) {
                                candidates[candidatesCount++] = concreteMatch;
                            }
                        }
                        candidates[candidatesCount++] = compatibleMethod;
                    } else if (problemMethod == null) {
                        problemMethod = compatibleMethod;
                    }
                }
                ++i;
            }
        }
        if (candidatesCount < 2) {
            if (concreteMatch == null) {
                if (candidatesCount == 0) {
                    return problemMethod;
                }
                concreteMatch = candidates[0];
            }
            this.compilationUnitScope().recordTypeReferences(concreteMatch.thrownExceptions);
            return concreteMatch;
        }
        if (this.compilerOptions().complianceLevel >= 0x300000L) {
            return this.mostSpecificMethodBinding(candidates, candidatesCount, argumentTypes, invocationSite, receiverType);
        }
        return this.mostSpecificInterfaceMethodBinding(candidates, candidatesCount, invocationSite);
    }

    public ReferenceBinding findDirectMemberType(char[] typeName, ReferenceBinding enclosingType) {
        if ((enclosingType.tagBits & 0x10000L) != 0L) {
            return null;
        }
        ReferenceBinding enclosingReceiverType = this.enclosingReceiverType();
        CompilationUnitScope unitScope = this.compilationUnitScope();
        unitScope.recordReference(enclosingType, typeName);
        ReferenceBinding memberType = enclosingType.getMemberType(typeName);
        if (memberType != null) {
            unitScope.recordTypeReference(memberType);
            if (enclosingReceiverType == null ? memberType.canBeSeenBy(this.getCurrentPackage()) : memberType.canBeSeenBy(enclosingType, enclosingReceiverType)) {
                return memberType;
            }
            return new ProblemReferenceBinding(typeName, memberType, 2);
        }
        return null;
    }

    public MethodBinding findExactMethod(ReferenceBinding receiverType, char[] selector, TypeBinding[] argumentTypes, InvocationSite invocationSite) {
        CompilationUnitScope unitScope = this.compilationUnitScope();
        unitScope.recordTypeReferences(argumentTypes);
        MethodBinding exactMethod = receiverType.getExactMethod(selector, argumentTypes, unitScope);
        if (exactMethod != null && exactMethod.typeVariables == Binding.NO_TYPE_VARIABLES) {
            unitScope.recordTypeReferences(exactMethod.thrownExceptions);
            if (receiverType.isInterface() || exactMethod.canBeSeenBy(receiverType, invocationSite, this)) {
                if (receiverType.id != 1 && argumentTypes == Binding.NO_PARAMETERS && CharOperation.equals(selector, GETCLASS) && exactMethod.returnType.isParameterizedType()) {
                    return ParameterizedMethodBinding.instantiateGetClass(receiverType, exactMethod, this);
                }
                if (exactMethod.typeVariables != Binding.NO_TYPE_VARIABLES || invocationSite.genericTypeArguments() != null) {
                    MethodBinding compatibleMethod = this.computeCompatibleMethod(exactMethod, argumentTypes, invocationSite);
                    if (!compatibleMethod.isValidBinding() && exactMethod.typeVariables != Binding.NO_TYPE_VARIABLES) {
                        return null;
                    }
                    exactMethod = compatibleMethod;
                }
                return exactMethod;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public FieldBinding findField(TypeBinding receiverType, char[] fieldName, InvocationSite invocationSite, boolean needResolve) {
        CompilationUnitScope unitScope;
        block35: {
            TypeBinding leafType;
            unitScope = this.compilationUnitScope();
            unitScope.recordTypeReference(receiverType);
            switch (receiverType.kind()) {
                case 132: {
                    return null;
                }
                case 516: 
                case 4100: {
                    TypeBinding receiverErasure = receiverType.erasure();
                    if (receiverErasure.isArrayType()) {
                        leafType = receiverErasure.leafComponentType();
                        break;
                    }
                    break block35;
                }
                case 68: {
                    leafType = receiverType.leafComponentType();
                    break;
                }
                default: {
                    break block35;
                }
            }
            if (leafType instanceof ReferenceBinding && !((ReferenceBinding)leafType).canBeSeenBy(this)) {
                return new ProblemFieldBinding((ReferenceBinding)leafType, fieldName, 8);
            }
            if (!CharOperation.equals(fieldName, LENGTH)) return null;
            return ArrayBinding.ArrayLength;
        }
        ReferenceBinding currentType = (ReferenceBinding)receiverType;
        if (!currentType.canBeSeenBy(this)) {
            return new ProblemFieldBinding(currentType, fieldName, 8);
        }
        FieldBinding field = currentType.getField(fieldName, true);
        if (field != null) {
            if (invocationSite == null) {
                if (!field.canBeSeenBy(this.getCurrentPackage())) return new ProblemFieldBinding(field, field.declaringClass, fieldName, 2);
                return field;
            }
            if (!field.canBeSeenBy(currentType, invocationSite, this)) return new ProblemFieldBinding(field, field.declaringClass, fieldName, 2);
            return field;
        }
        ReferenceBinding[] interfacesToVisit = null;
        int nextPosition = 0;
        FieldBinding visibleField = null;
        boolean keepLooking = true;
        FieldBinding notVisibleField = null;
        while (keepLooking) {
            ReferenceBinding[] itsInterfaces = currentType.superInterfaces();
            if (itsInterfaces == null) {
                ((SourceTypeBinding)currentType).scope.connectTypeHierarchy();
                itsInterfaces = currentType.superInterfaces();
            }
            if (itsInterfaces != Binding.NO_SUPERINTERFACES) {
                if (interfacesToVisit == null) {
                    interfacesToVisit = itsInterfaces;
                    nextPosition = interfacesToVisit.length;
                } else {
                    int itsLength = itsInterfaces.length;
                    if (nextPosition + itsLength >= interfacesToVisit.length) {
                        ReferenceBinding[] referenceBindingArray = interfacesToVisit;
                        interfacesToVisit = new ReferenceBinding[nextPosition + itsLength + 5];
                        System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, nextPosition);
                    }
                    int a = 0;
                    while (a < itsLength) {
                        block32: {
                            ReferenceBinding next = itsInterfaces[a];
                            int b = 0;
                            while (b < nextPosition) {
                                if (next != interfacesToVisit[b]) {
                                    ++b;
                                    continue;
                                }
                                break block32;
                            }
                            interfacesToVisit[nextPosition++] = next;
                        }
                        ++a;
                    }
                }
            }
            if ((currentType = currentType.superclass()) == null) break;
            unitScope.recordTypeReference(currentType);
            field = currentType.getField(fieldName, needResolve);
            if (field == null) continue;
            keepLooking = false;
            if (field.canBeSeenBy(receiverType, invocationSite, this)) {
                if (visibleField != null) return new ProblemFieldBinding(visibleField, visibleField.declaringClass, fieldName, 3);
                visibleField = field;
                continue;
            }
            if (notVisibleField != null) continue;
            notVisibleField = field;
        }
        if (interfacesToVisit != null) {
            ProblemFieldBinding ambiguous = null;
            int i = 0;
            while (i < nextPosition) {
                block33: {
                    ReferenceBinding anInterface = interfacesToVisit[i];
                    unitScope.recordTypeReference(anInterface);
                    field = anInterface.getField(fieldName, true);
                    if (field != null) {
                        if (visibleField == null) {
                            visibleField = field;
                            break block33;
                        } else {
                            ambiguous = new ProblemFieldBinding(visibleField, visibleField.declaringClass, fieldName, 3);
                            break;
                        }
                    }
                    ReferenceBinding[] itsInterfaces = anInterface.superInterfaces();
                    if (itsInterfaces != Binding.NO_SUPERINTERFACES) {
                        int itsLength = itsInterfaces.length;
                        if (nextPosition + itsLength >= interfacesToVisit.length) {
                            ReferenceBinding[] referenceBindingArray = interfacesToVisit;
                            interfacesToVisit = new ReferenceBinding[nextPosition + itsLength + 5];
                            System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, nextPosition);
                        }
                        int a = 0;
                        while (a < itsLength) {
                            block34: {
                                ReferenceBinding next = itsInterfaces[a];
                                int b = 0;
                                while (b < nextPosition) {
                                    if (next != interfacesToVisit[b]) {
                                        ++b;
                                        continue;
                                    }
                                    break block34;
                                }
                                interfacesToVisit[nextPosition++] = next;
                            }
                            ++a;
                        }
                    }
                }
                ++i;
            }
            if (ambiguous != null) {
                return ambiguous;
            }
        }
        if (visibleField != null) {
            return visibleField;
        }
        if (notVisibleField == null) return null;
        return new ProblemFieldBinding(notVisibleField, currentType, fieldName, 2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public ReferenceBinding findMemberType(char[] typeName, ReferenceBinding enclosingType) {
        if ((enclosingType.tagBits & 0x10000L) != 0L) {
            return null;
        }
        if (enclosingType.isTypeVariable()) {
            return null;
        }
        SourceTypeBinding enclosingSourceType = this.enclosingSourceType();
        PackageBinding currentPackage = this.getCurrentPackage();
        CompilationUnitScope unitScope = this.compilationUnitScope();
        unitScope.recordReference(enclosingType, typeName);
        ReferenceBinding memberType = enclosingType.getMemberType(typeName);
        if (memberType != null) {
            unitScope.recordTypeReference(memberType);
            if (enclosingSourceType == null) {
                if (!memberType.canBeSeenBy(currentPackage)) return new ProblemReferenceBinding(typeName, memberType, 2);
                return memberType;
            }
            if (!memberType.canBeSeenBy(enclosingType, enclosingSourceType)) return new ProblemReferenceBinding(typeName, memberType, 2);
            return memberType;
        }
        ReferenceBinding currentType = enclosingType;
        ReferenceBinding[] interfacesToVisit = null;
        int nextPosition = 0;
        ReferenceBinding visibleMemberType = null;
        boolean keepLooking = true;
        ReferenceBinding notVisible = null;
        while (keepLooking) {
            ReferenceBinding[] itsInterfaces = currentType.superInterfaces();
            if (itsInterfaces == null) {
                if (currentType.isHierarchyBeingConnected()) {
                    return null;
                }
                ((SourceTypeBinding)currentType).scope.connectTypeHierarchy();
                itsInterfaces = currentType.superInterfaces();
            }
            if (itsInterfaces != Binding.NO_SUPERINTERFACES) {
                if (interfacesToVisit == null) {
                    interfacesToVisit = itsInterfaces;
                    nextPosition = interfacesToVisit.length;
                } else {
                    int itsLength = itsInterfaces.length;
                    if (nextPosition + itsLength >= interfacesToVisit.length) {
                        ReferenceBinding[] referenceBindingArray = interfacesToVisit;
                        interfacesToVisit = new ReferenceBinding[nextPosition + itsLength + 5];
                        System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, nextPosition);
                    }
                    int a = 0;
                    while (a < itsLength) {
                        block27: {
                            ReferenceBinding next = itsInterfaces[a];
                            int b = 0;
                            while (b < nextPosition) {
                                if (next != interfacesToVisit[b]) {
                                    ++b;
                                    continue;
                                }
                                break block27;
                            }
                            interfacesToVisit[nextPosition++] = next;
                        }
                        ++a;
                    }
                }
            }
            if ((currentType = currentType.superclass()) == null) break;
            unitScope.recordReference(currentType, typeName);
            memberType = currentType.getMemberType(typeName);
            if (memberType == null) continue;
            unitScope.recordTypeReference(memberType);
            keepLooking = false;
            if (enclosingSourceType == null ? memberType.canBeSeenBy(currentPackage) : memberType.canBeSeenBy(enclosingType, enclosingSourceType)) {
                if (visibleMemberType != null) return new ProblemReferenceBinding(typeName, null, 3);
                visibleMemberType = memberType;
                continue;
            }
            notVisible = memberType;
        }
        if (interfacesToVisit != null) {
            ProblemReferenceBinding ambiguous = null;
            int i = 0;
            while (i < nextPosition) {
                block28: {
                    ReferenceBinding anInterface = interfacesToVisit[i];
                    unitScope.recordReference(anInterface, typeName);
                    memberType = anInterface.getMemberType(typeName);
                    if (memberType != null) {
                        unitScope.recordTypeReference(memberType);
                        if (visibleMemberType == null) {
                            visibleMemberType = memberType;
                            break block28;
                        } else {
                            ambiguous = new ProblemReferenceBinding(typeName, null, 3);
                            break;
                        }
                    }
                    ReferenceBinding[] itsInterfaces = anInterface.superInterfaces();
                    if (itsInterfaces != Binding.NO_SUPERINTERFACES) {
                        int itsLength = itsInterfaces.length;
                        if (nextPosition + itsLength >= interfacesToVisit.length) {
                            ReferenceBinding[] referenceBindingArray = interfacesToVisit;
                            interfacesToVisit = new ReferenceBinding[nextPosition + itsLength + 5];
                            System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, nextPosition);
                        }
                        int a = 0;
                        while (a < itsLength) {
                            block29: {
                                ReferenceBinding next = itsInterfaces[a];
                                int b = 0;
                                while (b < nextPosition) {
                                    if (next != interfacesToVisit[b]) {
                                        ++b;
                                        continue;
                                    }
                                    break block29;
                                }
                                interfacesToVisit[nextPosition++] = next;
                            }
                            ++a;
                        }
                    }
                }
                ++i;
            }
            if (ambiguous != null) {
                return ambiguous;
            }
        }
        if (visibleMemberType != null) {
            return visibleMemberType;
        }
        if (notVisible == null) return null;
        return new ProblemReferenceBinding(typeName, notVisible, 2);
    }

    public MethodBinding findMethod(ReferenceBinding receiverType, char[] selector, TypeBinding[] argumentTypes, InvocationSite invocationSite) {
        int candidatesCount;
        MethodBinding[] candidates;
        ReferenceBinding classHierarchyStart;
        boolean isCompliant15;
        boolean isCompliant14;
        long complianceLevel;
        CompilationUnitScope unitScope;
        ObjectVector found;
        block50: {
            ReferenceBinding currentType = receiverType;
            found = new ObjectVector(3);
            unitScope = this.compilationUnitScope();
            unitScope.recordTypeReferences(argumentTypes);
            if (currentType.isInterface()) {
                unitScope.recordTypeReference(currentType);
                Object[] currentMethods = currentType.getMethods(selector);
                if (currentMethods.length > 0) {
                    found.addAll(currentMethods);
                }
                this.findMethodInSuperInterfaces(currentType, selector, found);
                currentType = this.getJavaLangObject();
            }
            isCompliant14 = (complianceLevel = this.compilerOptions().complianceLevel) >= 0x300000L;
            isCompliant15 = complianceLevel >= 0x310000L;
            classHierarchyStart = currentType;
            boolean mustBePublic = receiverType.isInterface();
            while (currentType != null) {
                unitScope.recordTypeReference(currentType);
                Object[] currentMethods = currentType.getMethods(selector);
                int currentLength = currentMethods.length;
                if (currentLength > 0) {
                    Object currentMethod;
                    int i;
                    if (isCompliant14 && (mustBePublic || found.size > 0)) {
                        i = 0;
                        int l = currentLength;
                        while (i < l) {
                            currentMethod = currentMethods[i];
                            if (currentMethod != null) {
                                if (mustBePublic && !((MethodBinding)currentMethod).isPublic()) {
                                    --currentLength;
                                    currentMethods[i] = null;
                                } else {
                                    int j = 0;
                                    int max = found.size;
                                    while (j < max) {
                                        MethodBinding matchingMethod = (MethodBinding)found.elementAt(j);
                                        if (((MethodBinding)currentMethod).areParametersEqual(matchingMethod)) {
                                            if (isCompliant15 && (matchingMethod.typeVariables != Binding.NO_TYPE_VARIABLES && invocationSite.genericTypeArguments() == null || matchingMethod.hasSubstitutedParameters() && !((MethodBinding)currentMethod).original().areParametersEqual(matchingMethod.original()))) break;
                                            --currentLength;
                                            currentMethods[i] = null;
                                            break;
                                        }
                                        ++j;
                                    }
                                }
                            }
                            ++i;
                        }
                    }
                    if (currentLength > 0) {
                        if (currentMethods.length == currentLength) {
                            found.addAll(currentMethods);
                        } else {
                            i = 0;
                            int max = currentMethods.length;
                            while (i < max) {
                                currentMethod = currentMethods[i];
                                if (currentMethod != null) {
                                    found.add(currentMethod);
                                }
                                ++i;
                            }
                        }
                    }
                }
                currentType = currentType.superclass();
            }
            int foundSize = found.size;
            candidates = null;
            candidatesCount = 0;
            MethodBinding problemMethod = null;
            if (foundSize > 0) {
                int i = 0;
                while (i < foundSize) {
                    MethodBinding methodBinding = (MethodBinding)found.elementAt(i);
                    MethodBinding compatibleMethod = this.computeCompatibleMethod(methodBinding, argumentTypes, invocationSite);
                    if (compatibleMethod != null) {
                        if (compatibleMethod.isValidBinding()) {
                            if (foundSize == 1 && compatibleMethod.canBeSeenBy(receiverType, invocationSite, this)) {
                                if (isCompliant14 && (receiverType.isAbstract() || receiverType.isTypeVariable())) {
                                    return this.findDefaultAbstractMethod(receiverType, selector, argumentTypes, invocationSite, classHierarchyStart, found, compatibleMethod);
                                }
                                unitScope.recordTypeReferences(compatibleMethod.thrownExceptions);
                                return compatibleMethod;
                            }
                            if (candidatesCount == 0) {
                                candidates = new MethodBinding[foundSize];
                            }
                            candidates[candidatesCount++] = compatibleMethod;
                        } else if (problemMethod == null) {
                            problemMethod = compatibleMethod;
                        }
                    }
                    ++i;
                }
            }
            if (candidatesCount != 0) break block50;
            MethodBinding interfaceMethod = this.findDefaultAbstractMethod(receiverType, selector, argumentTypes, invocationSite, classHierarchyStart, found, null);
            if (interfaceMethod != null) {
                return interfaceMethod;
            }
            if (found.size == 0) {
                return null;
            }
            if (problemMethod != null) {
                return problemMethod;
            }
            int bestArgMatches = -1;
            MethodBinding bestGuess = (MethodBinding)found.elementAt(0);
            int argLength = argumentTypes.length;
            foundSize = found.size;
            int i = 0;
            while (i < foundSize) {
                block51: {
                    int argMatches;
                    MethodBinding methodBinding;
                    block52: {
                        int diff2;
                        methodBinding = (MethodBinding)found.elementAt(i);
                        TypeBinding[] params = methodBinding.parameters;
                        int paramLength = params.length;
                        argMatches = 0;
                        int a = 0;
                        while (a < argLength) {
                            TypeBinding arg = argumentTypes[a];
                            int p = a == 0 ? 0 : a - 1;
                            while (p < paramLength && p < a + 1) {
                                if (params[p] == arg) {
                                    ++argMatches;
                                    break;
                                }
                                ++p;
                            }
                            ++a;
                        }
                        if (argMatches < bestArgMatches) break block51;
                        if (argMatches != bestArgMatches) break block52;
                        int diff1 = paramLength < argLength ? 2 * (argLength - paramLength) : paramLength - argLength;
                        int bestLength = bestGuess.parameters.length;
                        int n = diff2 = bestLength < argLength ? 2 * (argLength - bestLength) : bestLength - argLength;
                        if (diff1 >= diff2) break block51;
                    }
                    bestArgMatches = argMatches;
                    bestGuess = methodBinding;
                }
                ++i;
            }
            return new ProblemMethodBinding(bestGuess, bestGuess.selector, argumentTypes, 1);
        }
        int visiblesCount = 0;
        int i = 0;
        while (i < candidatesCount) {
            MethodBinding methodBinding = candidates[i];
            if (methodBinding.canBeSeenBy(receiverType, invocationSite, this)) {
                if (visiblesCount != i) {
                    candidates[i] = null;
                    candidates[visiblesCount] = methodBinding;
                }
                ++visiblesCount;
            }
            ++i;
        }
        if (visiblesCount == 1) {
            if (isCompliant14 && (receiverType.isAbstract() || receiverType.isTypeVariable())) {
                return this.findDefaultAbstractMethod(receiverType, selector, argumentTypes, invocationSite, classHierarchyStart, found, candidates[0]);
            }
            unitScope.recordTypeReferences(candidates[0].thrownExceptions);
            return candidates[0];
        }
        if (visiblesCount == 0) {
            MethodBinding interfaceMethod = this.findDefaultAbstractMethod(receiverType, selector, argumentTypes, invocationSite, classHierarchyStart, found, null);
            if (interfaceMethod != null) {
                return interfaceMethod;
            }
            return new ProblemMethodBinding(candidates[0], candidates[0].selector, candidates[0].parameters, 2);
        }
        if (complianceLevel <= 0x2F0000L) {
            ReferenceBinding declaringClass = candidates[0].declaringClass;
            return !declaringClass.isInterface() ? this.mostSpecificClassMethodBinding(candidates, visiblesCount, invocationSite) : this.mostSpecificInterfaceMethodBinding(candidates, visiblesCount, invocationSite);
        }
        if (this.compilerOptions().sourceLevel >= 0x310000L) {
            i = 0;
            while (i < visiblesCount) {
                MethodBinding current = candidates[i];
                if (current instanceof ParameterizedGenericMethodBinding) {
                    current = ((ParameterizedGenericMethodBinding)current).originalMethod;
                }
                if (current instanceof ParameterizedMethodBinding) {
                    int j = i + 1;
                    while (j < visiblesCount) {
                        if (current.declaringClass == candidates[j].declaringClass && current.areParametersEqual(candidates[j])) {
                            return new ProblemMethodBinding(candidates[i].selector, candidates[i].parameters, 3);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        MethodBinding mostSpecificMethod = this.mostSpecificMethodBinding(candidates, visiblesCount, argumentTypes, invocationSite, receiverType);
        if (isCompliant15 && mostSpecificMethod.isValidBinding() && this.parameterCompatibilityLevel(mostSpecificMethod, argumentTypes) > 0) {
            return this.findDefaultAbstractMethod(receiverType, selector, argumentTypes, invocationSite, classHierarchyStart, found, mostSpecificMethod);
        }
        return mostSpecificMethod;
    }

    public MethodBinding findMethodForArray(ArrayBinding receiverType, char[] selector, TypeBinding[] argumentTypes, InvocationSite invocationSite) {
        TypeBinding leafType = receiverType.leafComponentType();
        if (leafType instanceof ReferenceBinding && !((ReferenceBinding)leafType).canBeSeenBy(this)) {
            return new ProblemMethodBinding(selector, Binding.NO_PARAMETERS, (ReferenceBinding)leafType, 8);
        }
        ReferenceBinding object = this.getJavaLangObject();
        MethodBinding methodBinding = object.getExactMethod(selector, argumentTypes, null);
        if (methodBinding != null) {
            if (argumentTypes == Binding.NO_PARAMETERS) {
                switch (selector[0]) {
                    case 'c': {
                        if (!CharOperation.equals(selector, CLONE)) break;
                        return new UpdatedMethodBinding(this.compilerOptions().targetJDK >= 0x300000L ? receiverType : object, methodBinding.modifiers & 0xFFFFFFFB | 1, CLONE, methodBinding.returnType, argumentTypes, null, object);
                    }
                    case 'g': {
                        if (!CharOperation.equals(selector, GETCLASS) || !methodBinding.returnType.isParameterizedType()) break;
                        return ParameterizedMethodBinding.instantiateGetClass(receiverType, methodBinding, this);
                    }
                }
            }
            if (methodBinding.canBeSeenBy(receiverType, invocationSite, this)) {
                return methodBinding;
            }
        }
        if ((methodBinding = this.findMethod(object, selector, argumentTypes, invocationSite)) == null) {
            return new ProblemMethodBinding(selector, argumentTypes, 1);
        }
        return methodBinding;
    }

    protected void findMethodInSuperInterfaces(ReferenceBinding currentType, char[] selector, ObjectVector found) {
        ReferenceBinding[] itsInterfaces = currentType.superInterfaces();
        if (itsInterfaces != Binding.NO_SUPERINTERFACES) {
            ReferenceBinding[] interfacesToVisit = itsInterfaces;
            int nextPosition = interfacesToVisit.length;
            int i = 0;
            while (i < nextPosition) {
                currentType = interfacesToVisit[i];
                this.compilationUnitScope().recordTypeReference(currentType);
                Object[] currentMethods = currentType.getMethods(selector);
                if (currentMethods.length > 0) {
                    found.addAll(currentMethods);
                }
                if ((itsInterfaces = currentType.superInterfaces()) != Binding.NO_SUPERINTERFACES) {
                    int itsLength = itsInterfaces.length;
                    if (nextPosition + itsLength >= interfacesToVisit.length) {
                        ReferenceBinding[] referenceBindingArray = interfacesToVisit;
                        interfacesToVisit = new ReferenceBinding[nextPosition + itsLength + 5];
                        System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, nextPosition);
                    }
                    int a = 0;
                    while (a < itsLength) {
                        block8: {
                            ReferenceBinding next = itsInterfaces[a];
                            int b = 0;
                            while (b < nextPosition) {
                                if (next != interfacesToVisit[b]) {
                                    ++b;
                                    continue;
                                }
                                break block8;
                            }
                            interfacesToVisit[nextPosition++] = next;
                        }
                        ++a;
                    }
                }
                ++i;
            }
        }
    }

    public ReferenceBinding findType(char[] typeName, PackageBinding declarationPackage, PackageBinding invocationPackage) {
        this.compilationUnitScope().recordReference(declarationPackage.compoundName, typeName);
        ReferenceBinding typeBinding = declarationPackage.getType(typeName);
        if (typeBinding == null) {
            return null;
        }
        if (typeBinding.isValidBinding() && declarationPackage != invocationPackage && !typeBinding.canBeSeenBy(invocationPackage)) {
            return new ProblemReferenceBinding(typeName, typeBinding, 2);
        }
        return typeBinding;
    }

    public LocalVariableBinding findVariable(char[] variable) {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Binding getBinding(char[] name, int mask, InvocationSite invocationSite, boolean needResolve) {
        try {
            Binding binding = null;
            Binding problemField = null;
            if ((mask & 3) != 0) {
                boolean insideStaticContext = false;
                boolean insideConstructorCall = false;
                boolean insideTypeAnnotation = false;
                Binding foundField = null;
                ProblemFieldBinding foundInsideProblem = null;
                Scope scope = this;
                int depth = 0;
                int foundDepth = 0;
                ReferenceBinding foundActualReceiverType = null;
                block8: while (true) {
                    switch (scope.kind) {
                        case 2: {
                            MethodScope methodScope = (MethodScope)scope;
                            insideStaticContext |= methodScope.isStatic;
                            insideConstructorCall |= methodScope.isConstructorCall;
                            insideTypeAnnotation = methodScope.insideTypeAnnotation;
                        }
                        case 1: {
                            LocalVariableBinding variableBinding = scope.findVariable(name);
                            if (variableBinding == null) break;
                            if (foundField != null && foundField.isValidBinding()) {
                                return new ProblemFieldBinding((FieldBinding)foundField, ((FieldBinding)foundField).declaringClass, name, 5);
                            }
                            if (depth <= 0) return variableBinding;
                            invocationSite.setDepth(depth);
                            return variableBinding;
                        }
                        case 3: {
                            FieldBinding fieldBinding;
                            ClassScope classScope = (ClassScope)scope;
                            ReferenceBinding receiverType = classScope.enclosingReceiverType();
                            if (!insideTypeAnnotation && (fieldBinding = classScope.findField(receiverType, name, invocationSite, needResolve)) != null) {
                                if (fieldBinding.problemId() == 3) {
                                    if (foundField == null) return fieldBinding;
                                    if (foundField.problemId() != 2) return new ProblemFieldBinding((FieldBinding)foundField, ((FieldBinding)foundField).declaringClass, name, 5);
                                    return fieldBinding;
                                }
                                ProblemFieldBinding insideProblem = null;
                                if (fieldBinding.isValidBinding()) {
                                    if (!fieldBinding.isStatic()) {
                                        if (insideConstructorCall) {
                                            insideProblem = new ProblemFieldBinding(fieldBinding, fieldBinding.declaringClass, name, 6);
                                        } else if (insideStaticContext) {
                                            insideProblem = new ProblemFieldBinding(fieldBinding, fieldBinding.declaringClass, name, 7);
                                        }
                                    }
                                    if (receiverType == fieldBinding.declaringClass || this.compilerOptions().complianceLevel >= 0x300000L) {
                                        if (foundField == null) {
                                            FieldBinding fieldBinding2;
                                            if (depth > 0) {
                                                invocationSite.setDepth(depth);
                                                invocationSite.setActualReceiverType(receiverType);
                                            }
                                            if (insideProblem == null) {
                                                fieldBinding2 = fieldBinding;
                                                return fieldBinding2;
                                            }
                                            fieldBinding2 = insideProblem;
                                            return fieldBinding2;
                                        }
                                        if (foundField.isValidBinding() && ((FieldBinding)foundField).declaringClass != fieldBinding.declaringClass) {
                                            return new ProblemFieldBinding((FieldBinding)foundField, ((FieldBinding)foundField).declaringClass, name, 5);
                                        }
                                    }
                                }
                                if (foundField == null || foundField.problemId() == 2 && fieldBinding.problemId() != 2) {
                                    foundDepth = depth;
                                    foundActualReceiverType = receiverType;
                                    foundInsideProblem = insideProblem;
                                    foundField = fieldBinding;
                                }
                            }
                            insideTypeAnnotation = false;
                            ++depth;
                            insideStaticContext |= receiverType.isStatic();
                            MethodScope enclosingMethodScope = scope.methodScope();
                            insideConstructorCall = enclosingMethodScope == null ? false : enclosingMethodScope.isConstructorCall;
                            break;
                        }
                        case 4: {
                            break block8;
                        }
                    }
                    scope = scope.parent;
                }
                if (foundInsideProblem != null) {
                    return foundInsideProblem;
                }
                if (foundField != null) {
                    if (foundField.isValidBinding()) {
                        if (foundDepth <= 0) return foundField;
                        invocationSite.setDepth(foundDepth);
                        invocationSite.setActualReceiverType(foundActualReceiverType);
                        return foundField;
                    }
                    problemField = foundField;
                    foundField = null;
                }
                if (this.compilerOptions().sourceLevel >= 0x310000L) {
                    CompilationUnitScope unitScope = (CompilationUnitScope)scope;
                    ImportBinding[] imports = unitScope.imports;
                    if (imports != null) {
                        int i = 0;
                        int length = imports.length;
                        while (i < length) {
                            ImportBinding importBinding = imports[i];
                            if (importBinding.isStatic() && !importBinding.onDemand && CharOperation.equals(importBinding.compoundName[importBinding.compoundName.length - 1], name) && unitScope.resolveSingleImport(importBinding) != null && importBinding.resolvedImport instanceof FieldBinding) {
                                foundField = (FieldBinding)importBinding.resolvedImport;
                                ImportReference importReference = importBinding.reference;
                                if (importReference != null) {
                                    importReference.used = true;
                                }
                                invocationSite.setActualReceiverType(((FieldBinding)foundField).declaringClass);
                                if (foundField.isValidBinding()) {
                                    return foundField;
                                }
                                if (problemField == null) {
                                    problemField = foundField;
                                }
                            }
                            ++i;
                        }
                        boolean foundInImport = false;
                        int i2 = 0;
                        int length2 = imports.length;
                        while (i2 < length2) {
                            FieldBinding temp;
                            Binding resolvedImport;
                            ImportBinding importBinding = imports[i2];
                            if (importBinding.isStatic() && importBinding.onDemand && (resolvedImport = importBinding.resolvedImport) instanceof ReferenceBinding && (temp = this.findField((ReferenceBinding)resolvedImport, name, invocationSite, needResolve)) != null) {
                                if (!temp.isValidBinding()) {
                                    if (problemField == null) {
                                        problemField = temp;
                                    }
                                } else if (temp.isStatic() && foundField != temp) {
                                    ImportReference importReference = importBinding.reference;
                                    if (importReference != null) {
                                        importReference.used = true;
                                    }
                                    if (foundInImport) {
                                        return new ProblemReferenceBinding(name, null, 3);
                                    }
                                    foundField = temp;
                                    foundInImport = true;
                                }
                            }
                            ++i2;
                        }
                        if (foundField != null) {
                            invocationSite.setActualReceiverType(((FieldBinding)foundField).declaringClass);
                            return foundField;
                        }
                    }
                }
            }
            if ((mask & 4) != 0) {
                binding = Scope.getBaseType(name);
                if (binding != null) {
                    return binding;
                }
                binding = this.getTypeOrPackage(name, (mask & 0x10) == 0 ? 4 : 20);
                if (binding.isValidBinding()) return binding;
                if (mask == 4) {
                    return binding;
                }
            } else if ((mask & 0x10) != 0) {
                this.compilationUnitScope().recordSimpleReference(name);
                binding = this.environment().getTopLevelPackage(name);
                if (binding != null) {
                    return binding;
                }
            }
            if (problemField != null) {
                return problemField;
            }
            if (binding == null) return new ProblemBinding(name, (ReferenceBinding)this.enclosingSourceType(), 1);
            if (binding.problemId() == 1) return new ProblemBinding(name, (ReferenceBinding)this.enclosingSourceType(), 1);
            return binding;
        }
        catch (AbortCompilation e) {
            e.updateContext(invocationSite, this.referenceCompilationUnit().compilationResult);
            throw e;
        }
    }

    public MethodBinding getConstructor(ReferenceBinding receiverType, TypeBinding[] argumentTypes, InvocationSite invocationSite) {
        try {
            CompilationUnitScope unitScope = this.compilationUnitScope();
            unitScope.recordTypeReference(receiverType);
            unitScope.recordTypeReferences(argumentTypes);
            MethodBinding methodBinding = receiverType.getExactConstructor(argumentTypes);
            if (methodBinding != null && methodBinding.canBeSeenBy(invocationSite, this)) {
                if (invocationSite.genericTypeArguments() != null) {
                    methodBinding = this.computeCompatibleMethod(methodBinding, argumentTypes, invocationSite);
                }
                return methodBinding;
            }
            MethodBinding[] methods = receiverType.getMethods(TypeConstants.INIT);
            if (methods == Binding.NO_METHODS) {
                return new ProblemMethodBinding(TypeConstants.INIT, argumentTypes, 1);
            }
            MethodBinding[] compatible = new MethodBinding[methods.length];
            int compatibleIndex = 0;
            MethodBinding problemMethod = null;
            int i = 0;
            int length = methods.length;
            while (i < length) {
                MethodBinding compatibleMethod = this.computeCompatibleMethod(methods[i], argumentTypes, invocationSite);
                if (compatibleMethod != null) {
                    if (compatibleMethod.isValidBinding()) {
                        compatible[compatibleIndex++] = compatibleMethod;
                    } else if (problemMethod == null) {
                        problemMethod = compatibleMethod;
                    }
                }
                ++i;
            }
            if (compatibleIndex == 0) {
                if (problemMethod == null) {
                    return new ProblemMethodBinding(TypeConstants.INIT, argumentTypes, 1);
                }
                return problemMethod;
            }
            MethodBinding[] visible = new MethodBinding[compatibleIndex];
            int visibleIndex = 0;
            int i2 = 0;
            while (i2 < compatibleIndex) {
                MethodBinding method = compatible[i2];
                if (method.canBeSeenBy(invocationSite, this)) {
                    visible[visibleIndex++] = method;
                }
                ++i2;
            }
            if (visibleIndex == 1) {
                return visible[0];
            }
            if (visibleIndex == 0) {
                return new ProblemMethodBinding(compatible[0], TypeConstants.INIT, compatible[0].parameters, 2);
            }
            return this.mostSpecificMethodBinding(visible, visibleIndex, argumentTypes, invocationSite, receiverType);
        }
        catch (AbortCompilation e) {
            e.updateContext(invocationSite, this.referenceCompilationUnit().compilationResult);
            throw e;
        }
    }

    public final PackageBinding getCurrentPackage() {
        Scope scope;
        Scope unitScope = this;
        while ((scope = unitScope.parent) != null) {
            unitScope = scope;
        }
        return ((CompilationUnitScope)unitScope).fPackage;
    }

    public int getDeclarationModifiers() {
        switch (this.kind) {
            case 1: 
            case 2: {
                MethodScope methodScope = this.methodScope();
                if (!methodScope.isInsideInitializer()) {
                    MethodBinding context = ((AbstractMethodDeclaration)methodScope.referenceContext).binding;
                    if (context == null) break;
                    return context.modifiers;
                }
                SourceTypeBinding type = ((BlockScope)this).referenceType().binding;
                if (methodScope.initializedField != null) {
                    return methodScope.initializedField.modifiers;
                }
                if (type == null) break;
                return type.modifiers;
            }
            case 3: {
                SourceTypeBinding context = ((ClassScope)this).referenceType().binding;
                if (context == null) break;
                return context.modifiers;
            }
        }
        return -1;
    }

    public FieldBinding getField(TypeBinding receiverType, char[] fieldName, InvocationSite invocationSite) {
        try {
            FieldBinding field = this.findField(receiverType, fieldName, invocationSite, true);
            if (field != null) {
                return field;
            }
            return new ProblemFieldBinding(receiverType instanceof ReferenceBinding ? (ReferenceBinding)receiverType : null, fieldName, 1);
        }
        catch (AbortCompilation e) {
            e.updateContext(invocationSite, this.referenceCompilationUnit().compilationResult);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public MethodBinding getImplicitMethod(char[] selector, TypeBinding[] argumentTypes, InvocationSite invocationSite) {
        Binding foundFuzzyProblem;
        Binding foundMethod;
        block50: {
            boolean insideStaticContext = false;
            boolean insideConstructorCall = false;
            boolean insideTypeAnnotation = false;
            foundMethod = null;
            foundFuzzyProblem = null;
            ProblemMethodBinding foundInsideProblem = null;
            Scope scope = this;
            int depth = 0;
            block5: while (true) {
                switch (scope.kind) {
                    case 2: {
                        MethodScope methodScope = (MethodScope)scope;
                        insideStaticContext |= methodScope.isStatic;
                        insideConstructorCall |= methodScope.isConstructorCall;
                        insideTypeAnnotation = methodScope.insideTypeAnnotation;
                        break;
                    }
                    case 3: {
                        ClassScope classScope = (ClassScope)scope;
                        ReferenceBinding receiverType = classScope.enclosingReceiverType();
                        if (!insideTypeAnnotation) {
                            MethodBinding methodBinding;
                            MethodBinding methodBinding2 = methodBinding = foundMethod == null ? classScope.findExactMethod(receiverType, selector, argumentTypes, invocationSite) : classScope.findExactMethod(receiverType, ((MethodBinding)foundMethod).selector, ((MethodBinding)foundMethod).parameters, invocationSite);
                            if (methodBinding == null) {
                                methodBinding = classScope.findMethod(receiverType, selector, argumentTypes, invocationSite);
                            }
                            if (methodBinding != null) {
                                if (methodBinding.problemId() == 3) {
                                    if (foundMethod != null && foundMethod.problemId() != 2) {
                                        return new ProblemMethodBinding(methodBinding, selector, argumentTypes, 5);
                                    }
                                    return methodBinding;
                                }
                                MethodBinding fuzzyProblem = null;
                                ProblemMethodBinding insideProblem = null;
                                if (methodBinding.isValidBinding()) {
                                    if (!methodBinding.isStatic()) {
                                        if (insideConstructorCall) {
                                            insideProblem = new ProblemMethodBinding(methodBinding, methodBinding.selector, methodBinding.parameters, 6);
                                        } else if (insideStaticContext) {
                                            insideProblem = new ProblemMethodBinding(methodBinding, methodBinding.selector, methodBinding.parameters, 7);
                                        }
                                    }
                                    if (foundMethod == null && (receiverType == methodBinding.declaringClass || receiverType.getMethods(selector) != Binding.NO_METHODS || (foundFuzzyProblem == null || foundFuzzyProblem.problemId() != 2) && this.compilerOptions().complianceLevel >= 0x300000L)) {
                                        if (depth > 0) {
                                            invocationSite.setDepth(depth);
                                            invocationSite.setActualReceiverType(receiverType);
                                        }
                                        if (foundFuzzyProblem != null && foundFuzzyProblem.problemId() != 2) {
                                            return foundFuzzyProblem;
                                        }
                                        if (insideProblem != null) {
                                            return insideProblem;
                                        }
                                        return methodBinding;
                                    }
                                } else {
                                    fuzzyProblem = methodBinding;
                                }
                                if (foundMethod != null && ((MethodBinding)foundMethod).declaringClass != methodBinding.declaringClass && (receiverType == methodBinding.declaringClass || receiverType.getMethods(selector) != Binding.NO_METHODS)) {
                                    return new ProblemMethodBinding(methodBinding, methodBinding.selector, methodBinding.parameters, 5);
                                }
                                if (foundMethod == null || foundMethod.problemId() == 2 && methodBinding.problemId() != 2) {
                                    if (depth > 0) {
                                        invocationSite.setDepth(depth);
                                        invocationSite.setActualReceiverType(receiverType);
                                    }
                                    foundFuzzyProblem = fuzzyProblem;
                                    foundInsideProblem = insideProblem;
                                    if (fuzzyProblem == null) {
                                        foundMethod = methodBinding;
                                    }
                                }
                            }
                        }
                        insideTypeAnnotation = false;
                        ++depth;
                        insideStaticContext |= receiverType.isStatic();
                        MethodScope enclosingMethodScope = scope.methodScope();
                        insideConstructorCall = enclosingMethodScope == null ? false : enclosingMethodScope.isConstructorCall;
                        break;
                    }
                    case 4: {
                        break block5;
                    }
                }
                scope = scope.parent;
            }
            if (foundFuzzyProblem != null && foundFuzzyProblem.problemId() != 2 && foundFuzzyProblem.problemId() != 1) {
                return foundFuzzyProblem;
            }
            if (foundInsideProblem != null) {
                return foundInsideProblem;
            }
            if (!insideStaticContext || this.compilerOptions().sourceLevel < 0x310000L) break block50;
            if (foundFuzzyProblem != null && ((MethodBinding)foundFuzzyProblem).declaringClass != null && ((MethodBinding)foundFuzzyProblem).declaringClass.id == 1) {
                return foundFuzzyProblem;
            }
            CompilationUnitScope unitScope = (CompilationUnitScope)scope;
            ImportBinding[] imports = unitScope.imports;
            if (imports == null) break block50;
            ObjectVector visible = null;
            boolean skipOnDemand = false;
            int i = 0;
            int length = imports.length;
            while (i < length) {
                block51: {
                    Binding possible;
                    block53: {
                        MethodBinding compatibleMethod;
                        block54: {
                            ImportBinding importBinding;
                            block52: {
                                importBinding = imports[i];
                                if (!importBinding.isStatic()) break block51;
                                Binding resolvedImport = importBinding.resolvedImport;
                                possible = null;
                                if (importBinding.onDemand) {
                                    if (!skipOnDemand && resolvedImport instanceof ReferenceBinding) {
                                        possible = this.findMethod((ReferenceBinding)resolvedImport, selector, argumentTypes, invocationSite);
                                    }
                                } else if (resolvedImport instanceof MethodBinding) {
                                    MethodBinding staticMethod = (MethodBinding)resolvedImport;
                                    if (CharOperation.equals(staticMethod.selector, selector)) {
                                        possible = this.findMethod(staticMethod.declaringClass, selector, argumentTypes, invocationSite);
                                    }
                                } else if (resolvedImport instanceof FieldBinding) {
                                    char[][] importName;
                                    TypeBinding referencedType;
                                    FieldBinding staticField = (FieldBinding)resolvedImport;
                                    if (CharOperation.equals(staticField.name, selector) && (referencedType = this.getType(importName = importBinding.reference.tokens, importName.length - 1)) != null) {
                                        possible = this.findMethod((ReferenceBinding)referencedType, selector, argumentTypes, invocationSite);
                                    }
                                }
                                if (possible == null || possible == foundFuzzyProblem) break block51;
                                if (possible.isValidBinding()) break block52;
                                if (foundFuzzyProblem == null) {
                                    foundFuzzyProblem = possible;
                                }
                                break block51;
                            }
                            if (!((MethodBinding)possible).isStatic()) break block51;
                            compatibleMethod = this.computeCompatibleMethod((MethodBinding)possible, argumentTypes, invocationSite);
                            if (compatibleMethod == null) break block53;
                            if (!compatibleMethod.isValidBinding()) break block54;
                            if (compatibleMethod.canBeSeenBy(unitScope.fPackage)) {
                                if (visible == null || !visible.contains(compatibleMethod)) {
                                    ImportReference importReference = importBinding.reference;
                                    if (importReference != null) {
                                        importReference.used = true;
                                    }
                                    if (!skipOnDemand && !importBinding.onDemand) {
                                        visible = null;
                                        skipOnDemand = true;
                                    }
                                    if (visible == null) {
                                        visible = new ObjectVector(3);
                                    }
                                    visible.add(compatibleMethod);
                                }
                                break block51;
                            } else if (foundFuzzyProblem == null) {
                                foundFuzzyProblem = new ProblemMethodBinding(compatibleMethod, selector, compatibleMethod.parameters, 2);
                            }
                            break block51;
                        }
                        if (foundFuzzyProblem == null) {
                            foundFuzzyProblem = compatibleMethod;
                        }
                        break block51;
                    }
                    if (foundFuzzyProblem == null) {
                        foundFuzzyProblem = new ProblemMethodBinding((MethodBinding)possible, selector, argumentTypes, 1);
                    }
                }
                ++i;
            }
            if (visible != null) {
                Object[] temp = new MethodBinding[visible.size];
                visible.copyInto(temp);
                foundMethod = this.mostSpecificMethodBinding((MethodBinding[])temp, temp.length, argumentTypes, invocationSite, null);
            }
        }
        if (foundMethod != null) {
            invocationSite.setActualReceiverType(((MethodBinding)foundMethod).declaringClass);
            return foundMethod;
        }
        if (foundFuzzyProblem != null) {
            return foundFuzzyProblem;
        }
        return new ProblemMethodBinding(selector, argumentTypes, 1);
    }

    public final ReferenceBinding getJavaIoSerializable() {
        this.compilationUnitScope().recordQualifiedReference(JAVA_IO_SERIALIZABLE);
        return this.environment().getResolvedType(JAVA_IO_SERIALIZABLE, this);
    }

    public final ReferenceBinding getJavaLangAnnotationAnnotation() {
        this.compilationUnitScope().recordQualifiedReference(JAVA_LANG_ANNOTATION_ANNOTATION);
        return this.environment().getResolvedType(JAVA_LANG_ANNOTATION_ANNOTATION, this);
    }

    public final ReferenceBinding getJavaLangAssertionError() {
        this.compilationUnitScope().recordQualifiedReference(JAVA_LANG_ASSERTIONERROR);
        return this.environment().getResolvedType(JAVA_LANG_ASSERTIONERROR, this);
    }

    public final ReferenceBinding getJavaLangClass() {
        this.compilationUnitScope().recordQualifiedReference(JAVA_LANG_CLASS);
        return this.environment().getResolvedType(JAVA_LANG_CLASS, this);
    }

    public final ReferenceBinding getJavaLangCloneable() {
        this.compilationUnitScope().recordQualifiedReference(JAVA_LANG_CLONEABLE);
        return this.environment().getResolvedType(JAVA_LANG_CLONEABLE, this);
    }

    public final ReferenceBinding getJavaLangEnum() {
        this.compilationUnitScope().recordQualifiedReference(JAVA_LANG_ENUM);
        return this.environment().getResolvedType(JAVA_LANG_ENUM, this);
    }

    public final ReferenceBinding getJavaLangIterable() {
        this.compilationUnitScope().recordQualifiedReference(JAVA_LANG_ITERABLE);
        return this.environment().getResolvedType(JAVA_LANG_ITERABLE, this);
    }

    public final ReferenceBinding getJavaLangObject() {
        this.compilationUnitScope().recordQualifiedReference(JAVA_LANG_OBJECT);
        return this.environment().getResolvedType(JAVA_LANG_OBJECT, this);
    }

    public final ReferenceBinding getJavaLangString() {
        this.compilationUnitScope().recordQualifiedReference(JAVA_LANG_STRING);
        return this.environment().getResolvedType(JAVA_LANG_STRING, this);
    }

    public final ReferenceBinding getJavaLangThrowable() {
        this.compilationUnitScope().recordQualifiedReference(JAVA_LANG_THROWABLE);
        return this.environment().getResolvedType(JAVA_LANG_THROWABLE, this);
    }

    public final ReferenceBinding getJavaUtilIterator() {
        this.compilationUnitScope().recordQualifiedReference(JAVA_UTIL_ITERATOR);
        return this.environment().getResolvedType(JAVA_UTIL_ITERATOR, this);
    }

    public final ReferenceBinding getMemberType(char[] typeName, ReferenceBinding enclosingType) {
        ReferenceBinding memberType = this.findMemberType(typeName, enclosingType);
        if (memberType != null) {
            return memberType;
        }
        return new ProblemReferenceBinding(typeName, null, 1);
    }

    public MethodBinding getMethod(TypeBinding receiverType, char[] selector, TypeBinding[] argumentTypes, InvocationSite invocationSite) {
        try {
            switch (receiverType.kind()) {
                case 132: {
                    return new ProblemMethodBinding(selector, argumentTypes, 1);
                }
                case 68: {
                    this.compilationUnitScope().recordTypeReference(receiverType);
                    return this.findMethodForArray((ArrayBinding)receiverType, selector, argumentTypes, invocationSite);
                }
            }
            this.compilationUnitScope().recordTypeReference(receiverType);
            ReferenceBinding currentType = (ReferenceBinding)receiverType;
            if (!currentType.canBeSeenBy(this)) {
                return new ProblemMethodBinding(selector, argumentTypes, 8);
            }
            MethodBinding methodBinding = this.findExactMethod(currentType, selector, argumentTypes, invocationSite);
            if (methodBinding != null) {
                return methodBinding;
            }
            methodBinding = this.findMethod(currentType, selector, argumentTypes, invocationSite);
            if (methodBinding == null) {
                return new ProblemMethodBinding(selector, argumentTypes, 1);
            }
            if (!methodBinding.isValidBinding()) {
                return methodBinding;
            }
            if (receiverType.id != 1 && argumentTypes == Binding.NO_PARAMETERS && CharOperation.equals(selector, GETCLASS) && methodBinding.returnType.isParameterizedType()) {
                return ParameterizedMethodBinding.instantiateGetClass(receiverType, methodBinding, this);
            }
            return methodBinding;
        }
        catch (AbortCompilation e) {
            e.updateContext(invocationSite, this.referenceCompilationUnit().compilationResult);
            throw e;
        }
    }

    public final Binding getPackage(char[][] compoundName) {
        this.compilationUnitScope().recordQualifiedReference(compoundName);
        Binding binding = this.getTypeOrPackage(compoundName[0], 20);
        if (binding == null) {
            return new ProblemReferenceBinding(compoundName[0], null, 1);
        }
        if (!binding.isValidBinding()) {
            return binding;
        }
        if (!(binding instanceof PackageBinding)) {
            return null;
        }
        int currentIndex = 1;
        PackageBinding packageBinding = (PackageBinding)binding;
        while (currentIndex < compoundName.length) {
            if ((binding = packageBinding.getTypeOrPackage(compoundName[currentIndex++])) == null) {
                return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), null, 1);
            }
            if (!binding.isValidBinding()) {
                return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), null, binding.problemId());
            }
            if (!(binding instanceof PackageBinding)) {
                return packageBinding;
            }
            packageBinding = (PackageBinding)binding;
        }
        return new ProblemReferenceBinding(compoundName, null, 1);
    }

    public final TypeBinding getType(char[] name) {
        TypeBinding binding = Scope.getBaseType(name);
        if (binding != null) {
            return binding;
        }
        return (ReferenceBinding)this.getTypeOrPackage(name, 4);
    }

    public final TypeBinding getType(char[] name, PackageBinding packageBinding) {
        if (packageBinding == null) {
            return this.getType(name);
        }
        Binding binding = packageBinding.getTypeOrPackage(name);
        if (binding == null) {
            return new ProblemReferenceBinding(CharOperation.arrayConcat(packageBinding.compoundName, name), null, 1);
        }
        if (!binding.isValidBinding()) {
            return new ProblemReferenceBinding(CharOperation.arrayConcat(packageBinding.compoundName, name), null, binding.problemId());
        }
        ReferenceBinding typeBinding = (ReferenceBinding)binding;
        if (!typeBinding.canBeSeenBy(this)) {
            return new ProblemReferenceBinding(CharOperation.arrayConcat(packageBinding.compoundName, name), typeBinding, 2);
        }
        return typeBinding;
    }

    /*
     * Unable to fully structure code
     */
    public final TypeBinding getType(char[][] compoundName, int typeNameLength) {
        if (typeNameLength == 1 && (binding = Scope.getBaseType(compoundName[0])) != null) {
            return binding;
        }
        unitScope = this.compilationUnitScope();
        unitScope.recordQualifiedReference(compoundName);
        binding = this.getTypeOrPackage(compoundName[0], typeNameLength == 1 ? 4 : 20);
        if (binding == null) {
            return new ProblemReferenceBinding(compoundName[0], null, 1);
        }
        if (!binding.isValidBinding()) {
            return (ReferenceBinding)binding;
        }
        currentIndex = 1;
        checkVisibility = false;
        if (binding instanceof PackageBinding) {
            packageBinding = (PackageBinding)binding;
            while (currentIndex < typeNameLength) {
                if ((binding = packageBinding.getTypeOrPackage(compoundName[currentIndex++])) == null) {
                    return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), null, 1);
                }
                if (!binding.isValidBinding()) {
                    return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), null, binding.problemId());
                }
                if (!(binding instanceof PackageBinding)) break;
                packageBinding = (PackageBinding)binding;
            }
            if (binding instanceof PackageBinding) {
                return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), null, 1);
            }
            checkVisibility = true;
        }
        typeBinding = (ReferenceBinding)binding;
        unitScope.recordTypeReference(typeBinding);
        if (!checkVisibility || typeBinding.canBeSeenBy(this)) ** GOTO lbl34
        return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), typeBinding, 2);
lbl-1000:
        // 1 sources

        {
            if ((typeBinding = this.getMemberType(compoundName[currentIndex++], typeBinding)).isValidBinding()) continue;
            if (typeBinding instanceof ProblemReferenceBinding) {
                problemBinding = (ProblemReferenceBinding)typeBinding;
                return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), problemBinding.closestMatch, typeBinding.problemId());
            }
            return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), null, typeBinding.problemId());
lbl34:
            // 2 sources

            ** while (currentIndex < typeNameLength)
        }
lbl35:
        // 1 sources

        return typeBinding;
    }

    /*
     * Enabled aggressive block sorting
     */
    final Binding getTypeOrPackage(char[] name, int mask) {
        PackageBinding packageBinding;
        Binding binding;
        Scope scope = this;
        Binding foundType = null;
        boolean insideStaticContext = false;
        boolean insideTypeAnnotation = false;
        if ((mask & 4) == 0) {
            Scope next = scope;
            while ((next = scope.parent) != null) {
                scope = next;
            }
        } else {
            block7: while (true) {
                switch (scope.kind) {
                    case 2: {
                        TypeVariableBinding typeVariable;
                        MethodScope methodScope = (MethodScope)scope;
                        AbstractMethodDeclaration methodDecl = methodScope.referenceMethod();
                        if (methodDecl != null && methodDecl.binding != null && (typeVariable = methodDecl.binding.getTypeVariable(name)) != null) {
                            return typeVariable;
                        }
                        insideStaticContext |= methodScope.isStatic;
                        insideTypeAnnotation = methodScope.insideTypeAnnotation;
                    }
                    case 1: {
                        ReferenceBinding localType = ((BlockScope)scope).findLocalType(name);
                        if (localType == null) break;
                        if (foundType != null && foundType != localType) {
                            return new ProblemReferenceBinding(name, (ReferenceBinding)foundType, 5);
                        }
                        return localType;
                    }
                    case 3: {
                        ReferenceBinding memberType;
                        TypeVariableBinding typeVariable;
                        SourceTypeBinding sourceType = ((ClassScope)scope).referenceContext.binding;
                        if (scope == this && (sourceType.tagBits & 0x40000L) == 0L) {
                            typeVariable = sourceType.getTypeVariable(name);
                            if (typeVariable != null) {
                                return typeVariable;
                            }
                            if (CharOperation.equals(name, sourceType.sourceName)) {
                                return sourceType;
                            }
                            insideStaticContext |= sourceType.isStatic();
                            break;
                        }
                        typeVariable = sourceType.getTypeVariable(name);
                        if (typeVariable != null) {
                            if (insideStaticContext) {
                                return new ProblemReferenceBinding(name, (ReferenceBinding)typeVariable, 7);
                            }
                            return typeVariable;
                        }
                        if (!insideTypeAnnotation && (memberType = this.findMemberType(name, sourceType)) != null) {
                            if (memberType.problemId() == 3) {
                                if (foundType != null && foundType.problemId() != 2) {
                                    return new ProblemReferenceBinding(name, (ReferenceBinding)foundType, 5);
                                }
                                return memberType;
                            }
                            if (memberType.isValidBinding() && (sourceType == memberType.enclosingType() || this.compilerOptions().complianceLevel >= 0x300000L)) {
                                if (insideStaticContext && !memberType.isStatic() && sourceType.isGenericType()) {
                                    return new ProblemReferenceBinding(name, memberType, 7);
                                }
                                if (foundType == null) {
                                    return memberType;
                                }
                                if (foundType.isValidBinding() && foundType != memberType) {
                                    return new ProblemReferenceBinding(name, (ReferenceBinding)foundType, 5);
                                }
                            }
                            if (foundType == null || foundType.problemId() == 2 && memberType.problemId() != 2) {
                                foundType = memberType;
                            }
                        }
                        insideTypeAnnotation = false;
                        insideStaticContext |= sourceType.isStatic();
                        if (!CharOperation.equals(sourceType.sourceName, name)) break;
                        if (foundType != null && foundType != sourceType && foundType.problemId() != 2) {
                            return new ProblemReferenceBinding(name, (ReferenceBinding)foundType, 5);
                        }
                        return sourceType;
                    }
                    case 4: {
                        break block7;
                    }
                }
                scope = scope.parent;
            }
            if (foundType != null && foundType.problemId() != 2) {
                return foundType;
            }
        }
        CompilationUnitScope unitScope = (CompilationUnitScope)scope;
        HashtableOfObject typeOrPackageCache = unitScope.typeOrPackageCache;
        if (typeOrPackageCache != null && (binding = (Binding)typeOrPackageCache.get(name)) != null) {
            if (binding instanceof ImportBinding) {
                ImportReference importReference = ((ImportBinding)binding).reference;
                if (importReference != null) {
                    importReference.used = true;
                }
                if (binding instanceof ImportConflictBinding) {
                    binding = ((ImportConflictBinding)binding).conflictingTypeBinding;
                    typeOrPackageCache.put(name, binding);
                } else {
                    binding = ((ImportBinding)binding).resolvedImport;
                    typeOrPackageCache.put(name, binding);
                }
            }
            if ((mask & 4) != 0) {
                if (foundType != null && foundType.problemId() != 2 && binding.problemId() != 3) {
                    return foundType;
                }
                if (binding instanceof ReferenceBinding) {
                    return binding;
                }
            }
            if ((mask & 0x10) != 0 && binding instanceof PackageBinding) {
                return binding;
            }
        }
        if ((mask & 4) != 0) {
            ImportBinding[] imports = unitScope.imports;
            if (imports != null && typeOrPackageCache == null) {
                int i = 0;
                int length = imports.length;
                while (i < length) {
                    Binding resolvedImport;
                    ImportBinding importBinding = imports[i];
                    if (!importBinding.onDemand && CharOperation.equals(importBinding.compoundName[importBinding.compoundName.length - 1], name) && (resolvedImport = unitScope.resolveSingleImport(importBinding)) != null && (!(resolvedImport instanceof MethodBinding) || (resolvedImport = this.getType(importBinding.compoundName, importBinding.compoundName.length)).isValidBinding()) && resolvedImport instanceof TypeBinding) {
                        ImportReference importReference = importBinding.reference;
                        if (importReference != null) {
                            importReference.used = true;
                        }
                        return resolvedImport;
                    }
                    ++i;
                }
            }
            PackageBinding currentPackage = unitScope.fPackage;
            unitScope.recordReference(currentPackage.compoundName, name);
            Binding binding2 = currentPackage.getTypeOrPackage(name);
            if (binding2 instanceof ReferenceBinding) {
                if (typeOrPackageCache != null) {
                    typeOrPackageCache.put(name, binding2);
                }
                return binding2;
            }
            if (imports != null) {
                boolean foundInImport = false;
                ReferenceBinding type = null;
                int i = 0;
                int length = imports.length;
                while (i < length) {
                    ImportBinding someImport = imports[i];
                    if (someImport.onDemand) {
                        Binding resolvedImport = someImport.resolvedImport;
                        ReferenceBinding temp = null;
                        if (resolvedImport instanceof PackageBinding) {
                            temp = this.findType(name, (PackageBinding)resolvedImport, currentPackage);
                        } else if (someImport.isStatic()) {
                            temp = this.findMemberType(name, (ReferenceBinding)resolvedImport);
                            if (temp != null && !temp.isStatic()) {
                                temp = null;
                            }
                        } else {
                            temp = this.findDirectMemberType(name, (ReferenceBinding)resolvedImport);
                        }
                        if (temp != type && temp != null) {
                            if (temp.isValidBinding()) {
                                ImportReference importReference = someImport.reference;
                                if (importReference != null) {
                                    importReference.used = true;
                                }
                                if (foundInImport) {
                                    temp = new ProblemReferenceBinding(name, null, 3);
                                    if (typeOrPackageCache != null) {
                                        typeOrPackageCache.put(name, temp);
                                    }
                                    return temp;
                                }
                                type = temp;
                                foundInImport = true;
                            } else if (foundType == null) {
                                foundType = temp;
                            }
                        }
                    }
                    ++i;
                }
                if (type != null) {
                    if (typeOrPackageCache != null) {
                        typeOrPackageCache.put(name, type);
                    }
                    return type;
                }
            }
        }
        unitScope.recordSimpleReference(name);
        if ((mask & 0x10) != 0 && (packageBinding = unitScope.environment.getTopLevelPackage(name)) != null) {
            if (typeOrPackageCache != null) {
                typeOrPackageCache.put(name, packageBinding);
            }
            return packageBinding;
        }
        if (foundType == null) {
            foundType = new ProblemReferenceBinding(name, null, 1);
            if (typeOrPackageCache != null && (mask & 0x10) != 0) {
                typeOrPackageCache.put(name, foundType);
            }
        }
        return foundType;
    }

    /*
     * Unable to fully structure code
     */
    public final Binding getTypeOrPackage(char[][] compoundName) {
        nameLength = compoundName.length;
        if (nameLength == 1 && (binding = Scope.getBaseType(compoundName[0])) != null) {
            return binding;
        }
        binding = this.getTypeOrPackage(compoundName[0], 20);
        if (!binding.isValidBinding()) {
            return binding;
        }
        currentIndex = 1;
        checkVisibility = false;
        if (binding instanceof PackageBinding) {
            packageBinding = (PackageBinding)binding;
            while (currentIndex < nameLength) {
                if ((binding = packageBinding.getTypeOrPackage(compoundName[currentIndex++])) == null) {
                    return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), null, 1);
                }
                if (!binding.isValidBinding()) {
                    return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), null, binding.problemId());
                }
                if (!(binding instanceof PackageBinding)) break;
                packageBinding = (PackageBinding)binding;
            }
            if (binding instanceof PackageBinding) {
                return binding;
            }
            checkVisibility = true;
        }
        typeBinding = (ReferenceBinding)binding;
        qualifiedType = (ReferenceBinding)this.environment().convertToRawType(typeBinding);
        if (!checkVisibility || typeBinding.canBeSeenBy(this)) ** GOTO lbl32
        return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), typeBinding, 2);
lbl-1000:
        // 1 sources

        {
            if (!(typeBinding = this.getMemberType(compoundName[currentIndex++], typeBinding)).isValidBinding()) {
                return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), null, typeBinding.problemId());
            }
            if (typeBinding.isGenericType()) {
                qualifiedType = this.environment().createRawType(typeBinding, qualifiedType);
                continue;
            }
            v0 = qualifiedType = qualifiedType != null && (qualifiedType.isRawType() != false || qualifiedType.isParameterizedType() != false) ? this.environment().createParameterizedType(typeBinding, null, qualifiedType) : typeBinding;
lbl32:
            // 3 sources

            ** while (currentIndex < nameLength)
        }
lbl33:
        // 1 sources

        return qualifiedType;
    }

    protected boolean hasErasedCandidatesCollisions(TypeBinding one, TypeBinding two, Map invocations, ReferenceBinding type, ASTNode typeRef) {
        invocations.clear();
        TypeBinding[] mecs = this.minimalErasedCandidates(new TypeBinding[]{one, two}, invocations);
        if (mecs != null) {
            int k = 0;
            int max = mecs.length;
            while (k < max) {
                Set invalidInvocations;
                int invalidSize;
                TypeBinding mec = mecs[k];
                if (mec != null && (invalidSize = (invalidInvocations = (Set)invocations.get(mec)).size()) > 1) {
                    TypeBinding[] collisions = new TypeBinding[invalidSize];
                    invalidInvocations.toArray(collisions);
                    this.problemReporter().superinterfacesCollide(collisions[0].erasure(), typeRef, collisions[0], collisions[1]);
                    type.tagBits |= 0x20000L;
                    return true;
                }
                ++k;
            }
        }
        return false;
    }

    public CaseStatement innermostSwitchCase() {
        Scope scope = this;
        do {
            if (!(scope instanceof BlockScope)) continue;
            return ((BlockScope)scope).enclosingCase;
        } while ((scope = scope.parent) != null);
        return null;
    }

    protected boolean isAcceptableMethod(MethodBinding one, MethodBinding two) {
        TypeBinding[] oneParams = one.parameters;
        int oneParamsLength = oneParams.length;
        TypeBinding[] twoParams = two.parameters;
        int twoParamsLength = twoParams.length;
        if (oneParamsLength == twoParamsLength) {
            int i = 0;
            while (i < oneParamsLength) {
                TypeBinding oneParam = oneParams[i];
                TypeBinding twoParam = twoParams[i];
                if (oneParam != twoParam) {
                    TypeBinding match;
                    if (oneParam.isRawType() && (match = oneParam.findSuperTypeWithSameErasure(twoParam)) != twoParam) {
                        return false;
                    }
                    if (!oneParam.isCompatibleWith(twoParam)) {
                        TypeBinding eType;
                        return i == oneParamsLength - 1 && one.isVarargs() && two.isVarargs() && (oneParam == (eType = ((ArrayBinding)twoParam).elementsType()) || oneParam.isCompatibleWith(eType));
                    }
                }
                ++i;
            }
            return true;
        }
        if (one.isVarargs() && two.isVarargs()) {
            if (oneParamsLength > twoParamsLength && ((ArrayBinding)twoParams[twoParamsLength - 1]).elementsType().id != 1) {
                return false;
            }
            int i = (oneParamsLength > twoParamsLength ? twoParamsLength : oneParamsLength) - 2;
            while (i >= 0) {
                if (oneParams[i] != twoParams[i] && !oneParams[i].isCompatibleWith(twoParams[i])) {
                    return false;
                }
                --i;
            }
            if (this.parameterCompatibilityLevel(one, twoParams) == -1 && this.parameterCompatibilityLevel(two, oneParams) == 2) {
                return true;
            }
        }
        return false;
    }

    public boolean isBoxingCompatibleWith(TypeBinding expressionType, TypeBinding targetType) {
        LookupEnvironment environment = this.environment();
        if (environment.globalOptions.sourceLevel < 0x310000L || expressionType.isBaseType() == targetType.isBaseType()) {
            return false;
        }
        TypeBinding convertedType = environment.computeBoxingType(expressionType);
        return convertedType == targetType || convertedType.isCompatibleWith(targetType);
    }

    public final boolean isDefinedInField(FieldBinding field) {
        Scope scope = this;
        do {
            if (!(scope instanceof MethodScope)) continue;
            MethodScope methodScope = (MethodScope)scope;
            if (methodScope.initializedField != field) continue;
            return true;
        } while ((scope = scope.parent) != null);
        return false;
    }

    public final boolean isDefinedInMethod(MethodBinding method) {
        Scope scope = this;
        do {
            ReferenceContext refContext;
            if (!(scope instanceof MethodScope) || !((refContext = ((MethodScope)scope).referenceContext) instanceof AbstractMethodDeclaration) || ((AbstractMethodDeclaration)refContext).binding != method) continue;
            return true;
        } while ((scope = scope.parent) != null);
        return false;
    }

    public final boolean isDefinedInSameUnit(ReferenceBinding type) {
        Scope scope;
        ReferenceBinding enclosingType = type;
        while ((type = enclosingType.enclosingType()) != null) {
            enclosingType = type;
        }
        Scope unitScope = this;
        while ((scope = unitScope.parent) != null) {
            unitScope = scope;
        }
        SourceTypeBinding[] topLevelTypes = ((CompilationUnitScope)unitScope).topLevelTypes;
        int i = topLevelTypes.length;
        while (--i >= 0) {
            if (topLevelTypes[i] != enclosingType) continue;
            return true;
        }
        return false;
    }

    public final boolean isDefinedInType(ReferenceBinding type) {
        Scope scope = this;
        do {
            if (!(scope instanceof ClassScope) || ((ClassScope)scope).referenceContext.binding != type) continue;
            return true;
        } while ((scope = scope.parent) != null);
        return false;
    }

    public boolean isInsideCase(CaseStatement caseStatement) {
        Scope scope = this;
        do {
            switch (scope.kind) {
                case 1: {
                    if (((BlockScope)scope).enclosingCase != caseStatement) break;
                    return true;
                }
            }
        } while ((scope = scope.parent) != null);
        return false;
    }

    public boolean isInsideDeprecatedCode() {
        switch (this.kind) {
            case 1: 
            case 2: {
                MethodScope methodScope = this.methodScope();
                if (!methodScope.isInsideInitializer()) {
                    MethodBinding context = ((AbstractMethodDeclaration)methodScope.referenceContext).binding;
                    if (context == null || !context.isViewedAsDeprecated()) break;
                    return true;
                }
                SourceTypeBinding type = ((BlockScope)this).referenceType().binding;
                if (methodScope.initializedField != null && methodScope.initializedField.isViewedAsDeprecated()) {
                    return true;
                }
                if (type == null) break;
                type.initializeDeprecatedAnnotationTagBits();
                if (!type.isViewedAsDeprecated()) break;
                return true;
            }
            case 3: {
                SourceTypeBinding context = ((ClassScope)this).referenceType().binding;
                if (context == null) break;
                ((Binding)context).initializeDeprecatedAnnotationTagBits();
                if (!context.isViewedAsDeprecated()) break;
                return true;
            }
            case 4: {
                SourceTypeBinding type;
                CompilationUnitDeclaration unit = this.referenceCompilationUnit();
                if (unit.types == null || unit.types.length <= 0 || (type = unit.types[0].binding) == null) break;
                type.initializeDeprecatedAnnotationTagBits();
                if (!type.isViewedAsDeprecated()) break;
                return true;
            }
        }
        return false;
    }

    private TypeBinding leastContainingInvocation(TypeBinding mec, Set invocations, List lubStack) {
        if (invocations == null) {
            return mec;
        }
        int length = invocations.size();
        Iterator iter = invocations.iterator();
        if (length == 1) {
            return (TypeBinding)iter.next();
        }
        int dim = mec.dimensions();
        int argLength = (mec = mec.leafComponentType()).typeVariables().length;
        if (argLength == 0) {
            return mec;
        }
        TypeBinding[] bestArguments = new TypeBinding[argLength];
        block5: while (iter.hasNext()) {
            TypeBinding invocation = ((TypeBinding)iter.next()).leafComponentType();
            switch (invocation.kind()) {
                case 2052: {
                    TypeVariableBinding[] invocationVariables = invocation.typeVariables();
                    int i = 0;
                    while (i < argLength) {
                        TypeBinding bestArgument = this.leastContainingTypeArgument(bestArguments[i], invocationVariables[i], (ReferenceBinding)mec, i, lubStack);
                        if (bestArgument == null) {
                            return null;
                        }
                        bestArguments[i] = bestArgument;
                        ++i;
                    }
                    continue block5;
                }
                case 260: {
                    ParameterizedTypeBinding parameterizedType = (ParameterizedTypeBinding)invocation;
                    int i = 0;
                    while (i < argLength) {
                        TypeBinding bestArgument = this.leastContainingTypeArgument(bestArguments[i], parameterizedType.arguments[i], (ReferenceBinding)mec, i, lubStack);
                        if (bestArgument == null) {
                            return null;
                        }
                        bestArguments[i] = bestArgument;
                        ++i;
                    }
                    continue block5;
                }
                case 1028: {
                    return dim == 0 ? invocation : this.environment().createArrayType(invocation, dim);
                }
            }
        }
        ParameterizedTypeBinding least = this.environment().createParameterizedType((ReferenceBinding)mec.erasure(), bestArguments, mec.enclosingType());
        return dim == 0 ? least : this.environment().createArrayType(least, dim);
    }

    private TypeBinding leastContainingTypeArgument(TypeBinding u, TypeBinding v, ReferenceBinding genericType, int rank, List lubStack) {
        block34: {
            block32: {
                WildcardBinding wildV;
                block33: {
                    if (u == null) {
                        return v;
                    }
                    if (u == v) {
                        return u;
                    }
                    if (!v.isWildcard()) break block32;
                    wildV = (WildcardBinding)v;
                    if (!u.isWildcard()) break block33;
                    WildcardBinding wildU = (WildcardBinding)u;
                    switch (wildU.boundKind) {
                        case 1: {
                            switch (wildV.boundKind) {
                                case 1: {
                                    TypeBinding lub = this.lowerUpperBound(new TypeBinding[]{wildU.bound, wildV.bound}, lubStack);
                                    if (lub == null) {
                                        return null;
                                    }
                                    if (lub == TypeBinding.INT) {
                                        return this.environment().createWildcard(genericType, rank, null, null, 0);
                                    }
                                    return this.environment().createWildcard(genericType, rank, lub, null, 1);
                                }
                                case 2: {
                                    if (wildU.bound == wildV.bound) {
                                        return wildU.bound;
                                    }
                                    return this.environment().createWildcard(genericType, rank, null, null, 0);
                                }
                            }
                            break;
                        }
                        case 2: {
                            if (wildU.boundKind == 2) {
                                TypeBinding[] glb = Scope.greaterLowerBound(new TypeBinding[]{wildU.bound, wildV.bound});
                                if (glb == null) {
                                    return null;
                                }
                                return this.environment().createWildcard(genericType, rank, glb[0], null, 2);
                            } else {
                                break;
                            }
                        }
                    }
                    break block34;
                }
                switch (wildV.boundKind) {
                    case 1: {
                        TypeBinding lub = this.lowerUpperBound(new TypeBinding[]{u, wildV.bound}, lubStack);
                        if (lub == null) {
                            return null;
                        }
                        if (lub == TypeBinding.INT) {
                            return this.environment().createWildcard(genericType, rank, null, null, 0);
                        }
                        return this.environment().createWildcard(genericType, rank, lub, null, 1);
                    }
                    case 2: {
                        TypeBinding[] glb = Scope.greaterLowerBound(new TypeBinding[]{u, wildV.bound});
                        if (glb == null) {
                            return null;
                        }
                        return this.environment().createWildcard(genericType, rank, glb[0], null, 2);
                    }
                }
                break block34;
            }
            if (u.isWildcard()) {
                WildcardBinding wildU = (WildcardBinding)u;
                switch (wildU.boundKind) {
                    case 1: {
                        TypeBinding lub = this.lowerUpperBound(new TypeBinding[]{wildU.bound, v}, lubStack);
                        if (lub == null) {
                            return null;
                        }
                        if (lub == TypeBinding.INT) {
                            return this.environment().createWildcard(genericType, rank, null, null, 0);
                        }
                        return this.environment().createWildcard(genericType, rank, lub, null, 1);
                    }
                    case 2: {
                        TypeBinding[] glb = Scope.greaterLowerBound(new TypeBinding[]{wildU.bound, v});
                        if (glb == null) {
                            return null;
                        }
                        return this.environment().createWildcard(genericType, rank, glb[0], null, 2);
                    }
                }
            }
        }
        TypeBinding lub = this.lowerUpperBound(new TypeBinding[]{u, v}, lubStack);
        if (lub == null) {
            return null;
        }
        if (lub == TypeBinding.INT) {
            return this.environment().createWildcard(genericType, rank, null, null, 0);
        }
        return this.environment().createWildcard(genericType, rank, lub, null, 1);
    }

    public TypeBinding lowerUpperBound(TypeBinding[] types) {
        int typeLength = types.length;
        if (typeLength == 1) {
            TypeBinding type = types[0];
            return type == null ? TypeBinding.VOID : type;
        }
        return this.lowerUpperBound(types, new ArrayList(1));
    }

    /*
     * Unable to fully structure code
     */
    private TypeBinding lowerUpperBound(TypeBinding[] types, List lubStack) {
        typeLength = types.length;
        if (typeLength == 1) {
            type = types[0];
            return type == null ? TypeBinding.VOID : type;
        }
        stackLength = lubStack.size();
        i = 0;
        while (i < stackLength) {
            block22: {
                lubTypes = (TypeBinding[])lubStack.get(i);
                lubTypeLength = lubTypes.length;
                if (lubTypeLength < typeLength) break block22;
                j = 0;
                block6: while (j < typeLength) {
                    type = types[j];
                    if (type == null) ** GOTO lbl21
                    k = 0;
                    while (k < lubTypeLength) {
                        lubType = lubTypes[k];
                        if (lubType == null || lubType != type && !lubType.isEquivalentTo(type)) {
                            ++k;
                            continue;
                        }
lbl21:
                        // 3 sources

                        ++j;
                        continue block6;
                    }
                    break block22;
                }
                return TypeBinding.INT;
            }
            ++i;
        }
        lubStack.add(types);
        invocations = new HashMap<K, V>(1);
        mecs = this.minimalErasedCandidates(types, invocations);
        if (mecs == null) {
            return null;
        }
        length = mecs.length;
        if (length == 0) {
            return TypeBinding.VOID;
        }
        count = 0;
        firstBound = null;
        commonDim = -1;
        i = 0;
        while (i < length) {
            mec = mecs[i];
            if (mec != null) {
                if ((mec = this.leastContainingInvocation(mec, (Set)invocations.get(mec), lubStack)) == null) {
                    return null;
                }
                dim = mec.dimensions();
                if (commonDim == -1) {
                    commonDim = dim;
                } else if (dim != commonDim) {
                    return null;
                }
                if (firstBound == null && !mec.leafComponentType().isInterface()) {
                    firstBound = mec.leafComponentType();
                }
                mecs[count++] = mec;
            }
            ++i;
        }
        switch (count) {
            case 0: {
                return TypeBinding.VOID;
            }
            case 1: {
                return mecs[0];
            }
            case 2: {
                if ((commonDim == 0 ? mecs[1].id : mecs[1].leafComponentType().id) == 1) {
                    return mecs[0];
                }
                if ((commonDim == 0 ? mecs[0].id : mecs[0].leafComponentType().id) != 1) break;
                return mecs[1];
            }
        }
        otherBounds = new TypeBinding[count - 1];
        rank = 0;
        i = 0;
        while (i < count) {
            v0 = mec = commonDim == 0 ? mecs[i] : mecs[i].leafComponentType();
            if (mec.isInterface()) {
                otherBounds[rank++] = mec;
            }
            ++i;
        }
        intersectionType = this.environment().createWildcard(null, 0, firstBound, otherBounds, 1);
        return commonDim == 0 ? intersectionType : this.environment().createArrayType(intersectionType, commonDim);
    }

    public final MethodScope methodScope() {
        Scope scope = this;
        do {
            if (!(scope instanceof MethodScope)) continue;
            return (MethodScope)scope;
        } while ((scope = scope.parent) != null);
        return null;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected TypeBinding[] minimalErasedCandidates(TypeBinding[] types, Map allInvocations) {
        length = types.length;
        indexOfFirst = -1;
        actualLength = 0;
        i = 0;
        while (i < length) {
            type = types[i];
            if (type != null) {
                if (type.isBaseType()) {
                    return null;
                }
                if (indexOfFirst < 0) {
                    indexOfFirst = i;
                }
                ++actualLength;
            }
            ++i;
        }
        switch (actualLength) {
            case 0: {
                return Binding.NO_TYPES;
            }
            case 1: {
                return types;
            }
        }
        firstType = types[indexOfFirst];
        if (firstType.isBaseType()) {
            return null;
        }
        typesToVisit = new ArrayList<TypeBinding>(5);
        dim = firstType.dimensions();
        leafType = firstType.leafComponentType();
        v0 = firstErasure = leafType.isTypeVariable() != false || leafType.isWildcard() != false ? firstType : firstType.erasure();
        if (firstErasure != firstType) {
            someInvocations = new HashSet<TypeBinding>(1);
            someInvocations.add(firstType);
            allInvocations.put(firstErasure, someInvocations);
        }
        typesToVisit.add(firstType);
        max = 1;
        i = 0;
        while (i < max) {
            block53: {
                block52: {
                    typeToVisit = (TypeBinding)typesToVisit.get(i);
                    dim = typeToVisit.dimensions();
                    if (dim <= 0) break block52;
                    leafType = typeToVisit.leafComponentType();
                    switch (leafType.id) {
                        case 1: {
                            if (dim <= 1) ** GOTO lbl51
                            elementType = ((ArrayBinding)typeToVisit).elementsType();
                            if (!typesToVisit.contains(elementType)) {
                                typesToVisit.add(elementType);
                                ++max;
                            }
                            break block53;
                        }
lbl51:
                        // 2 sources

                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: {
                            superType = this.getJavaIoSerializable();
                            if (!typesToVisit.contains(superType)) {
                                typesToVisit.add(superType);
                                ++max;
                            }
                            if (!typesToVisit.contains(superType = this.getJavaLangCloneable())) {
                                typesToVisit.add(superType);
                                ++max;
                            }
                            if (!typesToVisit.contains(superType = this.getJavaLangObject())) {
                                typesToVisit.add(superType);
                                ++max;
                            }
                            break block53;
                        }
                        default: {
                            typeToVisit = leafType;
                        }
                    }
                }
                if ((currentType = (ReferenceBinding)typeToVisit).isCapture() && (firstBound = ((CaptureBinding)currentType).firstBound) != null && firstBound.isArrayType()) {
                    v1 = superType = dim == 0 ? firstBound : this.environment().createArrayType(firstBound, dim);
                    if (!typesToVisit.contains(superType)) {
                        typesToVisit.add(superType);
                        ++max;
                        v2 = superTypeErasure = firstBound.isTypeVariable() != false || firstBound.isWildcard() != false ? superType : superType.erasure();
                        if (superTypeErasure != superType) {
                            someInvocations = new HashSet<TypeBinding>(1);
                            someInvocations.add(superType);
                            allInvocations.put(superTypeErasure, someInvocations);
                        }
                    }
                } else {
                    itsInterfaces = currentType.superInterfaces();
                    if (itsInterfaces != null) {
                        j = 0;
                        count = itsInterfaces.length;
                        while (j < count) {
                            itsInterface = itsInterfaces[j];
                            v3 /* !! */  = superType = dim == 0 ? itsInterface : this.environment().createArrayType(itsInterface, dim);
                            if (!typesToVisit.contains(superType)) {
                                typesToVisit.add(superType);
                                ++max;
                                v4 /* !! */  = superTypeErasure = itsInterface.isTypeVariable() != false || itsInterface.isWildcard() != false ? superType : superType.erasure();
                                if (superTypeErasure != superType) {
                                    someInvocations = new HashSet<ReferenceBinding>(1);
                                    someInvocations.add(superType);
                                    allInvocations.put(superTypeErasure, someInvocations);
                                }
                            }
                            ++j;
                        }
                    }
                    if ((itsSuperclass = currentType.superclass()) != null) {
                        v5 /* !! */  = superType = dim == 0 ? itsSuperclass : this.environment().createArrayType(itsSuperclass, dim);
                        if (!typesToVisit.contains(superType)) {
                            typesToVisit.add(superType);
                            ++max;
                            v6 /* !! */  = superTypeErasure = itsSuperclass.isTypeVariable() != false || itsSuperclass.isWildcard() != false ? superType : superType.erasure();
                            if (superTypeErasure != superType) {
                                someInvocations = new HashSet<ReferenceBinding>(1);
                                someInvocations.add(superType);
                                allInvocations.put(superTypeErasure, someInvocations);
                            }
                        }
                    }
                }
            }
            ++i;
        }
        superLength = typesToVisit.size();
        erasedSuperTypes = new TypeBinding[superLength];
        rank = 0;
        iter = typesToVisit.iterator();
        while (iter.hasNext()) {
            type = (TypeBinding)iter.next();
            leafType = type.leafComponentType();
            v7 = erasedSuperTypes[rank++] = leafType.isTypeVariable() != false || leafType.isWildcard() != false ? type : type.erasure();
        }
        remaining = superLength;
        i = indexOfFirst + 1;
        while (i < length) {
            block54: {
                block55: {
                    otherType = types[i];
                    if (otherType == null) break block54;
                    if (!otherType.isArrayType()) break block55;
                    j = 0;
                    while (j < superLength) {
                        erasedSuperType = erasedSuperTypes[j];
                        if (erasedSuperType != null && erasedSuperType != otherType) {
                            match /* !! */  = otherType.findSuperTypeWithSameErasure(erasedSuperType);
                            if (match /* !! */  == null) {
                                erasedSuperTypes[j] = null;
                                if (--remaining == 0) {
                                    return null;
                                }
                            } else {
                                someInvocations /* !! */  = (Set)allInvocations.get(erasedSuperType);
                                if (someInvocations /* !! */  == null) {
                                    someInvocations /* !! */  = new HashSet<E>(1);
                                }
                                someInvocations /* !! */ .add(match /* !! */ );
                                allInvocations.put(erasedSuperType, someInvocations /* !! */ );
                            }
                        }
                        ++j;
                    }
                    break block54;
                }
                j = 0;
                while (j < superLength) {
                    block56: {
                        block57: {
                            erasedSuperType = erasedSuperTypes[j];
                            if (erasedSuperType == null) break block56;
                            if (erasedSuperType != otherType && (erasedSuperType.id != 1 || !otherType.isInterface())) break block57;
                            match /* !! */  = erasedSuperType;
                            ** GOTO lbl-1000
                        }
                        match /* !! */  = erasedSuperType.isArrayType() != false ? null : otherType.findSuperTypeWithSameErasure(erasedSuperType);
                        if (match /* !! */  == null) {
                            erasedSuperTypes[j] = null;
                            if (--remaining == 0) {
                                return null;
                            }
                        } else lbl-1000:
                        // 2 sources

                        {
                            someInvocations /* !! */  = (HashSet<TypeBinding>)allInvocations.get(erasedSuperType);
                            if (someInvocations /* !! */  == null) {
                                someInvocations /* !! */  = new HashSet<TypeBinding>(1);
                            }
                            someInvocations /* !! */ .add(match /* !! */ );
                            allInvocations.put(erasedSuperType, someInvocations /* !! */ );
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (remaining > 1) {
            i = 0;
            while (i < superLength) {
                erasedSuperType = erasedSuperTypes[i];
                if (erasedSuperType != null) {
                    j = 0;
                    while (j < superLength) {
                        if (i != j && (otherType = erasedSuperTypes[j]) != null) {
                            if (erasedSuperType instanceof ReferenceBinding) {
                                if (!(otherType.id == 1 && erasedSuperType.isInterface() || erasedSuperType.findSuperTypeWithSameErasure(otherType) == null)) {
                                    erasedSuperTypes[j] = null;
                                    --remaining;
                                }
                            } else if (!(!erasedSuperType.isArrayType() || otherType.isArrayType() && otherType.leafComponentType().id == 1 && otherType.dimensions() == erasedSuperType.dimensions() && erasedSuperType.leafComponentType().isInterface() || erasedSuperType.findSuperTypeWithSameErasure(otherType) == null)) {
                                erasedSuperTypes[j] = null;
                                --remaining;
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return erasedSuperTypes;
    }

    protected final MethodBinding mostSpecificClassMethodBinding(MethodBinding[] visible, int visibleSize, InvocationSite invocationSite) {
        MethodBinding problemMethod = null;
        MethodBinding previous = null;
        int i = 0;
        while (i < visibleSize) {
            block5: {
                MethodBinding method = visible[i];
                if (previous != null && method.declaringClass != previous.declaringClass) break;
                if (!method.isStatic()) {
                    previous = method;
                }
                int j = 0;
                while (j < visibleSize) {
                    if (i == j || visible[j].areParametersCompatibleWith(method.parameters)) {
                        ++j;
                        continue;
                    }
                    break block5;
                }
                this.compilationUnitScope().recordTypeReferences(method.thrownExceptions);
                return method;
            }
            ++i;
        }
        if (problemMethod == null) {
            return new ProblemMethodBinding(visible[0].selector, visible[0].parameters, 3);
        }
        return problemMethod;
    }

    protected final MethodBinding mostSpecificInterfaceMethodBinding(MethodBinding[] visible, int visibleSize, InvocationSite invocationSite) {
        MethodBinding problemMethod = null;
        int i = 0;
        while (i < visibleSize) {
            block4: {
                MethodBinding method = visible[i];
                int j = 0;
                while (j < visibleSize) {
                    if (i == j || visible[j].areParametersCompatibleWith(method.parameters)) {
                        ++j;
                        continue;
                    }
                    break block4;
                }
                this.compilationUnitScope().recordTypeReferences(method.thrownExceptions);
                return method;
            }
            ++i;
        }
        if (problemMethod == null) {
            return new ProblemMethodBinding(visible[0].selector, visible[0].parameters, 3);
        }
        return problemMethod;
    }

    protected final MethodBinding mostSpecificMethodBinding(MethodBinding[] visible, int visibleSize, TypeBinding[] argumentTypes, InvocationSite invocationSite, ReferenceBinding receiverType) {
        int i;
        MethodBinding original;
        int[] compatibilityLevels = new int[visibleSize];
        int i2 = 0;
        while (i2 < visibleSize) {
            compatibilityLevels[i2] = this.parameterCompatibilityLevel(visible[i2], argumentTypes);
            ++i2;
        }
        boolean useTiebreakMethod = invocationSite.genericTypeArguments() == null;
        MethodBinding[] moreSpecific = new MethodBinding[visibleSize];
        int count = 0;
        int level = 0;
        int max = 2;
        while (level <= max) {
            int i3 = 0;
            while (i3 < visibleSize) {
                block52: {
                    if (compatibilityLevels[i3] == level) {
                        max = level;
                        MethodBinding current = visible[i3];
                        original = current.original();
                        MethodBinding tiebreakMethod = useTiebreakMethod ? current.tiebreakMethod() : current;
                        int j = 0;
                        while (j < visibleSize) {
                            if (i3 != j && compatibilityLevels[j] == level) {
                                MethodBinding next = visible[j];
                                if (original == next.original()) {
                                    compatibilityLevels[j] = -1;
                                } else {
                                    MethodBinding acceptable;
                                    MethodBinding methodToTest = next;
                                    if (next instanceof ParameterizedGenericMethodBinding) {
                                        ParameterizedGenericMethodBinding pNext = (ParameterizedGenericMethodBinding)next;
                                        if (!pNext.isRaw) {
                                            methodToTest = pNext.originalMethod;
                                        }
                                    }
                                    if ((acceptable = this.computeCompatibleMethod(methodToTest, tiebreakMethod.parameters, invocationSite)) == null || !acceptable.isValidBinding() || !this.isAcceptableMethod(tiebreakMethod, acceptable)) break block52;
                                }
                            }
                            ++j;
                        }
                        moreSpecific[i3] = current;
                        ++count;
                    }
                }
                ++i3;
            }
            ++level;
        }
        if (count == 1) {
            i = 0;
            while (i < visibleSize) {
                if (moreSpecific[i] != null) {
                    this.compilationUnitScope().recordTypeReferences(visible[i].thrownExceptions);
                    return visible[i];
                }
                ++i;
            }
        } else if (count == 0) {
            return new ProblemMethodBinding(visible[0].selector, visible[0].parameters, 3);
        }
        if (receiverType != null) {
            receiverType = receiverType instanceof CaptureBinding ? receiverType : (ReferenceBinding)receiverType.erasure();
        }
        i = 0;
        block5: while (i < visibleSize) {
            block53: {
                MethodBinding current = moreSpecific[i];
                if (current != null) {
                    Object[] mostSpecificExceptions = null;
                    SimpleSet possibleMethods = null;
                    original = current.original();
                    int j = 0;
                    while (j < visibleSize) {
                        MethodBinding next = moreSpecific[j];
                        if (next != null && i != j) {
                            int m;
                            TypeBinding superType;
                            MethodBinding original2 = next.original();
                            if (original.declaringClass == original2.declaringClass) break block5;
                            if (!original.isAbstract()) {
                                if (!original2.isAbstract()) {
                                    superType = original.declaringClass.findSuperTypeWithSameErasure(original2.declaringClass.erasure());
                                    if (superType == null) break block53;
                                    if (current.hasSubstitutedParameters() || original.typeVariables != Binding.NO_TYPE_VARIABLES) {
                                        if (original2.declaringClass != superType) {
                                            MethodBinding[] superMethods = ((ReferenceBinding)superType).getMethods(original2.selector);
                                            m = 0;
                                            int l = superMethods.length;
                                            while (m < l) {
                                                if (superMethods[m].original() == original2) {
                                                    original2 = superMethods[m];
                                                    break;
                                                }
                                                ++m;
                                            }
                                        }
                                        if (original.typeVariables != Binding.NO_TYPE_VARIABLES) {
                                            original2 = original.computeSubstitutedMethod(original2, this.environment());
                                        }
                                        if (original2 == null || !original.areParametersEqual(original2)) {
                                            break block53;
                                        }
                                    }
                                }
                            } else if (receiverType != null) {
                                superType = receiverType.findSuperTypeWithSameErasure(original.declaringClass.erasure());
                                if (original.declaringClass != superType && superType instanceof ReferenceBinding) {
                                    MethodBinding[] superMethods = ((ReferenceBinding)superType).getMethods(original.selector);
                                    m = 0;
                                    int l = superMethods.length;
                                    while (m < l) {
                                        if (superMethods[m].original() == original) {
                                            original = superMethods[m];
                                            break;
                                        }
                                        ++m;
                                    }
                                }
                                if (original2.declaringClass != (superType = receiverType.findSuperTypeWithSameErasure(original2.declaringClass.erasure())) && superType instanceof ReferenceBinding) {
                                    MethodBinding[] superMethods = ((ReferenceBinding)superType).getMethods(original2.selector);
                                    m = 0;
                                    int l = superMethods.length;
                                    while (m < l) {
                                        if (superMethods[m].original() == original2) {
                                            original2 = superMethods[m];
                                            break;
                                        }
                                        ++m;
                                    }
                                }
                                if (original.typeVariables != Binding.NO_TYPE_VARIABLES) {
                                    original2 = original.computeSubstitutedMethod(original2, this.environment());
                                }
                                if (original2 == null || !original.areParameterErasuresEqual(original2) || !original.returnType.isCompatibleWith(original2.returnType)) break block53;
                                if (original.thrownExceptions != original2.thrownExceptions) {
                                    if (mostSpecificExceptions == null) {
                                        mostSpecificExceptions = original.thrownExceptions;
                                    }
                                    if (possibleMethods == null) {
                                        possibleMethods = new SimpleSet(3);
                                    }
                                    int mostSpecificLength = mostSpecificExceptions.length;
                                    int original2Length = original2.thrownExceptions.length;
                                    SimpleSet temp = new SimpleSet(mostSpecificLength);
                                    int t = 0;
                                    while (t < mostSpecificLength) {
                                        ReferenceBinding exception = mostSpecificExceptions[t];
                                        int s = 0;
                                        while (s < original2Length) {
                                            if (exception.isCompatibleWith(original2.thrownExceptions[s])) {
                                                possibleMethods.add(current);
                                                temp.add(exception);
                                                break;
                                            }
                                            if (original2.thrownExceptions[s].isCompatibleWith(exception)) {
                                                possibleMethods.add(next);
                                                temp.add(original2.thrownExceptions[s]);
                                                break;
                                            }
                                            ++s;
                                        }
                                        ++t;
                                    }
                                    mostSpecificExceptions = temp.elementSize == 0 ? Binding.NO_EXCEPTIONS : new ReferenceBinding[temp.elementSize];
                                    temp.asArray(mostSpecificExceptions);
                                }
                            }
                        }
                        ++j;
                    }
                    if (mostSpecificExceptions != null) {
                        Object[] values = possibleMethods.values;
                        int exceptionLength = mostSpecificExceptions.length;
                        int p = 0;
                        int vLength = values.length;
                        while (p < vLength) {
                            block54: {
                                ReferenceBinding[] itsExceptions;
                                MethodBinding possible = (MethodBinding)values[p];
                                if (possible != null && (itsExceptions = possible.thrownExceptions).length == exceptionLength) {
                                    int e = 0;
                                    block13: while (e < exceptionLength) {
                                        ReferenceBinding exception = itsExceptions[e];
                                        int f = 0;
                                        while (f < exceptionLength) {
                                            if (exception != mostSpecificExceptions[f]) {
                                                ++f;
                                                continue;
                                            }
                                            ++e;
                                            continue block13;
                                        }
                                        break block54;
                                    }
                                    return possible;
                                }
                            }
                            ++p;
                        }
                    }
                    return current;
                }
            }
            ++i;
        }
        return new ProblemMethodBinding(visible[0].selector, visible[0].parameters, 3);
    }

    public final ClassScope outerMostClassScope() {
        ClassScope lastClassScope = null;
        Scope scope = this;
        do {
            if (!(scope instanceof ClassScope)) continue;
            lastClassScope = (ClassScope)scope;
        } while ((scope = scope.parent) != null);
        return lastClassScope;
    }

    public final MethodScope outerMostMethodScope() {
        MethodScope lastMethodScope = null;
        Scope scope = this;
        do {
            if (!(scope instanceof MethodScope)) continue;
            lastMethodScope = (MethodScope)scope;
        } while ((scope = scope.parent) != null);
        return lastMethodScope;
    }

    protected int parameterCompatibilityLevel(MethodBinding method, TypeBinding[] arguments) {
        TypeBinding arg;
        TypeBinding[] parameters = method.parameters;
        int paramLength = parameters.length;
        int argLength = arguments.length;
        if (this.compilerOptions().sourceLevel < 0x310000L) {
            if (paramLength != argLength) {
                return -1;
            }
            int i = 0;
            while (i < argLength) {
                TypeBinding arg2 = arguments[i];
                TypeBinding param = parameters[i];
                if (arg2 != param && !arg2.isCompatibleWith(param)) {
                    return -1;
                }
                ++i;
            }
            return 0;
        }
        int level = 0;
        int lastIndex = argLength;
        LookupEnvironment env = this.environment();
        if (method.isVarargs()) {
            TypeBinding param;
            lastIndex = paramLength - 1;
            if (paramLength == argLength) {
                param = parameters[lastIndex];
                TypeBinding arg3 = arguments[lastIndex];
                if (param != arg3 && (level = this.parameterCompatibilityLevel(arg3, param, env)) == -1) {
                    if (this.parameterCompatibilityLevel(arg3, param = ((ArrayBinding)param).elementsType(), env) == -1) {
                        return -1;
                    }
                    level = 2;
                }
            } else {
                if (paramLength < argLength) {
                    param = ((ArrayBinding)parameters[lastIndex]).elementsType();
                    int i = lastIndex;
                    while (i < argLength) {
                        arg = arguments[i];
                        if (param != arg && this.parameterCompatibilityLevel(arg, param, env) == -1) {
                            return -1;
                        }
                        ++i;
                    }
                } else if (lastIndex != argLength) {
                    return -1;
                }
                level = 2;
            }
        } else if (paramLength != argLength) {
            return -1;
        }
        int i = 0;
        while (i < lastIndex) {
            arg = arguments[i];
            TypeBinding param = parameters[i];
            if (arg != param) {
                int newLevel = this.parameterCompatibilityLevel(arg, param, env);
                if (newLevel == -1) {
                    return -1;
                }
                if (newLevel > level) {
                    level = newLevel;
                }
            }
            ++i;
        }
        return level;
    }

    private int parameterCompatibilityLevel(TypeBinding arg, TypeBinding param, LookupEnvironment env) {
        TypeBinding convertedType;
        if (arg.isCompatibleWith(param)) {
            return 0;
        }
        if (arg.isBaseType() != param.isBaseType() && ((convertedType = env.computeBoxingType(arg)) == param || convertedType.isCompatibleWith(param))) {
            return 1;
        }
        return -1;
    }

    public abstract ProblemReporter problemReporter();

    public final CompilationUnitDeclaration referenceCompilationUnit() {
        Scope scope;
        Scope unitScope = this;
        while ((scope = unitScope.parent) != null) {
            unitScope = scope;
        }
        return ((CompilationUnitScope)unitScope).referenceContext;
    }

    public ReferenceContext referenceContext() {
        Scope current = this;
        do {
            switch (current.kind) {
                case 2: {
                    return ((MethodScope)current).referenceContext;
                }
                case 3: {
                    return ((ClassScope)current).referenceContext;
                }
                case 4: {
                    return ((CompilationUnitScope)current).referenceContext;
                }
            }
        } while ((current = current.parent) != null);
        return null;
    }

    int startIndex() {
        return 0;
    }
}

