/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xslt4j.b2b2dtm;

import com.ibm.xml.b2b.scan.DTDParams;
import com.ibm.xml.b2b.scan.DoctypeEventHandler;
import com.ibm.xml.b2b.scan.DoctypeImplementationHandler;
import com.ibm.xml.b2b.scan.DocumentEventHandler;
import com.ibm.xml.b2b.scan.DocumentImplementationHandler;
import com.ibm.xml.b2b.scan.DocumentScannerSupport;
import com.ibm.xml.b2b.scan.ExternalEntityHandler;
import com.ibm.xml.b2b.scan.ExternalEntityState;
import com.ibm.xml.b2b.scan.ExternalSubsetHandler;
import com.ibm.xml.b2b.scan.InternalSubsetHandler;
import com.ibm.xml.b2b.scan.latin.LatinWFCDoctypeScanner;
import com.ibm.xml.b2b.scan.latin.LatinWFCDocumentScanner;
import com.ibm.xml.b2b.scan.latin.LatinWFCExternalEntityScanner;
import com.ibm.xml.b2b.scan.latin.LatinWFCExternalSubsetScanner;
import com.ibm.xml.b2b.scan.latin.LatinWFCInternalSubsetScanner;
import com.ibm.xml.b2b.scan.latin.LatinWFCMarkupDeclScanner;
import com.ibm.xml.b2b.scan.latin.LatinWFCScannerSupport;
import com.ibm.xml.b2b.scan.utf16.UTF16WFCDoctypeScanner;
import com.ibm.xml.b2b.scan.utf16.UTF16WFCDocumentScanner;
import com.ibm.xml.b2b.scan.utf16.UTF16WFCExternalEntityScanner;
import com.ibm.xml.b2b.scan.utf16.UTF16WFCExternalSubsetScanner;
import com.ibm.xml.b2b.scan.utf16.UTF16WFCInternalSubsetScanner;
import com.ibm.xml.b2b.scan.utf16.UTF16WFCMarkupDeclScanner;
import com.ibm.xml.b2b.scan.utf16.UTF16WFCScannerSupport;
import com.ibm.xml.b2b.util.ErrorReporter;
import com.ibm.xml.b2b.util.MessageProvider;
import com.ibm.xml.b2b.util.MessageProviderRegistry;
import com.ibm.xml.b2b.util.QName;
import com.ibm.xml.b2b.util.SymbolTable;
import com.ibm.xml.b2b.util.XMLName;
import com.ibm.xml.b2b.util.XMLString;
import com.ibm.xml.b2b.util.XMLStringBuffer;
import com.ibm.xml.b2b.util.entity.ByteArrayParsedEntityFactory;
import com.ibm.xml.b2b.util.entity.CharArrayParsedEntityFactory;
import com.ibm.xml.b2b.util.entity.DTDEntityEventHandler;
import com.ibm.xml.b2b.util.entity.EntityDeclPool;
import com.ibm.xml.b2b.util.entity.EntityEventHandler;
import com.ibm.xml.b2b.util.entity.EntityInputSource;
import com.ibm.xml.b2b.util.entity.EntityManager;
import com.ibm.xml.b2b.util.entity.ParsedEntity;
import com.ibm.xml.b2b.util.entity.ParsedEntityFactory;
import com.ibm.xslt4j.b2b2dtm.B2B2DTM;
import com.ibm.xslt4j.b2b2dtm.DTDGrammar;
import com.ibm.xslt4j.b2b2dtm.SimpleXMLDeclChecker;
import java.io.IOException;
import java.util.Hashtable;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamSource;
import org.apache.xml.utils.SystemIDResolver;
import org.apache.xml.utils.WrappedRuntimeException;
import org.xml.sax.SAXParseException;

final class B2BParser
implements ExternalEntityHandler,
DocumentEventHandler,
DocumentImplementationHandler,
DoctypeEventHandler,
DoctypeImplementationHandler,
ExternalSubsetHandler,
InternalSubsetHandler,
DTDEntityEventHandler,
EntityEventHandler,
ErrorReporter {
    private static final boolean RETAIN_OBJECTS_ACROSS_RESET = true;
    private static final String IDSYMBOL = "ID".intern();
    private B2B2DTM fDTM;
    private UTF16WFCScannerSupport fUTF16ScannerSupport;
    private UTF16WFCExternalSubsetScanner fUTF16ExternalSubsetScanner;
    private LatinWFCScannerSupport fLatinScannerSupport;
    private LatinWFCExternalSubsetScanner fLatinExternalSubsetScanner;
    private DocumentScannerSupport fScannerSupport;
    private EntityInputSource fEntityInputSource;
    private boolean fNeedReset;
    private XMLString fContent;
    private char[][] fCharBuffer;
    private int[] fCharBufferOffset;
    private boolean fInDTD;
    private SymbolTable fSymbolTable;
    private ExternalEntityState fExternalEntityState;
    private ParsedEntityFactory fEntityFactory;
    private EntityManager fEntityManager;
    private DTDParams fDTDParams;
    private DTDGrammar fDTDGrammar;
    private XMLStringBuffer fStringBuffer;
    private boolean fHaveExternalSubset;
    private EntityDeclPool fEntityDeclPool;
    private String fDoctypePublicID;
    private String fDoctypeSystemID;
    private QName fDeclElementType;
    private XMLString fContentModel;
    private int fContentModelOffset;
    private boolean fContentModelPCDATA;
    private QName fDeclAttrName;
    private XMLString fDeclAttType;
    private boolean fScannedDefaultAttValue;
    private int fDefaultAttValueOffset;
    private XMLString fDefaultAttValue;
    private int fEntityValueOffset;
    private XMLString fInternalEntityValue;
    private boolean fUsingReader;
    private Hashtable fUnparsedEntities;
    private SimpleXMLDeclChecker fXMLDeclChecker;
    private ErrorListener fErrorListener;

    public B2BParser(boolean usingReader) {
        this(null, usingReader);
    }

    public B2BParser(ErrorListener listener, boolean usingReader) {
        this.fErrorListener = listener;
        this.fUsingReader = usingReader;
        this.fSymbolTable = new SymbolTable();
        this.fExternalEntityState = new ExternalEntityState();
        this.fDTDParams = new DTDParams();
        if (usingReader) {
            this.fEntityFactory = new CharArrayParsedEntityFactory(true);
            this.fUTF16ScannerSupport = new UTF16WFCScannerSupport(this.fSymbolTable, this.fEntityFactory.createStringBuffer(), this);
            this.fScannerSupport = this.fUTF16ScannerSupport;
        } else {
            this.fEntityFactory = new ByteArrayParsedEntityFactory(true);
            this.fLatinScannerSupport = new LatinWFCScannerSupport(this.fSymbolTable, this.fEntityFactory.createStringBuffer(), this);
            this.fScannerSupport = this.fLatinScannerSupport;
        }
        this.fEntityManager = new EntityManager(this, this.fSymbolTable, this.fEntityFactory);
        this.fStringBuffer = this.fEntityFactory.createStringBuffer();
        this.fEntityInputSource = new EntityInputSource();
        this.fContent = new XMLString();
        this.fCharBuffer = new char[1][256];
        this.fCharBufferOffset = new int[1];
        this.fContentModel = new XMLString();
        this.fDefaultAttValue = new XMLString();
        this.fInternalEntityValue = new XMLString();
        this.fEntityManager.setDTDEntityEventHandler(this);
        this.fDTDGrammar = new DTDGrammar(this.fSymbolTable, this.fEntityFactory);
        this.fEntityDeclPool = this.fDTDGrammar.getEntityDeclPool();
        this.fStringBuffer = this.fDTDGrammar.getStringBuffer();
        this.fEntityManager.setEntityDeclPool(this.fDTDGrammar.getEntityDeclPool());
        this.fUnparsedEntities = new Hashtable();
        this.fXMLDeclChecker = new SimpleXMLDeclChecker();
    }

    public void setDTM(B2B2DTM dtm) {
        this.fDTM = dtm;
    }

    public SymbolTable getSymbolTable() {
        return this.fSymbolTable;
    }

    public DocumentScannerSupport getScannerSupport() {
        return this.fScannerSupport;
    }

    public Hashtable getUnparsedEntities() {
        return this.fUnparsedEntities;
    }

    protected void reset(boolean retainObjects) {
        this.fSymbolTable.reset(retainObjects);
        this.fExternalEntityState.reset();
        this.fEntityFactory.reset(retainObjects);
        this.fDTDParams.reset();
        this.fEntityManager.reset(retainObjects);
        this.fStringBuffer.reset(retainObjects);
        this.fHaveExternalSubset = false;
        this.fDTDGrammar.reset(retainObjects);
        this.fDoctypePublicID = null;
        this.fDoctypeSystemID = null;
        this.fContentModel.clear();
        this.fUnparsedEntities.clear();
        this.fScannerSupport.reset(retainObjects);
        if (this.fUsingReader) {
            if (this.fUTF16ExternalSubsetScanner != null) {
                this.fUTF16ExternalSubsetScanner.reset(retainObjects);
            }
        } else if (this.fLatinExternalSubsetScanner != null) {
            this.fLatinExternalSubsetScanner.reset(retainObjects);
        }
        this.fInDTD = false;
    }

    public boolean checkSource(StreamSource source) throws IOException {
        return this.fXMLDeclChecker.checkXMLDecl(source);
    }

    public void parse(StreamSource source) {
        String urlOfSource = source.getSystemId();
        if (null != urlOfSource) {
            try {
                urlOfSource = SystemIDResolver.getAbsoluteURI(urlOfSource);
            }
            catch (Exception e) {
                System.err.println("Can not absolutize URL: " + urlOfSource);
            }
        }
        this.fEntityInputSource.clear();
        this.fEntityInputSource.setSystemId(urlOfSource);
        this.fEntityInputSource.setPublicId(source.getPublicId());
        if (source.getInputStream() != null) {
            this.fEntityInputSource.setByteStream(source.getInputStream());
        }
        if (source.getReader() != null) {
            this.fEntityInputSource.setCharacterStream(source.getReader());
        }
        if (this.fNeedReset) {
            this.reset(true);
        }
        this.fNeedReset = true;
        this.fDTM.startDocument();
        this.fEntityManager.scanDocumentEntity(this.fEntityInputSource);
        this.fDTM.endDocument();
    }

    public void reportWarning(String uri, int errorCode, Object[] args) {
        MessageProvider mp = MessageProviderRegistry.getMessageProvider(uri);
        String msg = mp.createMessage(null, errorCode, args);
        SAXParseException spe = new SAXParseException(msg, null);
        if (this.fErrorListener != null) {
            try {
                this.fErrorListener.warning(new TransformerException(spe));
            }
            catch (TransformerException te) {
                throw new WrappedRuntimeException(te);
            }
        } else {
            throw new WrappedRuntimeException(spe);
        }
    }

    public void reportRecoverableError(String uri, int errorCode, Object[] args) {
        MessageProvider mp = MessageProviderRegistry.getMessageProvider(uri);
        String msg = mp.createMessage(null, errorCode, args);
        SAXParseException spe = new SAXParseException(msg, null);
        if (this.fErrorListener != null) {
            try {
                this.fErrorListener.error(new TransformerException(spe));
            }
            catch (TransformerException te) {
                throw new WrappedRuntimeException(te);
            }
        } else {
            throw new WrappedRuntimeException(spe);
        }
    }

    public void reportFatalError(String uri, int errorCode, Object[] args) {
        MessageProvider mp = MessageProviderRegistry.getMessageProvider(uri);
        String msg = mp.createMessage(null, errorCode, args);
        SAXParseException spe = new SAXParseException(msg, null);
        if (this.fErrorListener != null) {
            try {
                this.fErrorListener.fatalError(new TransformerException(spe));
            }
            catch (TransformerException te) {
                throw new WrappedRuntimeException(te);
            }
        } else {
            throw new WrappedRuntimeException(spe);
        }
    }

    public void xmlDeclEvent() {
        XMLString standalone = this.fExternalEntityState.standalone;
        if (standalone != null && standalone.offset + 3 == standalone.endOffset) {
            this.fEntityManager.setStandalone();
        }
    }

    public void textDeclEvent() {
    }

    public void startElementEvent(boolean isEmpty) {
        QName elementType = this.fScannerSupport.currentElement;
        if (this.fDTDGrammar != null && this.fDTDGrammar.hasAttDefs()) {
            this.fDTDGrammar.addDefaultAttributes(this.fScannerSupport, elementType.handle);
        }
        this.fScannerSupport.resolveNamespaceURIs();
        int elemNode = this.fDTM.createElementNode(elementType);
        this.fDTM.createNamespaceNodes(elemNode);
        int attrCount = this.fScannerSupport.attrCount;
        int i = 0;
        while (i < attrCount) {
            XMLString attValue = this.fScannerSupport.attValues[i];
            if (!this.fScannerSupport.attValueNormalized[i]) {
                this.fScannerSupport.normalizeAttributeValue(i);
            }
            this.fDTM.createAttributeNode(elemNode, this.fScannerSupport.attrNames[i], this.fScannerSupport.attTypes[i] == IDSYMBOL, attValue.toString());
            ++i;
        }
        this.fDTM.finishStartElement(elemNode);
        if (isEmpty) {
            this.fDTM.endElement(elementType.namespaceURI, elementType.localPart, elementType.str);
        }
    }

    public void endElementEvent() {
        QName elementType = this.fScannerSupport.currentElement;
        this.fDTM.endElement(elementType.namespaceURI, elementType.localPart, elementType.str);
    }

    public void characters(XMLString content) {
        if (this.fUsingReader) {
            int offset = content.offset;
            int length = content.endOffset - offset;
            this.fDTM.characters(content.chars, offset, length);
        } else {
            this.fCharBufferOffset[0] = 0;
            content.getChars(this.fCharBuffer, this.fCharBufferOffset);
            int length = this.fCharBufferOffset[0];
            this.fDTM.characters(this.fCharBuffer[0], 0, length);
        }
    }

    public void character(int ch, boolean predefinedEntity) {
        this.fDTM.character(ch);
    }

    public void processingInstruction(XMLName target, XMLString content) {
        this.fSymbolTable.addSymbol(target);
        this.fDTM.processingInstruction(target.handle, content.toString());
    }

    public boolean scanDoctypeDecl(ParsedEntity entityContent) {
        this.fDTDParams.push(entityContent);
        boolean result = this.fUsingReader ? UTF16WFCDoctypeScanner.scanDoctypeDecl(this, this, this.fUTF16ScannerSupport, this.fDTDParams, entityContent) : LatinWFCDoctypeScanner.scanDoctypeDecl(this, this, this.fLatinScannerSupport, this.fDTDParams, entityContent);
        this.fDTDParams.pop();
        return result;
    }

    public boolean scanExternalSubset() {
        boolean result = this.fHaveExternalSubset ? this.fEntityManager.scanExternalSubset(this.fDoctypePublicID, this.fDoctypeSystemID) : true;
        this.fInDTD = false;
        return result;
    }

    public void startCDATA() {
        this.fDTM.startCDATA();
    }

    public void endCDATA() {
        this.fDTM.endCDATA();
    }

    public void comment(XMLString content) {
        if (this.fInDTD) {
            return;
        }
        this.fDTM.comment(content.toString());
    }

    public boolean entityReferenceInContent(XMLName entityName) {
        int entityNameHandle = this.fSymbolTable.addSymbol(entityName);
        return this.fEntityManager.entityReferenceInContent(entityNameHandle);
    }

    public boolean entityReferenceInAttValue(XMLName entityName) {
        int entityNameHandle = this.fSymbolTable.addSymbol(entityName);
        return this.fEntityManager.entityReferenceInAttValue(entityNameHandle);
    }

    public void doctype(QName rootElementType, XMLString publicID, XMLString systemID, boolean internalSubset) {
        int sysID;
        boolean bl = this.fHaveExternalSubset = systemID != null;
        if (publicID != null) {
            this.fStringBuffer.normalizePublicID(publicID);
        }
        int pubID = publicID != null ? this.fSymbolTable.addSymbol(publicID) : -1;
        int n = sysID = systemID != null ? this.fSymbolTable.addSymbol(systemID) : -1;
        if (internalSubset || this.fHaveExternalSubset) {
            this.fDTDGrammar.setDescription(rootElementType, pubID, sysID);
            if (sysID != -1) {
                this.fDoctypePublicID = this.fSymbolTable.toString(pubID);
                this.fDoctypeSystemID = this.fSymbolTable.toString(sysID);
            }
        }
        this.fInDTD = true;
    }

    public boolean scanInternalSubset(ParsedEntity entityContent) {
        this.fDTDParams.push(entityContent);
        boolean result = this.fUsingReader ? UTF16WFCInternalSubsetScanner.scanInternalSubset(this, this.fUTF16ScannerSupport, this.fDTDParams, entityContent) : LatinWFCInternalSubsetScanner.scanInternalSubset(this, this.fLatinScannerSupport, this.fDTDParams, entityContent);
        this.fDTDParams.pop();
        return result;
    }

    public void startElementDecl(QName elementType) {
        this.fDeclElementType = elementType;
        this.fContentModel.clear();
        this.fContentModelOffset = -1;
        this.fContentModelPCDATA = false;
    }

    public void contentModelANY() {
        this.fContentModel.str = "ANY";
    }

    public void contentModelEMPTY() {
        this.fContentModel.str = "EMPTY";
    }

    public void contentModelStartGroup() {
        if (this.fContentModelOffset == -1) {
            this.fContentModelOffset = this.fStringBuffer.getOffset();
        }
        this.fStringBuffer.append(40);
    }

    public void contentModelPCDATA() {
        this.fStringBuffer.append("#PCDATA");
        this.fContentModelPCDATA = true;
    }

    public void contentModelElement(QName elementName) {
        this.fStringBuffer.append(elementName);
    }

    public void contentModelSeparator(int separator) {
        if (separator == 0) {
            this.fStringBuffer.append(124);
        } else {
            this.fStringBuffer.append(44);
        }
    }

    public void contentModelOccurrence(int occurrence) {
        if (occurrence == 0) {
            this.fStringBuffer.append(63);
        } else if (occurrence == 1) {
            this.fStringBuffer.append(42);
        } else {
            this.fStringBuffer.append(43);
        }
    }

    public void contentModelEndGroup() {
        this.fStringBuffer.append(41);
    }

    public void endElementDecl() {
        if (this.fContentModelOffset != -1) {
            if (!this.fContentModelPCDATA) {
                this.fDTDGrammar.setElementContentElement(this.fSymbolTable.addSymbol(this.fDeclElementType));
            }
            this.fStringBuffer.setStringValues(this.fContentModelOffset, this.fStringBuffer.getOffset(), this.fContentModel);
        }
    }

    public void startAttlistDecl(QName elementType) {
        this.fDeclElementType = elementType;
    }

    public void startAttDef(QName attrName, XMLString attType) {
        this.fDeclAttrName = attrName;
        this.fDeclAttType = attType;
        this.fScannedDefaultAttValue = false;
        this.fDTDGrammar.startAttDef(attrName, attType);
    }

    public void startEnumerationType() {
    }

    public void enumerationType(XMLString type) {
        this.fDTDGrammar.enumerationType(type);
    }

    public void endEnumerationType() {
    }

    public void startDefaultAttValue() {
        this.fScannedDefaultAttValue = true;
        this.fDefaultAttValueOffset = -1;
    }

    public void defaultAttValueCharacters(XMLString content) {
        if (content.offset < content.endOffset) {
            if (this.fDefaultAttValueOffset == -1) {
                this.fDefaultAttValueOffset = this.fStringBuffer.getOffset();
            }
            this.fStringBuffer.normalizedAppend(content);
        }
    }

    public void defaultAttValueCharacter(int ch, boolean predefinedEntity) {
        if (this.fDefaultAttValueOffset == -1) {
            this.fDefaultAttValueOffset = this.fStringBuffer.getOffset();
        }
        this.fStringBuffer.append(ch);
    }

    public boolean entityReferenceInDefaultAttValue(XMLName entityName) {
        int entityNameHandle = this.fSymbolTable.addSymbol(entityName);
        return this.fEntityManager.entityReferenceInDefaultAttValue(entityNameHandle);
    }

    public void endAttDef(XMLString defaultType) {
        QName elementType = this.fDeclElementType;
        QName attrName = this.fDeclAttrName;
        XMLString attType = this.fDeclAttType;
        if (this.fDTDGrammar.lookupAttDef(elementType, attrName) == -1) {
            this.fDTDGrammar.saveAttDef(elementType, attrName, attType, defaultType, this.getDefaultAttValueString(attType), this.fEntityManager.inExternalEntity());
        }
    }

    public void endAttlistDecl() {
    }

    private XMLString getDefaultAttValueString(XMLString attType) {
        int endOffset;
        int offset;
        if (!this.fScannedDefaultAttValue) {
            return null;
        }
        if (this.fDefaultAttValueOffset == -1) {
            offset = 0;
            endOffset = 0;
        } else {
            offset = this.fDefaultAttValueOffset;
            endOffset = this.fStringBuffer.getOffset();
        }
        this.fStringBuffer.setStringValues(offset, endOffset, this.fDefaultAttValue);
        return this.fDefaultAttValue;
    }

    public void startEntityValue() {
        this.fEntityValueOffset = -1;
    }

    public void entityValueCharacters(XMLString content) {
        if (content.offset < content.endOffset) {
            if (this.fEntityValueOffset == -1) {
                this.fEntityValueOffset = this.fStringBuffer.getOffset();
            }
            this.fStringBuffer.append(content);
        }
    }

    public void entityValueCharacter(int ch) {
        if (this.fEntityValueOffset == -1) {
            this.fEntityValueOffset = this.fStringBuffer.getOffset();
        }
        this.fStringBuffer.append(ch);
    }

    public void entityReferenceInEntityValue(XMLName entityName) {
        if (this.fEntityValueOffset == -1) {
            this.fEntityValueOffset = this.fStringBuffer.getOffset();
        }
        this.fStringBuffer.append(38);
        this.fStringBuffer.append(entityName);
        this.fStringBuffer.append(59);
    }

    public boolean peReferenceInEntityValue(XMLName peName) {
        int peNameHandle = this.fSymbolTable.addSymbol(peName);
        return this.fEntityManager.peReferenceInEntityValue(peNameHandle);
    }

    public void internalEntityDecl(XMLName entityName) {
        XMLString value = this.getInternalEntityValue();
        this.fEntityDeclPool.addInternalEntityDecl(entityName, value, this.fEntityManager);
    }

    public void externalEntityDecl(XMLName entityName, XMLString publicID, XMLString systemID) {
        if (publicID != null) {
            this.fStringBuffer.normalizePublicID(publicID);
        }
        this.fEntityDeclPool.addExternalEntityDecl(entityName, publicID, systemID, this.fEntityManager);
    }

    public void unparsedEntityDecl(XMLName entityName, XMLString publicID, XMLString systemID, XMLName notationName) {
        if (publicID != null) {
            this.fStringBuffer.normalizePublicID(publicID);
        }
        this.fEntityDeclPool.addUnparsedEntityDecl(entityName);
        String name = entityName.toString();
        if (this.fUnparsedEntities.get(name) == null) {
            String uri = systemID.toString();
            this.fUnparsedEntities.put(name, uri);
        }
    }

    public void internalPEDecl(XMLName peName) {
        XMLString value = this.getInternalEntityValue();
        this.fEntityDeclPool.addInternalPEDecl(peName, value, this.fEntityManager);
    }

    public void externalPEDecl(XMLName peName, XMLString publicID, XMLString systemID) {
        if (publicID != null) {
            this.fStringBuffer.normalizePublicID(publicID);
        }
        this.fEntityDeclPool.addExternalPEDecl(peName, publicID, systemID, this.fEntityManager);
    }

    private XMLString getInternalEntityValue() {
        int endOffset;
        int offset;
        if (this.fEntityValueOffset == -1) {
            offset = 0;
            endOffset = 0;
        } else {
            offset = this.fEntityValueOffset;
            endOffset = this.fStringBuffer.getOffset();
            this.fStringBuffer.append(0);
        }
        this.fStringBuffer.setStringValues(offset, endOffset, this.fInternalEntityValue);
        return this.fInternalEntityValue;
    }

    public void notationDecl(XMLName notationName, XMLString publicID, XMLString systemID) {
        if (publicID != null) {
            this.fStringBuffer.normalizePublicID(publicID);
        }
    }

    public boolean internalSubsetPEReference(XMLName peName) {
        int peNameHandle = this.fSymbolTable.addSymbol(peName);
        return this.fEntityManager.peReference(peNameHandle);
    }

    public boolean externalSubsetPEReference(XMLName peName) {
        int peNameHandle = this.fSymbolTable.addSymbol(peName);
        return this.fEntityManager.peReference(peNameHandle);
    }

    public boolean startPEReferenceWithinMarkup(XMLName peName, int markupDepth) {
        int peNameHandle = this.fSymbolTable.addSymbol(peName);
        return this.fEntityManager.startPEReferenceWithinMarkup(peNameHandle);
    }

    public void endPEReferenceWithinMarkup(int markupDepth) {
        this.fDTDParams.pop();
        this.fEntityManager.endPEReferenceWithinMarkup();
    }

    public boolean scanExternalSubset(ParsedEntity entityContent) {
        boolean result;
        this.fDTDParams.push(entityContent);
        if (this.fUsingReader) {
            if (this.fUTF16ExternalSubsetScanner == null) {
                this.fUTF16ExternalSubsetScanner = new UTF16WFCExternalSubsetScanner(this, this.fUTF16ScannerSupport);
            }
            result = this.fUTF16ExternalSubsetScanner.scanExternalSubset(this.fDTDParams, entityContent);
        } else {
            if (this.fLatinExternalSubsetScanner == null) {
                this.fLatinExternalSubsetScanner = new LatinWFCExternalSubsetScanner(this, this.fLatinScannerSupport);
            }
            result = this.fLatinExternalSubsetScanner.scanExternalSubset(this.fDTDParams, entityContent);
        }
        this.fDTDParams.pop();
        return result;
    }

    public boolean scanIntSubsetDecl(int peName, ParsedEntity entityContent) {
        this.fDTDParams.push(entityContent);
        boolean result = this.fUsingReader ? UTF16WFCInternalSubsetScanner.scanIntSubsetDecl(this, this.fUTF16ScannerSupport, this.fDTDParams, entityContent) : LatinWFCInternalSubsetScanner.scanIntSubsetDecl(this, this.fLatinScannerSupport, this.fDTDParams, entityContent);
        this.fDTDParams.pop();
        return result;
    }

    public boolean scanExtSubsetDecl(int peName, ParsedEntity entityContent) {
        boolean result;
        this.fDTDParams.push(entityContent);
        if (this.fUsingReader) {
            if (this.fUTF16ExternalSubsetScanner == null) {
                this.fUTF16ExternalSubsetScanner = new UTF16WFCExternalSubsetScanner(this, this.fUTF16ScannerSupport);
            }
            result = this.fUTF16ExternalSubsetScanner.scanExtSubsetDecl(this.fDTDParams, entityContent);
        } else {
            if (this.fLatinExternalSubsetScanner == null) {
                this.fLatinExternalSubsetScanner = new LatinWFCExternalSubsetScanner(this, this.fLatinScannerSupport);
            }
            result = this.fLatinExternalSubsetScanner.scanExtSubsetDecl(this.fDTDParams, entityContent);
        }
        this.fDTDParams.pop();
        return result;
    }

    public boolean scanDefaultAttValue(int entityName, ParsedEntity entityContent) {
        this.fDTDParams.push(entityContent);
        boolean result = this.fUsingReader ? UTF16WFCMarkupDeclScanner.scanDefaultAttValue(this, this.fUTF16ScannerSupport, this.fDTDParams, entityContent, 0) : LatinWFCMarkupDeclScanner.scanDefaultAttValue(this, this.fLatinScannerSupport, this.fDTDParams, entityContent, 0);
        this.fDTDParams.pop();
        return result;
    }

    public boolean scanEntityValue(int peName, ParsedEntity entityContent) {
        this.fDTDParams.push(entityContent);
        boolean result = this.fUsingReader ? UTF16WFCMarkupDeclScanner.scanEntityValue(this, this.fUTF16ScannerSupport, this.fDTDParams, entityContent, 0, false) : LatinWFCMarkupDeclScanner.scanEntityValue(this, this.fLatinScannerSupport, this.fDTDParams, entityContent, 0, false);
        this.fDTDParams.pop();
        return result;
    }

    public boolean scanPEWithinMarkup(int peName, ParsedEntity entityContent) {
        this.fDTDParams.push(entityContent);
        if (this.fUsingReader) {
            return this.fUTF16ExternalSubsetScanner.scanPEWithinMarkup(this.fDTDParams, entityContent);
        }
        return this.fLatinExternalSubsetScanner.scanPEWithinMarkup(this.fDTDParams, entityContent);
    }

    public void defaultAttValueCharacter(int entityName, int ch, boolean predefinedEntity) {
        this.defaultAttValueCharacter(ch, predefinedEntity);
    }

    public boolean scanXMLDecl(ParsedEntity entityContent) {
        if (this.fUsingReader) {
            return UTF16WFCExternalEntityScanner.scanXMLDecl(this, this.fScannerSupport, this.fExternalEntityState, entityContent);
        }
        return LatinWFCExternalEntityScanner.scanXMLDecl(this, this.fScannerSupport, this.fExternalEntityState, entityContent);
    }

    public boolean scanTextDecl(ParsedEntity entityContent) {
        if (this.fUsingReader) {
            return UTF16WFCExternalEntityScanner.scanTextDecl(this, this.fScannerSupport, this.fExternalEntityState, entityContent);
        }
        return LatinWFCExternalEntityScanner.scanTextDecl(this, this.fScannerSupport, this.fExternalEntityState, entityContent);
    }

    public boolean scanDocument(ParsedEntity entityContent) {
        if (this.fUsingReader) {
            return UTF16WFCDocumentScanner.scanDocument(this, this, this.fScannerSupport, entityContent);
        }
        return LatinWFCDocumentScanner.scanDocument(this, this, this.fScannerSupport, entityContent);
    }

    public boolean resolveExternalEntity(EntityInputSource source) {
        return true;
    }

    public void attributeValueCharacter(int entityName, int ch, boolean predefinedEntity) {
        this.fScannerSupport.attributeValueCharacter(ch, predefinedEntity);
    }

    public void character(int entityName, int ch, boolean predefinedEntity) {
        this.character(ch, predefinedEntity);
    }

    public boolean scanContent(int entityName, ParsedEntity entityContent) {
        if (this.fUsingReader) {
            return UTF16WFCDocumentScanner.scanContent(this, this, this.fScannerSupport, entityContent);
        }
        return LatinWFCDocumentScanner.scanContent(this, this, this.fScannerSupport, entityContent);
    }

    public boolean scanAttValue(int entityName, ParsedEntity entityContent) {
        if (this.fUsingReader) {
            return UTF16WFCDocumentScanner.scanAttValue(this, this, this.fScannerSupport, entityContent, 0);
        }
        return LatinWFCDocumentScanner.scanAttValue(this, this, this.fScannerSupport, entityContent, 0);
    }

    public boolean recursiveReferenceInContent(int entityName, String referencePath) {
        Object[] args = new String[]{this.fSymbolTable.toString(entityName), referencePath};
        this.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 108, args);
        return false;
    }

    public boolean undeclaredEntityInContent(String entityName) {
        Object[] args = new String[]{entityName};
        this.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 47, args);
        return false;
    }

    public boolean skippedEntityInContent(int entityName) {
        return true;
    }

    public boolean unparsedEntityInContent(int entityName) {
        Object[] args = new String[]{this.fSymbolTable.toString(entityName)};
        this.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 107, args);
        return false;
    }

    public boolean externallyDeclaredEntityInContent(String entityName) {
        Object[] args = new String[]{entityName};
        this.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 73, args);
        return true;
    }

    public boolean recursiveReferenceInAttValue(int entityName, String referencePath) {
        Object[] args = new String[]{this.fSymbolTable.toString(entityName), referencePath};
        this.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 108, args);
        return false;
    }

    public boolean undeclaredEntityInAttValue(String entityName) {
        Object[] args = new String[]{entityName};
        this.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 47, args);
        return false;
    }

    public boolean externalEntityInAttValue(int entityName) {
        Object[] args = new String[]{this.fSymbolTable.toString(entityName)};
        this.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 105, args);
        return false;
    }

    public boolean externallyDeclaredEntityInAttValue(String entityName) {
        Object[] args = new String[]{entityName};
        this.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 73, args);
        return true;
    }

    public boolean skippedParameterEntity(int peName) {
        return true;
    }

    public boolean recursiveReferenceInDefaultAttValue(int entityName, String referencePath) {
        Object[] args = new String[]{this.fSymbolTable.toString(entityName), referencePath};
        this.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 108, args);
        return false;
    }

    public boolean undeclaredEntityInDefaultAttValue(int entityName) {
        Object[] args = new String[]{this.fSymbolTable.toString(entityName)};
        this.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 47, args);
        return false;
    }

    public boolean externalEntityInDefaultAttValue(int entityName) {
        Object[] args = new String[]{this.fSymbolTable.toString(entityName)};
        this.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 105, args);
        return false;
    }

    public boolean externallyDeclaredEntityInDefaultAttValue(String entityName) {
        Object[] args = new String[]{entityName};
        this.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 73, args);
        return true;
    }

    public boolean skippedExternalSubsetEntity() {
        return true;
    }

    public boolean recursivePEReference(int peName, String referencePath) {
        Object[] args = new String[]{this.fSymbolTable.toString(peName), referencePath};
        this.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 109, args);
        return false;
    }

    public boolean undeclaredParameterEntity(int peName) {
        Object[] args = new String[]{this.fSymbolTable.toString(peName)};
        this.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 106, args);
        return true;
    }
}

