/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xslt4j.bcel.generic;

import com.ibm.xslt4j.bcel.ExceptionConstants;
import com.ibm.xslt4j.bcel.classfile.ConstantPool;
import com.ibm.xslt4j.bcel.generic.AllocationInstruction;
import com.ibm.xslt4j.bcel.generic.ArrayType;
import com.ibm.xslt4j.bcel.generic.CPInstruction;
import com.ibm.xslt4j.bcel.generic.ClassGenException;
import com.ibm.xslt4j.bcel.generic.ConstantPoolGen;
import com.ibm.xslt4j.bcel.generic.ExceptionThrower;
import com.ibm.xslt4j.bcel.generic.LoadClass;
import com.ibm.xslt4j.bcel.generic.ObjectType;
import com.ibm.xslt4j.bcel.generic.Type;
import com.ibm.xslt4j.bcel.generic.Visitor;
import com.ibm.xslt4j.bcel.util.ByteSequence;
import java.io.DataOutputStream;
import java.io.IOException;

public class MULTIANEWARRAY
extends CPInstruction
implements LoadClass,
AllocationInstruction,
ExceptionThrower {
    private short dimensions;

    MULTIANEWARRAY() {
    }

    public MULTIANEWARRAY(int index, short dimensions) {
        super((short)197, index);
        if (dimensions < 1) {
            throw new ClassGenException("Invalid dimensions value: " + dimensions);
        }
        this.dimensions = dimensions;
        this.length = (short)4;
    }

    public void dump(DataOutputStream out) throws IOException {
        out.writeByte(this.opcode);
        out.writeShort(this.index);
        out.writeByte(this.dimensions);
    }

    protected void initFromFile(ByteSequence bytes, boolean wide) throws IOException {
        super.initFromFile(bytes, wide);
        this.dimensions = bytes.readByte();
        this.length = (short)4;
    }

    public final short getDimensions() {
        return this.dimensions;
    }

    public String toString(boolean verbose) {
        return String.valueOf(super.toString(verbose)) + " " + this.index + " " + this.dimensions;
    }

    public String toString(ConstantPool cp) {
        return String.valueOf(super.toString(cp)) + " " + this.dimensions;
    }

    public int consumeStack(ConstantPoolGen cpg) {
        return this.dimensions;
    }

    public Class[] getExceptions() {
        Class[] cs = new Class[2 + ExceptionConstants.EXCS_CLASS_AND_INTERFACE_RESOLUTION.length];
        System.arraycopy(ExceptionConstants.EXCS_CLASS_AND_INTERFACE_RESOLUTION, 0, cs, 0, ExceptionConstants.EXCS_CLASS_AND_INTERFACE_RESOLUTION.length);
        cs[ExceptionConstants.EXCS_CLASS_AND_INTERFACE_RESOLUTION.length + 1] = ExceptionConstants.NEGATIVE_ARRAY_SIZE_EXCEPTION;
        cs[ExceptionConstants.EXCS_CLASS_AND_INTERFACE_RESOLUTION.length] = ExceptionConstants.ILLEGAL_ACCESS_ERROR;
        return cs;
    }

    public ObjectType getLoadClassType(ConstantPoolGen cpg) {
        Type t = this.getType(cpg);
        if (t instanceof ArrayType) {
            t = ((ArrayType)t).getBasicType();
        }
        return t instanceof ObjectType ? (ObjectType)t : null;
    }

    public void accept(Visitor v) {
        v.visitLoadClass(this);
        v.visitAllocationInstruction(this);
        v.visitExceptionThrower(this);
        v.visitTypedInstruction(this);
        v.visitCPInstruction(this);
        v.visitMULTIANEWARRAY(this);
    }
}

