/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.xpath;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.xml.xpath.SecuritySupport12;

class SecuritySupport {
    private static final Object securitySupport;

    SecuritySupport() {
    }

    public static SecuritySupport getInstance() {
        return (SecuritySupport)securitySupport;
    }

    public ClassLoader getContextClassLoader() {
        return null;
    }

    public String getSystemProperty(String string) {
        return System.getProperty(string);
    }

    public FileInputStream getFileInputStream(File file) throws FileNotFoundException {
        return new FileInputStream(file);
    }

    public Enumeration getResources(ClassLoader classLoader, String string) {
        final URL uRL = this.getResource(classLoader, string);
        return new Enumeration(){
            boolean more = true;

            public boolean hasMoreElements() {
                return this.more && uRL != null;
            }

            public Object nextElement() {
                if (!this.hasMoreElements()) {
                    throw new NoSuchElementException();
                }
                this.more = false;
                return uRL;
            }
        };
    }

    private URL getResource(ClassLoader classLoader, String string) {
        URL uRL = classLoader == null ? ClassLoader.getSystemResource(string) : classLoader.getResource(string);
        return uRL;
    }

    public boolean getFileExists(File file) {
        return file.exists();
    }

    public long getLastModified(File file) {
        return file.lastModified();
    }

    static {
        SecuritySupport securitySupport = null;
        try {
            try {
                Class<?> clazz = Class.forName("java.security.AccessController");
                securitySupport = new SecuritySupport12();
            }
            catch (Exception exception) {
                Object var3_4 = null;
                if (securitySupport == null) {
                    securitySupport = new SecuritySupport();
                }
                SecuritySupport.securitySupport = securitySupport;
            }
            Object var3_3 = null;
            if (securitySupport == null) {
                securitySupport = new SecuritySupport();
            }
            SecuritySupport.securitySupport = securitySupport;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            if (securitySupport == null) {
                securitySupport = new SecuritySupport();
            }
            SecuritySupport.securitySupport = securitySupport;
            throw throwable;
        }
    }
}

