/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.xpath;

import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactoryConfigurationException;
import javax.xml.xpath.XPathFactoryFinder;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;

public abstract class XPathFactory {
    public static final String DEFAULT_OBJECT_MODEL_URI = "http://java.sun.com/jaxp/xpath/dom";
    public static final String DEFAULT_PROPERTY_NAME = "javax.xml.xpath.XPathFactory";

    protected XPathFactory() {
    }

    public static final XPathFactory newInstance() {
        try {
            return XPathFactory.newInstance(DEFAULT_OBJECT_MODEL_URI);
        }
        catch (XPathFactoryConfigurationException xPathFactoryConfigurationException) {
            throw new RuntimeException(xPathFactoryConfigurationException.toString());
        }
    }

    public static final XPathFactory newInstance(String string) throws XPathFactoryConfigurationException {
        if (string == null) {
            throw new NullPointerException("null uri in XPathFactory.newInstance(String uri)");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("uri cannot be empty string in XPathFactory.newInstance(String uri)");
        }
        try {
            return (XPathFactory)XPathFactoryFinder.find(DEFAULT_PROPERTY_NAME, string, "org.apache.xpath.jaxp.XPathFactoryImpl");
        }
        catch (XPathFactoryFinder.ConfigurationError configurationError) {
            if (configurationError.getException() != null) {
                throw new XPathFactoryConfigurationException(configurationError.getException());
            }
            throw new XPathFactoryConfigurationException(configurationError.getMessage());
        }
    }

    public abstract boolean isObjectModelSupported(String var1);

    public abstract void setFeature(String var1, boolean var2) throws XPathFactoryConfigurationException;

    public abstract boolean getFeature(String var1) throws XPathFactoryConfigurationException;

    public abstract void setXPathVariableResolver(XPathVariableResolver var1);

    public abstract void setXPathFunctionResolver(XPathFunctionResolver var1);

    public abstract XPath newXPath();
}

