/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.jaxp;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.validation.Schema;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.apache.xerces.dom.DOMMessageFormatter;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.jaxp.DefaultValidationErrorHandler;
import org.apache.xerces.jaxp.DocumentBuilderFactoryImpl;
import org.apache.xerces.jaxp.ExternalSchemaValidator;
import org.apache.xerces.jaxp.JAXPConstants;
import org.apache.xerces.jaxp.validation.XSGrammarPoolContainer;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xerces.util.SecurityManager;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class DocumentBuilderImpl
extends DocumentBuilder
implements JAXPConstants {
    private DOMParser domParser = null;
    private Schema fSchema = null;
    private ExternalSchemaValidator fExternalSchemaValidator;
    private boolean fIsXIncludeAware;
    private final ErrorHandler fErrorHandler;
    private final EntityResolver fEntityResolver;
    protected static final String NAMESPACES_FEATURE = "http://xml.org/sax/features/namespaces";
    protected static final String INCLUDE_IGNORABLE_WHITESPACE = "http://apache.org/xml/features/dom/include-ignorable-whitespace";
    protected static final String CREATE_ENTITY_REF_NODES_FEATURE = "http://apache.org/xml/features/dom/create-entity-ref-nodes";
    protected static final String INCLUDE_COMMENTS_FEATURE = "http://apache.org/xml/features/include-comments";
    protected static final String CREATE_CDATA_NODES_FEATURE = "http://apache.org/xml/features/create-cdata-nodes";
    private static final String XINCLUDE_FEATURE = "http://apache.org/xml/features/xinclude";
    protected static final String XMLSCHEMA_VALIDATION = "http://apache.org/xml/features/validation/schema";
    protected static final String VALIDATION_FEATURE = "http://xml.org/sax/features/validation";
    protected static final String USE_GRAMMAR_POOL_ONLY = "http://apache.org/xml/features/internal/validation/schema/use-grammar-pool-only";
    private static final String SECURITY_MANAGER = "http://apache.org/xml/properties/security-manager";
    protected static final String XMLGRAMMAR_POOL = "http://apache.org/xml/properties/internal/grammar-pool";

    DocumentBuilderImpl(DocumentBuilderFactoryImpl documentBuilderFactoryImpl, Hashtable hashtable, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        this(documentBuilderFactoryImpl, hashtable, false, bl);
    }

    DocumentBuilderImpl(DocumentBuilderFactoryImpl documentBuilderFactoryImpl, Hashtable hashtable, boolean bl, boolean bl2) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.fIsXIncludeAware = documentBuilderFactoryImpl.isXIncludeAware();
        this.fSchema = documentBuilderFactoryImpl.getSchema();
        this.domParser = new DOMParser();
        this.domParser.setFeature(VALIDATION_FEATURE, documentBuilderFactoryImpl.isValidating());
        if (this.fSchema != null) {
            if (this.fSchema instanceof XSGrammarPoolContainer) {
                this.domParser.setFeature(XMLSCHEMA_VALIDATION, true);
                if (!documentBuilderFactoryImpl.isValidating()) {
                    this.domParser.setFeature(VALIDATION_FEATURE, true);
                }
                if (!bl2) {
                    this.domParser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
                }
                this.domParser.setProperty(XMLGRAMMAR_POOL, ((XSGrammarPoolContainer)((Object)this.fSchema)).getGrammarPool());
                this.domParser.setFeature(USE_GRAMMAR_POOL_ONLY, ((XSGrammarPoolContainer)((Object)this.fSchema)).isFullyComposed());
            } else {
                XMLParserConfiguration xMLParserConfiguration = this.domParser.getXMLParserConfiguration();
                this.fExternalSchemaValidator = new ExternalSchemaValidator(this.fSchema, xMLParserConfiguration);
                xMLParserConfiguration.setDocumentHandler(this.fExternalSchemaValidator);
                this.fExternalSchemaValidator.setDocumentHandler(this.domParser);
                this.domParser.setDocumentSource(this.fExternalSchemaValidator);
                if (!bl2) {
                    this.domParser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
                }
            }
        }
        this.domParser.getXMLParserConfiguration().addRecognizedFeatures(new String[]{XINCLUDE_FEATURE});
        if (this.fIsXIncludeAware) {
            this.domParser.setFeature(XINCLUDE_FEATURE, true);
        }
        if (bl) {
            this.domParser.setProperty(SECURITY_MANAGER, new SecurityManager());
        }
        if (documentBuilderFactoryImpl.isValidating()) {
            this.fErrorHandler = new DefaultValidationErrorHandler();
            this.setErrorHandler(this.fErrorHandler);
        } else {
            this.fErrorHandler = this.domParser.getErrorHandler();
        }
        this.domParser.setFeature(NAMESPACES_FEATURE, documentBuilderFactoryImpl.isNamespaceAware());
        this.domParser.setFeature(INCLUDE_IGNORABLE_WHITESPACE, !documentBuilderFactoryImpl.isIgnoringElementContentWhitespace());
        this.domParser.setFeature(CREATE_ENTITY_REF_NODES_FEATURE, !documentBuilderFactoryImpl.isExpandEntityReferences());
        this.domParser.setFeature(INCLUDE_COMMENTS_FEATURE, !documentBuilderFactoryImpl.isIgnoringComments());
        this.domParser.setFeature(CREATE_CDATA_NODES_FEATURE, !documentBuilderFactoryImpl.isCoalescing());
        this.setDocumentBuilderFactoryAttributes(hashtable);
        this.fEntityResolver = this.domParser.getEntityResolver();
    }

    private void setDocumentBuilderFactoryAttributes(Hashtable hashtable) throws SAXNotSupportedException, SAXNotRecognizedException {
        if (hashtable == null) {
            return;
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object v = hashtable.get(string);
            if (v instanceof Boolean) {
                this.domParser.setFeature(string, (Boolean)v);
                continue;
            }
            if ("http://java.sun.com/xml/jaxp/properties/schemaLanguage".equals(string)) {
                if (!"http://www.w3.org/2001/XMLSchema".equals(v) || !this.isValidating()) continue;
                this.domParser.setFeature(XMLSCHEMA_VALIDATION, true);
                this.domParser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
                continue;
            }
            if ("http://java.sun.com/xml/jaxp/properties/schemaSource".equals(string)) {
                if (!this.isValidating()) continue;
                String string2 = (String)hashtable.get("http://java.sun.com/xml/jaxp/properties/schemaLanguage");
                if (string2 != null && "http://www.w3.org/2001/XMLSchema".equals(string2)) {
                    this.domParser.setProperty(string, v);
                    continue;
                }
                throw new IllegalArgumentException(DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "jaxp-order-not-supported", new Object[]{"http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://java.sun.com/xml/jaxp/properties/schemaSource"}));
            }
            this.domParser.setProperty(string, v);
        }
    }

    public Document newDocument() {
        return new DocumentImpl();
    }

    public DOMImplementation getDOMImplementation() {
        return DOMImplementationImpl.getDOMImplementation();
    }

    public Document parse(InputSource inputSource) throws SAXException, IOException {
        if (inputSource == null) {
            throw new IllegalArgumentException(DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "jaxp-null-input-source", null));
        }
        this.domParser.parse(inputSource);
        Document document = this.domParser.getDocument();
        this.domParser.dropDocumentReferences();
        return document;
    }

    public boolean isNamespaceAware() {
        try {
            return this.domParser.getFeature(NAMESPACES_FEATURE);
        }
        catch (SAXException sAXException) {
            throw new IllegalStateException(sAXException.getMessage());
        }
    }

    public boolean isValidating() {
        try {
            return this.domParser.getFeature(VALIDATION_FEATURE);
        }
        catch (SAXException sAXException) {
            throw new IllegalStateException(sAXException.getMessage());
        }
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.domParser.setEntityResolver(entityResolver);
        if (this.fExternalSchemaValidator != null) {
            this.fExternalSchemaValidator.reset(this.domParser.getXMLParserConfiguration());
        }
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.domParser.setErrorHandler(errorHandler);
        if (this.fExternalSchemaValidator != null) {
            this.fExternalSchemaValidator.reset(this.domParser.getXMLParserConfiguration());
        }
    }

    public void reset() {
        this.domParser.setEntityResolver(this.fEntityResolver);
        this.domParser.setErrorHandler(this.fErrorHandler);
        if (this.fExternalSchemaValidator != null) {
            this.fExternalSchemaValidator.reset(this.domParser.getXMLParserConfiguration());
        }
    }

    public Schema getSchema() {
        return this.fSchema;
    }

    public boolean isXIncludeAware() {
        return this.fIsXIncludeAware;
    }

    DOMParser getDOMParser() {
        return this.domParser;
    }
}

