/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.jaxp;

import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.res.XPATHMessages;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.InputSource;

public class XPathExpressionImpl
implements XPathExpression {
    private XPath m_xpath = null;
    private PrefixResolver m_prefixResolver = null;
    private boolean m_isSecureProcessing = false;

    protected XPathExpressionImpl(XPath xpath, PrefixResolver prefixResolver, boolean isSecureProcessing) {
        this.m_xpath = xpath;
        this.m_prefixResolver = prefixResolver;
        this.m_isSecureProcessing = isSecureProcessing;
    }

    public Object evaluate(Object item, QName returnType) throws XPathExpressionException {
        XPathContext xctxt = new XPathContext(false);
        if (this.m_isSecureProcessing) {
            xctxt.setSecureProcessing(true);
        }
        int contextNode = XPathExpressionImpl.getContextNodeHandle(item, xctxt);
        try {
            XObject xobj = this.m_xpath.execute(xctxt, contextNode, this.m_prefixResolver);
            return XPathExpressionImpl.xObjectToObject(xobj, returnType);
        }
        catch (TransformerException te) {
            Throwable containedException = te.getException();
            if (containedException instanceof XPathExpressionException) {
                throw (XPathExpressionException)containedException;
            }
            throw new XPathExpressionException(te);
        }
    }

    public String evaluate(Object item) throws XPathExpressionException {
        return (String)this.evaluate(item, XPathConstants.STRING);
    }

    public Object evaluate(InputSource source, QName returnType) throws XPathExpressionException {
        if (source == null) {
            throw new NullPointerException(XPATHMessages.createXPATHMessage("ER_NULL_INPUT_SOURCE", null));
        }
        Document doc = null;
        try {
            DocumentBuilder builder = XPathExpressionImpl.getDocumentBuilder(this.m_isSecureProcessing);
            doc = builder.parse(source);
        }
        catch (Exception e) {
            throw new XPathExpressionException(e);
        }
        return this.evaluate(doc, returnType);
    }

    public String evaluate(InputSource source) throws XPathExpressionException {
        return (String)this.evaluate(source, XPathConstants.STRING);
    }

    private static int getContextNodeHandle(Object item, XPathContext xctxt) throws XPathExpressionException {
        Node node = null;
        if (item == null) {
            try {
                node = XPathExpressionImpl.getDocumentBuilder(xctxt.isSecureProcessing()).newDocument();
            }
            catch (ParserConfigurationException pce) {
                throw new XPathExpressionException(pce);
            }
        } else if (item instanceof Node) {
            node = (Node)item;
        } else if (item instanceof NodeList) {
            node = ((NodeList)item).item(0);
        } else if (item instanceof NodeIterator) {
            node = ((NodeIterator)item).nextNode();
        } else {
            throw new XPathExpressionException(XPATHMessages.createXPATHMessage("ER_UNSUPPORTED_CONTEXT_ITEM", new Object[]{item}));
        }
        return xctxt.getDTMHandleFromNode(node);
    }

    private static DocumentBuilder getDocumentBuilder(boolean isSecureProcessing) throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        try {
            if (isSecureProcessing) {
                factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        return factory.newDocumentBuilder();
    }

    private static Object xObjectToObject(XObject xobj, QName returnType) throws TransformerException {
        if (returnType == null) {
            throw new NullPointerException(XPATHMessages.createXPATHMessage("ER_NULL_XPATH_RETURN_TYPE", null));
        }
        if (returnType.equals(XPathConstants.STRING)) {
            return xobj.str();
        }
        if (returnType.equals(XPathConstants.NUMBER)) {
            return new Double(xobj.num());
        }
        if (returnType.equals(XPathConstants.BOOLEAN)) {
            return new Boolean(xobj.bool());
        }
        if (returnType.equals(XPathConstants.NODESET)) {
            return xobj.nodelist();
        }
        if (returnType.equals(XPathConstants.NODE)) {
            return xobj.nodeset().nextNode();
        }
        throw new IllegalArgumentException(XPATHMessages.createXPATHMessage("ER_INVALID_XPATH_RETURN_TYPE", new Object[]{returnType}));
    }
}

