/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.jdbc;

import com.ibm.db2.jcc.SQLJCallableStatement;
import com.ibm.db2.jcc.SQLJColumnMetaData;
import com.ibm.db2.jcc.SQLJPreparedStatement;
import com.ibm.db2.jcc.SQLJResultSet;
import com.ibm.db2.jcc.SQLJSection;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.jdbc.WSJccConnection;
import com.ibm.ws.rsadapter.jdbc.WSJccResultSet;
import com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement;
import com.ibm.ws.rsadapter.jdbc.WSJdbcConnection;
import com.ibm.ws.rsadapter.jdbc.WSJdbcObject;
import com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet;
import com.ibm.ws.rsadapter.jdbc.WSJdbcUtil;
import com.ibm.ws.rsadapter.spi.StatementCacheKey;
import java.sql.BatchUpdateException;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;

public class WSJccCallableStatement
extends WSJdbcCallableStatement
implements SQLJCallableStatement {
    private static final TraceComponent tc = Tr.register((Class)WSJccCallableStatement.class, (String)"RRA", (String)"IBMDataStoreAdapterNLS");
    private static final String[] PMI_EXECUTE_BATCH = new String[]{SQLJPreparedStatement.class.getName(), "executeBatch(boolean)"};
    private SQLJCallableStatement sqljCstmtImpl;

    WSJccCallableStatement(CallableStatement callableStatement, WSJccConnection wSJccConnection, int n, String string) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object)new Object[]{AdapterUtil.toString((Object)callableStatement), wSJccConnection, AdapterUtil.getCursorHoldabilityString((int)n)});
        }
        this.cstmtImpl = callableStatement;
        this.pstmtImpl = this.cstmtImpl;
        this.stmtImpl = this.cstmtImpl;
        this.parentWrapper = wSJccConnection;
        this.pmi = wSJccConnection.pmi;
        this.metrics = this.parentWrapper.metrics;
        this.sql = string;
        this.holdability = n;
        try {
            this.__mcf = ((WSJdbcConnection)this.parentWrapper).managedConn.getManagedConnectionFactory();
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Caught something, we will just log and ignore.  This will only disable usage of mcf later (this, t)", (Object)new Object[]{this, throwable});
            }
            Tr.warning((TraceComponent)tc, (String)"WS_INTERNAL_WARNING", (Object)new Object[]{throwable, "", ""});
        }
        try {
            this.currentFetchSize = this.pstmtImpl.getFetchSize();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJccCallableStatement.<init>", (String)"57", (Object)((Object)this));
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"<init>", (Object)"Exception");
            }
            throw WSJdbcUtil.mapException((WSJdbcObject)this, (SQLException)sQLException);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("current fetchSize is " + this.currentFetchSize));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)((Object)this));
        }
    }

    WSJccCallableStatement(CallableStatement callableStatement, WSJccConnection wSJccConnection, int n, String string, StatementCacheKey statementCacheKey) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object)new Object[]{AdapterUtil.toString((Object)callableStatement), wSJccConnection, AdapterUtil.getCursorHoldabilityString((int)n), statementCacheKey});
        }
        this.cstmtImpl = callableStatement;
        this.pstmtImpl = this.cstmtImpl;
        this.stmtImpl = this.cstmtImpl;
        this.parentWrapper = wSJccConnection;
        this.pmi = wSJccConnection.pmi;
        this.metrics = wSJccConnection.metrics;
        this.sql = string;
        this.key = statementCacheKey;
        this.holdability = n;
        try {
            this.__mcf = ((WSJdbcConnection)this.parentWrapper).managedConn.getManagedConnectionFactory();
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Caught something, we will just log and ignore.  This will only disable usage of mcf later (this, t)", (Object)new Object[]{this, throwable});
            }
            Tr.warning((TraceComponent)tc, (String)"WS_INTERNAL_WARNING", (Object)new Object[]{throwable, "", ""});
        }
        try {
            this.currentFetchSize = this.pstmtImpl.getFetchSize();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJccCallableStatement.<init>", (String)"109", (Object)((Object)this));
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"<init>", (Object)"Exception");
            }
            throw WSJdbcUtil.mapException((WSJdbcObject)this, (SQLException)sQLException);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("current fetchSize is " + this.currentFetchSize));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)((Object)this));
        }
    }

    public final void addBatch(SQLJPreparedStatement sQLJPreparedStatement) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"addBatch", (Object)new Object[]{this, AdapterUtil.toString((Object)sQLJPreparedStatement)});
        }
        try {
            this.getSQLJCallableStatement().addBatch(sQLJPreparedStatement);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)(((Object)((Object)this)).getClass().getName() + ".addBatch"), (String)"159", (Object)((Object)this));
            throw WSJdbcUtil.mapException((WSJdbcObject)this, (SQLException)sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    final RuntimeException checkIfClosed(RuntimeException runtimeException) {
        return this.state == 2 ? new RuntimeException(AdapterUtil.getNLSMessage((String)"OBJECT_CLOSED", (Object)"Statement")) : runtimeException;
    }

    protected final SQLException closeWrapper(boolean bl) {
        this.sqljCstmtImpl = null;
        return super.closeWrapper(bl);
    }

    protected final WSJdbcResultSet createResultSetWrapper(ResultSet resultSet) {
        return new WSJccResultSet(resultSet, (WSJdbcObject)this);
    }

    public int[] executeBatch(boolean bl) throws SQLException {
        int[] nArray;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"executeBatch", (Object)new Object[]{this, bl ? Boolean.TRUE : Boolean.FALSE});
        }
        try {
            if (this.childWrapper != null) {
                this.closeAndRemoveResultSet();
            }
            if (this.childWrappers != null && !this.childWrappers.isEmpty()) {
                this.closeAndRemoveResultSets();
            }
            this.beginTransactionIfNecessary();
            this.enforceStatementProperties();
            nArray = this.pmi == null && !this.metrics.isInteractionMetricsEnabled() ? this.getSQLJCallableStatement().executeBatch(bl) : this.pmiExecuteBatch(bl);
        }
        catch (BatchUpdateException batchUpdateException) {
            FFDCFilter.processException((Throwable)batchUpdateException, (String)(((Object)((Object)this)).getClass().getName() + ".executeBatch"), (String)"327", (Object)((Object)this));
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Check for Connection Error", (Object)new Object[]{AdapterUtil.getStackTraceWithState((SQLException)batchUpdateException)});
            }
            try {
                WSJccConnection wSJccConnection = (WSJccConnection)this.parentWrapper;
                if (wSJccConnection.helper.isConnectionError((SQLException)batchUpdateException)) {
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Encountered a Stale Connection: ", (Object)((Object)wSJccConnection));
                    }
                    wSJccConnection.fireConnectionErrorEvent(batchUpdateException);
                }
            }
            catch (NullPointerException nullPointerException) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"executeBatch", (Object)"Exception");
                }
                throw this.runtimeXIfNotClosed(nullPointerException);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"executeBatch", (Object)"Exception");
            }
            throw batchUpdateException;
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)(((Object)((Object)this)).getClass().getName() + ".executeBatch"), (String)"260", (Object)((Object)this));
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"executeBatch", (Object)"Exception");
            }
            throw WSJdbcUtil.mapException((WSJdbcObject)this, (SQLException)sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"executeBatch", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < nArray.length; ++i) {
                stringBuffer.append(i).append(' ');
            }
            Tr.exit((TraceComponent)tc, (String)"executeBatch", (Object)new String(stringBuffer));
        }
        return nArray;
    }

    public final int executeSetCurrentPackageset() throws SQLException {
        try {
            return this.getSQLJCallableStatement().executeSetCurrentPackageset();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)(((Object)((Object)this)).getClass().getName() + "executeSetCurrentPackageset"), (String)"300", (Object)((Object)this));
            throw WSJdbcUtil.mapException((WSJdbcObject)this, (SQLException)sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final Object[] getInputs() {
        try {
            return this.getSQLJCallableStatement().getInputs();
        }
        catch (NullPointerException nullPointerException) {
            throw this.checkIfClosed(nullPointerException);
        }
    }

    public final SQLJColumnMetaData getParameterColumnMetaData() throws SQLException {
        try {
            return this.getSQLJCallableStatement().getParameterColumnMetaData();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)(((Object)((Object)this)).getClass().getName() + ".getParameterColumnMetaData"), (String)"383", (Object)((Object)this));
            throw WSJdbcUtil.mapException((WSJdbcObject)this, (SQLException)sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final SQLJColumnMetaData getResultSetColumnMetaData() throws SQLException {
        try {
            return this.getSQLJCallableStatement().getResultSetColumnMetaData();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)(((Object)((Object)this)).getClass().getName() + ".getResultSetColumnMetaData"), (String)"403", (Object)((Object)this));
            throw WSJdbcUtil.mapException((WSJdbcObject)this, (SQLException)sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final SQLJSection getSection() {
        try {
            return this.getSQLJCallableStatement().getSection();
        }
        catch (NullPointerException nullPointerException) {
            throw this.checkIfClosed(nullPointerException);
        }
    }

    public SQLJResultSet getSingletonResultSet() {
        WSJccResultSet wSJccResultSet;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSingletonResultSet", (Object)((Object)this));
        }
        try {
            SQLJResultSet sQLJResultSet = this.getSQLJCallableStatement().getSingletonResultSet();
            if (sQLJResultSet == null) {
                wSJccResultSet = null;
            } else if (this.childWrapper == null && (this.childWrappers == null || this.childWrappers.isEmpty())) {
                wSJccResultSet = new WSJccResultSet((ResultSet)sQLJResultSet, (WSJdbcObject)this);
                this.childWrapper = wSJccResultSet;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Set the result set to child wrapper");
                }
            } else {
                if (this.childWrappers == null) {
                    this.childWrappers = new ArrayList(5);
                }
                wSJccResultSet = new WSJccResultSet((ResultSet)sQLJResultSet, (WSJdbcObject)this);
                this.childWrappers.add(wSJccResultSet);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Add the result set to child wrappers list.");
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getSingletonResultSet", (Object)"Exception");
            }
            throw this.checkIfClosed(nullPointerException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getSingletonResultSet", wSJccResultSet);
        }
        return wSJccResultSet;
    }

    private final SQLJCallableStatement getSQLJCallableStatement() {
        return this.sqljCstmtImpl == null ? (this.sqljCstmtImpl = (SQLJCallableStatement)this.cstmtImpl) : this.sqljCstmtImpl;
    }

    public final boolean getSQLJSingletonQuery() {
        try {
            return this.getSQLJCallableStatement().getSQLJSingletonQuery();
        }
        catch (NullPointerException nullPointerException) {
            throw this.checkIfClosed(nullPointerException);
        }
    }

    private int[] pmiExecuteBatch(boolean bl) throws SQLException {
        int[] nArray = null;
        Object object = null;
        int n = 0;
        Exception exception = null;
        Properties properties = null;
        if (this.metrics.isInteractionMetricsEnabled()) {
            object = this.metrics.preInteraction(PMI_EXECUTE_BATCH);
        }
        if (this.pmi != null) {
            this.pmi.jdbcOperationStarted();
        }
        try {
            nArray = this.getSQLJCallableStatement().executeBatch(bl);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)(((Object)((Object)this)).getClass().getName() + ".pmiExecuteBatch"), (String)"537", (Object)((Object)this));
            exception = sQLException;
            n = 2;
        }
        catch (RuntimeException runtimeException) {
            FFDCFilter.processException((Throwable)runtimeException, (String)(((Object)((Object)this)).getClass().getName() + ".pmiExecuteBatch"), (String)"544", (Object)((Object)this));
            exception = runtimeException;
            n = 2;
        }
        if (this.pmi != null) {
            this.pmi.jdbcOperationCompleted();
        }
        switch (this.metrics.getTranDetailLevel()) {
            case 2: 
            case 3: {
                properties = new Properties();
                properties.setProperty("SQLString", this.sql);
                properties.setProperty("DataSourceJNDIName", this.getJNDIName());
            }
            case 1: {
                this.metrics.postInteraction(object, n, properties);
            }
        }
        if (exception == null) {
            return nArray;
        }
        if (exception instanceof SQLException) {
            throw exception;
        }
        throw (RuntimeException)exception;
    }

    public final void setInputs(Object[] objectArray) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setInputs (# of inputs = " + objectArray.length + ")"));
        }
        try {
            this.getSQLJCallableStatement().setInputs(objectArray);
        }
        catch (NullPointerException nullPointerException) {
            throw this.checkIfClosed(nullPointerException);
        }
    }

    public final void setSection(SQLJSection sQLJSection) {
        try {
            this.getSQLJCallableStatement().setSection(sQLJSection);
        }
        catch (NullPointerException nullPointerException) {
            throw this.checkIfClosed(nullPointerException);
        }
    }

    public final void setSQLJSingletonQuery(boolean bl) {
        try {
            this.getSQLJCallableStatement().setSQLJSingletonQuery(bl);
        }
        catch (NullPointerException nullPointerException) {
            throw this.checkIfClosed(nullPointerException);
        }
    }

    public void setQueryInstanceIdentifier(long l) {
        try {
            this.getSQLJCallableStatement().setQueryInstanceIdentifier(l);
        }
        catch (NullPointerException nullPointerException) {
            throw this.checkIfClosed(nullPointerException);
        }
    }
}

