/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.basic;

import com.ibm.gsk.ikeyman.basic.BERObject;
import com.ibm.gsk.ikeyman.basic.BERObjectParser;
import com.ibm.gsk.ikeyman.basic.DNItem;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Vector;

public class DNItem
extends BERObject
implements BERObjectParser {
    private String cn;
    private String ou;
    private String o;
    private String l;
    private String s;
    private String pc;
    private String c;
    private String em;
    private Vector optional;

    public DNItem() {
        this(null, null, null, null, null, null, null, null, null);
    }

    public DNItem(byte[] byArray) {
        super(byArray);
    }

    public DNItem(String string, String string2, String string3, String string4) {
        this(string, string2, string3, null, null, null, string4, null);
    }

    public DNItem(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        this.cn = string;
        this.ou = string2;
        this.o = string3;
        this.l = string4;
        this.s = string5;
        this.pc = string6;
        this.c = string7;
        this.em = string8;
        this.optional = null;
        this.collapse();
    }

    public DNItem(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, byte[] byArray) {
        this.cn = string;
        this.ou = string2;
        this.o = string3;
        this.l = string4;
        this.s = string5;
        this.pc = string6;
        this.c = string7;
        this.em = string8;
        this.optional = null;
        this.setEncoded(byArray);
    }

    public void expand() {
    }

    public void collapse() {
        this.berData = null;
    }

    public boolean isValidDN() {
        if (this.cn != null && this.cn.length() > 64) {
            return false;
        }
        if (this.ou != null && this.ou.length() > 64) {
            return false;
        }
        if (this.o != null && this.o.length() > 64) {
            return false;
        }
        if (this.l != null && this.l.length() > 64) {
            return false;
        }
        if (this.s != null && (this.s.length() > 64 || this.s.length() < 3)) {
            return false;
        }
        return this.c == null || this.c.length() == 2;
    }

    public String getCommonName() {
        return this.cn;
    }

    public String getOrganizationUnit() {
        return this.ou;
    }

    public String getOrganization() {
        return this.o;
    }

    public String getLocality() {
        return this.l;
    }

    public String getState() {
        return this.s;
    }

    public String getCountryName() {
        return this.c;
    }

    public String getZipCode() {
        return this.pc;
    }

    public String getEmailAddr() {
        return this.em;
    }

    public Vector getOptional() {
        return this.optional;
    }

    public void setOptional(Vector vector) {
        if (vector == null) {
            this.optional = null;
        } else {
            if (this.optional == null) {
                this.optional = new Vector();
            } else {
                this.optional.removeAllElements();
            }
            int n = 0;
            while (n < vector.size()) {
                String string = (String)vector.elementAt(n);
                this.optional.addElement(string);
                ++n;
            }
        }
    }

    public void addOptionalField(String string) {
        if (string == null) {
            return;
        }
        if (this.optional == null) {
            this.optional = new Vector();
        }
        this.optional.addElement(string);
    }

    public String getRFC1779String() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.cn != null) {
            stringBuffer.append("cn=\"" + this.cn + "\"");
        }
        if (this.ou != null) {
            Strings strings = StringSplitterImpl.getStringSplitter().getStrings(this.ou, ',', '\\');
            LinkedList<String> linkedList = new LinkedList<String>();
            while (strings.hasNext()) {
                linkedList.add(strings.next());
            }
            ListIterator listIterator = linkedList.listIterator(linkedList.size());
            while (listIterator.hasPrevious()) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append("ou=\"" + listIterator.previous() + "\"");
            }
        }
        if (this.o != null) {
            stringBuffer.append(",o=\"" + this.o + "\"");
        }
        if (this.l != null) {
            stringBuffer.append(",l=\"" + this.l + "\"");
        }
        if (this.s != null) {
            stringBuffer.append(",st=\"" + this.s + "\"");
        }
        if (this.pc != null) {
            stringBuffer.append(",POSTALCODE=\"" + this.pc + "\"");
        }
        if (this.c != null) {
            stringBuffer.append(",c=\"" + this.c + "\"");
        }
        if (this.em != null) {
            stringBuffer.append(",email=\"" + this.em + "\"");
        }
        return new String(stringBuffer);
    }

    public String toStringWithoutTag() {
        String string = "";
        String string2 = "";
        if (this.cn != null) {
            string = this.cn;
        }
        if (this.ou != null) {
            string = (!string.equals("") ? string + "\n" : "") + this.ou;
        }
        if (this.o != null) {
            string = (!string.equals("") ? string + "\n" : "") + this.o;
        }
        if (this.l != null) {
            string2 = this.l;
        }
        if (this.s != null) {
            string2 = (!string2.equals("") ? string2 + ", " : "") + this.s;
        }
        if (this.pc != null) {
            string2 = (!string2.equals("") ? string2 + ", " : "") + this.pc;
        }
        if (this.c != null) {
            string2 = (!string2.equals("") ? string2 + ", " : "") + this.c;
        }
        if (string2 != null) {
            string = (!string.equals("") ? string + "\n" : "") + string2;
        }
        if (this.em != null) {
            string = (!string.equals("") ? string + "\n" : "") + this.em;
        }
        if (this.optional != null) {
            string = (!string.equals("") ? string + "\n" : "") + this.optional.toString();
        }
        return string;
    }

    public String toStringWithoutTagForKeyInfo() {
        String string = "";
        String string2 = "";
        if (this.cn != null) {
            string = "cn=" + this.cn;
        }
        if (this.ou != null) {
            string = (!string.equals("") ? string + "\n" : "") + "ou=" + this.ou;
        }
        if (this.o != null) {
            string = (!string.equals("") ? string + "\n" : "") + "o =" + this.o;
        }
        if (this.l != null) {
            string2 = "l =" + this.l;
        }
        if (this.s != null) {
            string2 = (!string2.equals("") ? string2 + ", " : "") + "s =" + this.s;
        }
        if (this.pc != null) {
            string2 = (!string2.equals("") ? string2 + ", " : "") + "pc=" + this.pc;
        }
        if (this.c != null) {
            string2 = (!string2.equals("") ? string2 + ", " : "") + "c =" + this.c;
        }
        if (string2 != null) {
            string = (!string.equals("") ? string + "\n" : "") + string2;
        }
        if (this.em != null) {
            string = (!string.equals("") ? string + "\n" : "") + "em=" + this.em;
        }
        if (this.optional != null) {
            string = (!string.equals("") ? string + "\n" : "") + this.optional.toString();
        }
        return string;
    }

    public String toString() {
        return this.paramString();
    }

    public String paramString() {
        String string = "";
        if (this.cn != null) {
            string = string + ", CN=" + this.cn;
        }
        if (this.ou != null) {
            string = string + ", OU=" + this.ou;
        }
        if (this.o != null) {
            string = string + ", O=" + this.o;
        }
        if (this.l != null) {
            string = string + ", L=" + this.l;
        }
        if (this.s != null) {
            string = string + ", S=" + this.s;
        }
        if (this.pc != null) {
            string = string + ", PC=" + this.pc;
        }
        if (this.c != null) {
            string = string + ", C=" + this.c;
        }
        if (this.em != null) {
            string = string + ", EM=" + this.em;
        }
        if (this.optional != null) {
            string = string + ", OPT=" + this.optional.toString();
        }
        return super.toString() + string;
    }

    public static final class StringSplitterImpl {
        private static final StringSplitter x = new StringSplitter(){

            public Strings getStrings(String string, char c, char c2) throws NullPointerException {
                if (string == null) {
                    throw new NullPointerException();
                }
                char[] cArray = new char[string.length()];
                LinkedList<String> linkedList = new LinkedList<String>();
                boolean bl = false;
                int n = 0;
                int n2 = 0;
                while (n2 < string.length()) {
                    char c3 = string.charAt(n2);
                    if (bl) {
                        if (c3 != c && c3 != c2) {
                            cArray[n++] = 92;
                        }
                        cArray[n++] = c3;
                        bl = false;
                    } else if (c3 == c) {
                        linkedList.add(new String(cArray, 0, n));
                        n = 0;
                    } else if (c3 == c2) {
                        bl = true;
                    } else {
                        cArray[n++] = c3;
                        bl = false;
                    }
                    ++n2;
                }
                if (n > 0) {
                    linkedList.add(new String(cArray, 0, n));
                }
                return new Strings(this, linkedList){
                    private final Iterator i;
                    private int position;
                    private final /* synthetic */ List val$strings;
                    private final /* synthetic */ 1 this$0;
                    {
                        this.this$0 = var1_1;
                        this.val$strings = list;
                        this.i = this.val$strings.iterator();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    public String next() throws NoSuchElementException {
                        if (this.hasNext()) {
                            ++this.position;
                            return (String)this.i.next();
                        }
                        throw new NoSuchElementException();
                    }

                    public int getPosition() {
                        return this.position;
                    }
                };
            }
        };

        private StringSplitterImpl() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        public static StringSplitter getStringSplitter() {
            return x;
        }
    }

    public static interface StringSplitter {
        public Strings getStrings(String var1, char var2, char var3) throws NullPointerException;
    }

    public static interface Strings {
        public boolean hasNext();

        public String next() throws NoSuchElementException;
    }
}

