/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.basic;

import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.PKIXExtensions;

public class KMExtensionItem {
    public static final int FIELD_TYPE_UNKNOWN = 0;
    public static final int FIELD_TYPE_EMAIL = 1;
    public static final int FIELD_TYPE_IPADDR = 7;
    public static final int FIELD_TYPE_DNSNAME = 2;
    public static final int FIELD_TYPE_BASIC_CONSTRAINT = Integer.MIN_VALUE;
    private ObjectIdentifier asn1oid;
    private int fieldType;
    private Object fieldValue;
    private ObjectIdentifier defaultAsn1oid;

    public KMExtensionItem() {
        this.defaultAsn1oid = PKIXExtensions.SubjectAlternativeName_Id;
        this.asn1oid = null;
        this.fieldType = 0;
        this.fieldValue = null;
    }

    public KMExtensionItem(int n, Object object) {
        this.asn1oid = this.defaultAsn1oid = PKIXExtensions.SubjectAlternativeName_Id;
        this.fieldType = n;
        this.fieldValue = object;
    }

    public KMExtensionItem(ObjectIdentifier objectIdentifier, int n, Object object) {
        this.defaultAsn1oid = PKIXExtensions.SubjectAlternativeName_Id;
        this.asn1oid = objectIdentifier;
        this.fieldType = n;
        this.fieldValue = object;
    }

    public ObjectIdentifier getAsn1oid() {
        return this.asn1oid;
    }

    public ObjectIdentifier getDefaultAsn1oid() {
        return this.defaultAsn1oid;
    }

    public int getFieldType() {
        return this.fieldType;
    }

    public Object getFieldValue() {
        return this.fieldValue;
    }

    public static boolean isValidFieldType(int n) {
        return n == 1 || n == 7 || n == 2 || n == Integer.MIN_VALUE;
    }
}

