/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.basic;

import com.ibm.gsk.ikeyman.basic.CMSKeyDatabase;
import com.ibm.gsk.ikeyman.basic.EncryptedPrivateKeyInfoItem;
import com.ibm.gsk.ikeyman.basic.IkeymanConstants;
import com.ibm.gsk.ikeyman.basic.KMSystem;
import com.ibm.gsk.ikeyman.basic.KMUtil;
import com.ibm.gsk.ikeyman.basic.KeyDatabaseException;
import com.ibm.gsk.ikeyman.basic.KeyDatabaseOperator;
import com.ibm.gsk.ikeyman.basic.KeyDatabaseOperatorNullException;
import com.ibm.gsk.ikeyman.basic.KeyItem;
import com.ibm.gsk.ikeyman.basic.PrivateKeyInfoItem;
import com.ibm.gsk.ikeyman.basic.SSLightKeyDatabase;
import com.ibm.gsk.ikeyman.basic.WEBDBKeyDatabase;
import java.io.File;
import java.io.IOException;
import java.util.Vector;

public class KeyDatabase
implements IkeymanConstants {
    public static final int MAX_KEY_DATABASE_TYPE_INDEX = 10;
    public static final int KEY_DATABASE_TYPE_UNKNOWN = 0;
    public static final int KEY_DATABASE_TYPE_CMS = 1;
    public static final int KEY_DATABASE_TYPE_WEBDB = 2;
    public static final int KEY_DATABASE_TYPE_SSLIGHT = 3;
    public static final int KEY_DATABASE_TYPE_SSLINK = 4;
    public static final int KEY_DATABASE_TYPE_CDSA = 5;
    public static final int KEY_DATABASE_TYPE_BERKELEY = 6;
    public static final int KEY_STORAGE_TYPE_PKCS12 = 7;
    public static final int KEY_STORAGE_DATA_TYPE_BASE64 = 8;
    public static final int KEY_STORAGE_DATA_TYPE_DER = 9;
    public static final int KEY_STORAGE_DATA_TYPE_SSLIGHT = 10;
    public static String DEFAULT_KEYDB_LOCATION_CMS = null;
    public static String DEFAULT_KEYDB_LOCATION_WEBDB = null;
    public static String DEFAULT_KEYDB_LOCATION_SSLIGHT = null;
    public static String DEFAULT_KEYDB_LOCATION_SSLINK = null;
    public static String DEFAULT_KEYDB_LOCATION_CDSA = null;
    public static String DEFAULT_KEYDB_LOCATION_BERKELEY = null;
    public static String DEFAULT_PKCS12_FILE_LOCATION = null;
    public static String DEFAULT_SSLIGHT_EXTRACT_FILE_LOCATION = null;
    public static String DEFAULT_SSLIGHT_PACKAGE_NAME = null;
    public static String DEFAULT_KEYDB_NAME_CMS = "key.kdb";
    public static String DEFAULT_KEYDB_NAME_WEBDB = "keyfile.kyr";
    public static String DEFAULT_KEYDB_NAME_SSLIGHT = "keyring.class";
    public static String DEFAULT_SSLIGHT_EXTRACT_FILE_NAME = "keyring.class";
    public static String DEFAULT_KEYDB_NAME_SSLINK = "keyring.ksl";
    public static String DEFAULT_KEYDB_NAME_CDSA = "cdsakey.kdl";
    public static String DEFAULT_KEYDB_NAME_BERKELEY = "key.db";
    public static String DEFAULT_PKCS12_FILE_NAME = "key.p12";
    public static String DEFAULT_CERTREQ_NAME = "certreq.arm";
    public static String DEFAULT_CERTIFICATE_NAME_ARM = "cert.arm";
    public static String DEFAULT_CERTIFICATE_NAME_BIN = "cert.crt";
    public static String DEFAULT_CERTIFICATE_NAME_DER = "cert.der";
    public static String DEFAULT_CERTIFICATE_NAME_PEM = "cert.pem";
    public static String DEFAULT_KEYDB_NAME_EXT_CMS = ".kdb";
    public static String DEFAULT_KEYDB_NAME_EXT_WEBDB = ".kyr";
    public static String DEFAULT_KEYDB_NAME_EXT_SSLIGHT = ".class";
    public static String DEFAULT_KEYDB_NAME_EXT_SSLINK = ".ksl";
    public static String DEFAULT_KEYDB_NAME_EXT_CDSA = ".kdl";
    public static String DEFAULT_KEYDB_NAME_EXT_BERKELEY = ".db";
    public static String DEFAULT_PKCS12_FILE_NAME_EXT = ".p12";
    public static String DEFAULT_BASE64_FILE_NAME_EXT = ".arm";
    public static String DEFAULT_DER_FILE_NAME_EXT = ".der";
    public static String DEFAULT_PEM_FILE_NAME_EXT = ".pem";
    public static final String DEFAULT_KEYDB_NAME_EXT_CMS_REQUEST = ".rdb";
    public static final String DEFAULT_KEYDB_NAME_EXT_CMS_CRL = ".crl";
    public static final String DEFAULT_BINARY_CERT_FILE_NAME_EXT = ".crt";
    public static final String DEFAULT_PASSWORD_STASH_FILE_NAME_EXT = ".sth";
    public static String DEFAULT_PKCS12_EXPORT_VERSION = "3";
    public static int DEFAULT_1_BROWSER_ITERATION_COUNT = 1;
    public static String DEFAULT_1_BROWSER_ENC_ALGORITHM = "SHA1_RC2_40";
    public static int DEFAULT_2_IKEYMAN_ITERATION_COUNT = 5;
    public static String DEFAULT_2_IKEYMAN_ENC_ALGORITHM = "SHA1_3DES3";
    public static int DEFAULT_PKCS12_ENCODE_TYPE = 2;
    public static String DEFAULT_PKCS12_GUI_POPUPS = "1";
    public static String DEFAULT_CRYPTOGRAPHIC_MODULE = null;
    protected String keyDbFileName;
    protected String keyDbPwd;
    protected long keyDbPwdExpireTime;
    protected int type;
    protected KeyDatabaseOperator op = null;
    protected Vector keyLabelList = null;
    protected Vector caCertLabelList = null;
    protected Vector myCertLabelList = null;
    protected Vector reqKeyLabelList = null;
    protected Vector crlLabelList = null;
    protected Vector siteCertLabelList = null;
    protected int currentKeyIndex;
    protected static boolean defaultCMSFileLocationSpecified = false;
    protected static boolean defaultWEBDBFileLocationSpecified = false;
    protected static boolean defaultSSLIGHTFileLocationSpecified = false;
    protected static boolean defaultSSLINKFileLocationSpecified = false;
    protected static boolean defaultCDSAFileLocationSpecified = false;
    protected static boolean defaultBERKELEYFileLocationSpecified = false;

    public KeyDatabase() {
        this.type = 0;
        this.keyDbFileName = null;
        this.keyDbPwd = null;
        this.keyDbPwdExpireTime = 0L;
    }

    public KeyDatabase(KeyDatabase keyDatabase) {
        this.type = keyDatabase.getType();
        this.keyDbFileName = keyDatabase.getKeyDbFileName();
        this.keyDbPwd = keyDatabase.getKeyDbPwd();
        this.keyDbPwdExpireTime = keyDatabase.getKeyDbPwdExpireTime();
        this.setKeyLabelList(keyDatabase.getKeyLabelList());
        this.setCaCertLabelList(keyDatabase.getCaCertLabelList());
        this.setMyCertLabelList(keyDatabase.getMyCertLabelList());
        this.setReqKeyLabelList(keyDatabase.getReqKeyLabelList());
        this.setCrlLabelList(keyDatabase.getCrlLabelList());
        this.setSiteCertLabelList(keyDatabase.getSiteCertLabelList());
    }

    public KeyDatabase(int n, String string) {
        this(n, string, "");
    }

    public KeyDatabase(int n, String string, String string2) {
        this(n, string, string2, 0L);
    }

    public KeyDatabase(int n, String string, String string2, long l) {
        this.type = n;
        this.keyDbFileName = string;
        this.keyDbPwd = string2;
        this.keyDbPwdExpireTime = l;
    }

    public void delete() throws IOException, KeyDatabaseException {
        File file = new File(this.keyDbFileName);
        String string = file.getCanonicalPath();
        if (!file.exists()) {
            throw new KeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_FILE_NOT_FOUND"));
        }
        file.delete();
    }

    public static void loadInitSetting() {
        String string = null;
        string = KMUtil.getFullPathFileName(KMSystem.getInitSetting("DEFAULT_KEYDB_LOCATION_CMS"));
        if (string != null) {
            DEFAULT_KEYDB_LOCATION_CMS = string;
            defaultCMSFileLocationSpecified = true;
        } else {
            DEFAULT_KEYDB_LOCATION_CMS = KMSystem.getWorkingDirName();
        }
        string = KMUtil.getFullPathFileName(KMSystem.getInitSetting("DEFAULT_KEYDB_LOCATION_WEBDB"));
        if (string != null) {
            DEFAULT_KEYDB_LOCATION_WEBDB = string;
            defaultWEBDBFileLocationSpecified = true;
        } else {
            DEFAULT_KEYDB_LOCATION_WEBDB = KMSystem.getWorkingDirName();
        }
        string = KMUtil.getFullPathFileName(KMSystem.getInitSetting("DEFAULT_KEYDB_LOCATION_SSLIGHT"));
        if (string != null) {
            DEFAULT_KEYDB_LOCATION_SSLIGHT = string;
            defaultSSLIGHTFileLocationSpecified = true;
        } else {
            DEFAULT_KEYDB_LOCATION_SSLIGHT = KMSystem.getWorkingDirName();
        }
        string = KMUtil.getFullPathFileName(KMSystem.getInitSetting("DEFAULT_KEYDB_LOCATION_SSLINK"));
        if (string != null) {
            DEFAULT_KEYDB_LOCATION_SSLINK = string;
            defaultSSLINKFileLocationSpecified = true;
        } else {
            DEFAULT_KEYDB_LOCATION_SSLINK = KMSystem.getWorkingDirName();
        }
        string = KMUtil.getFullPathFileName(KMSystem.getInitSetting("DEFAULT_KEYDB_LOCATION_CDSA"));
        if (string != null) {
            DEFAULT_KEYDB_LOCATION_CDSA = string;
            defaultCDSAFileLocationSpecified = true;
        } else {
            DEFAULT_KEYDB_LOCATION_CDSA = KMSystem.getWorkingDirName();
        }
        string = KMUtil.getFullPathFileName(KMSystem.getInitSetting("DEFAULT_KEYDB_LOCATION_BERKELEY"));
        if (string != null) {
            DEFAULT_KEYDB_LOCATION_BERKELEY = string;
            defaultBERKELEYFileLocationSpecified = true;
        } else {
            DEFAULT_KEYDB_LOCATION_BERKELEY = KMSystem.getWorkingDirName();
        }
        string = KMUtil.getFullPathFileName(KMSystem.getInitSetting("DEFAULT_PKCS12_FILE_LOCATION"));
        DEFAULT_PKCS12_FILE_LOCATION = string != null ? string : KMSystem.getWorkingDirName();
        string = KMUtil.getFullPathFileName(KMSystem.getInitSetting("DEFAULT_SSLIGHT_EXTRACT_FILE_LOCATION"));
        DEFAULT_SSLIGHT_EXTRACT_FILE_LOCATION = string != null ? string : DEFAULT_KEYDB_LOCATION_SSLIGHT;
        string = KMSystem.getInitSetting("DEFAULT_SSLIGHT_PACKAGE_NAME");
        if (string != null) {
            DEFAULT_SSLIGHT_PACKAGE_NAME = string;
        }
        if ((string = KMSystem.getInitSetting("DEFAULT_KEYDB_NAME_CMS")) != null && KMUtil.isValidFileName(string)) {
            DEFAULT_KEYDB_NAME_CMS = string;
        }
        if ((string = KMSystem.getInitSetting("DEFAULT_KEYDB_NAME_WEBDB")) != null && KMUtil.isValidFileName(string)) {
            DEFAULT_KEYDB_NAME_WEBDB = string;
        }
        if ((string = KMSystem.getInitSetting("DEFAULT_KEYDB_NAME_SSLIGHT")) != null && KMUtil.isValidFileName(string)) {
            DEFAULT_KEYDB_NAME_SSLIGHT = string;
        }
        if ((string = KMSystem.getInitSetting("DEFAULT_SSLIGHT_EXTRACT_FILE_NAME")) != null && KMUtil.isValidFileName(string)) {
            DEFAULT_SSLIGHT_EXTRACT_FILE_NAME = string;
        }
        if ((string = KMSystem.getInitSetting("DEFAULT_KEYDB_NAME_SSLINK")) != null && KMUtil.isValidFileName(string)) {
            DEFAULT_KEYDB_NAME_SSLINK = string;
        }
        if ((string = KMSystem.getInitSetting("DEFAULT_KEYDB_NAME_CDSA")) != null && KMUtil.isValidFileName(string)) {
            DEFAULT_KEYDB_NAME_CDSA = string;
        }
        if ((string = KMSystem.getInitSetting("DEFAULT_KEYDB_NAME_BERKELEY")) != null && KMUtil.isValidFileName(string)) {
            DEFAULT_KEYDB_NAME_BERKELEY = string;
        }
        if ((string = KMSystem.getInitSetting("DEFAULT_PKCS12_FILE_NAME")) != null && KMUtil.isValidFileName(string)) {
            DEFAULT_PKCS12_FILE_NAME = string;
        }
        if ((string = KMSystem.getInitSetting("DEFAULT_CERTREQ_NAME")) != null && KMUtil.isValidFileName(string)) {
            DEFAULT_CERTREQ_NAME = string;
        }
        if ((string = KMSystem.getInitSetting("DEFAULT_CERTIFICATE_NAME_ARM")) != null && KMUtil.isValidFileName(string)) {
            DEFAULT_CERTIFICATE_NAME_ARM = string;
        }
        if ((string = KMSystem.getInitSetting("DEFAULT_CERTIFICATE_NAME_DER")) != null && KMUtil.isValidFileName(string)) {
            DEFAULT_CERTIFICATE_NAME_DER = string;
        }
        if ((string = KMSystem.getInitSetting("DEFAULT_CERTIFICATE_NAME_PEM")) != null && KMUtil.isValidFileName(string)) {
            DEFAULT_CERTIFICATE_NAME_PEM = string;
        }
        if ((string = KMSystem.getInitSetting("DEFAULT_KEYDB_NAME_EXT_CMS")) != null) {
            DEFAULT_KEYDB_NAME_EXT_CMS = string;
        }
        if ((string = KMSystem.getInitSetting("DEFAULT_KEYDB_NAME_EXT_WEBDB")) != null) {
            DEFAULT_KEYDB_NAME_EXT_WEBDB = string;
        }
        if ((string = KMSystem.getInitSetting("DEFAULT_KEYDB_NAME_EXT_SSLIGHT")) != null) {
            DEFAULT_KEYDB_NAME_EXT_SSLIGHT = string;
        }
        if ((string = KMSystem.getInitSetting("DEFAULT_KEYDB_NAME_EXT_SSLINK")) != null) {
            DEFAULT_KEYDB_NAME_EXT_SSLINK = string;
        }
        if ((string = KMSystem.getInitSetting("DEFAULT_KEYDB_NAME_EXT_CDSA")) != null) {
            DEFAULT_KEYDB_NAME_EXT_CDSA = string;
        }
        if ((string = KMSystem.getInitSetting("DEFAULT_KEYDB_NAME_EXT_BERKELEY")) != null) {
            DEFAULT_KEYDB_NAME_EXT_BERKELEY = string;
        }
        if ((string = KMSystem.getInitSetting("DEFAULT_PKCS12_FILE_NAME_EXT")) != null) {
            DEFAULT_PKCS12_FILE_NAME_EXT = string;
        }
        if ((string = KMSystem.getInitSetting("DEFAULT_BASE64_FILE_NAME_EXT")) != null) {
            DEFAULT_BASE64_FILE_NAME_EXT = string;
        }
        if ((string = KMSystem.getInitSetting("DEFAULT_DER_FILE_NAME_EXT")) != null) {
            DEFAULT_DER_FILE_NAME_EXT = string;
        }
        if ((string = KMSystem.getInitSetting("DEFAULT_PEM_FILE_NAME_EXT")) != null) {
            DEFAULT_PEM_FILE_NAME_EXT = string;
        }
        if ((string = KMSystem.getInitSetting("DEFAULT_PKCS12_GUI_POPUPS")) != null) {
            DEFAULT_PKCS12_GUI_POPUPS = string;
        }
        if ((string = KMSystem.getInitSetting("DEFAULT_PKCS12_EXPORT_VERSION")) != null) {
            DEFAULT_PKCS12_EXPORT_VERSION = string;
        }
        if ((string = KMSystem.getInitSetting("DEFAULT_1_BROWSER_ITERATION_COUNT")) != null) {
            try {
                DEFAULT_1_BROWSER_ITERATION_COUNT = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                DEFAULT_1_BROWSER_ITERATION_COUNT = 1;
            }
        }
        if ((string = KMSystem.getInitSetting("DEFAULT_1_BROWSER_ENC_ALGORITHM")) != null) {
            DEFAULT_1_BROWSER_ENC_ALGORITHM = string;
        }
        if ((string = KMSystem.getInitSetting("DEFAULT_2_IKEYMAN_ITERATION_COUNT")) != null) {
            try {
                DEFAULT_2_IKEYMAN_ITERATION_COUNT = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                DEFAULT_2_IKEYMAN_ITERATION_COUNT = 5;
            }
        }
        if ((string = KMSystem.getInitSetting("DEFAULT_2_IKEYMAN_ENC_ALGORITHM")) != null) {
            DEFAULT_2_IKEYMAN_ENC_ALGORITHM = string;
        }
        if ((string = KMSystem.getInitSetting("DEFAULT_PKCS12_ENCODE_TYPE")) != null) {
            try {
                DEFAULT_PKCS12_ENCODE_TYPE = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                DEFAULT_PKCS12_ENCODE_TYPE = 1;
            }
        }
        if ((string = KMUtil.getFullPathFileName(KMSystem.getInitSetting("DEFAULT_CRYPTOGRAPHIC_MODULE"))) != null) {
            DEFAULT_CRYPTOGRAPHIC_MODULE = string;
        }
    }

    public KeyDatabaseOperator getKeyDatabaseOperator() throws KeyDatabaseOperatorNullException {
        if (this.op == null) {
            throw new KeyDatabaseOperatorNullException();
        }
        return this.op;
    }

    public void setKeyDatabaseOperator(KeyDatabaseOperator keyDatabaseOperator) {
        this.op = keyDatabaseOperator;
    }

    public static int[] getSupportedDatabaseTypes() {
        Integer n;
        Integer n2;
        Vector<Integer> vector = new Vector<Integer>();
        int[] nArray = null;
        if (KMSystem.isJNIEnabled()) {
            n2 = new Integer(1);
            vector.addElement(n2);
            n = new Integer(2);
            vector.addElement(n);
        }
        if (KMSystem.getVersion() >= 17) {
            n2 = new Integer(3);
            vector.addElement(n2);
            if (KMSystem.getVersion() >= 32) {
                n = new Integer(4);
                vector.addElement(n);
                Integer n3 = new Integer(5);
                vector.addElement(n3);
                Integer n4 = new Integer(6);
                vector.addElement(n4);
            }
        }
        if (!vector.isEmpty()) {
            nArray = new int[vector.size()];
            int n5 = 0;
            while (n5 < nArray.length) {
                nArray[n5] = (Integer)vector.elementAt(n5);
                ++n5;
            }
        }
        return nArray;
    }

    public static int[] getSupportedDatabaseTypes(int n) {
        if (n == 0) {
            return KeyDatabase.getSupportedDatabaseTypes();
        }
        int[] nArray = new int[]{n};
        return nArray;
    }

    public String getKeyDbFileName() {
        return this.keyDbFileName;
    }

    public String getKeyDbFileNameWithType(int n) {
        if (n == this.type) {
            return this.keyDbFileName;
        }
        return KMUtil.changeFileNameExtension(this.keyDbFileName, KeyDatabase.getKeyDbFileExtensionWithType(n));
    }

    public void setKeyDbFileName(String string) {
        this.keyDbFileName = string;
    }

    public String getKeyDbPwd() {
        return this.keyDbPwd;
    }

    public long getKeyDbPwdExpireTime() {
        return this.keyDbPwdExpireTime;
    }

    public void setKeyDbPwd(String string) {
        this.keyDbPwd = string;
    }

    public void setKeyDbPwdExpireTime(long l) {
        this.keyDbPwdExpireTime = l;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public Vector getKeyLabelList() {
        return this.keyLabelList;
    }

    public Vector getCaCertLabelList() {
        return this.caCertLabelList;
    }

    public Vector getMyCertLabelList() {
        return this.myCertLabelList;
    }

    public Vector getReqKeyLabelList() {
        return this.reqKeyLabelList;
    }

    public Vector getCrlLabelList() {
        return this.crlLabelList;
    }

    public Vector getSiteCertLabelList() {
        return this.siteCertLabelList;
    }

    protected void copyVector(Vector vector, Vector vector2) {
        if (vector == null) {
            vector2 = null;
            return;
        }
        if (vector2 == null) {
            vector2 = new Vector<String>();
        } else {
            vector2.removeAllElements();
        }
        int n = 0;
        while (n < vector.size()) {
            String string = (String)vector.elementAt(n);
            vector2.addElement(string);
            ++n;
        }
    }

    public void setKeyLabelList(Vector vector) {
        if (this.keyLabelList == null) {
            this.keyLabelList = new Vector();
        } else {
            this.keyLabelList.removeAllElements();
        }
        this.copyVector(vector, this.keyLabelList);
    }

    public void setCaCertLabelList(Vector vector) {
        if (this.caCertLabelList == null) {
            this.caCertLabelList = new Vector();
        } else {
            this.caCertLabelList.removeAllElements();
        }
        this.copyVector(vector, this.caCertLabelList);
    }

    public void setMyCertLabelList(Vector vector) {
        if (this.myCertLabelList == null) {
            this.myCertLabelList = new Vector();
        } else {
            this.myCertLabelList.removeAllElements();
        }
        this.copyVector(vector, this.myCertLabelList);
    }

    public void setReqKeyLabelList(Vector vector) {
        if (this.reqKeyLabelList == null) {
            this.reqKeyLabelList = new Vector();
        } else {
            this.reqKeyLabelList.removeAllElements();
        }
        this.copyVector(vector, this.reqKeyLabelList);
    }

    public void setCrlLabelList(Vector vector) {
        if (this.crlLabelList == null) {
            this.crlLabelList = new Vector();
        } else {
            this.crlLabelList.removeAllElements();
        }
        this.copyVector(vector, this.crlLabelList);
    }

    public void setSiteCertLabelList(Vector vector) {
        if (this.siteCertLabelList == null) {
            this.siteCertLabelList = new Vector();
        } else {
            this.siteCertLabelList.removeAllElements();
        }
        this.copyVector(vector, this.siteCertLabelList);
    }

    public void copyKeyLabelLists(KeyDatabase keyDatabase) {
        this.setKeyLabelList(keyDatabase.getKeyLabelList());
        this.setReqKeyLabelList(keyDatabase.getReqKeyLabelList());
        this.setCaCertLabelList(keyDatabase.getCaCertLabelList());
        this.setMyCertLabelList(keyDatabase.getMyCertLabelList());
        this.setCrlLabelList(keyDatabase.getCrlLabelList());
        this.setSiteCertLabelList(keyDatabase.getSiteCertLabelList());
    }

    public int getKeyCount() {
        if (this.keyLabelList == null) {
            return 0;
        }
        return this.keyLabelList.size();
    }

    public int getCaCertCount() {
        if (this.caCertLabelList == null) {
            return 0;
        }
        return this.caCertLabelList.size();
    }

    public int getMyCertCount() {
        if (this.myCertLabelList == null) {
            return 0;
        }
        return this.myCertLabelList.size();
    }

    public int getReqKeyCount() {
        if (this.reqKeyLabelList == null) {
            return 0;
        }
        return this.reqKeyLabelList.size();
    }

    public int getCrlCount() {
        if (this.crlLabelList == null) {
            return 0;
        }
        return this.crlLabelList.size();
    }

    public int getSiteCertCount() {
        if (this.siteCertLabelList == null) {
            return 0;
        }
        return this.siteCertLabelList.size();
    }

    public void addKeyLabel(String string) {
        if (string == null) {
            return;
        }
        if (this.keyLabelList == null) {
            this.keyLabelList = new Vector();
        }
        this.keyLabelList.addElement(string);
    }

    public void addCaCertLabel(String string) {
        if (string == null) {
            return;
        }
        if (this.caCertLabelList == null) {
            this.caCertLabelList = new Vector();
        }
        this.caCertLabelList.addElement(string);
    }

    public void addMyCertLabel(String string) {
        if (string == null) {
            return;
        }
        if (this.myCertLabelList == null) {
            this.myCertLabelList = new Vector();
        }
        this.myCertLabelList.addElement(string);
    }

    public void addReqKeyLabel(String string) {
        if (string == null) {
            return;
        }
        if (this.reqKeyLabelList == null) {
            this.reqKeyLabelList = new Vector();
        }
        this.reqKeyLabelList.addElement(string);
    }

    public void addCrlLabel(String string) {
        if (string == null) {
            return;
        }
        if (this.crlLabelList == null) {
            this.crlLabelList = new Vector();
        }
        this.crlLabelList.addElement(string);
    }

    public void addSiteCertLabel(String string) {
        if (string == null) {
            return;
        }
        if (this.siteCertLabelList == null) {
            this.siteCertLabelList = new Vector();
        }
        this.siteCertLabelList.addElement(string);
    }

    public void addKeyLabelAt(String string, int n) {
        KMUtil.debugMsg("KeyDatabase::addKeyLabelAt 0000, aLabel=" + (string == null ? "null" : string) + ", pos=" + n);
        if (string == null) {
            KMUtil.debugMsg("KeyDatabase::addKeyLabelAt 9999-1");
            return;
        }
        if (this.keyLabelList == null) {
            this.keyLabelList = new Vector();
        }
        this.keyLabelList.insertElementAt(string, n);
        KMUtil.debugMsg("KeyDatabase::addKeyLabelAt 9999");
    }

    public void addCaCertLabelAt(String string, int n) {
        KMUtil.debugMsg("KeyDatabase::addCaCertLabelAt 0000, aLabel=" + (string == null ? "null" : string) + ", pos=" + n);
        if (string == null) {
            KMUtil.debugMsg("KeyDatabase::addCaCertLabelAt 9999-1");
            return;
        }
        if (this.caCertLabelList == null) {
            this.caCertLabelList = new Vector();
        }
        this.caCertLabelList.insertElementAt(string, n);
        KMUtil.debugMsg("KeyDatabase::addCaCertLabelAt 9999");
    }

    public void addMyCertLabelAt(String string, int n) {
        KMUtil.debugMsg("KeyDatabase::addMyCertLabelAt 0000, aLabel=" + (string == null ? "null" : string) + ", pos=" + n);
        if (string == null) {
            KMUtil.debugMsg("KeyDatabase::addMyCertLabelAt 9999-1");
            return;
        }
        if (this.myCertLabelList == null) {
            this.myCertLabelList = new Vector();
        }
        this.myCertLabelList.insertElementAt(string, n);
        KMUtil.debugMsg("KeyDatabase::addMyCertLabelAt 9999");
    }

    public void addReqKeyLabelAt(String string, int n) {
        KMUtil.debugMsg("KeyDatabase::addReqKeyLabelAt 0000, aLabel=" + (string == null ? "null" : string) + ", pos=" + n);
        if (string == null) {
            KMUtil.debugMsg("KeyDatabase::addReqKeyLabelAt 9999-1");
            return;
        }
        if (this.reqKeyLabelList == null) {
            this.reqKeyLabelList = new Vector();
        }
        this.reqKeyLabelList.insertElementAt(string, n);
        KMUtil.debugMsg("KeyDatabase::addReqKeyLabelAt 9999");
    }

    public void addCrlLabelAt(String string, int n) {
        if (string == null) {
            return;
        }
        if (this.crlLabelList == null) {
            this.crlLabelList = new Vector();
        }
        this.crlLabelList.insertElementAt(string, n);
    }

    public void addSiteCertLabelAt(String string, int n) {
        if (string == null) {
            return;
        }
        if (this.siteCertLabelList == null) {
            this.siteCertLabelList = new Vector();
        }
        this.siteCertLabelList.insertElementAt(string, n);
    }

    public String getTypeName() {
        if (this.type == 1) {
            return "CMS key database file";
        }
        if (this.type == 2) {
            return "Key ring file";
        }
        if (this.type == 4) {
            return "SSLink key database file";
        }
        if (this.type == 3) {
            return "SSLight keyrng class";
        }
        if (this.type == 5) {
            return "CDSA key database";
        }
        if (this.type == 6) {
            return "Berkeley-db file";
        }
        return "Unknown key database type";
    }

    public static int getKeyDatabaseTypeByName(String string) {
        if (string == null) {
            return 0;
        }
        if (string.endsWith(DEFAULT_KEYDB_NAME_EXT_CMS)) {
            return 1;
        }
        if (string.endsWith(DEFAULT_KEYDB_NAME_EXT_WEBDB)) {
            return 2;
        }
        if (string.endsWith(DEFAULT_KEYDB_NAME_EXT_SSLIGHT)) {
            return 3;
        }
        if (string.endsWith(DEFAULT_KEYDB_NAME_EXT_SSLINK)) {
            return 4;
        }
        if (string.endsWith(DEFAULT_KEYDB_NAME_EXT_CDSA)) {
            return 5;
        }
        if (string.endsWith(DEFAULT_KEYDB_NAME_EXT_BERKELEY)) {
            return 6;
        }
        return 0;
    }

    public static boolean isPasswordNeededInSetting(int n) throws KeyDatabaseException {
        String string;
        switch (n) {
            case 1: {
                string = KMSystem.getInitSetting("DEFAULT_CMS_PASSWORD_REQUIRED");
                break;
            }
            case 3: {
                string = KMSystem.getInitSetting("DEFAULT_SSLIGHT_PASSWORD_REQUIRED");
                break;
            }
            case 2: {
                string = KMSystem.getInitSetting("DEFAULT_WEBDB_PASSWORD_REQUIRED");
                break;
            }
            default: {
                throw new KeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_INVALID_TYPE"));
            }
        }
        return string == null || !string.equalsIgnoreCase("false");
    }

    public static boolean isPasswordNeeded(int n, String string) throws KeyDatabaseException {
        switch (n) {
            case 1: {
                return CMSKeyDatabase.isPasswordNeeded(string);
            }
            case 3: {
                return SSLightKeyDatabase.isPasswordNeeded(string);
            }
            case 2: {
                return WEBDBKeyDatabase.isPasswordNeeded(string);
            }
        }
        throw new KeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_INVALID_TYPE"));
    }

    public static boolean isKeyLabelNeeded(int n) {
        return true;
    }

    public static String getKeyDbFileExtensionWithType(int n) {
        String string;
        switch (n) {
            case 1: {
                string = DEFAULT_KEYDB_NAME_EXT_CMS;
                break;
            }
            case 2: {
                string = DEFAULT_KEYDB_NAME_EXT_WEBDB;
                break;
            }
            case 3: {
                string = DEFAULT_KEYDB_NAME_EXT_SSLIGHT;
                break;
            }
            case 4: {
                string = DEFAULT_KEYDB_NAME_EXT_SSLINK;
                break;
            }
            case 5: {
                string = DEFAULT_KEYDB_NAME_EXT_CDSA;
                break;
            }
            case 6: {
                string = DEFAULT_KEYDB_NAME_EXT_BERKELEY;
                break;
            }
            default: {
                string = null;
            }
        }
        return string;
    }

    public static String getDefaultKeyDbFileLocation(int n) {
        String string = KMSystem.getWorkingDirName();
        switch (n) {
            case 1: {
                if (defaultCMSFileLocationSpecified) {
                    string = DEFAULT_KEYDB_LOCATION_CMS;
                    break;
                }
                string = KMSystem.getWorkingDirName();
                break;
            }
            case 2: {
                if (defaultWEBDBFileLocationSpecified) {
                    string = DEFAULT_KEYDB_LOCATION_WEBDB;
                    break;
                }
                string = KMSystem.getWorkingDirName();
                break;
            }
            case 3: {
                if (defaultSSLIGHTFileLocationSpecified) {
                    string = DEFAULT_KEYDB_LOCATION_SSLIGHT;
                    break;
                }
                string = KMSystem.getWorkingDirName();
                break;
            }
            case 4: {
                if (defaultSSLINKFileLocationSpecified) {
                    string = DEFAULT_KEYDB_LOCATION_SSLINK;
                    break;
                }
                string = KMSystem.getWorkingDirName();
                break;
            }
            case 5: {
                if (defaultCDSAFileLocationSpecified) {
                    string = DEFAULT_KEYDB_LOCATION_CDSA;
                    break;
                }
                string = KMSystem.getWorkingDirName();
                break;
            }
            case 6: {
                if (defaultBERKELEYFileLocationSpecified) {
                    string = DEFAULT_KEYDB_LOCATION_BERKELEY;
                    break;
                }
                string = KMSystem.getWorkingDirName();
                break;
            }
            default: {
                string = KMSystem.getWorkingDirName();
            }
        }
        return string;
    }

    public static String getDefaultKeyDbFileName(int n) {
        String string = "";
        switch (n) {
            case 1: {
                string = DEFAULT_KEYDB_NAME_CMS;
                break;
            }
            case 2: {
                string = DEFAULT_KEYDB_NAME_WEBDB;
                break;
            }
            case 3: {
                string = DEFAULT_KEYDB_NAME_SSLIGHT;
                break;
            }
            case 4: {
                string = DEFAULT_KEYDB_NAME_SSLINK;
                break;
            }
            case 5: {
                string = DEFAULT_KEYDB_NAME_CDSA;
                break;
            }
            case 6: {
                string = DEFAULT_KEYDB_NAME_BERKELEY;
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    public static void copyToKeyDb(KeyDatabase keyDatabase, KeyDatabase keyDatabase2, String[] stringArray) throws KeyDatabaseException {
        if (keyDatabase == null || keyDatabase.getType() == 0 || keyDatabase2 == null || keyDatabase2.getType() == 0) {
            throw new KeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_INVALID_TYPE"), "GSKKM_ERR_CMN_KEYDB_INVALID_TYPE");
        }
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            KeyItem keyItem = ((KeyDatabaseOperator)((Object)keyDatabase)).getKeyItemByLabel(stringArray[n]);
            if (keyItem.hasPrivateKey()) {
                PrivateKeyInfoItem privateKeyInfoItem = null;
                switch (keyDatabase.getType()) {
                    case 1: {
                        privateKeyInfoItem = ((CMSKeyDatabase)keyDatabase).decryptPrivateKey(keyItem.getEncryptedPrivateKeyInfoItem());
                        break;
                    }
                    case 2: {
                        privateKeyInfoItem = ((WEBDBKeyDatabase)keyDatabase).decryptPrivateKey(keyItem.getEncryptedPrivateKeyInfoItem());
                        break;
                    }
                    default: {
                        throw new KeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_INVALID_TYPE"), "GSKKM_ERR_CMN_KEYDB_INVALID_TYPE");
                    }
                }
                EncryptedPrivateKeyInfoItem encryptedPrivateKeyInfoItem = null;
                switch (keyDatabase2.getType()) {
                    case 1: {
                        encryptedPrivateKeyInfoItem = ((CMSKeyDatabase)keyDatabase2).encryptPrivateKey(privateKeyInfoItem);
                        break;
                    }
                    case 2: {
                        encryptedPrivateKeyInfoItem = ((WEBDBKeyDatabase)keyDatabase2).encryptPrivateKey(privateKeyInfoItem);
                        break;
                    }
                    default: {
                        throw new KeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_INVALID_TYPE"), "GSKKM_ERR_CMN_KEYDB_INVALID_TYPE");
                    }
                }
                keyItem.setEncryptedPrivateKeyInfoItem(encryptedPrivateKeyInfoItem);
            }
            keyItem.setDefault(false);
            ((KeyDatabaseOperator)((Object)keyDatabase2)).insertKey(keyItem);
            ++n;
        }
    }

    public void exportToKeyDb(KeyDatabase keyDatabase, String[] stringArray) throws KeyDatabaseException {
        KeyDatabase.copyToKeyDb(this, keyDatabase, stringArray);
    }

    public void importFromKeyDb(KeyDatabase keyDatabase, String[] stringArray) throws KeyDatabaseException {
        KeyDatabase.copyToKeyDb(keyDatabase, this, stringArray);
    }

    public void issueCertificate(String string, int n, String string2, int n2, String string3, String string4, boolean bl) throws KeyDatabaseException {
        if (this.type != 1) {
            throw new KeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_OP_NULL"), "GSKKM_ERR_CMN_KEYDB_OP_NULL");
        }
    }

    public void issueCertificate(String string, int n, String string2, int n2, int n3, String string3, String string4, boolean bl) throws KeyDatabaseException {
        if (this.type != 1) {
            throw new KeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_OP_NULL"), "GSKKM_ERR_CMN_KEYDB_OP_NULL");
        }
    }

    public boolean isPasswordProtected() {
        return true;
    }

    public boolean isPersonalCertificateSupported() {
        return true;
    }

    public boolean isStashPwdSupported() {
        if (this.type == 1) {
            try {
                int n = this.getType();
                String string = this.getKeyDbFileName();
                if (!KeyDatabase.isPasswordNeeded(n, string)) {
                    return false;
                }
            }
            catch (KeyDatabaseException keyDatabaseException) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return this.paramString();
    }

    public String paramString() {
        return super.toString() + ", type=" + this.getTypeName() + ", keyDbFileName=" + this.keyDbFileName + ", keyLabelList=" + this.keyLabelList;
    }
}

