/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.cli;

import com.ibm.gsk.ikeyman.basic.CMSKeyDatabase;
import com.ibm.gsk.ikeyman.basic.KMException;
import com.ibm.gsk.ikeyman.basic.KMSystem;
import com.ibm.gsk.ikeyman.basic.KeyStoreManager;
import com.ibm.gsk.ikeyman.basic.KeyStoreManagerException;
import com.ibm.gsk.ikeyman.cli.CLIConstants;
import com.ibm.gsk.ikeyman.cli.CLICryptoDatabaseManager;
import com.ibm.gsk.ikeyman.cli.CLIDatabaseInfo;
import com.ibm.gsk.ikeyman.cli.CLIKeyStoreManager;
import com.ibm.gsk.ikeyman.ikeycmd;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class CLIKeyStoreManager
implements CLIConstants {
    static int[] types = KeyStoreManager.getSupportedCLIDatabaseTypes();

    public static void keyDbCreate(CLIDatabaseInfo cLIDatabaseInfo) throws KeyStoreManagerException, KMException {
        cLIDatabaseInfo.init();
        String string = cLIDatabaseInfo.getName();
        String string2 = cLIDatabaseInfo.getPassword();
        String string3 = cLIDatabaseInfo.getExtension();
        long l = cLIDatabaseInfo.getExpire();
        int n = cLIDatabaseInfo.getDbType();
        boolean bl = cLIDatabaseInfo.getStash();
        ikeycmd.debugMsg("Entered CLIKeyStoreManager.keyDbCreate");
        ikeycmd.debugMsg("CLIKeyStoreManager.KeyDbFileName: " + string);
        ikeycmd.debugMsg("CLIKeyStoreManager.keyDbPassword: " + string2);
        ikeycmd.debugMsg("CLIKeyStoreManager.keyDbType:  " + n);
        ikeycmd.debugMsg("\n");
        if (string3 != null && string.lastIndexOf(".") < 1) {
            string = string + "." + string3;
        }
        File file = new File(string);
        ikeycmd.debugMsg("Checking to see if database " + string + " already exists\n");
        if (file.exists()) {
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_ALREADY_EXISTS"));
        }
        KeyStoreManager keyStoreManager = CLIKeyStoreManager.makeKeyDatabase(n, string, string2, l);
        try {
            keyStoreManager.create();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            throw new KMException(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE"));
        }
        if (bl) {
            if (n == 1) {
                keyStoreManager.stashKeydbPwd(keyStoreManager.getKeyDbFileName());
            } else {
                throw new KMException(KMSystem.getNLSErrString("GSKKM_CLI_ERR_STASH_DB_TYPE"));
            }
        }
        ikeycmd.debugMsg("Stash = false\n");
    }

    public static void keyDbChangePw(CLIDatabaseInfo cLIDatabaseInfo) throws KeyStoreManagerException, KMException {
        cLIDatabaseInfo.init();
        String string = cLIDatabaseInfo.getName();
        String string2 = cLIDatabaseInfo.getPassword();
        String string3 = cLIDatabaseInfo.getNewPassword();
        long l = cLIDatabaseInfo.getExpire();
        int n = cLIDatabaseInfo.getDbType();
        boolean bl = cLIDatabaseInfo.getStash();
        ikeycmd.debugMsg("CLIKeyStoreManager.keyDbChangePw().KeyDbFileName: " + string);
        ikeycmd.debugMsg("CLIKeyStoreManager.keyDbChangePw().keyDbPassword: " + string2);
        ikeycmd.debugMsg("CLIKeyStoreManager.keyDbChangePw().keyDbType:  " + n);
        ikeycmd.debugMsg("\n");
        KeyStoreManager keyStoreManager = CLIKeyStoreManager.makeKeyDatabase(n, string, string2, l);
        try {
            keyStoreManager.open();
            keyStoreManager.changeKeyDbPwd(string2, string3, l);
        }
        catch (Exception exception) {
            if (exception.getMessage().equals(KMSystem.getNLSErrString("GSKKM_ERR_PASSWORD_EXPIRATION_TIME"))) {
                keyStoreManager.changeKeyDbPwd(null, string3, l);
            }
            throw new KMException(exception.getMessage());
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            throw new KMException(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE"));
        }
        if (bl) {
            if (n == 1) {
                keyStoreManager.stashKeydbPwd(keyStoreManager.getKeyDbFileName());
            } else {
                throw new KMException(KMSystem.getNLSErrString("GSKKM_CLI_ERR_STASH_DB_TYPE"));
            }
        }
        keyStoreManager.close();
    }

    public static void keyDbStashPw(CLIDatabaseInfo cLIDatabaseInfo) throws KeyStoreManagerException, KMException {
        cLIDatabaseInfo.init();
        String string = cLIDatabaseInfo.getName();
        String string2 = cLIDatabaseInfo.getPassword();
        String string3 = cLIDatabaseInfo.getNewPassword();
        long l = cLIDatabaseInfo.getExpire();
        int n = cLIDatabaseInfo.getDbType();
        boolean bl = cLIDatabaseInfo.getStash();
        ikeycmd.debugMsg("CLIKeyStoreManager.keyDbStashPw().KeyDbFileName: " + string);
        ikeycmd.debugMsg("CLIKeyStoreManager.keyDbStashPw().keyDbPassword: " + string2);
        ikeycmd.debugMsg("CLIKeyStoreManager.keyDbStashPw().keyDbType:  " + n);
        ikeycmd.debugMsg("\n");
        KeyStoreManager keyStoreManager = CLIKeyStoreManager.makeKeyDatabase(n, string, string2, l);
        try {
            keyStoreManager.open();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            throw new KMException(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE"));
        }
        if (n != 1) {
            throw new KMException(KMSystem.getNLSErrString("GSKKM_CLI_ERR_STASH_DB_TYPE"));
        }
        keyStoreManager.stashKeydbPwd(keyStoreManager.getKeyDbFileName());
        keyStoreManager.close();
    }

    public static void keyDbConvert(CLIDatabaseInfo cLIDatabaseInfo) throws KeyStoreManagerException, KMException, IOException, Exception {
        cLIDatabaseInfo.init();
        String string = cLIDatabaseInfo.getName();
        String string2 = cLIDatabaseInfo.getPassword();
        int n = cLIDatabaseInfo.getDbType();
        int n2 = cLIDatabaseInfo.getNewDbType();
        long l = cLIDatabaseInfo.getExpire();
        String string3 = cLIDatabaseInfo.getNewExtension();
        ikeycmd.debugMsg("CLIKeyStoreManager.keyDbConvert().KeyDbFileName: " + string);
        ikeycmd.debugMsg("CLIKeyStoreManager.keyDbConvert().keyDbPassword: " + string2);
        ikeycmd.debugMsg("CLIKeyStoreManager.keyDbConvert().keyDbType:  " + n);
        ikeycmd.debugMsg("CLIKeyStoreManager.keyDbConvert().newDbType:  " + n2);
        ikeycmd.debugMsg("CLIKeyStoreManager.keyDbConvert().newExtension:  " + string3);
        ikeycmd.debugMsg("\n");
        KeyStoreManager keyStoreManager = CLIKeyStoreManager.makeKeyDatabase(n, string, string2, l);
        try {
            keyStoreManager.open();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            throw new KMException(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE"));
        }
        String string4 = string.substring(0, string.lastIndexOf("."));
        string4 = string4 + "." + string3;
        ikeycmd.debugMsg("\nnewName: " + string4);
        ikeycmd.debugMsg("newDbType: " + n2);
        ikeycmd.debugMsg("keyDbPassword: " + string2);
        ikeycmd.debugMsg("\n");
        KeyStoreManager keyStoreManager2 = CLIKeyStoreManager.makeKeyDatabase(n2, string4, string2, l);
        keyStoreManager2.setKeyDbFileName(string4);
        try {
            keyStoreManager2.reCreate(keyStoreManager);
        }
        catch (KeyStoreManagerException keyStoreManagerException) {
            if (keyStoreManagerException.getMessage().endsWith("reCreate duplicate certificate")) {
                keyStoreManager2.save();
                throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_DUPLICATE_KEY"));
            }
            throw keyStoreManagerException;
        }
        catch (Exception exception) {
            throw exception;
        }
        keyStoreManager2.keyDbChanged = true;
        keyStoreManager2.close();
    }

    public static void keyDbDelete(CLIDatabaseInfo cLIDatabaseInfo) throws KeyStoreManagerException, KMException, IOException {
        String string;
        File file;
        cLIDatabaseInfo.init();
        String string2 = cLIDatabaseInfo.getName();
        String string3 = cLIDatabaseInfo.getPassword();
        int n = cLIDatabaseInfo.getDbType();
        long l = cLIDatabaseInfo.getExpire();
        ikeycmd.debugMsg("CLIKeyStoreManager.keyDbDelete().KeyDbFileName: " + string2);
        ikeycmd.debugMsg("CLIKeyStoreManager.keyDbDelete().keyDbPassword: " + string3);
        ikeycmd.debugMsg("CLIKeyStoreManager.keyDbDelete().keyDbType:  " + n);
        ikeycmd.debugMsg("\n");
        KeyStoreManager keyStoreManager = CLIKeyStoreManager.makeKeyDatabase(n, string2, string3, l);
        ikeycmd.debugMsg("Deleteing " + string2 + "\n");
        try {
            keyStoreManager.delete();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            throw new KMException(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE"));
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
        String string4 = stringTokenizer.nextToken();
        String string5 = stringTokenizer.nextToken();
        if (string5 != null && string5.compareTo("kdb") == 0 && (file = new File(string = string4 + ".sth")).exists()) {
            ikeycmd.debugMsg("Deleting the stash file\n");
            file.delete();
        }
    }

    public static void keyDbExpiry(CLIDatabaseInfo cLIDatabaseInfo) throws KeyStoreManagerException, KMException, IOException {
        block6: {
            cLIDatabaseInfo.init();
            String string = cLIDatabaseInfo.getName();
            String string2 = cLIDatabaseInfo.getPassword();
            int n = cLIDatabaseInfo.getDbType();
            ikeycmd.debugMsg("CLIKeyStoreManager.keyDbExpiry().KeyDbFileName: " + string);
            ikeycmd.debugMsg("CLIKeyStoreManager.keyDbExpiry().keyDbPassword: " + string2);
            ikeycmd.debugMsg("CLIKeyStoreManager.keyDbExpiry().keyDbType:  " + n);
            ikeycmd.debugMsg("\n");
            ikeycmd.debugMsg("Expiry " + string + "\n");
            try {
                if (n == 1) {
                    CMSKeyDatabase cMSKeyDatabase = new CMSKeyDatabase(string, string2);
                    class ExpireTime {
                        public long expireTime;

                        ExpireTime() {
                        }
                    }
                    ExpireTime expireTime2 = new ExpireTime();
                    int n2 = cMSKeyDatabase.c_GetKeyDbPwdExpireTime(string, string2, expireTime2);
                    if (n2 != 0) {
                        throw new KMException(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE"));
                    }
                    if (expireTime2.expireTime != 0L) {
                        Date date = new Date(expireTime2.expireTime);
                        DateFormat dateFormat = DateFormat.getDateTimeInstance(0, 0);
                        String string3 = dateFormat.format(date);
                        System.out.println(ikeycmd.getNLSResString("GUI_LABEL_CERT_VALIDITY") + " " + string3);
                    } else {
                        System.out.println(ikeycmd.getNLSResString("GUI_LABEL_CERT_VALIDITY") + " " + expireTime2.expireTime);
                    }
                    break block6;
                }
                throw new KMException(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE"));
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                throw new KMException(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE"));
            }
        }
    }

    public static void keyDblist() {
        if (types.length != 0) {
            System.out.println(ikeycmd.getNLSResString("GUI_MSG_TIP_DBTYPE_CHOICE"));
            int n = 0;
            while (n < types.length) {
                if (KMSystem.isMSKeyStoreOS()) {
                    System.out.println("     " + KeyStoreManager.getKeyStoreName(types[n]));
                } else if (types[n] != 2) {
                    System.out.println("     " + KeyStoreManager.getKeyStoreName(types[n]));
                }
                ++n;
            }
        } else {
            System.out.println("     ");
        }
    }

    public static KeyStoreManager makeKeyDatabase(int n, String string, String string2, long l) throws KeyStoreManagerException {
        KeyStoreManager keyStoreManager;
        if (string == null || string.equals("")) {
            ikeycmd.displayHelp(null, 188);
        }
        String string3 = CLIKeyStoreManager.convertMapToKeyStore(n);
        if ((n == 1 || n == 10 || string.equalsIgnoreCase("MSCertificateStore")) && KMSystem.isJNIEnabled() && !KeyStoreManager.loadCMSNoJavaOnlyProvider()) {
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE"));
        }
        KeyStoreManager.getSupportedCLIDatabaseTypes();
        int n2 = KeyStoreManager.getDbTypeFromKeyStore(string3);
        ikeycmd.debugMsg("CLIKeyStoreManager.makeKeyDatabase()::DbType=" + n + " typeString=" + string3 + " KeyStoreIndex=" + n2 + "\n");
        if (string.equalsIgnoreCase("MSCertificateStore")) {
            ikeycmd.debugMsg("CLIKeyStoreManager.makeKeyDatabase()::MS Store " + n + ".." + CLIKeyStoreManager.convertMapToKeyStore(n) + "\n");
            KeyStoreManager keyStoreManager2 = new KeyStoreManager(2, "", "", 0L, true);
            return keyStoreManager2;
        }
        if (n == 10 && CLICryptoDatabaseManager.isCSPCrypto(string)) {
            ikeycmd.debugMsg("CLIKeyStoreManager.makeKeyDatabase()::CRYPTO_TYPE_WITH_MS\n");
            KeyStoreManager keyStoreManager3 = new KeyStoreManager(2, string, "", 0L, true);
            return keyStoreManager3;
        }
        ikeycmd.debugMsg("CLIKeyStoreManager.makeKeyDatabase()::Before mapping a KS, type: " + n + ".." + CLIKeyStoreManager.convertMapToKeyStore(n) + "\n");
        ikeycmd.debugMsg("CLIKeyStoreManager.makeKeyDatabase()::After mapping a KS, type: " + n2 + "\n");
        if (n2 == 0) {
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE"));
        }
        if (n2 != 1 && (string2 == null || string2.equals(""))) {
            ikeycmd.displayHelp(string, 187);
        }
        if ((keyStoreManager = new KeyStoreManager(n2, string, string2, l, true)) == null) {
            ikeycmd.displayHelp(string, 186);
        }
        return keyStoreManager;
    }

    public static String convertMapToKeyStore(int n) {
        String string;
        switch (n) {
            case 1: {
                string = new String("CMS");
                break;
            }
            case 3: {
                string = new String("SSLIGHT");
                break;
            }
            case 6: {
                string = new String("JKS");
                break;
            }
            case 7: {
                string = new String("JCEKS");
                break;
            }
            case 8: {
                string = new String("PKCS12");
                break;
            }
            case 10: {
                string = "CMS Cryptographic Token";
                break;
            }
            case 11: {
                string = "Java Cryptographic Token";
                break;
            }
            default: {
                string = new String("UNKNOWN");
            }
        }
        return string;
    }

    public static int getKeyDatabaseTypeByName(String string) {
        if (string == null) {
            return 0;
        }
        if (string.endsWith("kdb") || string.endsWith("KDB")) {
            return 1;
        }
        if (string.endsWith("class") || string.endsWith("CLASS")) {
            return 3;
        }
        if (string.endsWith("jks") || string.endsWith("JKS")) {
            return 6;
        }
        if (string.endsWith("jck") || string.endsWith("JCK")) {
            return 7;
        }
        if (string.endsWith("p12") || string.endsWith("P12")) {
            return 8;
        }
        return 0;
    }

    public static String getMSTrimString(String string, int n, int n2) {
        int n3;
        if (n != 2) {
            if (n != 3 && n != 4) {
                return string;
            }
            if (n2 != 3) {
                return string;
            }
        }
        if ((n3 = string.lastIndexOf("##")) == -1) {
            return string;
        }
        String string2 = string.substring(0, n3);
        int n4 = string2.lastIndexOf("##");
        if (n4 == -1) {
            return string;
        }
        String string3 = string.substring(0, 3);
        if (string3.compareToIgnoreCase("cn=") == 0) {
            String string4 = "{" + string2.substring(3, n4) + "}";
            return string4;
        }
        String string5 = string2.substring(0, n4);
        return string5;
    }

    public static String getMSKeyLabel(Vector vector, String string) {
        String string2 = null;
        Vector vector2 = vector;
        ikeycmd.debugMsg("CLIKeyStoreManager.getMSKeyLabel():label input " + string + "..");
        if (vector2 != null) {
            ikeycmd.debugMsg("CLIKeyStoreManager.getMSKeyLabel():label vector not null ..");
            Enumeration enumeration = vector2.elements();
            while (enumeration.hasMoreElements()) {
                String string3 = enumeration.nextElement().toString();
                if (!string3.startsWith(string + "##")) continue;
                string2 = string3;
                ikeycmd.debugMsg("CLIKeyStoreManager.getMSKeyLabel():label got " + string2);
                break;
            }
        }
        return string2;
    }
}

