/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.cli;

import com.ibm.gsk.ikeyman.cli.CLIConstants;
import com.ibm.gsk.ikeyman.cli.CLIDatabaseInfo;
import com.ibm.gsk.ikeyman.cli.CLIDefaults;
import com.ibm.gsk.ikeyman.cli.DistinguishedName;
import com.ibm.gsk.ikeyman.ikeycmd;
import java.io.File;

public class CLIRequestInfo
implements CLIConstants {
    public int rc;
    public int action;
    public String message;
    private String label;
    private String fileName;
    private String databaseName;
    private String databasePassword;
    private String newPassword;
    private String databaseExtension;
    private int keySize;
    private String target;
    private boolean showOID;
    public DistinguishedName dn;
    public CLIDatabaseInfo cliDb;
    public CLIDefaults defaults;
    private String san_ipaddr;
    private String san_dnsname;
    private String san_emailaddr;

    public CLIRequestInfo() {
        this.action = 252;
        this.message = null;
        this.label = null;
        this.fileName = null;
        this.databaseName = null;
        this.databasePassword = null;
        this.newPassword = null;
        this.keySize = 1024;
        this.dn = new DistinguishedName();
        this.cliDb = new CLIDatabaseInfo();
        this.databaseExtension = "kdb";
        this.target = null;
        this.san_ipaddr = null;
        this.san_emailaddr = null;
        this.san_dnsname = null;
        this.showOID = false;
    }

    public CLIRequestInfo(int n) {
        this.defaults = new CLIDefaults();
        this.action = n;
        this.message = null;
        this.label = null;
        this.fileName = this.defaults.CertReqName;
        this.databaseName = null;
        this.databasePassword = null;
        this.newPassword = null;
        this.keySize = 1024;
        if (this.defaults.certKeySize != null) {
            this.keySize = Integer.valueOf(this.defaults.certKeySize);
        }
        this.dn = new DistinguishedName();
        this.cliDb = new CLIDatabaseInfo();
        this.databaseExtension = "kdb";
        this.san_ipaddr = null;
        this.san_emailaddr = null;
        this.san_dnsname = null;
        this.target = this.defaults.CertArmName;
        this.showOID = false;
    }

    public void init() {
        if (this.databaseExtension != null && this.databaseName != null && this.databaseName.indexOf(".") == -1) {
            this.databaseName = this.databaseName + "." + this.databaseExtension;
        }
        ikeycmd.debugMsg("Action = " + this.action);
        if (this.target == null) {
            if (this.action == 29 || this.action == 29) {
                ikeycmd.displayHelp(null, 236);
            }
        } else if (this.defaults.FileLocation != null) {
            this.target = this.defaults.FileLocation + File.separator + this.target;
        }
        this.cliDb.init();
        if (this.fileName == null) {
            if (this.action == 17 || this.action == 16 || this.action == 24) {
                ikeycmd.displayHelp(null, 234);
            }
        } else if (this.defaults.FileLocation != null) {
            this.fileName = this.defaults.FileLocation + File.separator + this.fileName;
        }
        if (this.label == null && this.action != 27 && this.action != 10 && this.action != 15 && this.action != 20 && this.action != 13) {
            ikeycmd.displayHelp(null, 235);
        }
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setKeySize(int n) {
        this.keySize = n;
    }

    public String getLabel() {
        return this.label;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getOldPassword() {
        return this.newPassword;
    }

    public String getDatabasePassword() {
        return this.databasePassword;
    }

    public String getDatabaseExtension() {
        return this.databaseExtension;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public void setDistinguishedName(String string) {
        String string2 = string;
    }

    public void setExtractTarget(String string) {
        this.target = string;
    }

    public String getExtractTarget() {
        return this.target;
    }

    public String getSanIpAddr() {
        return this.san_ipaddr;
    }

    public void setSanIpAddr(String string) {
        this.san_ipaddr = string;
    }

    public String getSanDnsName() {
        return this.san_dnsname;
    }

    public void setSanDnsName(String string) {
        this.san_dnsname = string;
    }

    public String getSanEmailAddr() {
        return this.san_emailaddr;
    }

    public void setSanEmailAddr(String string) {
        this.san_emailaddr = string;
    }

    public void setShowOid(boolean bl) {
        this.showOID = bl;
    }

    public boolean getShowOid() {
        return this.showOID;
    }
}

