/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.jgss;

import com.ibm.security.jgss.Debug;
import com.ibm.security.jgss.i18n.I18NException;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;

public class TokenHeader {
    private static final byte a = 0;
    private static final byte b = 96;
    private Oid c = null;
    private byte[] d = null;
    private int e = 0;
    private int f = 0;
    private Debug g = new Debug();

    public TokenHeader(byte[] byArray) throws GSSException {
        if (byArray == null) {
            I18NException.throwGSSException(11, 0, TokenHeader.a("|\nxHB]\u0014qJ"));
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        this.a(byteArrayInputStream, false);
    }

    public TokenHeader(byte[] byArray, boolean bl2) throws GSSException {
        if (byArray == null) {
            I18NException.throwGSSException(11, 0, TokenHeader.a("|\nxHB]\u0014qJ"));
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        this.a(byteArrayInputStream, bl2);
    }

    public TokenHeader(InputStream inputStream) throws GSSException {
        this.a(inputStream, false);
    }

    public TokenHeader(InputStream inputStream, boolean bl2) throws GSSException {
        this.a(inputStream, bl2);
    }

    private void a(InputStream inputStream, boolean bl2) throws GSSException {
        this.a(inputStream);
        if (bl2) {
            this.b(inputStream);
        }
    }

    public TokenHeader(Oid oid, byte[] byArray) throws GSSException {
        this.c = oid;
        this.d = byArray;
    }

    public void asn1Encode(OutputStream outputStream) throws GSSException {
        byte[] byArray;
        if (outputStream == null) {
            I18NException.throwGSSException(11, 0, TokenHeader.a("|\nxHEF\rqE{"));
        }
        if ((byArray = this.asn1Encode()) != null) {
            try {
                this.f = byArray.length;
                outputStream.write(byArray);
                outputStream.flush();
            }
            catch (Exception exception) {
                I18NException.throwGSSException(11, 0, TokenHeader.a("a\u000bfAw_(fMbW:fVy@"), new String[]{exception.toString()});
            }
        }
    }

    public byte[] asn1Encode() throws GSSException {
        if (this.c == null) {
            throw new GSSException(11, 0, TokenHeader.a("\u007f\u0016gW\u007f\\\u0018YAuZ0}@"));
        }
        if (this.d == null) {
            throw new GSSException(11, 0, TokenHeader.a("\u007f\u0016gW\u007f\\\u0018YAuZ+{Os\\"));
        }
        try {
            byte[] byArray = this.c.getDER();
            this.g.out(6, TokenHeader.a("_\u001awL6v:F\u0019"));
            this.g.out(6, byArray);
            this.g.out(6, TokenHeader.a("[\u0011zAd\u0012\u000b{Os\\B"));
            this.g.out(6, this.d);
            byte[] byArray2 = new byte[this.d.length + byArray.length];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            System.arraycopy(this.d, 0, byArray2, byArray.length, this.d.length);
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.write(DerValue.createTag((byte)64, (boolean)true, (byte)0), byArray2);
            byte[] byArray3 = derOutputStream.toByteArray();
            this.g.out(6, TokenHeader.a("S\fz\u0015S\\\u001c{@sV_`K}W\u0011)"));
            this.g.out(6, byArray3);
            this.f = byArray3.length;
            return byArray3;
        }
        catch (Exception exception) {
            I18NException.throwGSSException(11, 0, TokenHeader.a("w\u0011wKr[\u0011sad@\u0010f"), new String[]{exception.toString()});
            return null;
        }
    }

    public Oid getMechanism() {
        return this.c;
    }

    public int getMechTokenLen() {
        return this.e;
    }

    public byte[] getMechToken() {
        return this.d;
    }

    static int a(Oid oid, int n2) throws GSSException {
        int n3 = oid.getDER().length;
        int n4 = n3 + n2;
        n4 += TokenHeader.a(n4);
        return n4 + 1;
    }

    private static int a(int n2) {
        if (n2 < 128) {
            return 1;
        }
        if (n2 < 256) {
            return 2;
        }
        if (n2 < 65536) {
            return 3;
        }
        if (n2 < 0x1000000) {
            return 4;
        }
        return 5;
    }

    private void a(InputStream inputStream) throws GSSException {
        if (inputStream == null) {
            I18NException.throwGSSException(10, 0, TokenHeader.a("|\nxHEF\rqE{"));
        }
        try {
            byte by = (byte)inputStream.read();
            if (by != 96) {
                I18NException.throwGSSException(10, 0, TokenHeader.a("p\u001eppyY\u001azpwU"), new String[]{Byte.toString(by)});
            }
            int n2 = this.c(inputStream);
            this.g.out(10, TokenHeader.a("`\u001auH6F\u0010\u007fAx\u0012\u0013qJ6") + n2);
            byte[] byArray = new DerValue(inputStream).toByteArray();
            this.c = new Oid(byArray);
            this.g.out(10, TokenHeader.a("f\u0010\u007fAx\u0012\u0010}@6") + this.c);
            this.e = n2 - byArray.length;
            this.g.out(10, TokenHeader.a("[\u0011zAd\u0012\u000b{Os\\_xAx\u0012") + this.e);
        }
        catch (GSSException gSSException) {
            throw gSSException;
        }
        catch (Exception exception) {
            I18NException.throwGSSException(10, 0, TokenHeader.a("a\u000bfAw_-qErw\rfKd"), new String[]{exception.toString()});
        }
    }

    private void b(InputStream inputStream) throws GSSException {
        int n2 = -1;
        this.d = new byte[this.e];
        try {
            n2 = inputStream.read(this.d, 0, this.e);
        }
        catch (Exception exception) {
            I18NException.throwGSSException(10, 0, TokenHeader.a("a\u000bfAw_-qErw\rfKd"), new String[]{exception.toString()});
        }
        if (n2 != this.e) {
            I18NException.throwGSSException(10, 0, TokenHeader.a("a\u000bfAw_;uPw~\u001azi\u007fA\u0012uPuZ"), new Integer[]{new Integer(this.e), new Integer(n2)});
        }
        this.g.out(6, TokenHeader.a("[\u0011zAd\u0012\u000b{Os\\B"));
        this.g.out(6, this.d);
    }

    private boolean a(DerValue derValue, byte by) {
        return (derValue.getTag() & 0x1F) == by;
    }

    private int c(InputStream inputStream) throws GSSException {
        try {
            return this.a(inputStream.read(), inputStream);
        }
        catch (GSSException gSSException) {
            throw gSSException;
        }
        catch (Exception exception) {
            I18NException.throwGSSException(10, 0, TokenHeader.a("a\u000bfAw_-qErw\rfKd"), new String[]{exception.toString()});
            return -1;
        }
    }

    private int a(int n2, InputStream inputStream) throws GSSException {
        int n3 = -1;
        int n4 = -1;
        n4 = n2;
        if ((n4 & 0x80) == 0) {
            n3 = n4;
        } else {
            if ((n4 &= 0x7F) == 0) {
                return -1;
            }
            if (n4 < 0 || n4 > 4) {
                I18NException.throwGSSException(10, 0, TokenHeader.a("p\u001ep`S`:zGyV\u0016zC"), new Integer[]{new Integer(n4)});
            }
            try {
                n3 = 0;
                while (n4 > 0) {
                    n3 <<= 8;
                    n3 += 0xFF & inputStream.read();
                    --n4;
                }
            }
            catch (Exception exception) {
                I18NException.throwGSSException(10, 0, TokenHeader.a("a\u000bfAw_-qErw\rfKd"), new String[]{exception.toString()});
            }
        }
        return n3;
    }

    public int getEncodedLength() {
        return this.f;
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private static String a(String string) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        boolean bl2 = true;
        block6: do {
            if (bl2 && !(bl2 = false) && n2 > 1) continue;
            char[] cArray2 = cArray;
            int n4 = n3;
            while (true) {
                int n5;
                char c2 = cArray2[n4];
                switch (n3 % 5) {
                    case 0: {
                        n5 = 50;
                        break;
                    }
                    case 1: {
                        n5 = 127;
                        break;
                    }
                    case 2: {
                        n5 = 20;
                        break;
                    }
                    case 3: {
                        n5 = 36;
                        break;
                    }
                    default: {
                        n5 = 22;
                    }
                }
                cArray2[n4] = (char)(c2 ^ n5);
                ++n3;
                if (n2 != 0) continue block6;
                cArray2 = cArray;
                n4 = n2;
            }
        } while (n3 < n2);
        return new String(cArray);
    }
}

