/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.PKCS11KeySpec;
import com.ibm.pkcs11.PKCS11Object;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;

final class ConstructKeys {
    ConstructKeys() {
    }

    static final Object[] constructPublicKeyAttrs(String wrappedKeyAlgorithm) {
        Object[] attrs = new Object[2];
        if (wrappedKeyAlgorithm.equalsIgnoreCase("DSA")) {
            int[] types = new int[]{0, 256, 266};
            Object[] values = new Object[]{PKCS11Object.PUBLIC_KEY, PKCS11Object.DSA, Boolean.TRUE};
            attrs[0] = types;
            attrs[1] = values;
        } else if (wrappedKeyAlgorithm.equalsIgnoreCase("RSA")) {
            int[] types = new int[]{0, 256, 266, 260, 262};
            Object[] values = new Object[]{PKCS11Object.PUBLIC_KEY, PKCS11Object.RSA, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE};
            attrs[0] = types;
            attrs[1] = values;
        }
        return attrs;
    }

    static final PublicKey constructPublicKey(PKCS11Object objKey, String keyAlgorithm) throws InvalidKeyException, NoSuchAlgorithmException {
        PublicKey key = null;
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(keyAlgorithm, "IBMPKCS11Impl");
            PKCS11KeySpec keySpec = new PKCS11KeySpec(objKey);
            key = keyFactory.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new NoSuchAlgorithmException("The IBMPKCS11Impl providers can not create keys for the " + keyAlgorithm + "algorithm");
        }
        catch (InvalidKeySpecException ikse) {
        }
        catch (NoSuchProviderException noSuchProviderException) {
            // empty catch block
        }
        return key;
    }

    static final Object[] constructPrivateKeyAttrs(String wrappedKeyAlgorithm) {
        Object[] attrs = new Object[2];
        if (wrappedKeyAlgorithm.equalsIgnoreCase("DSA")) {
            int[] types = new int[]{0, 256, 264};
            Object[] values = new Object[]{PKCS11Object.PRIVATE_KEY, PKCS11Object.DSA, Boolean.TRUE};
            attrs[0] = types;
            attrs[1] = values;
        } else if (wrappedKeyAlgorithm.equalsIgnoreCase("RSA")) {
            int[] types = new int[]{0, 256, 264, 261, 263};
            Object[] values = new Object[]{PKCS11Object.PRIVATE_KEY, PKCS11Object.RSA, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE};
            attrs[0] = types;
            attrs[1] = values;
        }
        return attrs;
    }

    static final PrivateKey constructPrivateKey(PKCS11Object objKey, String keyAlgorithm) throws InvalidKeyException, NoSuchAlgorithmException {
        PrivateKey key = null;
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(keyAlgorithm, "IBMPKCS11Impl");
            PKCS11KeySpec keySpec = new PKCS11KeySpec(objKey);
            return keyFactory.generatePrivate(keySpec);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new NoSuchAlgorithmException("The IBMPKCS11Impl providers can not create keys for the " + keyAlgorithm + "algorithm");
        }
        catch (InvalidKeySpecException ikse) {
        }
        catch (NoSuchProviderException noSuchProviderException) {
            // empty catch block
        }
        return key;
    }

    static final Object[] constructSecretKeyAttrs(String wrappedKeyAlgorithm) {
        Object[] attrs = new Object[2];
        if (wrappedKeyAlgorithm.equalsIgnoreCase("DES")) {
            int[] types = new int[]{0, 256, 260, 261, 262, 263};
            Object[] values = new Object[]{PKCS11Object.SECRET_KEY, PKCS11Object.DES, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE};
            attrs[0] = types;
            attrs[1] = values;
        } else if (wrappedKeyAlgorithm.equalsIgnoreCase("3DES") || wrappedKeyAlgorithm.equalsIgnoreCase("DESede") || wrappedKeyAlgorithm.equalsIgnoreCase("TripleDES")) {
            int[] types = new int[]{0, 256, 260, 261, 262, 263};
            Object[] values = new Object[]{PKCS11Object.SECRET_KEY, PKCS11Object.DES3, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE};
            attrs[0] = types;
            attrs[1] = values;
        }
        return attrs;
    }

    static final SecretKey constructSecretKey(PKCS11Object objKey, String keyAlgorithm) throws InvalidKeyException, NoSuchAlgorithmException {
        SecretKey key = null;
        try {
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(keyAlgorithm, "IBMPKCS11Impl");
            PKCS11KeySpec keySpec = new PKCS11KeySpec(objKey);
            return keyFactory.generateSecret(keySpec);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new NoSuchAlgorithmException("The IBMPKCS11Impl providers can not create keys for the " + keyAlgorithm + "algorithm");
        }
        catch (InvalidKeySpecException ikse) {
            ikse.printStackTrace();
        }
        catch (NoSuchProviderException nspe) {
            nspe.printStackTrace();
        }
        return key;
    }
}

