/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.ConstructKeys;
import com.ibm.crypto.pkcs11impl.provider.DESKey;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.PKCS11Cipher;
import com.ibm.crypto.pkcs11impl.provider.PKCS11Key;
import com.ibm.crypto.pkcs11impl.provider.PKCS11SecretKey;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Object;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;

public final class DESCipher
extends CipherSpi {
    protected int cipherMode;
    private boolean decrypting = false;
    protected static final int ECB_MODE = 0;
    protected static final int CBC_MODE = 1;
    private byte[] iv = null;
    SecureRandom random = null;
    PKCS11Cipher cipher = null;
    private int mechanism;
    public static final int DES_BLOCK_SIZE = 8;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.DESCipher";
    static /* synthetic */ Class class$javax$crypto$spec$IvParameterSpec;

    public DESCipher() {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "DESCipher");
        }
        IBMPKCS11Impl.verifyJceJar();
        if (!IBMPKCS11Impl.verifySelfIntegrity(this.getClass())) {
            throw new SecurityException("The IBM JCE PKCS11 provider may have been tampered.");
        }
        this.cipherMode = 0;
        this.mechanism = 289;
        if (debug != null) {
            debug.exit(16384L, (Object)className, "DESCipher");
        }
    }

    public DESCipher(String mode, String paddingScheme) throws NoSuchAlgorithmException, NoSuchPaddingException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "DESCipher", (Object)mode, (Object)paddingScheme);
        }
        IBMPKCS11Impl.verifyJceJar();
        if (!IBMPKCS11Impl.verifySelfIntegrity(this.getClass())) {
            throw new SecurityException("The IBMPKCS11Impl provider may have been tampered.");
        }
        try {
            this.random = SecureRandom.getInstance("IBMSecureRandom", "IBMPKCS11Impl");
        }
        catch (NoSuchProviderException noSuchProviderException) {
            // empty catch block
        }
        this.engineSetMode(mode);
        this.engineSetPadding(paddingScheme);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "DESCipher");
        }
    }

    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineSetMode", (Object)mode);
        }
        if (mode == null) {
            throw new NoSuchAlgorithmException("null mode");
        }
        String modeUpperCase = mode.toUpperCase();
        if (modeUpperCase.equals("ECB")) {
            this.cipherMode = 0;
            this.mechanism = 289;
        } else if (modeUpperCase.equals("CBC")) {
            this.cipherMode = 1;
            this.mechanism = 290;
        } else {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineSetMode", (Throwable)new NoSuchAlgorithmException("Cipher mode: " + mode + " not found"));
                debug.exit(16384L, (Object)className, "engineSetMode");
            }
            throw new NoSuchAlgorithmException("Cipher mode: " + mode + " not found");
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineSetMode");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void engineSetPadding(String paddingScheme) throws NoSuchPaddingException {
        block9: {
            block10: {
                if (debug != null) {
                    debug.entry(16384L, (Object)className, "engineSetPadding", (Object)paddingScheme);
                }
                if (this.mechanism != 290 && this.mechanism != 293) break block10;
                if (paddingScheme == null || paddingScheme.equalsIgnoreCase("NoPadding")) {
                    this.mechanism = 290;
                    break block9;
                } else if (paddingScheme.equalsIgnoreCase("Pad")) {
                    this.mechanism = 293;
                    break block9;
                } else {
                    if (debug != null) {
                        debug.exception(16384L, (Object)className, "engineSetPadding", (Throwable)new NoSuchPaddingException("Padding: " + paddingScheme + " can not be verified for use. Use Pad instead."));
                        debug.exit(16384L, (Object)className, "engineSetPadding");
                    }
                    throw new NoSuchPaddingException("Padding: " + paddingScheme + " can not be verified for use. Use Pad instead.");
                }
            }
            if (paddingScheme != null && !paddingScheme.equalsIgnoreCase("NoPadding")) {
                if (debug != null) {
                    debug.exception(16384L, (Object)className, "engineSetPadding", (Throwable)new NoSuchPaddingException("No padding implemented for ECB mode"));
                    debug.exit(16384L, (Object)className, "engineSetPadding");
                }
                throw new NoSuchPaddingException("No padding implemented for ECB mode");
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineSetPadding");
        }
    }

    protected int engineGetBlockSize() {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineGetBlockSize");
            debug.exit(16384L, (Object)className, "engineGetBlockSize");
        }
        return 8;
    }

    protected int engineGetOutputSize(int inputLen) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineGetOutputSize");
            debug.exception(16384L, (Object)className, "engineGetOutputSize", (Throwable)new UnsupportedOperationException("This size can not be guaranteed."));
            debug.exit(16384L, (Object)className, "engineGetOutputSize");
        }
        throw new UnsupportedOperationException("This size can not be guaranteed.");
    }

    protected byte[] engineGetIV() {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineGetIV");
            debug.exit(16384L, (Object)className, "engineGetIV");
        }
        if (this.cipherMode == 0) {
            return null;
        }
        return this.iv;
    }

    protected AlgorithmParameters engineGetParameters() {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineGetParameters");
        }
        AlgorithmParameters params = null;
        if (this.cipherMode == 0) {
            return null;
        }
        IvParameterSpec ivSpec = new IvParameterSpec(this.iv);
        try {
            params = AlgorithmParameters.getInstance("DES", "IBMPKCS11Impl");
        }
        catch (NoSuchAlgorithmException nsae) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineGetParameters", (Throwable)new RuntimeException("IBMPKCS11Impl called, but not configured"));
                debug.exit(16384L, (Object)className, "engineGetParameters");
            }
            throw new RuntimeException("IBMPKCS11Impl called, but not configured");
        }
        catch (NoSuchProviderException nspe) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineGetParameters", (Throwable)new RuntimeException("IBMPKCS11Impl called, but not configured"));
                debug.exit(16384L, (Object)className, "engineGetParameters");
            }
            throw new RuntimeException("IBMPKCS11Impl called, but not configured");
        }
        try {
            params.init(ivSpec);
        }
        catch (InvalidParameterSpecException ipse) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineGetParameters", (Throwable)new RuntimeException("IvParameterSpec not supported"));
                debug.exit(16384L, (Object)className, "engineGetParameters");
            }
            throw new RuntimeException("IvParameterSpec not supported");
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineGetParameters");
        }
        return params;
    }

    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        DESKey dkey;
        SecureRandom rnd;
        if (debug != null) {
            Object[] parms = new Object[]{new Integer(opmode), key, random};
            debug.entry(16384L, (Object)className, "engineInit", parms);
        }
        SecureRandom secureRandom = rnd = random == null ? this.random : random;
        if ((opmode == 2 || opmode == 4) && this.cipherMode != 0) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineInit", (Throwable)new InvalidKeyException("Parameters missing"));
                debug.exit(16384L, (Object)className, "engineInit");
            }
            throw new InvalidKeyException("Parameters missing");
        }
        if (key == null) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineInit", (Throwable)new InvalidKeyException("No key given"));
                debug.exit(16384L, (Object)className, "engineInit");
            }
            throw new InvalidKeyException("No key given");
        }
        if (!(key instanceof PKCS11SecretKey || key instanceof SecretKey && key.getAlgorithm().equalsIgnoreCase("DES") && key.getFormat().equalsIgnoreCase("RAW"))) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineInit", (Throwable)new InvalidKeyException("Key given is not a DES key."));
                debug.exit(16384L, (Object)className, "engineInit");
            }
            throw new InvalidKeyException("Key given is not a DES key.");
        }
        if (key instanceof SecretKey && key.getAlgorithm().equalsIgnoreCase("DES") && key.getFormat().equalsIgnoreCase("RAW")) {
            try {
                SecretKeyFactory kf = SecretKeyFactory.getInstance("DES", "IBMPKCS11Impl");
                dkey = (DESKey)kf.translateKey((SecretKey)key);
            }
            catch (Exception e) {
                if (debug != null) {
                    debug.exception(16384L, (Object)className, "engineInit", (Throwable)new InvalidKeyException("Cannot convert key: " + key + " with reason: " + e.getMessage()));
                    debug.exit(16384L, (Object)className, "engineInit");
                }
                throw new InvalidKeyException("Cannot convert key: " + key + " with reason: " + e.getMessage());
            }
        } else {
            dkey = (DESKey)key;
        }
        if (this.cipherMode == 1) {
            this.iv = new byte[8];
            rnd.nextBytes(this.iv);
        }
        this.cipher = new PKCS11Cipher(this.mechanism);
        this.cipher.engineInit(opmode, dkey.getObject(), this.iv, 8);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineInit");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        DESKey dkey;
        block19: {
            if (debug != null) {
                Object[] parms = new Object[]{new Integer(opmode), key, params, random};
                debug.entry(16384L, (Object)className, "engineInit", parms);
            }
            if ((opmode == 2 || opmode == 4) && this.cipherMode != 0 && params == null) {
                if (debug != null) {
                    debug.exception(16384L, (Object)className, "engineInit", (Throwable)new InvalidAlgorithmParameterException("Parameters missing"));
                    debug.exit(16384L, (Object)className, "engineInit");
                }
                throw new InvalidAlgorithmParameterException("Parameters missing");
            }
            if (key == null) {
                if (debug != null) {
                    debug.exception(16384L, (Object)className, "engineInit", (Throwable)new InvalidKeyException("No key given"));
                    debug.exit(16384L, (Object)className, "engineInit");
                }
                throw new InvalidKeyException("No key given");
            }
            if (!(key instanceof PKCS11SecretKey || key instanceof SecretKey && key.getAlgorithm().equalsIgnoreCase("DES") && key.getFormat().equalsIgnoreCase("RAW"))) {
                if (debug != null) {
                    debug.exception(16384L, (Object)className, "engineInit", (Throwable)new InvalidKeyException("Key given is not a DES key."));
                    debug.exit(16384L, (Object)className, "engineInit");
                }
                throw new InvalidKeyException("Key given is not a DES key.");
            }
            if (key instanceof SecretKey && key.getAlgorithm().equalsIgnoreCase("DES") && key.getFormat().equalsIgnoreCase("RAW")) {
                try {
                    SecretKeyFactory kf = SecretKeyFactory.getInstance("DES", "IBMPKCS11Impl");
                    dkey = (DESKey)kf.translateKey((SecretKey)key);
                }
                catch (Exception e) {
                    if (debug != null) {
                        debug.exception(16384L, (Object)className, "engineInit", (Throwable)new InvalidKeyException("Cannot convert key: " + key + " with reason: " + e.getMessage()));
                        debug.exit(16384L, (Object)className, "engineInit");
                    }
                    throw new InvalidKeyException("Cannot convert key: " + key + " with reason: " + e.getMessage());
                }
            } else {
                dkey = (DESKey)key;
            }
            if (this.cipherMode == 1) {
                if (params != null) {
                    if (params instanceof IvParameterSpec) {
                        this.iv = ((IvParameterSpec)params).getIV();
                        break block19;
                    } else {
                        if (debug != null) {
                            debug.exception(16384L, (Object)className, "engineInit", (Throwable)new InvalidAlgorithmParameterException("Wrong parameter type: IV expected"));
                            debug.exit(16384L, (Object)className, "engineInit");
                        }
                        throw new InvalidAlgorithmParameterException("Wrong parameter type: IV expected");
                    }
                }
                if (random != null) {
                    byte[] iv = new byte[8];
                    random.nextBytes(iv);
                }
            }
        }
        this.cipher = new PKCS11Cipher(this.mechanism);
        this.cipher.engineInit(opmode, dkey.getObject(), this.iv, 8);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineInit");
        }
    }

    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (debug != null) {
            Object[] parms = new Object[]{new Integer(opmode), key, params, random};
            debug.entry(16384L, (Object)className, "engineInit", parms);
        }
        IvParameterSpec ivSpec = null;
        if (params != null) {
            try {
                ivSpec = (IvParameterSpec)params.getParameterSpec(class$javax$crypto$spec$IvParameterSpec == null ? (class$javax$crypto$spec$IvParameterSpec = DESCipher.class$("javax.crypto.spec.IvParameterSpec")) : class$javax$crypto$spec$IvParameterSpec);
            }
            catch (InvalidParameterSpecException ipse) {
                if (debug != null) {
                    debug.exception(16384L, (Object)className, "engineInit", (Throwable)new InvalidAlgorithmParameterException("Wrong parameter type: IV expected"));
                    debug.exit(16384L, (Object)className, "engineInit");
                }
                throw new InvalidAlgorithmParameterException("Wrong parameter type: IV expected");
            }
        }
        this.engineInit(opmode, key, ivSpec, random);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineInit");
        }
    }

    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        if (debug != null) {
            Object[] parms = new Object[]{input, new Integer(inputOffset), new Integer(inputLen)};
            debug.entry(16384L, (Object)className, "engineUpdate", parms);
            debug.exit(16384L, (Object)className, "engineUpdate");
        }
        return this.cipher.engineUpdate(input, inputOffset, inputLen);
    }

    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        if (debug != null) {
            Object[] parms = new Object[]{input, new Integer(inputOffset), new Integer(inputLen), output, new Integer(outputOffset)};
            debug.entry(16384L, (Object)className, "engineUpdate", parms);
            debug.exit(16384L, (Object)className, "engineUpdate");
        }
        return this.cipher.engineUpdate(input, inputOffset, inputLen, output, outputOffset);
    }

    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        if (debug != null) {
            Object[] parms = new Object[]{input, new Integer(inputOffset), new Integer(inputLen)};
            debug.entry(16384L, (Object)className, "engineDoFinal", parms);
            debug.exit(16384L, (Object)className, "engineDoFinal");
        }
        return this.cipher.engineDoFinal(input, inputOffset, inputLen);
    }

    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws IllegalBlockSizeException, ShortBufferException, BadPaddingException {
        if (debug != null) {
            Object[] parms = new Object[]{input, new Integer(inputOffset), new Integer(inputLen), output, new Integer(outputOffset)};
            debug.entry(16384L, (Object)className, "engineDoFinal", parms);
            debug.exit(16384L, (Object)className, "engineDoFinal");
        }
        return this.cipher.engineDoFinal(input, inputOffset, inputLen, output, outputOffset);
    }

    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineGetKeySize", (Object)key);
        }
        if (!(key instanceof DESKey || key instanceof SecretKey && key.getAlgorithm().equalsIgnoreCase("DES") && key.getFormat().equalsIgnoreCase("RAW"))) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "engineGetKeySize", (Object)new InvalidKeyException("Wrong key passed in."));
                debug.exit(16384L, (Object)className, "engineGetKeySize");
            }
            throw new InvalidKeyException("Wrong key passed in.");
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineGetKeySize");
        }
        return 56;
    }

    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineWrap", (Object)key);
            debug.exit(16384L, (Object)className, "engineWrap");
        }
        int len = ((PKCS11Key)key).getObject().size() + 7;
        return this.cipher.engineWrap(((PKCS11Key)key).getObject(), len);
    }

    protected Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        if (debug != null) {
            Object[] parms = new Object[]{wrappedKey, wrappedKeyAlgorithm, new Integer(wrappedKeyType)};
            debug.entry(16384L, (Object)className, "engineUnwrap", parms);
        }
        Key result = null;
        int[] attrTypes = null;
        Object[] attrValues = null;
        Object[] attrs = new Object[2];
        PKCS11Object objKey = null;
        switch (wrappedKeyType) {
            case 3: {
                attrs = ConstructKeys.constructSecretKeyAttrs(wrappedKeyAlgorithm);
                attrTypes = (int[])attrs[0];
                attrValues = (Object[])attrs[1];
                objKey = this.cipher.engineUnwrap(wrappedKey, attrTypes, attrValues);
                result = ConstructKeys.constructSecretKey(objKey, wrappedKeyAlgorithm);
                break;
            }
            case 2: {
                attrs = ConstructKeys.constructPrivateKeyAttrs(wrappedKeyAlgorithm);
                attrTypes = (int[])attrs[0];
                attrValues = (Object[])attrs[1];
                objKey = this.cipher.engineUnwrap(wrappedKey, attrTypes, attrValues);
                result = ConstructKeys.constructPrivateKey(objKey, wrappedKeyAlgorithm);
                break;
            }
            case 1: {
                attrs = ConstructKeys.constructPublicKeyAttrs(wrappedKeyAlgorithm);
                attrTypes = (int[])attrs[0];
                attrValues = (Object[])attrs[1];
                objKey = this.cipher.engineUnwrap(wrappedKey, attrTypes, attrValues);
                result = ConstructKeys.constructPublicKey(objKey, wrappedKeyAlgorithm);
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineUnwrap");
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

