/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.DESKey;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.PKCS11KeySpec;
import com.ibm.crypto.pkcs11impl.provider.PKCS11SecretKey;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.pkcs11.PKCS11Session;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.spec.DESKeySpec;

public final class DESPKCS11KeyFactory
extends SecretKeyFactorySpi {
    private PKCS11Session session = null;
    private static Debug debug1 = Debug.getInstance((String)"pkcs11impl");
    private static Debug debug2 = Debug.getInstance((String)"despkcs11keyfactory");
    private static Debug debug = debug1 == null ? debug2 : debug1;
    private static String className = "com.ibm.crypto.pkcs11impl.provider.DESPKCS11KeyFactory";
    static /* synthetic */ Class class$javax$crypto$spec$DESKeySpec;

    public DESPKCS11KeyFactory() {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "DESPKCS11KeyFactory");
        }
        IBMPKCS11Impl.verifyJceJar();
        this.session = IBMPKCS11Impl.session;
        if (debug != null) {
            debug.exit(16384L, (Object)className, "DESPKCS11KeyFactory");
        }
    }

    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        DESKey desKey;
        block11: {
            if (debug != null) {
                debug.entry(16384L, (Object)className, "engineGenerateSecret", (Object)keySpec);
            }
            desKey = null;
            if (keySpec == null || !(keySpec instanceof DESKeySpec) && !(keySpec instanceof PKCS11KeySpec)) {
                if (debug != null) {
                    debug.text(16384L, (Object)className, "engineGenerateSecret", "Inappropriate key specification");
                    debug.exit(16384L, (Object)className, "engineGenerateSecret");
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            if (!(keySpec instanceof PKCS11KeySpec)) {
                try {
                    PKCS11Object object = null;
                    byte[] ID = null;
                    Boolean isToken = Boolean.FALSE;
                    Boolean isSensitive = Boolean.FALSE;
                    Boolean encrypt = Boolean.TRUE;
                    Boolean wrapping = Boolean.TRUE;
                    Boolean extractable = Boolean.TRUE;
                    byte[] value = null;
                    DESKeySpec desKeySpec = (DESKeySpec)keySpec;
                    value = desKeySpec.getKey();
                    ID = this.genID();
                    int[] attrTypes = new int[]{0, 256, 258, 2, 1, 259, 260, 261, 262, 263, 17};
                    Object[] attrValues = new Object[]{PKCS11Object.SECRET_KEY, PKCS11Object.DES, ID, Boolean.TRUE, isToken, isSensitive, encrypt, new Boolean(encrypt), wrapping, new Boolean(wrapping), value};
                    object = this.session.createObject(attrTypes, attrValues);
                    desKey = new DESKey(object, ID, null, isToken, isSensitive, encrypt, wrapping, extractable, value);
                }
                catch (InvalidKeyException e) {
                    if (debug != null) {
                        debug.exception(16384L, (Object)className, "engineGenerateSecret", (Throwable)e);
                    }
                    break block11;
                }
            }
            PKCS11Object object = ((PKCS11KeySpec)keySpec).getObject();
            byte[] ID = (byte[])this.getAttrValue(object, 258);
            String label = (String)this.getAttrValue(object, 3);
            Boolean isToken = (Boolean)this.getAttrValue(object, 1);
            Boolean isSensitive = (Boolean)this.getAttrValue(object, 259);
            Boolean encrypt = (Boolean)this.getAttrValue(object, 260);
            Boolean wrapping = (Boolean)this.getAttrValue(object, 262);
            Boolean extractable = (Boolean)this.getAttrValue(object, 354);
            byte[] value = (byte[])this.getAttrValue(object, 17);
            if (debug != null) {
                System.out.println("ID = " + ID);
                System.out.println("label = " + label);
                System.out.println("isToken = " + isToken);
                System.out.println("isSensitive = " + isSensitive);
                System.out.println("encrypt = " + encrypt);
                System.out.println("wrapping = " + wrapping);
                System.out.println("extractable = " + extractable);
                System.out.println("value = " + value);
            }
            try {
                desKey = new DESKey(object, ID, label, isToken, isSensitive, encrypt, wrapping, extractable, value);
            }
            catch (InvalidKeyException e) {
                if (debug == null) break block11;
                debug.exception(16384L, (Object)className, "engineGenerateSecret", (Throwable)e);
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineGenerateSecret");
        }
        return desKey;
    }

    protected KeySpec engineGetKeySpec(SecretKey key, Class keySpec) throws InvalidKeySpecException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineGetKeySpec", (Object)key, (Object)keySpec);
        }
        try {
            if (key != null && key instanceof PKCS11SecretKey && key.getAlgorithm().equalsIgnoreCase("DES") && key.getFormat().equalsIgnoreCase("PKCS#11")) {
                Class<?> desKeySpec = Class.forName("javax.crypto.spec.DESKeySpec");
                if (keySpec != null && desKeySpec.isAssignableFrom(keySpec)) {
                    if (((DESKey)key).getSensitive().booleanValue()) {
                        if (debug != null) {
                            debug.text(16384L, (Object)className, "engineGetKeySpec_1", "Secret key value is not exportable");
                            debug.exit(16384L, (Object)className, "engineGetKeySpec_1");
                        }
                        throw new PKCS11Exception("Secret key value is not exportable");
                    }
                    if (debug != null) {
                        debug.exit(16384L, (Object)className, "engineGetKeySpec_2", (Object)"PKCS11SecretKey");
                    }
                    return new DESKeySpec(((DESKey)key).getValue());
                }
                if (debug != null) {
                    debug.text(16384L, (Object)className, "engineGetKeySpec_3", "Inappropriate key specification");
                    debug.exit(16384L, (Object)className, "engineGetKeySpec_3");
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            if (key != null && key instanceof SecretKey && key.getAlgorithm().equalsIgnoreCase("DES") && key.getFormat().equalsIgnoreCase("RAW")) {
                Class<?> desKeySpec = Class.forName("javax.crypto.spec.DESKeySpec");
                if (keySpec != null && desKeySpec.isAssignableFrom(keySpec)) {
                    if (debug != null) {
                        debug.exit(16384L, (Object)className, "engineGetKeySpec_4", (Object)"SecretKey");
                    }
                    return new DESKeySpec(key.getEncoded());
                }
                if (debug != null) {
                    debug.text(16384L, (Object)className, "engineGetKeySpec_5", "Inappropriate key specification");
                    debug.exit(16384L, (Object)className, "engineGetKeySpec_5");
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            if (debug != null) {
                debug.text(16384L, (Object)className, "engineGetKeySpec_6", "Inappropriate key specification");
                debug.exit(16384L, (Object)className, "engineGetKeySpec_6");
            }
            throw new InvalidKeySpecException("Inappropriate key format/algorithm");
        }
        catch (InvalidKeyException e) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineGetKeySpec_7", (Throwable)e);
                debug.exit(16384L, (Object)className, "engineGetKeySpec_7");
            }
            throw new InvalidKeySpecException("Secret key has wrong size");
        }
        catch (ClassNotFoundException e) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineGetKeySpec_8", (Throwable)e);
                debug.exit(16384L, (Object)className, "engineGetKeySpec_8");
            }
            throw new InvalidKeySpecException("Unsupported key specification: " + e.getMessage());
        }
    }

    protected SecretKey engineTranslateKey(SecretKey key) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineTranslateKey", (Object)key);
        }
        try {
            if (key != null && key instanceof DESKey) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "engineTranslateKey", (Object)"PKCS11 DES KEY");
                }
                return key;
            }
            if (key != null && key.getAlgorithm().equalsIgnoreCase("DES") && key.getFormat().equalsIgnoreCase("RAW")) {
                DESKeySpec desKeySpec = (DESKeySpec)this.engineGetKeySpec(key, class$javax$crypto$spec$DESKeySpec == null ? (class$javax$crypto$spec$DESKeySpec = DESPKCS11KeyFactory.class$("javax.crypto.spec.DESKeySpec")) : class$javax$crypto$spec$DESKeySpec);
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "engineTranslateKey", (Object)"DES KEY");
                }
                return this.engineGenerateSecret(desKeySpec);
            }
            if (debug != null) {
                debug.text(16384L, (Object)className, "engineTranslateKey", "Inappropriate key format/algorithm");
                debug.exit(16384L, (Object)className, "engineTranslateKey");
            }
            throw new InvalidKeyException("Inappropriate key format/algorithm");
        }
        catch (InvalidKeySpecException e) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineTranslateKey", (Throwable)e);
                debug.exit(16384L, (Object)className, "engineTranslateKey");
            }
            throw new InvalidKeyException("Cannot translate key");
        }
    }

    private byte[] genID() {
        byte[] labelName = new byte[33];
        byte[] labelSaltData = new byte[24];
        byte[] labelTmp = null;
        int labelLength = 0;
        try {
            SecureRandom random = SecureRandom.getInstance("IBMSecureRandom", "IBMPKCS11Impl");
            random.nextBytes(labelSaltData);
        }
        catch (Exception e) {
            // empty catch block
        }
        BigInteger bigInt = new BigInteger(1, labelSaltData);
        try {
            labelTmp = bigInt.toString().getBytes("8859_1");
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError("Can not convert string");
        }
        labelLength = bigInt.toString().length();
        if (labelLength > 24) {
            labelLength = 24;
        }
        System.arraycopy(labelTmp, 0, labelName, 9, labelLength);
        labelName[0] = 73;
        labelName[1] = 66;
        labelName[2] = 77;
        labelName[3] = 80;
        labelName[4] = 75;
        labelName[5] = 67;
        labelName[6] = 83;
        labelName[7] = 49;
        labelName[8] = 49;
        return labelName;
    }

    private Object getAttrValue(PKCS11Object pkcs11obj, int attr) {
        Object rtn;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getValue", (Object)pkcs11obj, (Object)new Integer(attr));
        }
        try {
            rtn = pkcs11obj.getAttributeValue(attr);
        }
        catch (Exception e) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "getValue", e.getMessage());
            }
            rtn = null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getValue");
        }
        return rtn;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

