/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.ConstructKeys;
import com.ibm.crypto.pkcs11impl.provider.DESedeKey;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.PKCS11Cipher;
import com.ibm.crypto.pkcs11impl.provider.PKCS11Key;
import com.ibm.crypto.pkcs11impl.provider.PKCS11SecretKey;
import com.ibm.pkcs11.PKCS11Object;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;

public final class DESedeCipher
extends CipherSpi {
    protected int cipherMode;
    private boolean decrypting = false;
    protected static final int ECB_MODE = 0;
    protected static final int CBC_MODE = 1;
    private byte[] iv = null;
    SecureRandom random = null;
    PKCS11Cipher cipher = null;
    private int mechanism;
    public static final int DES_BLOCK_SIZE = 8;
    static /* synthetic */ Class class$javax$crypto$spec$IvParameterSpec;

    public DESedeCipher() {
        IBMPKCS11Impl.verifyJceJar();
        if (!IBMPKCS11Impl.verifySelfIntegrity(this.getClass())) {
            throw new SecurityException("The IBM JCE PKCS11 provider may have been tampered.");
        }
        this.cipherMode = 0;
        this.mechanism = 306;
    }

    public DESedeCipher(String mode, String paddingScheme) throws NoSuchAlgorithmException, NoSuchPaddingException {
        IBMPKCS11Impl.verifyJceJar();
        if (!IBMPKCS11Impl.verifySelfIntegrity(this.getClass())) {
            throw new SecurityException("The IBM JCE PKCS11 provider may have been tampered.");
        }
        try {
            this.random = SecureRandom.getInstance("IBMSecureRandom", "IBMPKCS11Impl");
        }
        catch (NoSuchProviderException noSuchProviderException) {
            // empty catch block
        }
        this.engineSetMode(mode);
        this.engineSetPadding(paddingScheme);
    }

    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        if (mode == null) {
            throw new NoSuchAlgorithmException("null mode");
        }
        String modeUpperCase = mode.toUpperCase();
        if (modeUpperCase.equals("ECB")) {
            this.cipherMode = 0;
            this.mechanism = 306;
        } else if (modeUpperCase.equals("CBC")) {
            this.cipherMode = 1;
            this.mechanism = 307;
        } else {
            throw new NoSuchAlgorithmException("Cipher mode: " + mode + " not found");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void engineSetPadding(String paddingScheme) throws NoSuchPaddingException {
        if (this.mechanism == 307) {
            if (paddingScheme == null || paddingScheme.equalsIgnoreCase("NoPadding")) {
                this.mechanism = 307;
                return;
            } else {
                if (!paddingScheme.equalsIgnoreCase("Pad")) throw new NoSuchPaddingException("Padding: " + paddingScheme + " can not be verified for use. " + "Use Pad instead.");
                this.mechanism = 310;
            }
            return;
        } else {
            if (paddingScheme == null || paddingScheme.equalsIgnoreCase("NoPadding")) return;
            throw new NoSuchPaddingException("No padding implemented for ECB mode");
        }
    }

    protected int engineGetBlockSize() {
        return 8;
    }

    protected int engineGetOutputSize(int inputLen) {
        throw new UnsupportedOperationException("This size can not be guaranteed.");
    }

    protected byte[] engineGetIV() {
        if (this.cipherMode == 0) {
            return null;
        }
        return this.iv;
    }

    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        DESedeKey dkey;
        if ((opmode == 2 || opmode == 4) && this.cipherMode != 0) {
            throw new InvalidKeyException("Parameters missing");
        }
        if (key == null) {
            throw new InvalidKeyException("No key given");
        }
        if (!(key instanceof PKCS11SecretKey || key instanceof SecretKey && key.getAlgorithm().equalsIgnoreCase("DESede") && key.getFormat().equalsIgnoreCase("RAW"))) {
            throw new InvalidKeyException("Key given is not a DESede key.");
        }
        if (key instanceof SecretKey && key.getAlgorithm().equalsIgnoreCase("DESede") && key.getFormat().equalsIgnoreCase("RAW")) {
            try {
                SecretKeyFactory kf = SecretKeyFactory.getInstance("DESede", "IBMPKCS11Impl");
                dkey = (DESedeKey)kf.translateKey((SecretKey)key);
            }
            catch (Exception e) {
                throw new InvalidKeyException("Cannot convert key: " + key + " with reason: " + e.getMessage());
            }
        } else {
            dkey = (DESedeKey)key;
        }
        if (this.cipherMode == 1) {
            this.iv = new byte[8];
            random.nextBytes(this.iv);
        }
        this.cipher = new PKCS11Cipher(this.mechanism);
        this.cipher.engineInit(opmode, dkey.getObject(), this.iv, 8);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        DESedeKey dkey;
        if ((opmode == 2 || opmode == 4) && this.cipherMode != 0 && params == null) {
            throw new InvalidAlgorithmParameterException("Parameters missing");
        }
        if (key == null) {
            throw new InvalidKeyException("No key given");
        }
        if (!(key instanceof PKCS11SecretKey || key instanceof SecretKey && key.getAlgorithm().equalsIgnoreCase("DESede") && key.getFormat().equalsIgnoreCase("RAW"))) {
            throw new InvalidKeyException("Key given is not a DESede key.");
        }
        if (key instanceof SecretKey && key.getAlgorithm().equalsIgnoreCase("DESede") && key.getFormat().equalsIgnoreCase("RAW")) {
            try {
                SecretKeyFactory kf = SecretKeyFactory.getInstance("DESede", "IBMPKCS11Impl");
                dkey = (DESedeKey)kf.translateKey((SecretKey)key);
            }
            catch (Exception e) {
                throw new InvalidKeyException("Cannot convert key: " + key + " with reason: " + e.getMessage());
            }
        } else {
            dkey = (DESedeKey)key;
        }
        if (this.cipherMode == 1) {
            if (params != null) {
                if (!(params instanceof IvParameterSpec)) throw new InvalidAlgorithmParameterException("Wrong parameter type: IV expected");
                this.iv = ((IvParameterSpec)params).getIV();
            } else if (random != null) {
                byte[] iv = new byte[8];
                random.nextBytes(iv);
            }
        }
        this.cipher = new PKCS11Cipher(this.mechanism);
        this.cipher.engineInit(opmode, dkey.getObject(), this.iv, 8);
    }

    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        IvParameterSpec ivSpec = null;
        if (params != null) {
            try {
                ivSpec = (IvParameterSpec)params.getParameterSpec(class$javax$crypto$spec$IvParameterSpec == null ? (class$javax$crypto$spec$IvParameterSpec = DESedeCipher.class$("javax.crypto.spec.IvParameterSpec")) : class$javax$crypto$spec$IvParameterSpec);
            }
            catch (InvalidParameterSpecException ipse) {
                throw new InvalidAlgorithmParameterException("Wrong parameter type: IV expected");
            }
        }
        this.engineInit(opmode, key, ivSpec, random);
    }

    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        return this.cipher.engineUpdate(input, inputOffset, inputLen);
    }

    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        return this.cipher.engineUpdate(input, inputOffset, inputLen, output, outputOffset);
    }

    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        return this.cipher.engineDoFinal(input, inputOffset, inputLen);
    }

    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws IllegalBlockSizeException, ShortBufferException, BadPaddingException {
        return this.cipher.engineDoFinal(input, inputOffset, inputLen, output, outputOffset);
    }

    protected AlgorithmParameters engineGetParameters() {
        AlgorithmParameters params = null;
        if (this.cipherMode == 0) {
            return null;
        }
        IvParameterSpec ivSpec = new IvParameterSpec(this.iv);
        try {
            params = AlgorithmParameters.getInstance("DESede", "IBMPKCS11Impl");
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException("IBMPKCS11Impl called, but not configured");
        }
        catch (NoSuchProviderException nspe) {
            throw new RuntimeException("IBMPKCS11Impl called, but not configured");
        }
        try {
            params.init(ivSpec);
        }
        catch (InvalidParameterSpecException ipse) {
            throw new RuntimeException("IvParameterSpec not supported");
        }
        return params;
    }

    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        if (!(key instanceof DESedeKey || key instanceof SecretKey && key.getAlgorithm().equalsIgnoreCase("DESede") && key.getFormat().equalsIgnoreCase("RAW"))) {
            throw new InvalidKeyException();
        }
        return 168;
    }

    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        int len = ((PKCS11Key)key).getObject().size() + 7;
        return this.cipher.engineWrap(((PKCS11Key)key).getObject(), len);
    }

    protected Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        Key result = null;
        int[] attrTypes = null;
        Object[] attrValues = null;
        Object[] attrs = new Object[2];
        PKCS11Object objKey = null;
        switch (wrappedKeyType) {
            case 3: {
                attrs = ConstructKeys.constructSecretKeyAttrs(wrappedKeyAlgorithm);
                attrTypes = (int[])attrs[0];
                attrValues = (Object[])attrs[1];
                objKey = this.cipher.engineUnwrap(wrappedKey, attrTypes, attrValues);
                result = ConstructKeys.constructSecretKey(objKey, wrappedKeyAlgorithm);
                break;
            }
            case 2: {
                attrs = ConstructKeys.constructPrivateKeyAttrs(wrappedKeyAlgorithm);
                attrTypes = (int[])attrs[0];
                attrValues = (Object[])attrs[1];
                objKey = this.cipher.engineUnwrap(wrappedKey, attrTypes, attrValues);
                result = ConstructKeys.constructPrivateKey(objKey, wrappedKeyAlgorithm);
                break;
            }
            case 1: {
                attrs = ConstructKeys.constructPublicKeyAttrs(wrappedKeyAlgorithm);
                attrTypes = (int[])attrs[0];
                attrValues = (Object[])attrs[1];
                objKey = this.cipher.engineUnwrap(wrappedKey, attrTypes, attrValues);
                result = ConstructKeys.constructPublicKey(objKey, wrappedKeyAlgorithm);
            }
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

