/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.PKCS11DESedeKey;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Object;
import java.io.Serializable;
import java.security.InvalidKeyException;
import java.util.Date;

public final class DESedeKey
implements PKCS11DESedeKey,
Serializable {
    private PKCS11Object object = null;
    private Boolean isToken = null;
    private Boolean isPrivate = null;
    private String label = null;
    private Boolean isModifiable = null;
    private Integer keyType = PKCS11Object.DES3;
    private byte[] ID = null;
    private Date startDate = null;
    private Date endDate = null;
    private Boolean isDerive = null;
    private Boolean isLocal = null;
    private Boolean isSensitive = null;
    private Boolean isEncrypt = null;
    private Boolean isDecrypt = null;
    private Boolean isSign = null;
    private Boolean isVerify = null;
    private Boolean isWrap = null;
    private Boolean isUnwrap = null;
    private Boolean isExtractable = null;
    private Boolean isAlwaysSensitive = null;
    private Boolean isNeverExtractable = null;
    private byte[] value = null;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.DESedeKey";

    DESedeKey(PKCS11Object object, byte[] ID, String label, Boolean isToken, Boolean isSensitive, Boolean encrypt, Boolean wrapping, Boolean extractable) throws InvalidKeyException {
        this.object = object;
        if (ID != null) {
            this.ID = new byte[ID.length];
            System.arraycopy(ID, 0, this.ID, 0, ID.length);
        } else {
            this.ID = (byte[])this.getAttrValue(this.object, 258);
        }
        this.label = label != null ? label : (String)this.getAttrValue(this.object, 3);
        this.isToken = isToken != null ? new Boolean(isToken) : (Boolean)this.getAttrValue(this.object, 1);
        this.isSensitive = isSensitive != null ? new Boolean(isSensitive) : (Boolean)this.getAttrValue(this.object, 259);
        this.isEncrypt = encrypt != null ? new Boolean(encrypt) : (Boolean)this.getAttrValue(this.object, 260);
        this.isWrap = wrapping != null ? new Boolean(wrapping) : (Boolean)this.getAttrValue(this.object, 262);
        this.isExtractable = extractable != null ? new Boolean(extractable) : (Boolean)this.getAttrValue(this.object, 354);
        this.isPrivate = (Boolean)this.getAttrValue(this.object, 2);
        this.isModifiable = (Boolean)this.getAttrValue(this.object, 368);
        this.startDate = (Date)this.getAttrValue(this.object, 272);
        this.endDate = (Date)this.getAttrValue(this.object, 273);
        this.isDerive = (Boolean)this.getAttrValue(this.object, 268);
        this.isLocal = (Boolean)this.getAttrValue(this.object, 355);
        this.isDecrypt = (Boolean)this.getAttrValue(this.object, 261);
        this.isVerify = (Boolean)this.getAttrValue(this.object, 266);
        this.isUnwrap = (Boolean)this.getAttrValue(this.object, 263);
        this.isAlwaysSensitive = (Boolean)this.getAttrValue(this.object, 357);
        this.isNeverExtractable = (Boolean)this.getAttrValue(this.object, 356);
    }

    public DESedeKey(PKCS11Object object, byte[] ID, String label, Boolean isToken, Boolean isSensitive, Boolean encrypt, Boolean wrapping, Boolean extractable, byte[] value) throws InvalidKeyException {
        this(object, ID, label, isToken, isSensitive, encrypt, wrapping, extractable);
        if (value != null) {
            this.value = new byte[value.length];
            System.arraycopy(value, 0, this.value, 0, value.length);
        }
    }

    public byte[] getEncoded() {
        if (this.value != null) {
            return (byte[])this.value.clone();
        }
        return null;
    }

    public PKCS11Object getObject() {
        return this.object;
    }

    public Boolean getToken() {
        return new Boolean(this.isToken);
    }

    public Boolean getPrivate() {
        return new Boolean(this.isPrivate);
    }

    public String getLabel() {
        return this.label;
    }

    public Boolean getModifiable() {
        return new Boolean(this.isModifiable);
    }

    public Integer getKeyType() {
        return this.keyType;
    }

    public byte[] getID() {
        return (byte[])this.ID.clone();
    }

    public Date getStartDate() {
        return (Date)this.startDate.clone();
    }

    public Date getEndDate() {
        return (Date)this.endDate.clone();
    }

    public Boolean getDerive() {
        return new Boolean(this.isDerive);
    }

    public Boolean getLocal() {
        return new Boolean(this.isLocal);
    }

    public Boolean getSensitive() {
        return new Boolean(this.isSensitive);
    }

    public Boolean getEncrypt() {
        return new Boolean(this.isEncrypt);
    }

    public Boolean getDecrypt() {
        return new Boolean(this.isDecrypt);
    }

    public Boolean getSign() {
        return new Boolean(this.isSign);
    }

    public Boolean getVerify() {
        return new Boolean(this.isVerify);
    }

    public Boolean getWrap() {
        return new Boolean(this.isWrap);
    }

    public Boolean getUnwrap() {
        return new Boolean(this.isUnwrap);
    }

    public Boolean getExtractable() {
        return new Boolean(this.isExtractable);
    }

    public Boolean getAlwaysSensitive() {
        return new Boolean(this.isAlwaysSensitive);
    }

    public Boolean getNeverExtractable() {
        return new Boolean(this.isNeverExtractable);
    }

    public byte[] getValue() {
        return this.value;
    }

    public String toString() {
        String prov = "IBMPKCS11Impl";
        String output = prov + " DESede Key: ";
        if (this.isToken != null) {
            output = output + "\n Token: " + this.isToken;
        }
        if (this.isPrivate != null) {
            output = output + "\n Private: " + this.isPrivate;
        }
        if (this.label != null) {
            output = output + "\n Label: " + this.label;
        }
        if (this.isModifiable != null) {
            output = output + "\n Modifiable: " + this.isModifiable;
        }
        output = output + "\n KeyType: " + this.keyType.toString();
        if (this.ID != null) {
            output = output + "\n ID: " + new String(this.ID);
        }
        if (this.startDate != null) {
            output = output + "\n Start Date: " + this.startDate.toString();
        }
        if (this.endDate != null) {
            output = output + "\n End Date: " + this.endDate.toString();
        }
        if (this.isDerive != null) {
            output = output + "\n Derive: " + this.isDerive;
        }
        if (this.isLocal != null) {
            output = output + "\n Local: " + this.isLocal;
        }
        if (this.isSensitive != null) {
            output = output + "\n Sensitive: " + this.isSensitive;
        }
        if (this.isEncrypt != null) {
            output = output + "\n Encrypt: " + this.isEncrypt;
        }
        if (this.isDecrypt != null) {
            output = output + "\n Decrypt: " + this.isDecrypt;
        }
        if (this.isSign != null) {
            output = output + "\n Sign: " + this.isSign;
        }
        if (this.isVerify != null) {
            output = output + "\n Verify: " + this.isVerify;
        }
        if (this.isWrap != null) {
            output = output + "\n Wrap: " + this.isWrap;
        }
        if (this.isUnwrap != null) {
            output = output + "\n Unwrap: " + this.isUnwrap;
        }
        if (this.isExtractable != null) {
            output = output + "\n Extractable: " + this.isExtractable;
        }
        if (this.isAlwaysSensitive != null) {
            output = output + "\n Always Sensitive: " + this.isAlwaysSensitive;
        }
        if (this.isNeverExtractable != null) {
            output = output + "\n Never Extractable: " + this.isNeverExtractable;
        }
        if (this.value != null) {
            output = output + "\n value: " + this.value.toString();
        }
        return output;
    }

    public String getFormat() {
        return "PKCS#11";
    }

    public String getAlgorithm() {
        return "DESede";
    }

    private Object getAttrValue(PKCS11Object pkcs11obj, int attr) {
        Object rtn;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getValue", (Object)pkcs11obj, (Object)new Integer(attr));
        }
        try {
            rtn = pkcs11obj.getAttributeValue(attr);
        }
        catch (Exception e) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "getValue", e.getMessage());
            }
            rtn = null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getValue");
        }
        return rtn;
    }
}

