/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.DESedeKey;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.PKCS11KeySpec;
import com.ibm.crypto.pkcs11impl.provider.PKCS11SecretKey;
import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.pkcs11.PKCS11Session;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.spec.DESedeKeySpec;

public final class DESedePKCS11KeyFactory
extends SecretKeyFactorySpi {
    private PKCS11Session session = null;
    static /* synthetic */ Class class$javax$crypto$spec$DESedeKeySpec;

    public DESedePKCS11KeyFactory() {
        IBMPKCS11Impl.verifyJceJar();
        this.session = IBMPKCS11Impl.session;
    }

    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        DESedeKey desEdeKey = null;
        if (keySpec == null || !(keySpec instanceof DESedeKeySpec) && !(keySpec instanceof PKCS11KeySpec)) {
            throw new InvalidKeySpecException("Inappropriate key specification");
        }
        if (!(keySpec instanceof PKCS11KeySpec)) {
            try {
                PKCS11Object object = null;
                byte[] ID = null;
                Boolean isToken = Boolean.FALSE;
                Boolean isSensitive = Boolean.FALSE;
                Boolean encrypt = Boolean.TRUE;
                Boolean wrapping = Boolean.TRUE;
                Boolean extractable = Boolean.TRUE;
                byte[] value = null;
                DESedeKeySpec desEdeKeySpec = (DESedeKeySpec)keySpec;
                value = desEdeKeySpec.getKey();
                ID = this.genID();
                int[] attrTypes = new int[]{0, 256, 258, 2, 1, 259, 260, 261, 262, 263, 17};
                Object[] attrValues = new Object[]{PKCS11Object.SECRET_KEY, PKCS11Object.DES3, ID, Boolean.TRUE, isToken, isSensitive, encrypt, new Boolean(encrypt), wrapping, new Boolean(wrapping), value};
                object = this.session.createObject(attrTypes, attrValues);
                desEdeKey = new DESedeKey(object, ID, null, isToken, isSensitive, encrypt, wrapping, extractable, value);
            }
            catch (InvalidKeyException e) {}
        } else {
            PKCS11Object object = ((PKCS11KeySpec)keySpec).getObject();
            try {
                desEdeKey = new DESedeKey(object, (byte[])this.getAttrValue(object, 258), (String)this.getAttrValue(object, 3), (Boolean)this.getAttrValue(object, 1), (Boolean)this.getAttrValue(object, 259), (Boolean)this.getAttrValue(object, 260), (Boolean)this.getAttrValue(object, 262), (Boolean)this.getAttrValue(object, 354), (byte[])this.getAttrValue(object, 17));
            }
            catch (InvalidKeyException e) {
                // empty catch block
            }
        }
        return desEdeKey;
    }

    protected KeySpec engineGetKeySpec(SecretKey key, Class keySpec) throws InvalidKeySpecException {
        try {
            if (key != null && key instanceof PKCS11SecretKey && key.getAlgorithm().equalsIgnoreCase("DESede") && key.getFormat().equalsIgnoreCase("PKCS#11")) {
                Class<?> desEdeKeySpec = Class.forName("javax.crypto.spec.DESedeKeySpec");
                if (keySpec != null && desEdeKeySpec.isAssignableFrom(keySpec)) {
                    if (((DESedeKey)key).getSensitive().booleanValue()) {
                        throw new PKCS11Exception("Secret key value is not exportable");
                    }
                    return new DESedeKeySpec(((DESedeKey)key).getValue());
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            if (key != null && key instanceof SecretKey && key.getAlgorithm().equalsIgnoreCase("DESede") && key.getFormat().equalsIgnoreCase("RAW")) {
                Class<?> desEdeKeySpec = Class.forName("javax.crypto.spec.DESedeKeySpec");
                if (keySpec != null && desEdeKeySpec.isAssignableFrom(keySpec)) {
                    return new DESedeKeySpec(key.getEncoded());
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            throw new InvalidKeySpecException("Inappropriate key format/algorithm");
        }
        catch (InvalidKeyException e) {
            throw new InvalidKeySpecException("Secret key has wrong size");
        }
        catch (ClassNotFoundException e) {
            throw new InvalidKeySpecException("Unsupported key specification: " + e.getMessage());
        }
    }

    protected SecretKey engineTranslateKey(SecretKey key) throws InvalidKeyException {
        try {
            if (key != null && key.getAlgorithm().equalsIgnoreCase("DESede") && key.getFormat().equalsIgnoreCase("RAW")) {
                if (key instanceof DESedeKey) {
                    return key;
                }
                DESedeKeySpec desEdeKeySpec = (DESedeKeySpec)this.engineGetKeySpec(key, class$javax$crypto$spec$DESedeKeySpec == null ? (class$javax$crypto$spec$DESedeKeySpec = DESedePKCS11KeyFactory.class$("javax.crypto.spec.DESedeKeySpec")) : class$javax$crypto$spec$DESedeKeySpec);
                return this.engineGenerateSecret(desEdeKeySpec);
            }
            throw new InvalidKeyException("Inappropriate key format/algorithm");
        }
        catch (InvalidKeySpecException e) {
            throw new InvalidKeyException("Cannot translate key");
        }
    }

    private byte[] genID() {
        byte[] labelName = new byte[33];
        byte[] labelSaltData = new byte[24];
        byte[] labelTmp = null;
        int labelLength = 0;
        try {
            SecureRandom random = SecureRandom.getInstance("IBMSecureRandom", "IBMPKCS11Impl");
            random.nextBytes(labelSaltData);
        }
        catch (Exception e) {
            // empty catch block
        }
        BigInteger bigInt = new BigInteger(1, labelSaltData);
        try {
            labelTmp = bigInt.toString().getBytes("8859_1");
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError("Can not convert string");
        }
        labelLength = bigInt.toString().length();
        if (labelLength > 24) {
            labelLength = 24;
        }
        System.arraycopy(labelTmp, 0, labelName, 9, labelLength);
        labelName[0] = 73;
        labelName[1] = 66;
        labelName[2] = 77;
        labelName[3] = 80;
        labelName[4] = 75;
        labelName[5] = 67;
        labelName[6] = 83;
        labelName[7] = 49;
        labelName[8] = 49;
        return labelName;
    }

    private Object getAttrValue(PKCS11Object pkcs11obj, int attr) {
        Object rtn;
        try {
            rtn = pkcs11obj.getAttributeValue(attr);
        }
        catch (Exception e) {
            rtn = null;
        }
        return rtn;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

