/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.DESedeKey;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.PKCS11SecretKeyParameterSpec;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.pkcs11.PKCS11Session;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;

public final class DESedePKCS11KeyGenerator
extends KeyGeneratorSpi {
    private Integer keyType = PKCS11Object.DES3;
    private PKCS11Session session = null;
    private byte[] id = null;
    private String label = null;
    private Boolean isToken = new Boolean(false);
    private Boolean isSensitive = new Boolean(false);
    private Boolean encrypt = new Boolean(true);
    private Boolean wrapping = new Boolean(true);
    private Boolean extractable = null;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.DESedePKCS11KeyGenerator";

    public DESedePKCS11KeyGenerator() {
        IBMPKCS11Impl.verifyJceJar();
        this.session = IBMPKCS11Impl.session;
    }

    protected void engineInit(SecureRandom random) {
        throw new UnsupportedOperationException("Parameters must be specified");
    }

    protected void engineInit(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (params == null || !(params instanceof PKCS11SecretKeyParameterSpec)) {
            throw new InvalidAlgorithmParameterException("PKCS11 Secret Key Parameters must be specified");
        }
        PKCS11SecretKeyParameterSpec spec = (PKCS11SecretKeyParameterSpec)params;
        if (spec.getKeyType().equals(PKCS11Object.DES3)) {
            try {
                this.id = spec.getKeyID().getBytes("8859_1");
            }
            catch (Exception e) {
                this.id = spec.getKeyID().getBytes();
            }
        } else {
            throw new InvalidAlgorithmParameterException("The Secret Key type must be DES3.");
        }
        this.label = spec.getLabel();
        this.isToken = spec.getToken();
        this.isSensitive = spec.getSensitive();
        this.encrypt = spec.getEncrypt();
        this.wrapping = spec.getWrap();
        this.extractable = spec.getExtractable();
    }

    protected void engineInit(int keysize, SecureRandom random) {
        throw new UnsupportedOperationException("Parameters must be specified");
    }

    protected SecretKey engineGenerateKey() {
        DESedeKey des3Key;
        PKCS11Object obj = null;
        int sizeArray = 9;
        int count = 0;
        if (this.id == null) {
            --sizeArray;
        }
        if (this.label == null) {
            --sizeArray;
        }
        if (this.isToken == null) {
            --sizeArray;
        }
        if (this.isSensitive == null) {
            --sizeArray;
        }
        if (this.encrypt == null) {
            --sizeArray;
            --sizeArray;
        }
        if (this.wrapping == null) {
            --sizeArray;
            --sizeArray;
        }
        if (this.extractable == null) {
            --sizeArray;
        }
        int[] attrTypes = new int[sizeArray];
        Object[] attrValues = new Object[sizeArray];
        if (this.id != null) {
            attrTypes[count] = 258;
            attrValues[count++] = this.id;
        }
        if (this.label != null) {
            attrTypes[count] = 3;
            attrValues[count++] = this.label;
        }
        if (this.isToken != null) {
            attrTypes[count] = 1;
            attrValues[count++] = this.isToken;
        }
        if (this.isSensitive != null) {
            attrTypes[count] = 259;
            attrValues[count++] = this.isSensitive;
        }
        if (this.encrypt != null) {
            attrTypes[count] = 260;
            attrValues[count++] = this.encrypt;
            attrTypes[count] = 261;
            attrValues[count++] = new Boolean(this.encrypt);
        }
        if (this.wrapping != null) {
            attrTypes[count] = 262;
            attrValues[count++] = this.wrapping;
            attrTypes[count] = 263;
            attrValues[count++] = new Boolean(this.wrapping);
        }
        if (this.extractable != null) {
            attrTypes[count] = 354;
            attrValues[count++] = this.extractable;
        }
        try {
            obj = this.session.generateKey(305, null, attrTypes, attrValues);
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineGenerateKey_1", (Throwable)e);
            }
            throw new RuntimeException(e.getMessage());
        }
        try {
            des3Key = this.isSensitive != null && this.isSensitive.booleanValue() ? new DESedeKey(obj, this.id, this.label, this.isToken, this.isSensitive, this.encrypt, this.wrapping, this.extractable) : new DESedeKey(obj, this.id, this.label, this.isToken, this.isSensitive, this.encrypt, this.wrapping, this.extractable, (byte[])this.getValue(obj, 17));
        }
        catch (Exception e) {
            des3Key = null;
        }
        return des3Key;
    }

    private Object getValue(PKCS11Object pkcs11obj, int attr) {
        Object rtn;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getValue", (Object)pkcs11obj, (Object)new Integer(attr));
        }
        try {
            rtn = pkcs11obj.getAttributeValue(attr);
        }
        catch (Exception e) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "getValue", e.getMessage());
            }
            rtn = null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getValue");
        }
        return rtn;
    }
}

