/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.DSAPrivateKey;
import com.ibm.crypto.pkcs11impl.provider.DSAPublicKey;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.PKCS11DSAPrivateKey;
import com.ibm.crypto.pkcs11impl.provider.PKCS11DSAPublicKey;
import com.ibm.crypto.pkcs11impl.provider.PKCS11KeySpec;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.pkcs11.PKCS11Session;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.DSAParams;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.X509EncodedKeySpec;

public class DSAPKCS11KeyFactory
extends KeyFactorySpi {
    private PKCS11Session session = null;
    private static Debug debug1 = Debug.getInstance((String)"pkcs11impl");
    private static Debug debug2 = Debug.getInstance((String)"dsapkcs11keyfactory");
    private static Debug debug = debug1 == null ? debug2 : debug1;
    private static String className = "com.ibm.crypto.pkcs11impl.provider.DSAPKCS11KeyFactory";
    static /* synthetic */ Class class$java$security$spec$DSAPublicKeySpec;
    static /* synthetic */ Class class$java$security$spec$DSAPrivateKeySpec;

    public DSAPKCS11KeyFactory() {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "DSAPKCS11KeyFactory");
        }
        this.session = IBMPKCS11Impl.session;
        if (debug != null) {
            debug.exit(16384L, (Object)className, "DSAPKCS11KeyFactory");
        }
    }

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        DSAPrivateKey privDSA = null;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineGeneratePrivate", (Object)keySpec);
        }
        if (keySpec instanceof DSAPrivateKeySpec) {
            DSAPrivateKeySpec privateKeySpec = (DSAPrivateKeySpec)keySpec;
            BigInteger p = privateKeySpec.getP();
            BigInteger q = privateKeySpec.getQ();
            BigInteger g = privateKeySpec.getG();
            BigInteger x = privateKeySpec.getX();
            try {
                PKCS11Object object = null;
                byte[] ID = null;
                Boolean isToken = Boolean.FALSE;
                Boolean isSensitive = Boolean.FALSE;
                Boolean isExtractable = Boolean.TRUE;
                ID = this.genID();
                int[] attrTypes = new int[]{0, 256, 258, 2, 1, 259, 264, 304, 305, 306, 17};
                Object[] attrValues = new Object[]{PKCS11Object.PRIVATE_KEY, PKCS11Object.DSA, ID, Boolean.TRUE, Boolean.FALSE, Boolean.FALSE, Boolean.TRUE, p, q, g, x.toByteArray()};
                if (debug != null) {
                    debug.text(16384L, (Object)className, "engineGeneratePublic", "P: " + p + "\n bit len: " + p.bitLength());
                    debug.text(16384L, (Object)className, "engineGeneratePublic", "Q: " + q + "\n bit len: " + q.bitLength());
                    debug.text(16384L, (Object)className, "engineGeneratePublic", "G: " + g + "\n bit len: " + g.bitLength());
                    debug.text(16384L, (Object)className, "engineGeneratePublic", "X: " + x + "\n bit len: " + x.bitLength());
                }
                object = this.session.createObject(attrTypes, attrValues);
                privDSA = new DSAPrivateKey(object, null, ID, null, Boolean.FALSE, Boolean.FALSE, Boolean.TRUE, p, q, g, x);
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "engineGeneratePrivate");
                }
                return privDSA;
            }
            catch (Exception e) {
                if (debug != null) {
                    debug.exception(16384L, (Object)className, "engineGeneratePrivate_1", (Throwable)e);
                    debug.exit(16384L, (Object)className, "engineGeneratePrivate");
                }
                throw new InvalidKeySpecException("Invalid key spec: " + e.getMessage());
            }
        }
        if (keySpec instanceof PKCS11KeySpec) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "engineGeneratePrivate_3");
            }
            PKCS11Object object = ((PKCS11KeySpec)keySpec).getObject();
            try {
                return new DSAPrivateKey(object, (String)this.getAttrValue(object, 3), (byte[])this.getAttrValue(object, 258), (byte[])this.getAttrValue(object, 257), (Boolean)this.getAttrValue(object, 1), (Boolean)this.getAttrValue(object, 259), (Boolean)this.getAttrValue(object, 354), (BigInteger)this.getAttrValue(object, 304), (BigInteger)this.getAttrValue(object, 305), (BigInteger)this.getAttrValue(object, 306), new BigInteger((byte[])this.getAttrValue(object, 17)));
            }
            catch (Exception e) {
                if (debug != null) {
                    debug.exception(16384L, (Object)className, "engineGeneratePrivate_4", (Throwable)e);
                    debug.exit(16384L, (Object)className, "engineGeneratePrivate");
                }
                throw new InvalidKeySpecException("Invalid key spec: " + e.getMessage());
            }
        }
        if (debug != null) {
            debug.text(16384L, (Object)className, "engineGeneratePrivate_5", "Invalid key spec");
            debug.exit(16384L, (Object)className, "engineGeneratePrivate");
        }
        throw new InvalidKeySpecException("Invalid key spec");
    }

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineGeneratePublic", (Object)keySpec);
        }
        try {
            DSAPublicKey pubDSA = null;
            if (keySpec instanceof DSAPublicKeySpec) {
                DSAPublicKeySpec publicKeySpec = (DSAPublicKeySpec)keySpec;
                BigInteger p = publicKeySpec.getP();
                BigInteger q = publicKeySpec.getQ();
                BigInteger g = publicKeySpec.getG();
                BigInteger y = publicKeySpec.getY();
                PKCS11Object object = null;
                byte[] ID = null;
                ID = this.genID();
                int[] attrTypes = new int[]{0, 256, 258, 1, 266, 304, 305, 306, 17};
                Object[] attrValues = new Object[]{PKCS11Object.PUBLIC_KEY, PKCS11Object.DSA, ID, Boolean.FALSE, Boolean.TRUE, p, q, g, y.toByteArray()};
                if (debug != null) {
                    debug.text(16384L, (Object)className, "engineGeneratePublic", "P: " + p + "\n bit len: " + p.bitLength());
                    debug.text(16384L, (Object)className, "engineGeneratePublic", "Q: " + q + "\n bit len: " + q.bitLength());
                    debug.text(16384L, (Object)className, "engineGeneratePublic", "G: " + g + "\n bit len: " + g.bitLength());
                    debug.text(16384L, (Object)className, "engineGeneratePublic", "Y: " + y + "\n bit len: " + y.bitLength());
                }
                object = this.session.createObject(attrTypes, attrValues);
                pubDSA = new DSAPublicKey(object, ID, null, null, Boolean.FALSE, p, q, g, y);
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "engineGeneratePublic");
                }
                return pubDSA;
            }
            if (keySpec instanceof X509EncodedKeySpec) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "engineGeneratePublic");
                }
                return new DSAPublicKey(((X509EncodedKeySpec)keySpec).getEncoded());
            }
            if (keySpec instanceof PKCS11KeySpec) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "engineGeneratePublic_3");
                }
                PKCS11Object object = ((PKCS11KeySpec)keySpec).getObject();
                return new DSAPublicKey(object, (byte[])this.getAttrValue(object, 258), (byte[])this.getAttrValue(object, 257), (String)this.getAttrValue(object, 3), (Boolean)this.getAttrValue(object, 1), (BigInteger)this.getAttrValue(object, 304), (BigInteger)this.getAttrValue(object, 305), (BigInteger)this.getAttrValue(object, 306), new BigInteger((byte[])this.getAttrValue(object, 17)));
            }
            if (debug != null) {
                debug.text(16384L, (Object)className, "engineGeneratePublic_1", "Invalid Key spec");
                debug.exit(16384L, (Object)className, "engineGeneratePublic");
            }
            throw new InvalidKeySpecException("Invalid key spec");
        }
        catch (InvalidKeyException e) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineGeneratePublic_2", (Throwable)e);
                debug.exit(16384L, (Object)className, "engineGeneratePublic");
            }
            throw new InvalidKeySpecException("Invalid key spec: " + e.getMessage());
        }
    }

    protected KeySpec engineGetKeySpec(Key key, Class keySpec) throws InvalidKeySpecException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineGetKeySpec", (Object)key, (Object)keySpec);
        }
        try {
            if (key instanceof PKCS11DSAPublicKey) {
                Class<?> dsaPubKeySpec = Class.forName("java.security.spec.DSAPublicKeySpec");
                Class<?> x509KeySpec = Class.forName("java.security.spec.X509EncodedKeySpec");
                if (dsaPubKeySpec.isAssignableFrom(keySpec)) {
                    DSAPublicKey dsaPubKey = (DSAPublicKey)key;
                    if (debug != null) {
                        debug.exit(16384L, (Object)className, "engineGetKeySpec", (Object)"DSAPublicKeySpec");
                    }
                    return new DSAPublicKeySpec(dsaPubKey.getValue(), dsaPubKey.getPrime(), dsaPubKey.getSubprime(), dsaPubKey.getBase());
                }
                if (x509KeySpec.isAssignableFrom(keySpec)) {
                    if (debug != null) {
                        debug.exit(16384L, (Object)className, "engineGetKeySpec", (Object)"X509EncodedKeySpec");
                    }
                    return new X509EncodedKeySpec(key.getEncoded());
                }
                if (debug != null) {
                    debug.text(16384L, (Object)className, "engineGetKeySpec", "Inappropriate key specification");
                    debug.exit(16384L, (Object)className, "engineGetKeySpec");
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            if (key instanceof java.security.interfaces.DSAPublicKey) {
                Class<?> dsaPubKeySpec = Class.forName("java.security.spec.DSAPublicKeySpec");
                Class<?> x509KeySpec = Class.forName("java.security.spec.X509EncodedKeySpec");
                if (dsaPubKeySpec.isAssignableFrom(keySpec)) {
                    java.security.interfaces.DSAPublicKey dsaPubKey = (java.security.interfaces.DSAPublicKey)key;
                    DSAParams dsaParms = dsaPubKey.getParams();
                    if (debug != null) {
                        debug.exit(16384L, (Object)className, "engineGetKeySpec", (Object)"DSAPublicKeySpec_1");
                    }
                    return new DSAPublicKeySpec(dsaPubKey.getY(), dsaParms.getP(), dsaParms.getQ(), dsaParms.getG());
                }
                if (x509KeySpec.isAssignableFrom(keySpec)) {
                    if (debug != null) {
                        debug.exit(16384L, (Object)className, "engineGetKeySpec", (Object)"X509EncodedKeySpec_1");
                    }
                    return new X509EncodedKeySpec(key.getEncoded());
                }
                if (debug != null) {
                    debug.text(16384L, (Object)className, "engineGetKeySpec", "Inappropriate key specification");
                    debug.exit(16384L, (Object)className, "engineGetKeySpec");
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            if (key instanceof PKCS11DSAPrivateKey) {
                Class<?> dsaPrivKeySpec = Class.forName("java.security.spec.DSAPrivateKeySpec");
                if (dsaPrivKeySpec.isAssignableFrom(keySpec)) {
                    DSAPrivateKey dsaPrivKey = (DSAPrivateKey)key;
                    if (dsaPrivKey.getSensitive().booleanValue()) {
                        if (debug != null) {
                            debug.text(16384L, (Object)className, "engineGetKeySpec", "Private key value is not exportable");
                            debug.exit(16384L, (Object)className, "engineGetKeySpec");
                        }
                        throw new PKCS11Exception("Private key value is not exportable");
                    }
                    if (debug != null) {
                        debug.exit(16384L, (Object)className, "engineGetKeySpec", (Object)"DSAPrivateKeySpec");
                    }
                    return new DSAPrivateKeySpec(dsaPrivKey.getValue(), dsaPrivKey.getPrime(), dsaPrivKey.getSubprime(), dsaPrivKey.getBase());
                }
                if (debug != null) {
                    debug.text(16384L, (Object)className, "engineGetKeySpec", "Inappropriate key specification");
                    debug.exit(16384L, (Object)className, "engineGetKeySpec");
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            if (key instanceof java.security.interfaces.DSAPrivateKey) {
                Class<?> dsaPrivKeySpec = Class.forName("java.security.spec.DSAPrivateKeySpec");
                if (dsaPrivKeySpec.isAssignableFrom(keySpec)) {
                    java.security.interfaces.DSAPrivateKey dsaPrivKey = (java.security.interfaces.DSAPrivateKey)key;
                    DSAParams dsaParms = dsaPrivKey.getParams();
                    if (debug != null) {
                        debug.exit(16384L, (Object)className, "engineGetKeySpec", (Object)"DSAPrivateKeySpec_1");
                    }
                    return new DSAPrivateKeySpec(dsaPrivKey.getX(), dsaParms.getP(), dsaParms.getQ(), dsaParms.getG());
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            if (debug != null) {
                debug.text(16384L, (Object)className, "engineGetKeySpec", "Inappropriate key specification");
                debug.exit(16384L, (Object)className, "engineGetKeySpec");
            }
            throw new InvalidKeySpecException("Inappropriate key type");
        }
        catch (ClassNotFoundException e) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineGetKeySpec", (Throwable)e);
                debug.exit(16384L, (Object)className, "engineGetKeySpec");
            }
            throw new InvalidKeySpecException("Unsupported key specification: " + e.getMessage());
        }
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineTranslateKey", (Object)key);
        }
        try {
            if (key instanceof java.security.interfaces.DSAPublicKey) {
                if (key instanceof DSAPublicKey) {
                    return key;
                }
                DSAPublicKeySpec dsaPubKeySpec = (DSAPublicKeySpec)this.engineGetKeySpec(key, class$java$security$spec$DSAPublicKeySpec == null ? (class$java$security$spec$DSAPublicKeySpec = DSAPKCS11KeyFactory.class$("java.security.spec.DSAPublicKeySpec")) : class$java$security$spec$DSAPublicKeySpec);
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "engineTranslateKey", (Object)"DSAPublicKey");
                }
                return this.engineGeneratePublic(dsaPubKeySpec);
            }
            if (key instanceof java.security.interfaces.DSAPrivateKey) {
                if (key instanceof DSAPrivateKey) {
                    return key;
                }
                DSAPrivateKeySpec dsaPrivKeySpec = (DSAPrivateKeySpec)this.engineGetKeySpec(key, class$java$security$spec$DSAPrivateKeySpec == null ? (class$java$security$spec$DSAPrivateKeySpec = DSAPKCS11KeyFactory.class$("java.security.spec.DSAPrivateKeySpec")) : class$java$security$spec$DSAPrivateKeySpec);
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "engineTranslateKey", (Object)"DSAPrivateKey");
                }
                return this.engineGeneratePrivate(dsaPrivKeySpec);
            }
            if (debug != null) {
                debug.text(16384L, (Object)className, "engineTranslateKey", "Wrong algorithm type");
                debug.exit(16384L, (Object)className, "engineTranslateKey");
            }
            throw new InvalidKeyException("Wrong algorithm type");
        }
        catch (InvalidKeySpecException e) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineTranslateKey", (Throwable)e);
                debug.exit(16384L, (Object)className, "engineTranslateKey");
            }
            throw new InvalidKeyException("Cannot translate key: " + e.getMessage());
        }
    }

    private byte[] genID() {
        byte[] labelName = new byte[33];
        byte[] labelSaltData = new byte[24];
        byte[] labelTmp = null;
        int labelLength = 0;
        try {
            SecureRandom random = SecureRandom.getInstance("IBMSecureRandom", "IBMPKCS11Impl");
            random.nextBytes(labelSaltData);
        }
        catch (Exception e) {
            // empty catch block
        }
        BigInteger bigInt = new BigInteger(1, labelSaltData);
        try {
            labelTmp = bigInt.toString().getBytes("8859_1");
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError("Can not convert string");
        }
        labelLength = bigInt.toString().length();
        if (labelLength > 24) {
            labelLength = 24;
        }
        System.arraycopy(labelTmp, 0, labelName, 9, labelLength);
        labelName[0] = 73;
        labelName[1] = 66;
        labelName[2] = 77;
        labelName[3] = 80;
        labelName[4] = 75;
        labelName[5] = 67;
        labelName[6] = 83;
        labelName[7] = 49;
        labelName[8] = 49;
        return labelName;
    }

    private Object getAttrValue(PKCS11Object pkcs11obj, int attr) {
        Object rtn;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getValue", (Object)pkcs11obj, (Object)new Integer(attr));
        }
        try {
            rtn = pkcs11obj.getAttributeValue(attr);
        }
        catch (Exception e) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "getValue", e.getMessage());
            }
            rtn = null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getValue");
        }
        return rtn;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

