/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.DSAParameterGenerator;
import com.ibm.crypto.pkcs11impl.provider.DSAPrivateKey;
import com.ibm.crypto.pkcs11impl.provider.DSAPublicKey;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.PKCS11DSAKeyPairParameterSpec;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.pkcs11.PKCS11Session;
import java.math.BigInteger;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public final class DSAPKCS11KeyPairGenerator
extends KeyPairGeneratorSpi {
    private int keySize = 512;
    private PKCS11Session session = null;
    private byte[] id = null;
    private byte[] subject = null;
    private String label = null;
    private Boolean isToken = new Boolean(false);
    private Boolean isSensitive = new Boolean(false);
    private Boolean extractable = null;
    private DSAParameterSpec dsaparams = null;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.DSAPKCS11KeyPairGenerator";
    static /* synthetic */ Class class$java$security$spec$DSAParameterSpec;

    public DSAPKCS11KeyPairGenerator() {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "DSAPKCS11KeyPairGenerator");
        }
        this.session = IBMPKCS11Impl.session;
        if (debug != null) {
            debug.exit(16384L, (Object)className, "DSAPKCS11KeyPairGenerator");
        }
    }

    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "initialize", (Object)params, (Object)random);
        }
        if (params == null || !(params instanceof PKCS11DSAKeyPairParameterSpec)) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "initialize", "PKCS11 DSA KeyPair Parameters must be specified");
            }
            throw new InvalidAlgorithmParameterException("PKCS11 DSA KeyPair Parameters must be specified");
        }
        PKCS11DSAKeyPairParameterSpec spec = (PKCS11DSAKeyPairParameterSpec)params;
        this.keySize = spec.getKeySize();
        if (spec.getKeyID() != null) {
            try {
                this.id = spec.getKeyID().getBytes("8859_1");
            }
            catch (Exception e) {
                this.id = spec.getKeyID().getBytes();
            }
        }
        if (spec.getSubject() != null) {
            try {
                this.subject = spec.getSubject().getBytes("8859_1");
            }
            catch (Exception e) {
                this.subject = spec.getSubject().getBytes();
            }
        }
        this.label = spec.getLabel();
        this.isSensitive = spec.getSensitive();
        this.isToken = spec.getToken();
        this.extractable = spec.getExtractable();
        this.dsaparams = (DSAParameterSpec)spec.getParams();
        if (this.dsaparams == null) {
            this.generateParameters();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "initialize");
        }
    }

    public void initialize(int strength, SecureRandom random) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "initialize", (Object)(" " + strength), (Object)random);
            debug.exit(16384L, (Object)className, "initialize");
        }
        throw new UnsupportedOperationException("Parameters must be specified");
    }

    public void initialize(int strength) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "initialize", (Object)(" " + strength));
            debug.exit(16384L, (Object)className, "initialize");
        }
        throw new UnsupportedOperationException("Parameters must be specified");
    }

    public KeyPair generateKeyPair() {
        KeyPair pair;
        block19: {
            if (debug != null) {
                debug.entry(16384L, (Object)className, "generateKeyPair");
            }
            PKCS11Object[] objs = null;
            pair = null;
            DSAPublicKey pubKey = null;
            DSAPrivateKey privKey = null;
            int sizePubArray = 8;
            int sizePrivArray = 7;
            int count = 0;
            if (this.dsaparams == null) {
                this.generateParameters();
            }
            if (this.isSensitive == null) {
                --sizePrivArray;
            }
            if (this.isToken == null) {
                --sizePrivArray;
                --sizePubArray;
            }
            if (this.extractable == null) {
                --sizePrivArray;
            }
            int[] pubTypes = new int[sizePubArray];
            Object[] pubValues = new Object[sizePubArray];
            if (this.isToken != null) {
                pubTypes[count] = 1;
                pubValues[count++] = this.isToken;
            }
            pubTypes[count] = 258;
            pubValues[count++] = this.id;
            pubTypes[count] = 257;
            pubValues[count++] = this.subject;
            pubTypes[count] = 3;
            pubValues[count++] = this.label;
            pubTypes[count] = 266;
            pubValues[count++] = Boolean.TRUE;
            pubTypes[count] = 304;
            pubValues[count++] = this.dsaparams.getP();
            pubTypes[count] = 305;
            pubValues[count++] = this.dsaparams.getQ();
            pubTypes[count] = 306;
            pubValues[count] = this.dsaparams.getG();
            int[] privTypes = new int[sizePrivArray];
            Object[] privValues = new Object[sizePrivArray];
            count = 0;
            if (this.isToken != null) {
                privTypes[count] = 1;
                privValues[count++] = this.isToken;
            }
            privTypes[count] = 258;
            privValues[count++] = this.id;
            privTypes[count] = 257;
            privValues[count++] = this.subject;
            privTypes[count] = 3;
            privValues[count++] = this.label;
            privTypes[count] = 264;
            privValues[count++] = Boolean.TRUE;
            if (this.isSensitive != null) {
                privTypes[count] = 259;
                privValues[count++] = this.isSensitive;
            }
            if (this.extractable != null) {
                privTypes[count] = 354;
                privValues[count] = this.extractable;
            }
            try {
                objs = this.session.generateKeyPair(16, null, pubTypes, pubValues, privTypes, privValues);
            }
            catch (Exception e) {
                if (debug != null) {
                    debug.exception(16384L, (Object)className, "generateKeyPair_1", (Throwable)e);
                }
                throw new RuntimeException(e.getMessage());
            }
            PKCS11Object[] returnobjs = this.orderObjects(objs);
            PKCS11Object pubObj = returnobjs[0];
            PKCS11Object privObj = returnobjs[1];
            try {
                pubKey = new DSAPublicKey(pubObj, this.id, this.subject, this.label, this.isToken, (BigInteger)this.getValue(pubObj, 304), (BigInteger)this.getValue(pubObj, 305), (BigInteger)this.getValue(pubObj, 306), new BigInteger(1, (byte[])this.getValue(pubObj, 17)));
                if (this.isSensitive.booleanValue()) {
                    privKey = new DSAPrivateKey(privObj, this.label, this.id, this.subject, this.isToken, this.isSensitive, this.extractable);
                } else {
                    try {
                        privKey = new DSAPrivateKey(privObj, this.label, this.id, this.subject, this.isToken, this.isSensitive, this.extractable, (BigInteger)this.getValue(privObj, 304), (BigInteger)this.getValue(privObj, 305), (BigInteger)this.getValue(privObj, 306), new BigInteger(1, (byte[])this.getValue(privObj, 17)));
                    }
                    catch (Exception ex) {
                        privKey = new DSAPrivateKey(privObj, this.label, this.id, this.subject, this.isToken, this.isSensitive, this.extractable);
                    }
                }
                pair = new KeyPair(pubKey, privKey);
            }
            catch (Exception e) {
                pair = null;
                if (debug == null) break block19;
                debug.exception(16384L, (Object)className, "generateKeyPair_2", (Throwable)e);
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "generateKeyPair");
        }
        return pair;
    }

    private void generateParameters() {
        SecureRandom rnd;
        AlgorithmParameterGenerator gen;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "generateParameters");
        }
        switch (this.keySize) {
            case 512: {
                this.dsaparams = new DSAParameterSpec(DSAParameterGenerator.p_512, DSAParameterGenerator.q_512, DSAParameterGenerator.g_512);
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "generateParameters", (Object)this.dsaparams);
                }
                return;
            }
            case 768: {
                this.dsaparams = new DSAParameterSpec(DSAParameterGenerator.p_768, DSAParameterGenerator.q_768, DSAParameterGenerator.g_768);
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "generateParameters", (Object)this.dsaparams);
                }
                return;
            }
            case 1024: {
                this.dsaparams = new DSAParameterSpec(DSAParameterGenerator.p_1024, DSAParameterGenerator.q_1024, DSAParameterGenerator.g_1024);
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "generateParameters", (Object)this.dsaparams);
                }
                return;
            }
        }
        try {
            gen = AlgorithmParameterGenerator.getInstance("DSA", "IBMPKCS11Impl");
            rnd = SecureRandom.getInstance("IBMSecureRandom", "IBMPKCS11Impl");
        }
        catch (NoSuchAlgorithmException e) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "generateParameters_1", (Throwable)e);
            }
            throw new RuntimeException(e.getMessage());
        }
        catch (NoSuchProviderException e) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "generateParameters_2", (Throwable)e);
            }
            throw new RuntimeException(e.getMessage());
        }
        gen.init(this.keySize, rnd);
        AlgorithmParameters algParams = gen.generateParameters();
        try {
            this.dsaparams = (DSAParameterSpec)algParams.getParameterSpec(class$java$security$spec$DSAParameterSpec == null ? (class$java$security$spec$DSAParameterSpec = DSAPKCS11KeyPairGenerator.class$("java.security.spec.DSAParameterSpec")) : class$java$security$spec$DSAParameterSpec);
        }
        catch (InvalidParameterSpecException e) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "generateParameters_3", (Throwable)e);
            }
            throw new Error();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "generateParameters");
        }
    }

    private PKCS11Object[] orderObjects(PKCS11Object[] objs) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "orderObjects");
        }
        Integer objsType0 = (Integer)this.getValue(objs[0], 0);
        Integer objsType1 = (Integer)this.getValue(objs[1], 0);
        PKCS11Object privObj = null;
        PKCS11Object pubObj = null;
        if (objsType0.equals(PKCS11Object.PUBLIC_KEY) && objsType1.equals(PKCS11Object.PRIVATE_KEY)) {
            pubObj = objs[0];
            privObj = objs[1];
        } else if (objsType0.equals(PKCS11Object.PRIVATE_KEY) && objsType1.equals(PKCS11Object.PUBLIC_KEY)) {
            pubObj = objs[1];
            privObj = objs[0];
        } else {
            if (debug != null) {
                debug.text(16384L, (Object)className, "orderObjects", "Token returns invalid objects");
            }
            throw new RuntimeException("Token returns invalid objects");
        }
        objs[0] = pubObj;
        objs[1] = privObj;
        if (debug != null) {
            debug.exit(16384L, (Object)className, "orderObjects");
        }
        return objs;
    }

    private Object getValue(PKCS11Object pkcs11obj, int attr) {
        Object rtn;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getValue", (Object)pkcs11obj, (Object)new Integer(attr));
        }
        try {
            rtn = pkcs11obj.getAttributeValue(attr);
        }
        catch (Exception e) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "getValue", e.getMessage());
            }
            rtn = null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getValue");
        }
        return rtn;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

