/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import java.math.BigInteger;
import java.security.AlgorithmParameterGeneratorSpi;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public class DSAParameterGenerator
extends AlgorithmParameterGeneratorSpi {
    private int size = 1024;
    private SecureRandom random;
    private AlgorithmParameters generatedParameters;
    static final BigInteger p_512 = new BigInteger("fca682ce8e12caba26efccf7110e526db078b05edecbcd1eb4a208f3ae1617ae01f35b91a47e6df63413c5e12ed0899bcd132acd50d99151bdc43ee737592e17", 16);
    static final BigInteger q_512 = new BigInteger("962eddcc369cba8ebb260ee6b6a126d9346e38c5", 16);
    static final BigInteger g_512 = new BigInteger("678471b27a9cf44ee91a49c5147db1a9aaf244f05a434d6486931d2d14271b9e35030b71fd73da179069b32e2935630e1c2062354d0da20a6c416e50be794ca4", 16);
    static final BigInteger p_768 = new BigInteger("e9e642599d355f37c97ffd3567120b8e25c9cd43e927b3a9670fbec5d890141922d2c3b3ad2480093799869d1e846aab49fab0ad26d2ce6a22219d470bce7d777d4a21fbe9c270b57f607002f3cef8393694cf45ee3688c11a8c56ab127a3daf", 16);
    static final BigInteger q_768 = new BigInteger("9cdbd84c9f1ac2f38d0f80f42ab952e7338bf511", 16);
    static final BigInteger g_768 = new BigInteger("30470ad5a005fb14ce2d9dcd87e38bc7d1b1c5facbaecbe95f190aa7a31d23c4dbbcbe06174544401a5b2c020965d8c2bd2171d3668445771f74ba084d2029d83c1c158547f3a9f1a2715be23d51ae4d3e5a1f6a7064f316933a346d3f529252", 16);
    static final BigInteger p_1024 = new BigInteger("fd7f53811d75122952df4a9c2eece4e7f611b7523cef4400c31e3f80b6512669455d402251fb593d8d58fabfc5f5ba30f6cb9b556cd7813b801d346ff26660b76b9950a5a49f9fe8047b1022c24fbba9d7feb7c61bf83b57e7c6a8a6150f04fb83f6d3c51ec3023554135a169132f675f3ae2b61d72aeff22203199dd14801c7", 16);
    static final BigInteger q_1024 = new BigInteger("9760508f15230bccb292b982a2eb840bf0581cf5", 16);
    static final BigInteger g_1024 = new BigInteger("f7e1a085d69b3ddecbbcab5c36b857b97994afbbfa3aea82f9574c0b3d0782675159578ebad4594fe67107108180b449167123e84c281613b7cf09328cc8a6e13c167a8b547c8d28e0a3ae1e2bb3a675916ea37f0bfa213562f1fb627a01243bcca4f1bea8519089a883dfe15ae59f06928b665e807b552564014c3bfecf492a", 16);
    private static final BigInteger TWO = BigInteger.valueOf(2L);
    private static final int g = 160;
    private static final BigInteger twoRaisedTog = TWO.pow(160);
    private static final int PRIME_CERTAINTY_EXP = 80;

    protected AlgorithmParameters engineGenerateParameters() {
        if (this.generatedParameters == null) {
            this.generateParameters();
        }
        return this.generatedParameters;
    }

    protected void engineInit(AlgorithmParameterSpec genParamSpec, SecureRandom random) throws InvalidAlgorithmParameterException {
        this.random = random;
        this.initFromSpec(genParamSpec);
    }

    private void initFromSpec(AlgorithmParameterSpec genParamSpec) throws InvalidAlgorithmParameterException {
        AlgorithmParameters result;
        try {
            result = AlgorithmParameters.getInstance("DSA", "IBMPKCS11Impl");
        }
        catch (NoSuchAlgorithmException e) {
            this.generatedParameters = null;
            return;
        }
        catch (NoSuchProviderException e) {
            throw new RuntimeException(e.getMessage());
        }
        try {
            result.init(genParamSpec);
        }
        catch (InvalidParameterSpecException e) {
            throw new InvalidAlgorithmParameterException();
        }
        this.generatedParameters = result;
    }

    protected void engineInit(int size, SecureRandom random) {
        this.size = size;
        this.random = random;
        this.generatedParameters = null;
    }

    private BigInteger generate_g(BigInteger p, BigInteger q) {
        BigInteger h;
        BigInteger g;
        BigInteger e = p.subtract(BigInteger.ONE).divide(q);
        boolean found_g = false;
        do {
            int bitsIn_p;
            boolean found_h = false;
            while (!(found_h = (h = new BigInteger(bitsIn_p = p.bitLength(), this.random)).compareTo(p) < 0 && h.compareTo(BigInteger.ONE) > 0)) {
            }
        } while (!(found_g = (g = h.multiply(e).mod(p)).compareTo(BigInteger.ONE) != 0));
        return g;
    }

    private void setParameters(BigInteger p, BigInteger q, BigInteger g) {
        try {
            this.initFromSpec(new DSAParameterSpec(p, q, g));
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException(e.toString());
        }
    }

    private byte[] xor(byte[] ar1, byte[] ar2) {
        byte[] result = new byte[ar1.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (byte)(ar1[i] ^ ar2[i]);
        }
        return result;
    }

    private void generateParameters() {
        int L = this.size;
        int n = (L - 1) / 160;
        int b = 160;
        BigInteger twoRaisedToLMinus1 = TWO.pow(L - 1);
        BigInteger twoRaisedTob = TWO.pow(b);
        while (true) {
            BigInteger SBigInteger;
            BigInteger q;
            boolean isPrime = false;
            do {
                MessageDigest sha;
                byte[] S = new byte[20];
                this.random.nextBytes(S);
                SBigInteger = new BigInteger(1, S);
                try {
                    sha = MessageDigest.getInstance("SHA", "IBMPKCS11Impl");
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException(e.getMessage());
                }
                catch (NoSuchProviderException e) {
                    throw new RuntimeException(e.getMessage());
                }
                sha.update(S, 0, S.length);
                byte[] shaS = sha.digest();
                BigInteger SPlusOneBigInteger = SBigInteger.add(BigInteger.ONE);
                BigInteger SPlusOneModPow = SPlusOneBigInteger.mod(twoRaisedTog);
                sha.reset();
                byte[] SPlusOneModPowByteArray = SPlusOneModPow.toByteArray();
                sha.update(SPlusOneModPowByteArray, 0, SPlusOneModPowByteArray.length);
                byte[] shaSPlusOneModPow = sha.digest();
                byte[] U = this.xor(shaS, shaSPlusOneModPow);
                q = new BigInteger(1, U);
                q = q.setBit(0);
            } while (!(isPrime = (q = q.setBit(159)).isProbablePrime(80)));
            int C = 0;
            BigInteger N = TWO;
            do {
                BigInteger Xmod2q;
                BigInteger[] V = new BigInteger[n + 1];
                BigInteger SPlusN = SBigInteger.add(N);
                for (int k = 0; k <= n; ++k) {
                    BigInteger kBigInteger = BigInteger.valueOf(k);
                    BigInteger SPlusNPlusk = SPlusN.add(kBigInteger);
                    V[k] = SPlusNPlusk.mod(twoRaisedTog);
                }
                BigInteger W = V[0];
                for (int i = 1; i < n; ++i) {
                    int shift = 160 * i;
                    BigInteger toAdd = V[i].shiftLeft(shift);
                    W = W.add(toAdd);
                }
                BigInteger toAdd = V[n].mod(twoRaisedTob).shiftLeft(160 * n);
                BigInteger X = (W = W.add(toAdd)).add(twoRaisedToLMinus1);
                BigInteger p = X.subtract((Xmod2q = X.mod(TWO.multiply(q))).subtract(BigInteger.ONE));
                int compare = p.compareTo(twoRaisedToLMinus1);
                if (compare >= 0 && p.isProbablePrime(80)) {
                    this.setParameters(p, q, this.generate_g(p, q));
                    return;
                }
                N = N.add(N);
                N = N.add(BigInteger.valueOf(n));
                N = N.add(BigInteger.ONE);
            } while (++C != 4096);
        }
    }
}

