/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public class DSAParameters
extends AlgorithmParametersSpi {
    protected BigInteger p;
    protected BigInteger q;
    protected BigInteger g;

    protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        if (!(paramSpec instanceof DSAParameterSpec)) {
            throw new InvalidParameterSpecException("Inappropriate parameter specification");
        }
        this.p = ((DSAParameterSpec)paramSpec).getP();
        this.q = ((DSAParameterSpec)paramSpec).getQ();
        this.g = ((DSAParameterSpec)paramSpec).getG();
    }

    protected void engineInit(byte[] params) throws IOException {
        DerValue encoded = new DerValue(params);
        if (encoded.getTag() != 48) {
            throw new IOException("DSA params parsing error");
        }
        encoded.getData().reset();
        this.p = encoded.getData().getInteger();
        this.q = encoded.getData().getInteger();
        this.g = encoded.getData().getInteger();
        if (encoded.getData().available() != 0) {
            throw new IOException("encoded params have " + encoded.getData().available() + " extra bytes");
        }
    }

    protected void engineInit(byte[] params, String decodingMethod) throws IOException {
        this.engineInit(params);
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
        try {
            Class<?> dsaParamSpec = Class.forName("java.security.spec.DSAParameterSpec");
            if (dsaParamSpec.isAssignableFrom(paramSpec)) {
                return new DSAParameterSpec(this.p, this.q, this.g);
            }
            throw new InvalidParameterSpecException("Inappropriate parameter Specification");
        }
        catch (ClassNotFoundException e) {
            throw new InvalidParameterSpecException("Unsupported parameter specification: " + e.getMessage());
        }
    }

    protected byte[] engineGetEncoded() throws IOException {
        DerOutputStream out = new DerOutputStream();
        DerOutputStream bytes = new DerOutputStream();
        bytes.putInteger(this.p);
        bytes.putInteger(this.q);
        bytes.putInteger(this.g);
        out.write((byte)48, bytes);
        return out.toByteArray();
    }

    protected byte[] engineGetEncoded(String encodingMethod) throws IOException {
        return this.engineGetEncoded();
    }

    protected String engineToString() {
        return "\n\tp: " + this.p.toString() + "\n\tq: " + this.q.toString() + "\n\tg: " + this.g.toString() + "\n";
    }
}

