/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.PKCS11DSAPublicKey;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.pkcs11.PKCS11Session;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgIdDSA;
import com.ibm.security.x509.X509Key;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.SecureRandom;
import java.security.interfaces.DSAParams;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Date;

public final class DSAPublicKey
extends X509Key
implements PKCS11DSAPublicKey,
Serializable {
    private PKCS11Object object = null;
    static final long serialVersionUID = 4996119436080850303L;
    private Boolean isToken = null;
    private Boolean isPrivate = null;
    private String label = null;
    private Boolean isModifiable = null;
    private Integer keyType = PKCS11Object.DSA;
    private byte[] ID = null;
    private Date startDate = null;
    private Date endDate = null;
    private Boolean isDerive = null;
    private Boolean isLocal = null;
    private byte[] subject = null;
    private Boolean isEncrypt = null;
    private Boolean isVerify = null;
    private Boolean isVerifyRecover = null;
    private Boolean isWrap = null;
    private BigInteger prime = null;
    private BigInteger subprime = null;
    private BigInteger base = null;
    private BigInteger value = null;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.DSAPublicKey";
    static /* synthetic */ Class class$java$security$spec$DSAParameterSpec;

    DSAPublicKey(PKCS11Object object, byte[] ID, byte[] subject, String label, Boolean isToken) throws InvalidKeyException {
        this.object = object;
        this.label = label != null ? label : (String)this.getAttrValue(this.object, 3);
        if (ID != null) {
            this.ID = new byte[ID.length];
            System.arraycopy(ID, 0, this.ID, 0, ID.length);
        } else {
            this.ID = (byte[])this.getAttrValue(this.object, 258);
        }
        if (subject != null) {
            this.subject = new byte[subject.length];
            System.arraycopy(subject, 0, this.subject, 0, subject.length);
        } else {
            this.subject = (byte[])this.getAttrValue(this.object, 257);
        }
        this.isToken = isToken != null ? new Boolean(isToken) : (Boolean)this.getAttrValue(this.object, 1);
        this.isPrivate = (Boolean)this.getAttrValue(this.object, 2);
        this.isModifiable = (Boolean)this.getAttrValue(this.object, 368);
        this.startDate = (Date)this.getAttrValue(this.object, 272);
        this.endDate = (Date)this.getAttrValue(this.object, 273);
        this.isDerive = (Boolean)this.getAttrValue(this.object, 268);
        this.isLocal = (Boolean)this.getAttrValue(this.object, 355);
        this.isEncrypt = (Boolean)this.getAttrValue(this.object, 260);
        this.isVerifyRecover = (Boolean)this.getAttrValue(this.object, 267);
        this.isVerify = (Boolean)this.getAttrValue(this.object, 266);
        this.isWrap = (Boolean)this.getAttrValue(this.object, 262);
    }

    public DSAPublicKey(PKCS11Object object, byte[] ID, byte[] subject, String label, Boolean isToken, BigInteger prime, BigInteger subprime, BigInteger base, BigInteger value) throws InvalidKeyException {
        this(object, ID, subject, label, isToken);
        if (prime != null) {
            this.prime = new BigInteger(prime.toByteArray());
        }
        if (subprime != null) {
            this.subprime = new BigInteger(subprime.toByteArray());
        }
        if (base != null) {
            this.base = new BigInteger(base.toByteArray());
        }
        if (value != null) {
            this.value = new BigInteger(value.toByteArray());
        }
        this.algid = new AlgIdDSA(prime, subprime, base);
        if (this.value != null) {
            try {
                this.key = new DerValue(2, this.value.toByteArray()).toByteArray();
                this.encode();
            }
            catch (IOException e) {
                throw new InvalidKeyException("could not DER encode y: " + e.getMessage());
            }
        }
    }

    DSAPublicKey(byte[] encoded) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "DSAPublicKey", (Object)encoded);
        }
        this.decode(encoded);
        try {
            if (this.algid instanceof DSAParams) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "DSAPublicKey", (Object)this.algid);
                }
                DSAParams params = (DSAParams)this.algid;
                this.prime = ((DSAParameterSpec)params).getP();
                this.subprime = ((DSAParameterSpec)params).getQ();
                this.base = ((DSAParameterSpec)params).getG();
            } else {
                AlgorithmParameters algParams = this.algid.getAlgParameters();
                if (algParams == null) {
                    if (debug != null) {
                        debug.exit(16384L, (Object)className, "DSAPublicKey", null);
                    }
                    throw new InvalidKeyException("A key could not be create from encoding");
                }
                DSAParameterSpec paramSpec = (DSAParameterSpec)algParams.getParameterSpec(class$java$security$spec$DSAParameterSpec == null ? (class$java$security$spec$DSAParameterSpec = DSAPublicKey.class$("java.security.spec.DSAParameterSpec")) : class$java$security$spec$DSAParameterSpec);
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "DSAPublicKey", (Object)paramSpec);
                }
                this.prime = paramSpec.getP();
                this.subprime = paramSpec.getQ();
                this.base = paramSpec.getG();
            }
        }
        catch (InvalidParameterSpecException e) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "DSAPublicKey", (Throwable)e);
                debug.exit(16384L, (Object)className, "DSAPublicKey", null);
            }
            throw new InvalidKeyException(e.getMessage());
        }
        this.label = this.genLabel();
        int[] attrTypes = new int[]{0, 256, 3, 1, 266, 304, 305, 306, 17};
        Object[] attrValues = new Object[]{PKCS11Object.PUBLIC_KEY, PKCS11Object.DSA, this.label, Boolean.FALSE, Boolean.TRUE, this.prime, this.subprime, this.base, this.value.toByteArray()};
        PKCS11Session session = IBMPKCS11Impl.session;
        this.object = session.createObject(attrTypes, attrValues);
        this.ID = (byte[])this.getAttrValue(this.object, 258);
        this.subject = (byte[])this.getAttrValue(this.object, 257);
        this.isToken = (Boolean)this.getAttrValue(this.object, 1);
        this.isPrivate = (Boolean)this.getAttrValue(this.object, 2);
        this.isModifiable = (Boolean)this.getAttrValue(this.object, 368);
        this.startDate = (Date)this.getAttrValue(this.object, 272);
        this.endDate = (Date)this.getAttrValue(this.object, 273);
        this.isDerive = (Boolean)this.getAttrValue(this.object, 268);
        this.isLocal = (Boolean)this.getAttrValue(this.object, 355);
        this.isEncrypt = (Boolean)this.getAttrValue(this.object, 260);
        this.isVerifyRecover = (Boolean)this.getAttrValue(this.object, 267);
        this.isVerify = (Boolean)this.getAttrValue(this.object, 266);
        this.isWrap = (Boolean)this.getAttrValue(this.object, 262);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "DSAPublicKey");
        }
    }

    protected void parseKeyBits() throws InvalidKeyException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "parseKeyBits");
        }
        try {
            DerInputStream in = new DerInputStream(this.key);
            this.value = in.getInteger();
        }
        catch (IOException e) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "parseKeyBits", "Invalid key value");
            }
            throw new InvalidKeyException("Invalid key value\n" + e.getMessage());
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "parseKeyBits");
        }
    }

    public PKCS11Object getObject() {
        return this.object;
    }

    public Boolean getToken() {
        return new Boolean(this.isToken);
    }

    public Boolean getPrivate() {
        return new Boolean(this.isPrivate);
    }

    public String getLabel() {
        return this.label;
    }

    public Boolean getModifiable() {
        return new Boolean(this.isModifiable);
    }

    public Integer getKeyType() {
        return this.keyType;
    }

    public byte[] getID() {
        return (byte[])this.ID.clone();
    }

    public Date getStartDate() {
        if (this.startDate != null) {
            return (Date)this.startDate.clone();
        }
        return null;
    }

    public Date getEndDate() {
        if (this.endDate != null) {
            return (Date)this.endDate.clone();
        }
        return null;
    }

    public Boolean getDerive() {
        return new Boolean(this.isDerive);
    }

    public Boolean getLocal() {
        return new Boolean(this.isLocal);
    }

    public byte[] getSubject() {
        return (byte[])this.subject.clone();
    }

    public Boolean getEncrypt() {
        return new Boolean(this.isEncrypt);
    }

    public Boolean getVerify() {
        return new Boolean(this.isVerify);
    }

    public Boolean getVerifyRecover() {
        return new Boolean(this.isVerifyRecover);
    }

    public Boolean getWrap() {
        return new Boolean(this.isWrap);
    }

    public BigInteger getPrime() {
        return this.prime;
    }

    public BigInteger getSubprime() {
        return this.subprime;
    }

    public BigInteger getBase() {
        return this.base;
    }

    public BigInteger getValue() {
        return this.value;
    }

    public BigInteger getY() {
        return this.value;
    }

    public DSAParams getParams() {
        try {
            if (this.algid instanceof DSAParams) {
                return (DSAParams)this.algid;
            }
            AlgorithmParameters algParams = this.algid.getAlgParameters();
            if (algParams == null) {
                return null;
            }
            DSAParameterSpec paramSpec = (DSAParameterSpec)algParams.getParameterSpec(class$java$security$spec$DSAParameterSpec == null ? (class$java$security$spec$DSAParameterSpec = DSAPublicKey.class$("java.security.spec.DSAParameterSpec")) : class$java$security$spec$DSAParameterSpec);
            return paramSpec;
        }
        catch (InvalidParameterSpecException e) {
            return null;
        }
    }

    public String toString() {
        String prov = "IBMPKCS11Impl";
        String output = prov + " DSA Public Key: ";
        if (this.isToken != null) {
            output = output + "\n Token: " + this.isToken;
        }
        if (this.isPrivate != null) {
            output = output + "\n Private: " + this.isPrivate;
        }
        if (this.label != null) {
            output = output + "\n Label: " + this.label;
        }
        if (this.isModifiable != null) {
            output = output + "\n Modifiable: " + this.isModifiable;
        }
        output = output + "\n KeyType: " + this.keyType.toString();
        if (this.ID != null) {
            output = output + "\n ID: " + new String(this.ID);
        }
        if (this.startDate != null) {
            output = output + "\n Start Date: " + this.startDate.toString();
        }
        if (this.endDate != null) {
            output = output + "\n End Date: " + this.endDate.toString();
        }
        if (this.isDerive != null) {
            output = output + "\n Derive: " + this.isDerive;
        }
        if (this.isLocal != null) {
            output = output + "\n Local: " + this.isLocal;
        }
        if (this.subject != null) {
            output = output + "\n Subject: " + new String(this.subject);
        }
        if (this.isEncrypt != null) {
            output = output + "\n Encrypt: " + this.isEncrypt;
        }
        if (this.isVerify != null) {
            output = output + "\n Verify: " + this.isVerify;
        }
        if (this.isVerifyRecover != null) {
            output = output + "\n VerifyRecover: " + this.isVerifyRecover;
        }
        if (this.isWrap != null) {
            output = output + "\n Wrap: " + this.isWrap;
        }
        if (this.prime != null) {
            output = output + "\n prime: " + this.prime.toString();
        }
        if (this.subprime != null) {
            output = output + "\n subprime: " + this.subprime.toString();
        }
        if (this.base != null) {
            output = output + "\n base: " + this.base.toString();
        }
        if (this.value != null) {
            output = output + "\n value: " + this.value.toString();
        }
        return output;
    }

    private Object getAttrValue(PKCS11Object pkcs11obj, int attr) {
        Object rtn;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getValue", (Object)pkcs11obj, (Object)new Integer(attr));
        }
        try {
            rtn = pkcs11obj.getAttributeValue(attr);
        }
        catch (Exception e) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "getValue", e.getMessage());
            }
            rtn = null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getValue");
        }
        return rtn;
    }

    public String getFormat() {
        return "PKCS#11";
    }

    public String getAlgorithm() {
        return "DSA";
    }

    private String genLabel() {
        byte[] labelName = new byte[33];
        byte[] labelSaltData = new byte[24];
        byte[] labelTmp = null;
        int labelLength = 0;
        try {
            SecureRandom random = SecureRandom.getInstance("IBMSecureRandom", "IBMPKCS11Impl");
            random.nextBytes(labelSaltData);
        }
        catch (Exception e) {
            // empty catch block
        }
        BigInteger bigInt = new BigInteger(1, labelSaltData);
        try {
            labelTmp = bigInt.toString().getBytes("8859_1");
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError("Can not convert string");
        }
        labelLength = bigInt.toString().length();
        if (labelLength > 24) {
            labelLength = 24;
        }
        System.arraycopy(labelTmp, 0, labelName, 9, labelLength);
        labelName[0] = 73;
        labelName[1] = 66;
        labelName[2] = 77;
        labelName[3] = 80;
        labelName[4] = 75;
        labelName[5] = 67;
        labelName[6] = 83;
        labelName[7] = 49;
        labelName[8] = 49;
        String label = null;
        try {
            label = new String(labelName, "8859_1");
        }
        catch (UnsupportedEncodingException e) {
            label = new String(labelName);
        }
        return label;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

