/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Session;
import java.security.DigestException;

final class Hash
implements Cloneable {
    private static final int MAX_HASH_LENGTH = 20;
    private byte[] digest;
    private byte[] buffer;
    private byte[] checksum;
    private byte[] mdBuffer;
    private int bufferIndex;
    private int bufferLeft;
    private int mechanism;
    private PKCS11Session session;
    private boolean initObject = false;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.Hash";

    protected Hash(int mechanism) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "Hash", (Object)("mechanism: " + mechanism));
        }
        this.mechanism = mechanism;
        this.init();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "Hash");
        }
    }

    private void init() {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "init");
        }
        this.session = IBMPKCS11Impl.session;
        this.initObject = false;
        if (debug != null) {
            debug.exit(16384L, (Object)className, "init");
        }
    }

    protected void engineReset() {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineReset");
        }
        this.init();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineReset");
        }
    }

    protected synchronized void engineUpdate(byte[] input, int offset, int len) {
        if (debug != null) {
            Object[] parms = new Object[]{input, new Integer(offset).toString(), new Integer(len).toString()};
            debug.entry(16384L, (Object)className, "engineUpdate", parms);
        }
        if (!this.initObject) {
            this.session.digestInit(this.mechanism, null);
            this.initObject = true;
        }
        this.session.digestUpdate(input, offset, len);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineUpdate");
        }
    }

    protected byte[] engineDigest() {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineDigest");
        }
        if (!this.initObject) {
            this.session.digestInit(this.mechanism, null);
            this.initObject = true;
        }
        int resultLen = 0;
        byte[] buffer = new byte[20];
        resultLen = this.session.digestFinal(buffer, 0);
        byte[] result = new byte[resultLen];
        System.arraycopy(buffer, 0, result, 0, resultLen);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineDigest");
        }
        return result;
    }

    protected int engineDigest(byte[] buf, int offset, int len) throws DigestException {
        if (debug != null) {
            Object[] parms = new Object[]{buf, new Integer(offset).toString(), new Integer(len).toString()};
            debug.entry(16384L, (Object)className, "engineDigest", parms);
        }
        if (!this.initObject) {
            this.session.digestInit(this.mechanism, null);
            this.initObject = true;
        }
        int resultLen = 0;
        byte[] buffer = new byte[20];
        resultLen = this.session.digestFinal(buffer, 0);
        if (len < resultLen) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "engineDigest", "partial digests not returned");
            }
            throw new DigestException("partial digests not returned");
        }
        if (buf.length - offset < resultLen) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "engineDigest", "insufficient space in the output buffer to store the digest");
            }
            throw new DigestException("insufficient space in the output buffer to store the digest");
        }
        System.arraycopy(buffer, 0, buf, offset, resultLen);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineDigest");
        }
        return resultLen;
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "clone");
        }
        Hash that = null;
        try {
            that = (Hash)super.clone();
            that.digest = (byte[])this.digest.clone();
            that.buffer = (byte[])this.buffer.clone();
            that.checksum = (byte[])this.checksum.clone();
            that.mdBuffer = (byte[])this.mdBuffer.clone();
            that.bufferIndex = this.bufferIndex;
            that.bufferLeft = this.bufferLeft;
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone");
            }
            return that;
        }
        catch (CloneNotSupportedException e) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "clone", (Throwable)e);
            }
            return that;
        }
    }
}

