/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.DESKey;
import com.ibm.crypto.pkcs11impl.provider.DESedeKey;
import com.ibm.crypto.pkcs11impl.provider.DSAPrivateKey;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.PKCS11Key;
import com.ibm.crypto.pkcs11impl.provider.PKCS11PrivateKey;
import com.ibm.crypto.pkcs11impl.provider.PKCS11PublicKey;
import com.ibm.crypto.pkcs11impl.provider.PKCS11SecretKey;
import com.ibm.crypto.pkcs11impl.provider.RSAPrivateKey;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.pkcs11.PKCS11Session;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CertImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;

public final class PKCS11KeyStore
extends KeyStoreSpi {
    private static Debug debug1 = Debug.getInstance((String)"pkcs11impl");
    private static Debug debug2 = Debug.getInstance((String)"pkcs11keystore");
    private static Debug debug = debug1 == null ? debug2 : debug1;
    private static String className = "com.ibm.crypto.pkcs11impl.provider.PKCS11KeyStore";
    private PKCS11Session session = null;
    private Hashtable entries = new Hashtable();

    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        Object entry = this.entries.get(alias.toLowerCase());
        if (entry != null) {
            if (entry instanceof PrivateKeyEntry) {
                return ((PrivateKeyEntry)entry).key;
            }
            if (entry instanceof SecretKeyEntry) {
                return ((SecretKeyEntry)entry).key;
            }
        }
        return null;
    }

    public Certificate[] engineGetCertificateChain(String alias) {
        Certificate[] chain = null;
        Object entry = this.entries.get(alias.toLowerCase());
        if (entry != null && entry instanceof PrivateKeyEntry && ((PrivateKeyEntry)entry).chain != null) {
            chain = (Certificate[])((PrivateKeyEntry)entry).chain.clone();
        }
        return chain;
    }

    public Certificate engineGetCertificate(String alias) {
        Certificate cert = null;
        Object entry = this.entries.get(alias.toLowerCase());
        if (entry != null) {
            if (entry instanceof TrustedCertEntry) {
                cert = ((TrustedCertEntry)entry).cert;
            } else if (entry instanceof PrivateKeyEntry && ((PrivateKeyEntry)entry).chain != null) {
                cert = ((PrivateKeyEntry)entry).chain[0];
            }
        }
        return cert;
    }

    public Date engineGetCreationDate(String alias) {
        Object date = null;
        Object entry = this.entries.get(alias.toLowerCase());
        if (entry != null) {
            if (entry instanceof PrivateKeyEntry) {
                try {
                    date = ((PrivateKeyEntry)entry).keyObject.getAttributeValue(272);
                }
                catch (PKCS11Exception pkcs11ex) {
                    if (debug != null) {
                        debug.exception(16384L, (Object)className, "engineGetCreationDate", (Throwable)pkcs11ex);
                    }
                    date = null;
                }
                if (date == null) {
                    PublicKey pkey;
                    Certificate[] chain;
                    if (debug != null) {
                        debug.text(16384L, (Object)className, "engineGetCreationDate", "start date attribute is not set for the private key");
                    }
                    if ((chain = ((PrivateKeyEntry)entry).chain) != null && chain.length > 0 && (pkey = ((X509Certificate)chain[0]).getPublicKey()) instanceof PKCS11PublicKey) {
                        date = ((PKCS11PublicKey)pkey).getStartDate();
                    }
                } else if (!(date instanceof Date)) {
                    if (debug != null) {
                        debug.text(16384L, (Object)className, "engineGetCreationDate", "expected Date object, but got " + date);
                    }
                    date = null;
                }
            } else if (entry instanceof SecretKeyEntry) {
                try {
                    date = ((SecretKeyEntry)entry).keyObject.getAttributeValue(272);
                }
                catch (PKCS11Exception pkcs11ex) {
                    if (debug != null) {
                        debug.exception(16384L, (Object)className, "engineGetCreationDate", (Throwable)pkcs11ex);
                    }
                    date = null;
                }
                if (date == null) {
                    if (debug != null) {
                        debug.text(16384L, (Object)className, "engineGetCreationDate", "start date attribute is not set for the secret key");
                    }
                } else if (!(date instanceof Date)) {
                    if (debug != null) {
                        debug.text(16384L, (Object)className, "engineGetCreationDate", "expected Date object, but got " + date);
                    }
                    date = null;
                }
            } else if (entry instanceof TrustedCertEntry) {
                try {
                    date = ((TrustedCertEntry)entry).certObject.getAttributeValue(272);
                }
                catch (PKCS11Exception pkcs11ex) {
                    if (debug != null) {
                        debug.exception(16384L, (Object)className, "engineGetCreationDate", (Throwable)pkcs11ex);
                    }
                    date = null;
                }
                if (date == null) {
                    PublicKey pkey;
                    if (debug != null) {
                        debug.text(16384L, (Object)className, "engineGetCreationDate", "start date attribute is not set for the certificate");
                    }
                    if ((pkey = ((TrustedCertEntry)entry).cert.getPublicKey()) instanceof PKCS11PublicKey) {
                        date = ((PKCS11PublicKey)pkey).getStartDate();
                    }
                } else if (!(date instanceof Date)) {
                    if (debug != null) {
                        debug.text(16384L, (Object)className, "engineGetCreationDate", "expected Date object, but got " + date);
                    }
                    date = null;
                }
            }
        }
        if (date == null) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "engineGetCreationDate", "no entry found associated with alias " + alias);
            }
            return null;
        }
        return (Date)date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        Hashtable hashtable = this.entries;
        synchronized (hashtable) {
            Object newEntry = null;
            if (this.engineIsCertificateEntry(alias)) {
                throw new KeyStoreException("Alias exists for a certificate entry");
            }
            if (key instanceof PKCS11PrivateKey) {
                PrivateKeyEntry entry = new PrivateKeyEntry();
                entry.key = key;
                entry.keyObject = ((PKCS11PrivateKey)key).getObject();
                entry.chain = chain != null ? (Certificate[])chain.clone() : null;
                newEntry = entry;
            } else if (key instanceof PKCS11SecretKey) {
                SecretKeyEntry entry = new SecretKeyEntry();
                entry.key = key;
                entry.keyObject = ((PKCS11SecretKey)key).getObject();
                newEntry = entry;
            } else if (key instanceof PrivateKey) {
                PKCS11PrivateKey ppkey;
                block20: {
                    String alg = key.getAlgorithm();
                    ppkey = null;
                    KeyFactory kf = null;
                    try {
                        if (alg.equalsIgnoreCase("DSA")) {
                            kf = KeyFactory.getInstance("DSA", "IBMPKCS11Impl");
                            ppkey = (PKCS11PrivateKey)kf.translateKey(key);
                            break block20;
                        }
                        if (alg.equalsIgnoreCase("RSA")) {
                            kf = KeyFactory.getInstance("RSA", "IBMPKCS11Impl");
                            ppkey = (PKCS11PrivateKey)kf.translateKey(key);
                            break block20;
                        }
                        throw new KeyStoreException("Keystore can not handle this key algorithm: " + alg);
                    }
                    catch (Exception e) {
                        throw new KeyStoreException("Keystore can not handle this key: " + e.getMessage());
                    }
                }
                PrivateKeyEntry entry = new PrivateKeyEntry();
                entry.key = ppkey;
                entry.keyObject = ppkey.getObject();
                entry.chain = chain != null ? (Certificate[])chain.clone() : null;
                newEntry = entry;
            } else if (key instanceof SecretKey) {
                PKCS11SecretKey skey;
                block21: {
                    String alg = key.getAlgorithm();
                    skey = null;
                    SecretKeyFactory kf = null;
                    try {
                        if (alg.equalsIgnoreCase("DES")) {
                            kf = SecretKeyFactory.getInstance("DES", "IBMPKCS11Impl");
                            skey = (PKCS11SecretKey)kf.translateKey((SecretKey)key);
                            break block21;
                        }
                        if (alg.equalsIgnoreCase("3DES") || alg.equalsIgnoreCase("DESede") || alg.equalsIgnoreCase("TripleDES")) {
                            kf = SecretKeyFactory.getInstance("DESede", "IBMPKCS11Impl");
                            skey = (PKCS11SecretKey)kf.translateKey((SecretKey)key);
                            break block21;
                        }
                        throw new KeyStoreException("Keystore can not handle this key algorithm: " + alg);
                    }
                    catch (Exception e) {
                        throw new KeyStoreException("Keystore can not handle this key: " + e.getMessage());
                    }
                }
                SecretKeyEntry entry = new SecretKeyEntry();
                entry.key = skey;
                entry.keyObject = skey.getObject();
                newEntry = entry;
            } else {
                throw new KeyStoreException("Invalid key type");
            }
            this.entries.put(alias.toLowerCase(), newEntry);
        }
    }

    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        throw new KeyStoreException("This method is not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        Hashtable hashtable = this.entries;
        synchronized (hashtable) {
            Object entry = this.entries.get(alias.toLowerCase());
            if (entry != null && (entry instanceof PrivateKeyEntry || entry instanceof SecretKeyEntry)) {
                throw new KeyStoreException("Cannot overwrite key entry");
            }
            PKCS11Object certObj = null;
            if (cert instanceof X509Certificate) {
                byte[] subject = null;
                byte[] id = null;
                try {
                    id = alias.getBytes("8859_1");
                }
                catch (UnsupportedEncodingException e) {
                    id = alias.getBytes();
                }
                byte[] issuer = null;
                BigInteger serialNumber = null;
                DerOutputStream dos = null;
                if (id.length > 20) {
                    byte[] bytes = new byte[20];
                    System.arraycopy(id, 0, bytes, 0, 20);
                    id = bytes;
                }
                try {
                    CertificateFactory certFactory = CertificateFactory.getInstance("X509", "IBMPKCS11Impl");
                    if (cert instanceof X509CertImpl) {
                        X509CertImpl thecert = (X509CertImpl)cert;
                        dos = new DerOutputStream();
                        ((X500Name)thecert.getSubjectDN()).encode(dos);
                        subject = dos.toByteArray();
                        dos = new DerOutputStream();
                        ((X500Name)thecert.getIssuerDN()).encode(dos);
                        issuer = dos.toByteArray();
                        serialNumber = thecert.getSerialNumber();
                        certObj = this.createCertObject(alias, thecert.getEncoded(), subject, id, issuer, serialNumber);
                    }
                    ByteArrayInputStream bais = new ByteArrayInputStream(cert.getEncoded());
                    X509CertImpl thecert = (X509CertImpl)certFactory.generateCertificate(bais);
                    dos = new DerOutputStream();
                    ((X500Name)thecert.getSubjectDN()).encode(dos);
                    subject = dos.toByteArray();
                    dos = new DerOutputStream();
                    ((X500Name)thecert.getIssuerDN()).encode(dos);
                    serialNumber = thecert.getSerialNumber();
                    certObj = this.createCertObject(alias, thecert.getEncoded(), subject, id, issuer, serialNumber);
                }
                catch (Exception ioe) {
                    throw new KeyStoreException("Cannot store certificate :" + ioe.getMessage());
                }
            } else {
                throw new KeyStoreException("Unsupported certificate type. Only X509 certificate is supported");
            }
            TrustedCertEntry trustedCertEntry = new TrustedCertEntry();
            trustedCertEntry.cert = cert;
            trustedCertEntry.certObject = certObj;
            this.entries.put(alias.toLowerCase(), trustedCertEntry);
        }
    }

    private PKCS11Object createCertObject(String label, byte[] value, byte[] subject, byte[] id, byte[] issuer, BigInteger serialNumber) throws KeyStoreException {
        int[] attrtypes = new int[]{0, 1, 2, 3, 128, 258, 257, 130, 17, 129};
        Object[] attrvalues = new Object[]{PKCS11Object.CERTIFICATE, Boolean.FALSE, Boolean.FALSE, label, PKCS11Object.X_509, id, subject, serialNumber.toByteArray(), value, issuer};
        PKCS11Object newobj = null;
        try {
            newobj = this.session.createObject(attrtypes, attrvalues);
        }
        catch (Exception e) {
            throw new KeyStoreException("Cannot store certificate: " + e.getMessage());
        }
        return newobj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void engineDeleteEntry(String alias) throws KeyStoreException {
        Hashtable hashtable = this.entries;
        synchronized (hashtable) {
            if (this.engineIsKeyEntry(alias)) {
                Object entry = this.entries.get(alias.toLowerCase());
                if (entry instanceof PrivateKeyEntry) {
                    PrivateKeyEntry keyentry = (PrivateKeyEntry)entry;
                    ((PKCS11Key)keyentry.key).getObject().destroy();
                } else {
                    SecretKeyEntry keyentry = (SecretKeyEntry)entry;
                    ((PKCS11Key)keyentry.key).getObject().destroy();
                }
            } else if (this.engineIsCertificateEntry(alias)) {
                TrustedCertEntry certentry = (TrustedCertEntry)this.entries.get(alias.toLowerCase());
                certentry.certObject.destroy();
            }
            this.entries.remove(alias.toLowerCase());
        }
    }

    public Enumeration engineAliases() {
        return this.entries.keys();
    }

    public boolean engineContainsAlias(String alias) {
        return this.entries.containsKey(alias.toLowerCase());
    }

    public int engineSize() {
        return this.entries.size();
    }

    public boolean engineIsKeyEntry(String alias) {
        boolean isKey = false;
        Object entry = this.entries.get(alias.toLowerCase());
        if (entry != null && (entry instanceof PrivateKeyEntry || entry instanceof SecretKeyEntry)) {
            isKey = true;
        }
        return isKey;
    }

    public boolean engineIsCertificateEntry(String alias) {
        boolean isCert = false;
        Object entry = this.entries.get(alias.toLowerCase());
        if (entry != null && entry instanceof TrustedCertEntry) {
            isCert = true;
        }
        return isCert;
    }

    public String engineGetCertificateAlias(Certificate cert) {
        Enumeration e = this.entries.keys();
        while (e.hasMoreElements()) {
            Certificate certElem;
            String alias = (String)e.nextElement();
            Object entry = this.entries.get(alias);
            if (entry instanceof TrustedCertEntry) {
                certElem = ((TrustedCertEntry)entry).cert;
            } else {
                if (!(entry instanceof PrivateKeyEntry) || ((PrivateKeyEntry)entry).chain == null) continue;
                certElem = ((PrivateKeyEntry)entry).chain[0];
            }
            if (!certElem.equals(cert)) continue;
            return alias;
        }
        return null;
    }

    public void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        throw new IOException("This method is not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineLoad");
        }
        Hashtable hashtable = this.entries;
        synchronized (hashtable) {
            CertificateFactory certFactory;
            Object obj;
            PKCS11Object pkcs11obj;
            block116: {
                this.entries.clear();
                pkcs11obj = null;
                obj = null;
                certFactory = null;
                try {
                    certFactory = CertificateFactory.getInstance("X509", "IBMPKCS11Impl");
                }
                catch (Exception ee) {
                    if (debug == null) break block116;
                    ee.printStackTrace();
                    if (debug != null) {
                        debug.exit(16384L, (Object)className, "engineLoad");
                    }
                    System.exit(1);
                }
            }
            Vector<PKCS11Object> privKeys = new Vector<PKCS11Object>();
            Vector<PKCS11Object> secretKeys = new Vector<PKCS11Object>();
            Vector<PKCS11Object> certs = new Vector<PKCS11Object>();
            this.session = IBMPKCS11Impl.session;
            this.session.findObjectsInit(null, null);
            while ((pkcs11obj = this.session.findObject()) != null) {
                obj = this.getValue(pkcs11obj, 0);
                if (obj != null && ((Integer)obj).equals(PKCS11Object.PRIVATE_KEY)) {
                    if (debug != null) {
                        debug.text(16384L, (Object)className, "engineLoad", "found PRIVATE KEY");
                    }
                    privKeys.add(pkcs11obj);
                    continue;
                }
                if (obj != null && ((Integer)obj).equals(PKCS11Object.CERTIFICATE)) {
                    if (debug != null) {
                        debug.text(16384L, (Object)className, "engineLoad", "found CERTIFICATE");
                    }
                    certs.add(pkcs11obj);
                    continue;
                }
                if (obj == null || !((Integer)obj).equals(PKCS11Object.SECRET_KEY)) continue;
                if (debug != null) {
                    debug.text(16384L, (Object)className, "engineLoad", "found CERTIFICATE");
                }
                secretKeys.add(pkcs11obj);
            }
            if (debug != null) {
                debug.text(16384L, (Object)className, "engineLoad", "# privkeys=" + privKeys.size() + " # certs=" + certs.size() + " # secret keys=" + secretKeys.size());
            }
            String tmpKeyName = "privateKey";
            int nameNum = 0;
            int num = 0;
            if (privKeys.size() > 0) {
                Enumeration enumeration = privKeys.elements();
                boolean p = false;
                if (debug != null) {
                    debug.text(16384L, (Object)className, "engineLoad", "now find key and certs");
                }
                while (enumeration.hasMoreElements()) {
                    X509Certificate[] chain;
                    PrivateKeyInfo key;
                    String label;
                    PKCS11Object pobj;
                    block119: {
                        byte[] id;
                        block117: {
                            pobj = (PKCS11Object)enumeration.nextElement();
                            label = (String)this.getValue(pobj, 3);
                            id = (byte[])this.getValue(pobj, 258);
                            byte[] sub = (byte[])this.getValue(pobj, 257);
                            if (debug != null) {
                                debug.text(16384L, (Object)className, "engineLoad", "within the private key loop");
                            }
                            String empty = "e";
                            if (id == null) continue;
                            Integer keytype = (Integer)this.getValue(pobj, 256);
                            if (debug != null) {
                                debug.text(16384L, (Object)className, "engineLoad", "Key Type=" + keytype.toString());
                            }
                            key = null;
                            if (keytype.equals(PKCS11Object.RSA)) {
                                try {
                                    if (debug != null) {
                                        debug.text(16384L, (Object)className, "engineLoad", "Constructure RSA(...) clear");
                                    }
                                    key = new RSAPrivateKey(pobj, (byte[])this.getValue(pobj, 258), (byte[])this.getValue(pobj, 257), (String)this.getValue(pobj, 3), (Boolean)this.getValue(pobj, 1), (Boolean)this.getValue(pobj, 259), (Boolean)this.getValue(pobj, 264), (Boolean)this.getValue(pobj, 261), (Boolean)this.getValue(pobj, 263), (Boolean)this.getValue(pobj, 354), (BigInteger)this.getValue(pobj, 288), (BigInteger)this.getValue(pobj, 290), (BigInteger)this.getValue(pobj, 291), (BigInteger)this.getValue(pobj, 292), (BigInteger)this.getValue(pobj, 293), (BigInteger)this.getValue(pobj, 294), (BigInteger)this.getValue(pobj, 295), (BigInteger)this.getValue(pobj, 296));
                                }
                                catch (Exception ike) {
                                    try {
                                        if (debug != null) {
                                            debug.text(16384L, (Object)className, "engineLoad", "Constructure RSA() hardware");
                                        }
                                        key = new RSAPrivateKey(pobj, (byte[])this.getValue(pobj, 258), (byte[])this.getValue(pobj, 257), (String)this.getValue(pobj, 3), (Boolean)this.getValue(pobj, 1), (Boolean)this.getValue(pobj, 259), (Boolean)this.getValue(pobj, 264), (Boolean)this.getValue(pobj, 261), (Boolean)this.getValue(pobj, 263), (Boolean)this.getValue(pobj, 354), (BigInteger)this.getValue(pobj, 288), (BigInteger)this.getValue(pobj, 290));
                                        break block117;
                                    }
                                    catch (InvalidKeyException ikee) {
                                        if (debug != null) {
                                            debug.exception(16384L, (Object)className, "engineLoad_2", (Throwable)ikee);
                                        }
                                        break block117;
                                    }
                                }
                            }
                            if (!keytype.equals(PKCS11Object.DSA)) continue;
                            try {
                                if (debug != null) {
                                    debug.text(16384L, (Object)className, "engineLoad", "Constructure DSA(...) clear");
                                }
                                key = new DSAPrivateKey(pobj, (String)this.getValue(pobj, 3), (byte[])this.getValue(pobj, 258), (byte[])this.getValue(pobj, 257), (Boolean)this.getValue(pobj, 1), (Boolean)this.getValue(pobj, 259), (Boolean)this.getValue(pobj, 354), (BigInteger)this.getValue(pobj, 304), (BigInteger)this.getValue(pobj, 305), (BigInteger)this.getValue(pobj, 306), new BigInteger(1, (byte[])this.getValue(pobj, 17)));
                            }
                            catch (Exception ike) {
                                try {
                                    if (debug != null) {
                                        debug.text(16384L, (Object)className, "engineLoad", "Constructure DSA() hardware");
                                    }
                                    key = new DSAPrivateKey(pobj, (String)this.getValue(pobj, 3), (byte[])this.getValue(pobj, 258), (byte[])this.getValue(pobj, 257), (Boolean)this.getValue(pobj, 1), (Boolean)this.getValue(pobj, 259), (Boolean)this.getValue(pobj, 354));
                                }
                                catch (InvalidKeyException ikee) {
                                    if (debug == null) break block117;
                                    debug.exception(16384L, (Object)className, "engineLoad_3", (Throwable)ikee);
                                }
                            }
                        }
                        int j = certs.size();
                        Enumeration e = certs.elements();
                        PKCS11Object cobj = null;
                        ArrayList<X509Certificate> certsArray = new ArrayList<X509Certificate>();
                        HashSet<TrustAnchor> trustAnchors = new HashSet<TrustAnchor>();
                        X509Certificate keyCert = null;
                        X509Certificate cert = null;
                        chain = null;
                        byte[] origMsg = "testmessage_a very long test message".getBytes();
                        for (int k = 0; k < j; ++k) {
                            if (debug != null) {
                                debug.text(16384L, (Object)className, "engineLoad", "going through cert objects");
                            }
                            cobj = (PKCS11Object)e.nextElement();
                            byte[] tid = (byte[])this.getValue(cobj, 258);
                            byte[] tsub = (byte[])this.getValue(cobj, 257);
                            byte[] bytearray = (byte[])this.getValue(cobj, 17);
                            ByteArrayInputStream bais = new ByteArrayInputStream(bytearray);
                            cert = (X509Certificate)certFactory.generateCertificate(bais);
                            if (tid != null && this.bytesEquals(id, tid)) {
                                block118: {
                                    PublicKey pubkey = cert.getPublicKey();
                                    try {
                                        Signature sig = Signature.getInstance(key.getAlgorithm(), "IBMPKCS11Impl");
                                        sig.initSign((PrivateKey)key);
                                        sig.update(origMsg);
                                        byte[] signature = sig.sign();
                                        sig.initVerify(pubkey);
                                        sig.update(origMsg);
                                        if (sig.verify(signature)) {
                                            keyCert = cert;
                                        }
                                    }
                                    catch (Exception ex) {
                                        if (debug == null) break block118;
                                        debug.text(16384L, (Object)className, "engineLoad", "Error checking signature: " + ex.getMessage());
                                    }
                                }
                                if (debug != null) {
                                    debug.text(16384L, (Object)className, "engineLoad", "found cert at pos" + k + " # of certs now = " + certsArray.size());
                                    debug.text(16384L, (Object)className, "engineLoad", "found cert = " + keyCert);
                                }
                            }
                            certsArray.add(cert);
                            trustAnchors.add(new TrustAnchor(cert, null));
                        }
                        if (keyCert != null) {
                            try {
                                CertPathBuilder cpb = CertPathBuilder.getInstance("PKIX", "IBMCertPath");
                                X509CertSelector targetConstraints = new X509CertSelector();
                                if (debug != null) {
                                    debug.text(16384L, (Object)className, "engineLoad", "building certpath");
                                }
                                String currentSubject = ((Object)keyCert.getSubjectDN()).toString();
                                targetConstraints.setSubject(currentSubject);
                                if (debug != null) {
                                    debug.text(16384L, (Object)className, "engineLoad", "Subject = " + currentSubject);
                                }
                                PKIXBuilderParameters params = new PKIXBuilderParameters(trustAnchors, (CertSelector)targetConstraints);
                                params.setRevocationEnabled(false);
                                params.setMaxPathLength(-1);
                                CollectionCertStoreParameters ccsp = new CollectionCertStoreParameters(certsArray);
                                CertStore store = CertStore.getInstance("Collection", (CertStoreParameters)ccsp, "IBMCertPath");
                                params.addCertStore(store);
                                try {
                                    PKIXCertPathBuilderResult cpresult = (PKIXCertPathBuilderResult)cpb.build(params);
                                    CertPath cp = cpresult.getCertPath();
                                    if (cp != null) {
                                        List<? extends Certificate> cpcerts = cp.getCertificates();
                                        int i = 0;
                                        chain = new X509Certificate[cpcerts.size() + 1];
                                        Iterator<? extends Certificate> cpIterator = cpcerts.iterator();
                                        while (cpIterator.hasNext()) {
                                            chain[i++] = (X509Certificate)cpIterator.next();
                                        }
                                        chain[i] = cpresult.getTrustAnchor().getTrustedCert();
                                    }
                                }
                                catch (CertPathBuilderException cpbe) {
                                    if (debug != null) {
                                        debug.text(16384L, (Object)className, "engineLoad_0", "could not build CertPath for certificate " + cpbe.getMessage());
                                    }
                                    chain = null;
                                }
                            }
                            catch (Exception ex) {
                                if (debug == null) break block119;
                                debug.exception(16384L, (Object)className, "engineLoad_1", (Throwable)ex);
                            }
                        }
                    }
                    PrivateKeyEntry keyEntry = new PrivateKeyEntry();
                    keyEntry.key = key;
                    keyEntry.keyObject = pobj;
                    keyEntry.chain = chain;
                    if (debug != null) {
                        debug.text(16384L, (Object)className, "engineLoad", "Entry: \n key =" + key.toString() + "\nkeyObject =" + pobj + "\nchain = " + chain + "\nLabel = " + label);
                    }
                    if (label != null && label.length() != 0) {
                        if (debug != null) {
                            debug.text(16384L, (Object)className, "engineLoad", "label != null");
                        }
                        if (!this.entries.containsKey(label.toLowerCase())) {
                            if (debug != null) {
                                debug.text(16384L, (Object)className, "engineLoad", "label empty");
                            }
                            this.entries.put(label.toLowerCase(), keyEntry);
                            if (debug == null) continue;
                            System.out.println("PKCS11IMPLKS: put key entry[" + label.toLowerCase() + "] to entries");
                            continue;
                        }
                        if (debug != null) {
                            debug.text(16384L, (Object)className, "engineLoad", "label not empty");
                        }
                        boolean foundLabel = false;
                        while (!foundLabel) {
                            String newLabel = label + "key" + num;
                            if (debug != null) {
                                debug.text(16384L, (Object)className, "engineLoad", "finding label: " + newLabel);
                            }
                            if (this.entries.get(newLabel.toLowerCase()) == null) {
                                this.entries.put(newLabel.toLowerCase(), keyEntry);
                                if (debug != null) {
                                    System.out.println("PKCS11IMPLKS: put key entry[" + newLabel.toLowerCase() + "] to entries");
                                }
                                foundLabel = true;
                                continue;
                            }
                            ++num;
                        }
                        continue;
                    }
                    boolean foundName = false;
                    while (!foundName) {
                        String keyName = tmpKeyName + nameNum;
                        if (!this.entries.containsKey(keyName.toLowerCase())) {
                            this.entries.put(keyName.toLowerCase(), keyEntry);
                            if (debug != null) {
                                System.out.println("PKCS11IMPLKS: put key entry[" + keyName.toLowerCase() + "] to entries");
                            }
                            foundName = true;
                            continue;
                        }
                        ++nameNum;
                    }
                }
                privKeys.removeAllElements();
            }
            tmpKeyName = "secretKey";
            nameNum = 0;
            num = 0;
            if (secretKeys.size() > 0) {
                int j = secretKeys.size();
                Enumeration e = secretKeys.elements();
                for (int k = 0; k < j; ++k) {
                    Object key;
                    String label;
                    PKCS11Object sobj;
                    block121: {
                        block120: {
                            sobj = null;
                            label = null;
                            try {
                                sobj = (PKCS11Object)e.nextElement();
                                label = (String)this.getValue(sobj, 3);
                                if (debug == null) break block120;
                                debug.text(16384L, (Object)className, "engineLoad", "sobj: " + sobj);
                            }
                            catch (NoSuchElementException nsee) {
                                k = j;
                                continue;
                            }
                        }
                        Integer keytype = (Integer)this.getValue(sobj, 256);
                        key = null;
                        if (keytype.equals(PKCS11Object.DES)) {
                            try {
                                if (debug != null) {
                                    debug.text(16384L, (Object)className, "engineLoad", "Constructure DES(...) clear");
                                }
                                key = new DESKey(sobj, (byte[])this.getValue(sobj, 258), (String)this.getValue(sobj, 3), (Boolean)this.getValue(sobj, 1), (Boolean)this.getValue(sobj, 259), (Boolean)this.getValue(sobj, 260), (Boolean)this.getValue(sobj, 262), (Boolean)this.getValue(sobj, 354), (byte[])this.getValue(sobj, 17));
                            }
                            catch (Exception ike) {
                                try {
                                    if (debug != null) {
                                        debug.text(16384L, (Object)className, "engineLoad", "Constructure DES() hardware");
                                    }
                                    key = new DESKey(sobj, (byte[])this.getValue(sobj, 258), (String)this.getValue(sobj, 3), (Boolean)this.getValue(sobj, 1), (Boolean)this.getValue(sobj, 259), (Boolean)this.getValue(sobj, 260), (Boolean)this.getValue(sobj, 262), (Boolean)this.getValue(sobj, 354));
                                    break block121;
                                }
                                catch (InvalidKeyException ikee) {
                                    if (debug != null) {
                                        debug.exception(16384L, (Object)className, "engineLoad_4", (Throwable)ikee);
                                    }
                                    break block121;
                                }
                            }
                        }
                        if (!keytype.equals(PKCS11Object.DES3)) continue;
                        try {
                            if (debug != null) {
                                debug.text(16384L, (Object)className, "engineLoad", "Constructure DESede(...) clear");
                            }
                            key = new DESedeKey(sobj, (byte[])this.getValue(sobj, 258), (String)this.getValue(sobj, 3), (Boolean)this.getValue(sobj, 1), (Boolean)this.getValue(sobj, 259), (Boolean)this.getValue(sobj, 260), (Boolean)this.getValue(sobj, 262), (Boolean)this.getValue(sobj, 354), (byte[])this.getValue(sobj, 17));
                        }
                        catch (Exception ike) {
                            try {
                                if (debug != null) {
                                    debug.text(16384L, (Object)className, "engineLoad", "Constructure DESede() hardware");
                                }
                                key = new DESedeKey(sobj, (byte[])this.getValue(sobj, 258), (String)this.getValue(sobj, 3), (Boolean)this.getValue(sobj, 1), (Boolean)this.getValue(sobj, 259), (Boolean)this.getValue(sobj, 260), (Boolean)this.getValue(sobj, 262), (Boolean)this.getValue(sobj, 354));
                            }
                            catch (InvalidKeyException ikee) {
                                if (debug == null) break block121;
                                ike.printStackTrace();
                                debug.exception(16384L, (Object)className, "engineLoad_5", (Throwable)ikee);
                            }
                        }
                    }
                    SecretKeyEntry keyEntry = new SecretKeyEntry();
                    keyEntry.key = key;
                    keyEntry.keyObject = sobj;
                    if (debug != null) {
                        debug.text(16384L, (Object)className, "engineLoad", "Secret Entry: \n key =" + key.toString() + "\nkeyObject =" + sobj + "\nLabel = " + label);
                    }
                    if (label != null && label.length() != 0) {
                        if (debug != null) {
                            debug.text(16384L, (Object)className, "engineLoad", "label != null");
                        }
                        if (this.entries.get(label.toLowerCase()) == null) {
                            if (debug != null) {
                                debug.text(16384L, (Object)className, "engineLoad", "label empty");
                            }
                            this.entries.put(label.toLowerCase(), keyEntry);
                            if (debug == null) continue;
                            System.out.println("PKCS11IMPLKS: put secret key entry[" + label.toLowerCase() + "] to entries");
                            continue;
                        }
                        if (debug != null) {
                            debug.text(16384L, (Object)className, "engineLoad", "label not empty");
                        }
                        boolean foundLabel = false;
                        while (!foundLabel) {
                            String newLabel;
                            if (debug != null) {
                                debug.text(16384L, (Object)className, "engineLoad", "finding label");
                            }
                            if (this.entries.get((newLabel = label + "sec" + num).toLowerCase()) == null) {
                                this.entries.put(newLabel.toLowerCase(), keyEntry);
                                if (debug != null) {
                                    System.out.println("PKCS11IMPLKS: put secret key entry[" + newLabel.toLowerCase() + "] to entries");
                                }
                                foundLabel = true;
                                continue;
                            }
                            ++num;
                        }
                        continue;
                    }
                    boolean foundName = false;
                    while (!foundName) {
                        String keyName = tmpKeyName + nameNum;
                        if (!this.entries.containsKey(keyName.toLowerCase())) {
                            this.entries.put(keyName.toLowerCase(), keyEntry);
                            if (debug != null) {
                                System.out.println("PKCS11IMPLKS: put secret key entry[" + keyName.toLowerCase() + "] to entries");
                            }
                            foundName = true;
                            continue;
                        }
                        ++nameNum;
                    }
                }
                secretKeys.removeAllElements();
            }
            String tmpCertName = "cert";
            nameNum = 0;
            if (certs.size() > 0) {
                int j = certs.size();
                Enumeration e = certs.elements();
                for (int k = 0; k < j; ++k) {
                    byte[] bytearray;
                    String label;
                    PKCS11Object cobj;
                    block123: {
                        block122: {
                            cobj = null;
                            try {
                                cobj = (PKCS11Object)e.nextElement();
                                if (debug == null) break block122;
                                debug.text(16384L, (Object)className, "engineLoad", "cobj: " + cobj);
                            }
                            catch (NoSuchElementException nsee) {
                                k = j;
                                continue;
                            }
                        }
                        label = (String)this.getValue(cobj, 3);
                        byte[] id = (byte[])this.getValue(cobj, 258);
                        bytearray = null;
                        try {
                            bytearray = (byte[])this.getValue(cobj, 17);
                        }
                        catch (Exception ex) {
                            if (debug == null) break block123;
                            debug.text(16384L, (Object)className, "engineLoad", "tries to get cert value2");
                            ex.printStackTrace();
                        }
                    }
                    ByteArrayInputStream bais = new ByteArrayInputStream(bytearray);
                    TrustedCertEntry ce = new TrustedCertEntry();
                    ce.cert = certFactory.generateCertificate(bais);
                    ce.certObject = cobj;
                    if (debug != null) {
                        debug.text(16384L, (Object)className, "engineLoad", "Trusted Cert Entry: \n cert =" + ce.cert.toString() + "\n CertObject =" + cobj + "\nLabel = " + label);
                    }
                    if (label != null && label.length() != 0) {
                        if (debug != null) {
                            debug.text(16384L, (Object)className, "engineLoad", "label != null");
                        }
                        if (this.entries.get(label.toLowerCase()) == null) {
                            if (debug != null) {
                                debug.text(16384L, (Object)className, "engineLoad", "label empty");
                            }
                            this.entries.put(label.toLowerCase(), ce);
                            if (debug == null) continue;
                            System.out.println("PKCS11IMPLKS: put cert entry[" + label.toLowerCase() + "] to entries");
                            continue;
                        }
                        if (debug != null) {
                            debug.text(16384L, (Object)className, "engineLoad", "label not empty");
                        }
                        boolean foundLabel = false;
                        while (!foundLabel) {
                            String newLabel;
                            if (debug != null) {
                                debug.text(16384L, (Object)className, "engineLoad", "finding label");
                            }
                            if (this.entries.get((newLabel = label + "cert" + num).toLowerCase()) == null) {
                                this.entries.put(newLabel.toLowerCase(), ce);
                                if (debug != null) {
                                    System.out.println("PKCS11IMPLKS: put cert entry[" + newLabel.toLowerCase() + "] to entries");
                                }
                                foundLabel = true;
                                continue;
                            }
                            ++num;
                        }
                        continue;
                    }
                    boolean foundName = false;
                    while (!foundName) {
                        String keyName = tmpCertName + nameNum;
                        if (!this.entries.containsKey(keyName.toLowerCase())) {
                            this.entries.put(keyName.toLowerCase(), ce);
                            if (debug != null) {
                                System.out.println("PKCS11IMPLKS: put cert entry[" + keyName.toLowerCase() + "] to entries");
                            }
                            foundName = true;
                            continue;
                        }
                        ++nameNum;
                    }
                }
                certs.removeAllElements();
            }
            try {
                this.session.findObjectsFinal();
            }
            catch (Exception foe) {
                // empty catch block
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineLoad");
        }
    }

    private Object getValue(PKCS11Object pkcs11obj, int attr) {
        Object obj = null;
        try {
            obj = pkcs11obj.getAttributeValue(attr);
        }
        catch (Exception e) {
            return null;
        }
        return obj;
    }

    private Object[] getAttributes(PKCS11Object pkcs11obj) {
        return null;
    }

    private boolean bytesEquals(byte[] a, byte[] b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    protected void finalize() {
    }

    class TrustedCertEntry {
        Certificate cert;
        PKCS11Object certObject;

        TrustedCertEntry() {
        }
    }

    class SecretKeyEntry {
        Key key;
        PKCS11Object keyObject;

        SecretKeyEntry() {
        }
    }

    class PrivateKeyEntry {
        Key key;
        PKCS11Object keyObject;
        Certificate[] chain;

        PrivateKeyEntry() {
        }
    }
}

