/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.Hash;
import com.ibm.crypto.pkcs11impl.provider.Signature;
import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;

public final class PKCS11MD2withRSASingle
extends SignatureSpi {
    private Signature sig = new Signature(1);
    private Hash md2 = new Hash(512);
    private String oid = "1.2.840.113549.2.2";
    private PrivateKey privateKey;
    private PublicKey publicKey;
    private boolean reset = false;

    protected void engineSetParameter(String key, Object param) {
    }

    protected Object engineGetParameter(String key) {
        return null;
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.privateKey = privateKey;
        if (this.reset) {
            this.md2.engineReset();
        }
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        this.publicKey = publicKey;
        if (this.reset) {
            this.md2.engineReset();
        }
    }

    protected void engineUpdate(byte b) {
        byte[] onebyte = new byte[]{b};
        this.md2.engineUpdate(onebyte, 0, 1);
    }

    protected void engineUpdate(byte[] data, int off, int len) {
        this.md2.engineUpdate(data, off, len);
    }

    protected byte[] engineSign() throws SignatureException {
        byte[] result = this.md2.engineDigest();
        DerOutputStream out = null;
        try {
            out = new DerOutputStream();
            DerOutputStream out1 = new DerOutputStream();
            AlgorithmId algid = AlgorithmId.getAlgorithmId((String)this.oid);
            algid.encode(out1);
            DerValue[] value = new DerValue[]{new DerValue(out1.toByteArray()), new DerValue(4, result)};
            out.putSequence(value);
        }
        catch (IOException e) {
            throw new SignatureException("error encoding signature");
        }
        catch (NoSuchAlgorithmException ee) {
            throw new SignatureException("error encoding signature");
        }
        byte[] digest = out.toByteArray();
        try {
            this.sig.engineInitSign(this.privateKey);
        }
        catch (Exception ex) {
            throw new PKCS11Exception(ex.getMessage());
        }
        this.reset = true;
        return this.sig.engineSign(digest, digest.length);
    }

    protected boolean engineVerify(byte[] signature) throws SignatureException {
        byte[] result = this.md2.engineDigest();
        DerOutputStream out = null;
        try {
            out = new DerOutputStream();
            DerOutputStream out1 = new DerOutputStream();
            AlgorithmId algid = AlgorithmId.getAlgorithmId((String)this.oid);
            algid.encode(out1);
            DerValue[] value = new DerValue[]{new DerValue(out1.toByteArray()), new DerValue(4, result)};
            out.putSequence(value);
        }
        catch (IOException e) {
            throw new SignatureException("error encoding signature");
        }
        catch (NoSuchAlgorithmException ee) {
            throw new SignatureException("error encoding signature");
        }
        byte[] digest = out.toByteArray();
        try {
            this.sig.engineInitVerify(this.publicKey);
        }
        catch (Exception ex) {
            throw new PKCS11Exception(ex.getMessage());
        }
        this.reset = true;
        return this.sig.engineVerify(signature, digest, digest.length);
    }
}

