/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.Hash;
import com.ibm.crypto.pkcs11impl.provider.Signature;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;

public final class PKCS11MD5withRSASingle
extends SignatureSpi {
    private Signature sig;
    private Hash md5;
    private String oid = "1.2.840.113549.2.5";
    private PrivateKey privateKey;
    private PublicKey publicKey;
    private boolean reset = false;
    private static Debug debug1 = Debug.getInstance((String)"pkcs11impl");
    private static Debug debug2 = Debug.getInstance((String)"pkcs11md5withrsasingle");
    private static Debug debug = debug1 == null ? debug2 : debug1;
    private static String className = "com.ibm.crypto.pkcs11impl.provider.PKCS11MD5withRSASingle";

    public PKCS11MD5withRSASingle() throws NoSuchAlgorithmException, NoSuchProviderException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "PKCS11MD5withRSASingle");
        }
        this.sig = new Signature(1);
        this.md5 = new Hash(528);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "PKCS11MD5withRSASingle");
        }
    }

    protected void engineSetParameter(String key, Object param) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineSetParameter");
            debug.exit(16384L, (Object)className, "engineSetParameter");
        }
    }

    protected Object engineGetParameter(String key) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineGetParameter");
            debug.exit(16384L, (Object)className, "engineGetParameter");
        }
        return null;
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineInitSign");
        }
        this.privateKey = privateKey;
        if (this.reset) {
            this.md5.engineReset();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineInitSign");
        }
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineInitVerify");
        }
        this.publicKey = publicKey;
        if (this.reset) {
            this.md5.engineReset();
        }
    }

    protected void engineUpdate(byte b) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineUpdate", (Object)new String("b = " + b));
        }
        byte[] onebyte = new byte[]{b};
        this.md5.engineUpdate(onebyte, 0, 1);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineUpdate");
        }
    }

    protected void engineUpdate(byte[] data, int off, int len) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineUpdate", (Object)new String("data = " + data + " off = " + off + " len = " + len));
        }
        this.md5.engineUpdate(data, off, len);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineUpdate");
        }
    }

    protected byte[] engineSign() throws SignatureException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineSign");
        }
        byte[] result = this.md5.engineDigest();
        DerOutputStream out = null;
        try {
            out = new DerOutputStream();
            DerOutputStream out1 = new DerOutputStream();
            AlgorithmId algid = AlgorithmId.getAlgorithmId((String)this.oid);
            algid.encode(out1);
            DerValue[] value = new DerValue[]{new DerValue(out1.toByteArray()), new DerValue(4, result)};
            out.putSequence(value);
        }
        catch (IOException e) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineSign", (Throwable)e);
            }
            throw new SignatureException("error encoding signature");
        }
        catch (NoSuchAlgorithmException ee) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineSign", (Throwable)ee);
            }
            throw new SignatureException("error encoding signature");
        }
        byte[] digest = out.toByteArray();
        try {
            this.sig.engineInitSign(this.privateKey);
        }
        catch (Exception ex) {
            throw new PKCS11Exception(ex.getMessage());
        }
        this.reset = true;
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineSign");
        }
        return this.sig.engineSign(digest, digest.length);
    }

    protected boolean engineVerify(byte[] signature) throws SignatureException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineVerify");
        }
        byte[] result = this.md5.engineDigest();
        DerOutputStream out = null;
        try {
            out = new DerOutputStream();
            DerOutputStream out1 = new DerOutputStream();
            AlgorithmId algid = AlgorithmId.getAlgorithmId((String)this.oid);
            algid.encode(out1);
            DerValue[] value = new DerValue[]{new DerValue(out1.toByteArray()), new DerValue(4, result)};
            out.putSequence(value);
        }
        catch (IOException e) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineVerify", (Throwable)e);
            }
            throw new SignatureException("error encoding signature");
        }
        catch (NoSuchAlgorithmException ee) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineVerify", (Throwable)ee);
            }
            throw new SignatureException("error encoding signature");
        }
        byte[] digest = out.toByteArray();
        try {
            this.sig.engineInitVerify(this.publicKey);
        }
        catch (Exception ex) {
            throw new PKCS11Exception(ex.getMessage());
        }
        this.reset = true;
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineVerify");
        }
        return this.sig.engineVerify(signature, digest, digest.length);
    }
}

