/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.Signature;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;

public final class PKCS11SHA1withDSA
extends SignatureSpi {
    private Signature sig = new Signature(18);

    protected void engineSetParameter(String key, Object param) {
    }

    protected Object engineGetParameter(String key) {
        return null;
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.sig.engineInitSign(privateKey);
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        this.sig.engineInitVerify(publicKey);
    }

    protected void engineUpdate(byte b) {
        byte[] onebyte = new byte[]{b};
        this.sig.engineUpdate(onebyte, 0, 1);
    }

    protected void engineUpdate(byte[] data, int off, int len) {
        this.sig.engineUpdate(data, off, len);
    }

    protected byte[] engineSign() throws SignatureException {
        byte[] ret = this.sig.engineSign();
        try {
            byte[] r = new byte[20];
            byte[] s = new byte[20];
            System.arraycopy(ret, 0, r, 0, 20);
            System.arraycopy(ret, 20, s, 0, 20);
            DerOutputStream out = new DerOutputStream(100);
            out.putInteger(new BigInteger(1, r));
            out.putInteger(new BigInteger(1, s));
            DerValue result = new DerValue(48, out.toByteArray());
            return result.toByteArray();
        }
        catch (IOException e) {
            throw new SignatureException("error encoding signature");
        }
    }

    protected boolean engineVerify(byte[] signature) throws SignatureException {
        byte[] signingBytes = new byte[40];
        try {
            DerInputStream in = new DerInputStream(signature);
            DerValue[] integers = in.getSequence(2);
            byte[] rPrime = integers[0].getInteger().toByteArray();
            byte[] sPrime = integers[1].getInteger().toByteArray();
            int length = rPrime.length;
            if (length > 20) {
                System.arraycopy(rPrime, length - 20, signingBytes, 0, 20);
            } else {
                System.arraycopy(rPrime, 0, signingBytes, 20 - length, length);
            }
            length = sPrime.length;
            if (length > 20) {
                System.arraycopy(sPrime, length - 20, signingBytes, 20, 20);
            } else {
                System.arraycopy(sPrime, 0, signingBytes, 40 - length, length);
            }
        }
        catch (IOException e) {
            throw new SignatureException("invalid encoding for signature :" + e);
        }
        return this.sig.engineVerify(signingBytes);
    }
}

