/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.SecureRandom;
import com.ibm.crypto.pkcs11impl.provider.Signature;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;

public final class PKCS11SSLHashingwithRSA
extends SignatureSpi {
    private Signature sig = new Signature(1);
    private byte[] hashData = new byte[128];
    private int count = 0;

    protected void engineSetParameter(String key, Object param) {
    }

    protected Object engineGetParameter(String key) {
        return null;
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.count = 0;
        this.sig.engineInitSign(privateKey);
    }

    protected void engineInitSign(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException {
        this.count = 0;
        this.sig.engineInitSign(privateKey);
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        this.count = 0;
        this.sig.engineInitVerify(publicKey);
    }

    protected void engineInitVerify(PublicKey publicKey, SecureRandom random) throws InvalidKeyException {
        this.count = 0;
        this.sig.engineInitVerify(publicKey);
    }

    protected void engineUpdate(byte b) {
        if (this.count + 1 > this.hashData.length) {
            byte[] temp = new byte[this.hashData.length + 128];
            System.arraycopy(this.hashData, 0, temp, 0, this.hashData.length);
            this.hashData = temp;
        }
        this.hashData[this.count] = b;
        ++this.count;
    }

    protected void engineUpdate(byte[] data, int off, int len) {
        if (this.count + (len - off) > this.hashData.length) {
            byte[] temp = new byte[this.hashData.length + 128 + (len - off)];
            System.arraycopy(this.hashData, 0, temp, 0, this.hashData.length);
            this.hashData = temp;
        }
        System.arraycopy(data, off, this.hashData, this.count, len - off);
        this.count += len - off;
    }

    protected byte[] engineSign() throws SignatureException {
        byte[] rtn = this.sig.engineSign(this.hashData, this.count);
        this.count = 0;
        return rtn;
    }

    protected boolean engineVerify(byte[] signature) throws SignatureException {
        boolean rtn = this.sig.engineVerify(signature, this.hashData, this.count);
        this.count = 0;
        return rtn;
    }
}

