/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.PKCS11KeySpec;
import com.ibm.crypto.pkcs11impl.provider.PKCS11RSAPrivateKey;
import com.ibm.crypto.pkcs11impl.provider.PKCS11RSAPublicKey;
import com.ibm.crypto.pkcs11impl.provider.RSAPrivateKey;
import com.ibm.crypto.pkcs11impl.provider.RSAPublicKey;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.pkcs11.PKCS11Session;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;

public final class RSAPKCS11KeyFactory
extends KeyFactorySpi {
    private PKCS11Session session = null;
    private static Debug debug1 = Debug.getInstance((String)"pkcs11impl");
    private static Debug debug2 = Debug.getInstance((String)"rsapkcs11keyfactory");
    private static Debug debug = debug1 == null ? debug2 : debug1;
    private static String className = "com.ibm.crypto.pkcs11impl.provider.RSAPKCS11KeyFactory";
    static /* synthetic */ Class class$java$security$spec$RSAPublicKeySpec;
    static /* synthetic */ Class class$java$security$spec$RSAPrivateCrtKeySpec;
    static /* synthetic */ Class class$java$security$spec$RSAPrivateKeySpec;

    public RSAPKCS11KeyFactory() {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "RSAPKCS11KeyFactory");
        }
        this.session = IBMPKCS11Impl.session;
        if (debug != null) {
            debug.exit(16384L, (Object)className, "RSAPKCS11KeyFactory");
        }
    }

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineGeneratePublic", (Object)keySpec);
        }
        try {
            if (keySpec instanceof RSAPublicKeySpec) {
                RSAPublicKeySpec rsaPubKeySpec = (RSAPublicKeySpec)keySpec;
                PKCS11Object object = null;
                byte[] ID = null;
                Boolean isToken = Boolean.FALSE;
                Boolean isVerify = Boolean.TRUE;
                Boolean isEncrypt = Boolean.TRUE;
                Boolean isWrap = Boolean.TRUE;
                BigInteger modulus = rsaPubKeySpec.getModulus();
                Integer modulusBits = new Integer(String.valueOf(rsaPubKeySpec.getModulus().toByteArray().length * 8));
                BigInteger publicExponent = rsaPubKeySpec.getPublicExponent();
                ID = this.genID();
                int[] attrTypes = new int[]{0, 256, 258, 1, 266, 260, 262, 288, 290};
                Object[] attrValues = new Object[]{PKCS11Object.PUBLIC_KEY, PKCS11Object.RSA, ID, isToken, isVerify, isEncrypt, isWrap, modulus, publicExponent};
                object = this.session.createObject(attrTypes, attrValues);
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "engineGeneratePublic_1");
                }
                return new RSAPublicKey(object, ID, null, null, isToken, isVerify, isEncrypt, isWrap, modulus, modulusBits, publicExponent);
            }
            if (keySpec instanceof X509EncodedKeySpec) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "engineGeneratePublic_2");
                }
                return new RSAPublicKey(((X509EncodedKeySpec)keySpec).getEncoded());
            }
            if (keySpec instanceof PKCS11KeySpec) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "engineGeneratePublic_3");
                }
                PKCS11Object object = ((PKCS11KeySpec)keySpec).getObject();
                return new RSAPublicKey(object, (byte[])this.getAttrValue(object, 258), (byte[])this.getAttrValue(object, 257), (String)this.getAttrValue(object, 3), (Boolean)this.getAttrValue(object, 1), (Boolean)this.getAttrValue(object, 266), (Boolean)this.getAttrValue(object, 260), (Boolean)this.getAttrValue(object, 262), (BigInteger)this.getAttrValue(object, 288), (Integer)this.getAttrValue(object, 289), (BigInteger)this.getAttrValue(object, 290));
            }
            if (debug != null) {
                debug.text(16384L, (Object)className, "engineGeneratePublic", "Inappropriate key specification");
                debug.exit(16384L, (Object)className, "engineGeneratePublic");
            }
            throw new InvalidKeySpecException("Inappropriate key specification");
        }
        catch (InvalidKeyException e) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineGeneratePublic", (Throwable)e);
                debug.exit(16384L, (Object)className, "engineGeneratePublic");
            }
            throw new InvalidKeySpecException("Inappropriate key specification: " + e.getMessage());
        }
    }

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineGeneratePrivate", (Object)keySpec);
        }
        try {
            PKCS11Object object = null;
            byte[] ID = null;
            Boolean isToken = Boolean.FALSE;
            Boolean isSensitive = Boolean.FALSE;
            Boolean isSign = Boolean.TRUE;
            Boolean isDecrypt = Boolean.TRUE;
            Boolean isUnwrap = Boolean.TRUE;
            Boolean isExtractable = null;
            BigInteger modulus = null;
            BigInteger publicExponent = null;
            BigInteger privateExponent = null;
            BigInteger prime1 = null;
            BigInteger prime2 = null;
            BigInteger exponent1 = null;
            BigInteger exponent2 = null;
            BigInteger coefficient = null;
            if (keySpec instanceof RSAPrivateCrtKeySpec) {
                RSAPrivateCrtKeySpec rsaPrivKeySpec = (RSAPrivateCrtKeySpec)keySpec;
                ID = this.genID();
                modulus = rsaPrivKeySpec.getModulus();
                publicExponent = rsaPrivKeySpec.getPublicExponent();
                privateExponent = rsaPrivKeySpec.getPrivateExponent();
                prime1 = rsaPrivKeySpec.getPrimeP();
                prime2 = rsaPrivKeySpec.getPrimeQ();
                exponent1 = rsaPrivKeySpec.getPrimeExponentP();
                exponent2 = rsaPrivKeySpec.getPrimeExponentQ();
                coefficient = rsaPrivKeySpec.getCrtCoefficient();
                if (debug != null) {
                    debug.text(16384L, (Object)className, "engineGeneratePrivate", "Modulus: " + modulus);
                    debug.text(16384L, (Object)className, "engineGeneratePrivate", "publicExponent: " + publicExponent);
                    debug.text(16384L, (Object)className, "engineGeneratePrivate", "privateExponent: " + privateExponent);
                    debug.text(16384L, (Object)className, "engineGeneratePrivate", "prime1: " + prime1);
                    debug.text(16384L, (Object)className, "engineGeneratePrivate", "prime2: " + prime2);
                    debug.text(16384L, (Object)className, "engineGeneratePrivate", "exponent1: " + exponent1);
                    debug.text(16384L, (Object)className, "engineGeneratePrivate", "exponent2: " + exponent2);
                    debug.text(16384L, (Object)className, "engineGeneratePrivate", "coefficient: " + coefficient);
                    debug.text(16384L, (Object)className, "engineGeneratePrivate", "ID: " + ID);
                    debug.text(16384L, (Object)className, "engineGeneratePrivate", "isToken: " + isToken);
                    debug.text(16384L, (Object)className, "engineGeneratePrivate", "isSensitive: " + isSensitive);
                    debug.text(16384L, (Object)className, "engineGeneratePrivate", "isSign: " + isSign);
                    debug.text(16384L, (Object)className, "engineGeneratePrivate", "isDecrypt: " + isDecrypt);
                    debug.text(16384L, (Object)className, "engineGeneratePrivate", "isUnwrap: " + isUnwrap);
                }
                int[] attrTypes = new int[]{0, 256, 258, 1, 2, 259, 264, 261, 263, 288, 290, 291, 292, 293, 294, 295, 296};
                Object[] attrValues = new Object[]{PKCS11Object.PRIVATE_KEY, PKCS11Object.RSA, ID, isToken, Boolean.TRUE, isSensitive, isSign, isDecrypt, isUnwrap, modulus, publicExponent, privateExponent, prime1, prime2, exponent1, exponent2, coefficient};
                object = this.session.createObject(attrTypes, attrValues);
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "engineGeneratePrivate_1");
                }
                return new RSAPrivateKey(object, ID, null, null, isToken, isSensitive, isSign, isDecrypt, isUnwrap, isExtractable, modulus, publicExponent, privateExponent, prime1, prime2, exponent1, exponent2, coefficient);
            }
            if (keySpec instanceof RSAPrivateKeySpec) {
                RSAPrivateKeySpec rsaPrivKeySpec = (RSAPrivateKeySpec)keySpec;
                ID = this.genID();
                modulus = rsaPrivKeySpec.getModulus();
                privateExponent = rsaPrivKeySpec.getPrivateExponent();
                if (debug != null) {
                    debug.text(16384L, (Object)className, "engineGeneratePrivate", "Modulus not CRT: " + modulus.intValue());
                    debug.text(16384L, (Object)className, "engineGeneratePrivate", "privateExponent length not CRT: " + privateExponent.bitLength());
                    debug.text(16384L, (Object)className, "engineGeneratePrivate", "privateExponent not CRT: " + privateExponent);
                }
                int[] attrTypes = new int[]{0, 256, 258, 1, 2, 259, 264, 261, 263, 288, 291};
                Object[] attrValues = new Object[]{PKCS11Object.PRIVATE_KEY, PKCS11Object.RSA, ID, isToken, Boolean.TRUE, isSensitive, isSign, isDecrypt, isUnwrap, modulus, privateExponent};
                object = this.session.createObject(attrTypes, attrValues);
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "engineGeneratePrivate_2");
                }
                return new RSAPrivateKey(object, ID, null, null, isToken, isSensitive, isSign, isDecrypt, isUnwrap, isExtractable, modulus, publicExponent, privateExponent, prime1, prime2, exponent1, exponent2, coefficient);
            }
            if (keySpec instanceof PKCS11KeySpec) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "engineGeneratePublic_3");
                }
                object = ((PKCS11KeySpec)keySpec).getObject();
                return new RSAPrivateKey(object, (byte[])this.getAttrValue(object, 258), (byte[])this.getAttrValue(object, 257), (String)this.getAttrValue(object, 3), (Boolean)this.getAttrValue(object, 1), (Boolean)this.getAttrValue(object, 259), (Boolean)this.getAttrValue(object, 264), (Boolean)this.getAttrValue(object, 261), (Boolean)this.getAttrValue(object, 263), (Boolean)this.getAttrValue(object, 354), (BigInteger)this.getAttrValue(object, 288), (BigInteger)this.getAttrValue(object, 290), (BigInteger)this.getAttrValue(object, 291), (BigInteger)this.getAttrValue(object, 292), (BigInteger)this.getAttrValue(object, 293), (BigInteger)this.getAttrValue(object, 294), (BigInteger)this.getAttrValue(object, 295), (BigInteger)this.getAttrValue(object, 296));
            }
            if (debug != null) {
                debug.text(16384L, (Object)className, "engineGeneratePrivate", "Inappropriate key specification");
                debug.exit(16384L, (Object)className, "engineGeneratePrivate");
            }
            throw new InvalidKeySpecException("Inappropriate key specification");
        }
        catch (InvalidKeyException e) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineGeneratePrivate", (Throwable)e);
                debug.exit(16384L, (Object)className, "engineGeneratePrivate");
            }
            throw new InvalidKeySpecException("Inappropriate key specification: " + e.getMessage());
        }
    }

    protected KeySpec engineGetKeySpec(Key key, Class keySpec) throws InvalidKeySpecException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineGetKeySpec", (Object)key, (Object)keySpec);
        }
        try {
            if (key instanceof PKCS11RSAPublicKey) {
                Class<?> rsaPubKeySpec = Class.forName("java.security.spec.RSAPublicKeySpec");
                Class<?> x509KeySpec = Class.forName("java.security.spec.X509EncodedKeySpec");
                if (rsaPubKeySpec.isAssignableFrom(keySpec)) {
                    RSAPublicKey rsaPubKey = (RSAPublicKey)key;
                    if (debug != null) {
                        debug.exit(16384L, (Object)className, "engineGetKeySpec");
                    }
                    return new RSAPublicKeySpec(rsaPubKey.getModulus(), rsaPubKey.getPublicExponent());
                }
                if (x509KeySpec.isAssignableFrom(keySpec)) {
                    if (debug != null) {
                        debug.exit(16384L, (Object)className, "engineGetKeySpec_1");
                    }
                    return new X509EncodedKeySpec(key.getEncoded());
                }
                if (debug != null) {
                    debug.text(16384L, (Object)className, "engineGetKeySpec_2", "Inappropriate key specification");
                    debug.exit(16384L, (Object)className, "engineGetKeySpec_2");
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            if (key instanceof java.security.interfaces.RSAPublicKey) {
                Class<?> rsaPubKeySpec = Class.forName("java.security.spec.RSAPublicKeySpec");
                Class<?> x509KeySpec = Class.forName("java.security.spec.X509EncodedKeySpec");
                if (rsaPubKeySpec.isAssignableFrom(keySpec)) {
                    java.security.interfaces.RSAPublicKey rsaPubKey = (java.security.interfaces.RSAPublicKey)key;
                    if (debug != null) {
                        debug.exit(16384L, (Object)className, "engineGetKeySpec_3");
                    }
                    return new RSAPublicKeySpec(rsaPubKey.getModulus(), rsaPubKey.getPublicExponent());
                }
                if (x509KeySpec.isAssignableFrom(keySpec)) {
                    if (debug != null) {
                        debug.exit(16384L, (Object)className, "engineGetKeySpec_4");
                    }
                    return new X509EncodedKeySpec(key.getEncoded());
                }
                if (debug != null) {
                    debug.text(16384L, (Object)className, "engineGetKeySpec_5", "Inappropriate key specification");
                    debug.exit(16384L, (Object)className, "engineGetKeySpec_5");
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            if (key instanceof PKCS11RSAPrivateKey) {
                Class<?> rsaPrivCrtKeySpec = Class.forName("java.security.spec.RSAPrivateCrtKeySpec");
                Class<?> rsaPrivKeySpec = Class.forName("java.security.spec.RSAPrivateKeySpec");
                if (rsaPrivCrtKeySpec.isAssignableFrom(keySpec)) {
                    RSAPrivateKey rsaPrivCrtKey = (RSAPrivateKey)key;
                    if (rsaPrivCrtKey.getSensitive().booleanValue()) {
                        if (debug != null) {
                            debug.text(16384L, (Object)className, "engineGetKeySpec_6", "Private key value is not exportable");
                            debug.exit(16384L, (Object)className, "engineGetKeySpec_6");
                        }
                        throw new PKCS11Exception("Private key value is not exportable");
                    }
                    if (debug != null) {
                        debug.exit(16384L, (Object)className, "engineGetKeySpec_7");
                    }
                    return new RSAPrivateCrtKeySpec(rsaPrivCrtKey.getModulus(), rsaPrivCrtKey.getPublicExponent(), rsaPrivCrtKey.getPrivateExponent(), rsaPrivCrtKey.getPrime1(), rsaPrivCrtKey.getPrime2(), rsaPrivCrtKey.getExponent1(), rsaPrivCrtKey.getExponent2(), rsaPrivCrtKey.getCoefficient());
                }
                if (rsaPrivKeySpec.isAssignableFrom(keySpec)) {
                    RSAPrivateKey rsaPrivKey = (RSAPrivateKey)key;
                    if (rsaPrivKey.getSensitive().booleanValue()) {
                        if (debug != null) {
                            debug.text(16384L, (Object)className, "engineGetKeySpec_8", "Private key value is not exportable");
                            debug.exit(16384L, (Object)className, "engineGetKeySpec_8");
                        }
                        throw new PKCS11Exception("Private key value is not exportable");
                    }
                    if (debug != null) {
                        debug.exit(16384L, (Object)className, "engineGetKeySpec_9");
                    }
                    return new RSAPrivateKeySpec(rsaPrivKey.getModulus(), rsaPrivKey.getPrivateExponent());
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            if (key instanceof RSAPrivateCrtKey) {
                Class<?> rsaPrivCrtKeySpec = Class.forName("java.security.spec.RSAPrivateCrtKeySpec");
                if (rsaPrivCrtKeySpec.isAssignableFrom(keySpec)) {
                    RSAPrivateCrtKey rsaPrivCrtKey = (RSAPrivateCrtKey)key;
                    if (debug != null) {
                        debug.exit(16384L, (Object)className, "engineGetKeySpec_10");
                    }
                    return new RSAPrivateCrtKeySpec(rsaPrivCrtKey.getModulus(), rsaPrivCrtKey.getPublicExponent(), rsaPrivCrtKey.getPrivateExponent(), rsaPrivCrtKey.getPrimeP(), rsaPrivCrtKey.getPrimeQ(), rsaPrivCrtKey.getPrimeExponentP(), rsaPrivCrtKey.getPrimeExponentQ(), rsaPrivCrtKey.getCrtCoefficient());
                }
                if (debug != null) {
                    debug.text(16384L, (Object)className, "engineGetKeySpec_11", "Inappropriate key specification");
                    debug.exit(16384L, (Object)className, "engineGetKeySpec_11");
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            if (key instanceof java.security.interfaces.RSAPrivateKey) {
                Class<?> rsaPrivKeySpec = Class.forName("java.security.spec.RSAPrivateKeySpec");
                if (rsaPrivKeySpec.isAssignableFrom(keySpec)) {
                    java.security.interfaces.RSAPrivateKey rsaPrivKey = (java.security.interfaces.RSAPrivateKey)key;
                    if (debug != null) {
                        debug.exit(16384L, (Object)className, "engineGetKeySpec_12");
                    }
                    return new RSAPrivateKeySpec(rsaPrivKey.getModulus(), rsaPrivKey.getPrivateExponent());
                }
                if (debug != null) {
                    debug.text(16384L, (Object)className, "engineGetKeySpec_13", "Inappropriate key specification");
                    debug.exit(16384L, (Object)className, "engineGetKeySpec_13");
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            if (debug != null) {
                debug.text(16384L, (Object)className, "engineGetKeySpec_14", "Inappropriate key type");
                debug.exit(16384L, (Object)className, "engineGetKeySpec_14");
            }
            throw new InvalidKeySpecException("Inappropriate key type");
        }
        catch (ClassNotFoundException e) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineGetKeySpec", (Throwable)e);
                debug.exit(16384L, (Object)className, "engineGetKeySpec");
            }
            throw new InvalidKeySpecException("Unsupported key specification: " + e.getMessage());
        }
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineTranslateKey", (Object)key);
        }
        try {
            if (key instanceof java.security.interfaces.RSAPublicKey) {
                if (key instanceof RSAPublicKey) {
                    return key;
                }
                RSAPublicKeySpec rsaPubKeySpec = (RSAPublicKeySpec)this.engineGetKeySpec(key, class$java$security$spec$RSAPublicKeySpec == null ? (class$java$security$spec$RSAPublicKeySpec = RSAPKCS11KeyFactory.class$("java.security.spec.RSAPublicKeySpec")) : class$java$security$spec$RSAPublicKeySpec);
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "engineTranslateKey", (Object)"RSAPublicKey");
                }
                return this.engineGeneratePublic(rsaPubKeySpec);
            }
            if (key instanceof RSAPrivateCrtKey) {
                if (key instanceof RSAPrivateKey) {
                    return key;
                }
                RSAPrivateKeySpec rsaPrivKeySpec = (RSAPrivateKeySpec)this.engineGetKeySpec(key, class$java$security$spec$RSAPrivateCrtKeySpec == null ? (class$java$security$spec$RSAPrivateCrtKeySpec = RSAPKCS11KeyFactory.class$("java.security.spec.RSAPrivateCrtKeySpec")) : class$java$security$spec$RSAPrivateCrtKeySpec);
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "engineTranslateKey", (Object)"RSAPrivateCrtKey");
                }
                return this.engineGeneratePrivate(rsaPrivKeySpec);
            }
            if (key instanceof java.security.interfaces.RSAPrivateKey) {
                if (key instanceof RSAPrivateKey) {
                    return key;
                }
                RSAPrivateKeySpec rsaPrivKeySpec = (RSAPrivateKeySpec)this.engineGetKeySpec(key, class$java$security$spec$RSAPrivateKeySpec == null ? (class$java$security$spec$RSAPrivateKeySpec = RSAPKCS11KeyFactory.class$("java.security.spec.RSAPrivateKeySpec")) : class$java$security$spec$RSAPrivateKeySpec);
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "engineTranslateKey", (Object)"RSAPrivateKey");
                }
                return this.engineGeneratePrivate(rsaPrivKeySpec);
            }
            if (debug != null) {
                debug.text(16384L, (Object)className, "engineTranslateKey", "Wrong algorithm type");
                debug.exit(16384L, (Object)className, "engineTranslateKey");
            }
            throw new InvalidKeyException("Wrong algorithm type");
        }
        catch (InvalidKeySpecException e) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineTranslateKey", (Throwable)e);
                debug.exit(16384L, (Object)className, "engineTranslateKey");
            }
            throw new InvalidKeyException("Cannot translate key: " + e.getMessage());
        }
    }

    private byte[] genID() {
        byte[] labelName = new byte[33];
        byte[] labelSaltData = new byte[24];
        byte[] labelTmp = null;
        int labelLength = 0;
        try {
            SecureRandom random = SecureRandom.getInstance("IBMSecureRandom", "IBMPKCS11Impl");
            random.nextBytes(labelSaltData);
        }
        catch (Exception e) {
            // empty catch block
        }
        BigInteger bigInt = new BigInteger(1, labelSaltData);
        try {
            labelTmp = bigInt.toString().getBytes("8859_1");
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError("Can not convert string");
        }
        labelLength = bigInt.toString().length();
        if (labelLength > 24) {
            labelLength = 24;
        }
        System.arraycopy(labelTmp, 0, labelName, 9, labelLength);
        labelName[0] = 73;
        labelName[1] = 66;
        labelName[2] = 77;
        labelName[3] = 80;
        labelName[4] = 75;
        labelName[5] = 67;
        labelName[6] = 83;
        labelName[7] = 49;
        labelName[8] = 49;
        return labelName;
    }

    private Object getAttrValue(PKCS11Object pkcs11obj, int attr) {
        Object rtn;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getValue", (Object)pkcs11obj, (Object)new Integer(attr));
        }
        try {
            rtn = pkcs11obj.getAttributeValue(attr);
        }
        catch (Exception e) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "getValue", e.getMessage());
            }
            rtn = null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getValue");
        }
        return rtn;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

