/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.PKCS11RSAKeyPairParameterSpec;
import com.ibm.crypto.pkcs11impl.provider.RSAPrivateKey;
import com.ibm.crypto.pkcs11impl.provider.RSAPublicKey;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.pkcs11.PKCS11Session;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public final class RSAPKCS11KeyPairGenerator
extends KeyPairGeneratorSpi {
    private int modlen = 1024;
    private PKCS11Session session = null;
    private byte[] id = null;
    private byte[] subject = null;
    private String label = null;
    private Boolean isToken = new Boolean(false);
    private Boolean isSensitive = new Boolean(false);
    private Boolean sign = new Boolean(true);
    private Boolean encrypt = new Boolean(true);
    private Boolean wrapping = new Boolean(true);
    private Boolean extractable = null;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.RSAPKCS11KeyPairGenerator";

    public RSAPKCS11KeyPairGenerator() {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "RSAPKCS11KeyPairGenerator");
        }
        this.session = IBMPKCS11Impl.session;
        if (debug != null) {
            debug.exit(16384L, (Object)className, "RSAPKCS11KeyPairGenerator");
        }
    }

    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "initialize", (Object)params, (Object)random);
        }
        if (params == null || !(params instanceof PKCS11RSAKeyPairParameterSpec)) {
            throw new InvalidAlgorithmParameterException("PKCS11 RSA KeyPair Parameters must be specified");
        }
        PKCS11RSAKeyPairParameterSpec spec = (PKCS11RSAKeyPairParameterSpec)params;
        this.modlen = spec.getStrength();
        if (spec.getKeyID() != null) {
            try {
                this.id = spec.getKeyID().getBytes("8859_1");
            }
            catch (Exception e) {
                this.id = spec.getKeyID().getBytes();
            }
        }
        if (spec.getSubject() != null) {
            try {
                this.subject = spec.getSubject().getBytes("8859_1");
            }
            catch (Exception e) {
                this.subject = spec.getSubject().getBytes();
            }
        }
        this.label = spec.getLabel();
        this.isSensitive = spec.getSensitive();
        this.isToken = spec.getToken();
        this.sign = spec.getSign();
        this.encrypt = spec.getEncrypt();
        this.wrapping = spec.getWrap();
        this.extractable = spec.getExtractable();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "initialize");
        }
    }

    public void initialize(int strength, SecureRandom random) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "initialize", (Object)(" " + strength), (Object)random);
            debug.exit(16384L, (Object)className, "initialize");
        }
        throw new UnsupportedOperationException("Parameters must be specified");
    }

    public void initialize(int strength) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "initialize", (Object)(" " + strength));
            debug.exit(16384L, (Object)className, "initialize");
        }
        throw new UnsupportedOperationException("Parameters must be specified");
    }

    public KeyPair generateKeyPair() {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "generateKeyPair");
        }
        int sizePubArray = 9;
        int sizePrivArray = 9;
        int count = 0;
        if (this.isToken == null) {
            --sizePrivArray;
            --sizePubArray;
        }
        if (this.isSensitive == null) {
            --sizePrivArray;
        }
        if (this.sign == null) {
            --sizePubArray;
            --sizePrivArray;
        }
        if (this.encrypt == null) {
            --sizePubArray;
            --sizePrivArray;
        }
        if (this.wrapping == null) {
            --sizePubArray;
            --sizePrivArray;
        }
        if (this.extractable == null) {
            --sizePrivArray;
        }
        int[] pubTypes = new int[sizePubArray];
        Object[] pubValues = new Object[sizePubArray];
        pubTypes[count] = 289;
        pubValues[count++] = new Integer(this.modlen);
        pubTypes[count] = 290;
        pubValues[count++] = new BigInteger("65537");
        pubTypes[count] = 258;
        pubValues[count++] = this.id;
        pubTypes[count] = 257;
        pubValues[count++] = this.subject;
        pubTypes[count] = 3;
        pubValues[count++] = this.label;
        if (this.isToken != null) {
            pubTypes[count] = 1;
            pubValues[count++] = this.isToken;
        }
        if (this.sign != null) {
            pubTypes[count] = 266;
            pubValues[count++] = this.sign;
        }
        if (this.encrypt != null) {
            pubTypes[count] = 260;
            pubValues[count++] = this.encrypt;
        }
        if (this.wrapping != null) {
            pubTypes[count] = 262;
            pubValues[count++] = this.wrapping;
        }
        int[] privTypes = new int[sizePrivArray];
        Object[] privValues = new Object[sizePrivArray];
        count = 0;
        privTypes[count] = 258;
        privValues[count++] = this.id;
        privTypes[count] = 257;
        privValues[count++] = this.subject;
        privTypes[count] = 3;
        privValues[count++] = this.label;
        if (this.isToken != null) {
            privTypes[count] = 1;
            privValues[count++] = this.isToken;
        }
        if (this.isSensitive != null) {
            privTypes[count] = 259;
            privValues[count++] = this.isSensitive;
        }
        if (this.encrypt != null) {
            privTypes[count] = 261;
            privValues[count++] = this.encrypt;
        }
        if (this.sign != null) {
            privTypes[count] = 264;
            privValues[count++] = this.sign;
        }
        if (this.wrapping != null) {
            privTypes[count] = 263;
            privValues[count++] = this.wrapping;
        }
        if (this.extractable != null) {
            privTypes[count] = 354;
            privValues[count] = this.extractable;
        }
        String error = "";
        PKCS11Object[] objs = null;
        KeyPair pair = null;
        try {
            objs = this.session.generateKeyPair(0, null, pubTypes, pubValues, privTypes, privValues);
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "generateKeyPair_1", (Throwable)e);
            }
            throw new RuntimeException(e.getMessage());
        }
        PKCS11Object[] returnobjs = this.orderObjects(objs);
        PKCS11Object pubObj = returnobjs[0];
        PKCS11Object privObj = returnobjs[1];
        try {
            RSAPublicKey pubKey = new RSAPublicKey(pubObj, this.id, this.subject, this.label, this.isToken, this.sign, this.encrypt, this.wrapping, (BigInteger)this.getValue(pubObj, 288), (Integer)this.getValue(pubObj, 289), (BigInteger)this.getValue(pubObj, 290));
            RSAPrivateKey privKey = null;
            if (this.isSensitive.booleanValue()) {
                privKey = new RSAPrivateKey(privObj, this.id, this.subject, this.label, this.isToken, this.isSensitive, this.sign, this.encrypt, this.wrapping, this.extractable, (BigInteger)this.getValue(privObj, 288), (BigInteger)this.getValue(privObj, 290));
            } else {
                try {
                    privKey = new RSAPrivateKey(privObj, this.id, this.subject, this.label, this.isToken, this.isSensitive, this.sign, this.encrypt, this.wrapping, this.extractable, (BigInteger)this.getValue(privObj, 288), (BigInteger)this.getValue(privObj, 290), (BigInteger)this.getValue(privObj, 291), (BigInteger)this.getValue(privObj, 292), (BigInteger)this.getValue(privObj, 293), (BigInteger)this.getValue(privObj, 294), (BigInteger)this.getValue(privObj, 295), (BigInteger)this.getValue(privObj, 296));
                }
                catch (Exception ex) {
                    if (debug != null) {
                        debug.exception(16384L, (Object)className, "generateKeyPair_2", (Throwable)ex);
                    }
                    privKey = new RSAPrivateKey(privObj, this.id, this.subject, this.label, this.isToken, this.isSensitive, this.sign, this.encrypt, this.wrapping, this.extractable, (BigInteger)this.getValue(privObj, 288), (BigInteger)this.getValue(privObj, 290));
                }
            }
            pair = new KeyPair(pubKey, privKey);
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "generateKeyPair_3", (Throwable)e);
            }
            pair = null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "generateKeyPair");
        }
        return pair;
    }

    private PKCS11Object[] orderObjects(PKCS11Object[] objs) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "orderObjects", (Object[])objs);
        }
        Integer objsType0 = (Integer)this.getValue(objs[0], 0);
        Integer objsType1 = (Integer)this.getValue(objs[1], 0);
        PKCS11Object privObj = null;
        PKCS11Object pubObj = null;
        if (objsType0.equals(PKCS11Object.PUBLIC_KEY) && objsType1.equals(PKCS11Object.PRIVATE_KEY)) {
            pubObj = objs[0];
            privObj = objs[1];
        } else if (objsType0.equals(PKCS11Object.PRIVATE_KEY) && objsType1.equals(PKCS11Object.PUBLIC_KEY)) {
            pubObj = objs[1];
            privObj = objs[0];
        } else {
            if (debug != null) {
                debug.text(16384L, (Object)className, "orderObjects", "Token returns invalid objects");
            }
            throw new RuntimeException("Token returns invalid objects");
        }
        objs[0] = pubObj;
        objs[1] = privObj;
        if (debug != null) {
            debug.exit(16384L, (Object)className, "orderObjects", (Object)objs);
        }
        return objs;
    }

    private Object getValue(PKCS11Object pkcs11obj, int attr) {
        Object rtn;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getValue", (Object)pkcs11obj, (Object)new Integer(attr));
        }
        try {
            rtn = pkcs11obj.getAttributeValue(attr);
        }
        catch (Exception e) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "getValue", e.getMessage());
            }
            rtn = null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getValue");
        }
        return rtn;
    }
}

