/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.PKCS11RSAPublicKey;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.pkcs11.PKCS11Session;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgIdRSA;
import com.ibm.security.x509.X509Key;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.SecureRandom;
import java.util.Date;

public final class RSAPublicKey
extends X509Key
implements PKCS11RSAPublicKey,
Serializable {
    private PKCS11Object object = null;
    static final long serialVersionUID = 8371797842697540042L;
    private Boolean isToken = null;
    private Boolean isPrivate = null;
    private String label = null;
    private Boolean isModifiable = null;
    private Integer keyType = PKCS11Object.RSA;
    private byte[] ID = null;
    private Date startDate = null;
    private Date endDate = null;
    private Boolean isDerive = null;
    private Boolean isLocal = null;
    private byte[] subject = null;
    private Boolean isEncrypt = null;
    private Boolean isVerify = null;
    private Boolean isVerifyRecover = null;
    private Boolean isWrap = null;
    private BigInteger modulus = null;
    private Integer modulusBits = null;
    private BigInteger publicExponent = null;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.RSAPublicKey";

    RSAPublicKey(PKCS11Object object, byte[] ID, byte[] subject, String label, Boolean isToken, Boolean isVerify, Boolean isEncrypt, Boolean isWrap) throws InvalidKeyException {
        this.object = object;
        if (ID != null) {
            this.ID = new byte[ID.length];
            System.arraycopy(ID, 0, this.ID, 0, ID.length);
        } else {
            this.ID = (byte[])this.getValue(this.object, 258);
        }
        if (subject != null) {
            this.subject = new byte[subject.length];
            System.arraycopy(subject, 0, this.subject, 0, subject.length);
        } else {
            this.subject = (byte[])this.getValue(this.object, 257);
        }
        this.label = label != null ? new String(label) : (String)this.getValue(this.object, 3);
        this.isToken = isToken != null ? new Boolean(isToken) : (Boolean)this.getValue(this.object, 1);
        this.isVerify = isVerify != null ? new Boolean(isVerify) : (Boolean)this.getValue(this.object, 266);
        this.isEncrypt = isEncrypt != null ? new Boolean(isEncrypt) : (Boolean)this.getValue(this.object, 260);
        this.isWrap = isWrap != null ? new Boolean(isWrap) : (Boolean)this.getValue(this.object, 262);
        this.isPrivate = (Boolean)this.getValue(this.object, 2);
        this.isModifiable = (Boolean)this.getValue(this.object, 368);
        this.startDate = (Date)this.getValue(this.object, 272);
        this.endDate = (Date)this.getValue(this.object, 273);
        this.isDerive = (Boolean)this.getValue(this.object, 268);
        this.isLocal = (Boolean)this.getValue(this.object, 355);
        this.isVerifyRecover = (Boolean)this.getValue(this.object, 267);
    }

    RSAPublicKey(PKCS11Object object, byte[] ID, byte[] subject, String label, Boolean isToken, Boolean isVerify, Boolean isEncrypt, Boolean isWrap, BigInteger modulus, Integer modulusBits, BigInteger publicExponent) throws InvalidKeyException {
        this(object, ID, subject, label, isToken, isVerify, isEncrypt, isWrap);
        if (modulus != null) {
            this.modulus = new BigInteger(modulus.toByteArray());
        }
        if (modulusBits != null) {
            this.modulusBits = new Integer(modulusBits);
        }
        if (publicExponent != null) {
            this.publicExponent = new BigInteger(publicExponent.toByteArray());
        }
        this.algid = new AlgIdRSA();
        try {
            DerValue[] value = new DerValue[]{new DerValue(2, this.modulus.toByteArray()), new DerValue(2, this.publicExponent.toByteArray())};
            DerOutputStream out = new DerOutputStream();
            out.putSequence(value);
            this.key = out.toByteArray();
            this.encode();
        }
        catch (IOException e) {
            throw new InvalidKeyException("could not DER encode: " + e.getMessage());
        }
    }

    RSAPublicKey(byte[] encoded) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "RSAPublicKey", (Object)encoded);
        }
        this.decode(encoded);
        this.label = this.genLabel();
        int[] attrTypes = new int[]{0, 256, 3, 1, 266, 260, 262, 288, 290};
        Object[] attrValues = new Object[]{PKCS11Object.PUBLIC_KEY, PKCS11Object.RSA, this.label, Boolean.FALSE, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, this.modulus, this.publicExponent};
        PKCS11Session session = IBMPKCS11Impl.session;
        this.object = session.createObject(attrTypes, attrValues);
        this.subject = (byte[])this.getValue(this.object, 257);
        this.ID = (byte[])this.getValue(this.object, 258);
        this.isToken = (Boolean)this.getValue(this.object, 1);
        this.isVerify = (Boolean)this.getValue(this.object, 266);
        this.isEncrypt = (Boolean)this.getValue(this.object, 260);
        this.isWrap = (Boolean)this.getValue(this.object, 262);
        this.isPrivate = (Boolean)this.getValue(this.object, 2);
        this.isModifiable = (Boolean)this.getValue(this.object, 368);
        this.startDate = (Date)this.getValue(this.object, 272);
        this.endDate = (Date)this.getValue(this.object, 273);
        this.isDerive = (Boolean)this.getValue(this.object, 268);
        this.isLocal = (Boolean)this.getValue(this.object, 355);
        this.isVerifyRecover = (Boolean)this.getValue(this.object, 267);
        this.modulusBits = (Integer)this.getValue(this.object, 289);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "RSAPublicKey");
        }
    }

    protected void parseKeyBits() throws InvalidKeyException {
        if (debug != null) {
            debug.exit(16384L, (Object)className, "parseKeyBits");
        }
        try {
            DerInputStream in = new DerInputStream(this.key);
            DerValue[] value = in.getSequence(2);
            this.modulus = value[0].getInteger();
            this.publicExponent = value[1].getInteger();
        }
        catch (Exception e) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "parseKeyBits", "Invalid key value");
            }
            throw new InvalidKeyException("Invalid key value \n" + e.getMessage());
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "parseKeyBits");
        }
    }

    public PKCS11Object getObject() {
        return this.object;
    }

    public Boolean getToken() {
        return new Boolean(this.isToken);
    }

    public Boolean getPrivate() {
        return new Boolean(this.isPrivate);
    }

    public String getLabel() {
        return this.label;
    }

    public Boolean getModifiable() {
        return new Boolean(this.isModifiable);
    }

    public Integer getKeyType() {
        return this.keyType;
    }

    public byte[] getID() {
        return (byte[])this.ID.clone();
    }

    public Date getStartDate() {
        if (this.startDate != null) {
            return (Date)this.startDate.clone();
        }
        return null;
    }

    public Date getEndDate() {
        if (this.endDate != null) {
            return (Date)this.endDate.clone();
        }
        return null;
    }

    public Boolean getDerive() {
        return new Boolean(this.isDerive);
    }

    public Boolean getLocal() {
        return new Boolean(this.isLocal);
    }

    public byte[] getSubject() {
        return (byte[])this.subject.clone();
    }

    public Boolean getEncrypt() {
        return new Boolean(this.isEncrypt);
    }

    public Boolean getVerify() {
        return new Boolean(this.isVerify);
    }

    public Boolean getVerifyRecover() {
        return new Boolean(this.isVerifyRecover);
    }

    public Boolean getWrap() {
        return new Boolean(this.isWrap);
    }

    public BigInteger getModulus() {
        return this.modulus;
    }

    public Integer getModulusBits() {
        return this.modulusBits;
    }

    public BigInteger getPublicExponent() {
        return this.publicExponent;
    }

    public String toString() {
        String prov = "IBMPKCS11Impl";
        String output = prov + " RSA Public Key: ";
        if (this.isToken != null) {
            output = output + "\n Token: " + this.isToken;
        }
        if (this.isPrivate != null) {
            output = output + "\n Private: " + this.isPrivate;
        }
        if (this.label != null) {
            output = output + "\n Label: " + this.label;
        }
        if (this.isModifiable != null) {
            output = output + "\n Modifiable: " + this.isModifiable;
        }
        output = output + "\n KeyType: " + this.keyType.toString();
        if (this.ID != null) {
            output = output + "\n ID: " + new String(this.ID);
        }
        if (this.startDate != null) {
            output = output + "\n Start Date: " + this.startDate.toString();
        }
        if (this.endDate != null) {
            output = output + "\n End Date: " + this.endDate.toString();
        }
        if (this.isDerive != null) {
            output = output + "\n Derive: " + this.isDerive;
        }
        if (this.isLocal != null) {
            output = output + "\n Local: " + this.isLocal;
        }
        if (this.subject != null) {
            output = output + "\n Subject: " + new String(this.subject);
        }
        if (this.isEncrypt != null) {
            output = output + "\n Encrypt: " + this.isEncrypt;
        }
        if (this.isVerify != null) {
            output = output + "\n Verify: " + this.isVerify;
        }
        if (this.isVerifyRecover != null) {
            output = output + "\n VerifyRecover: " + this.isVerifyRecover;
        }
        if (this.isWrap != null) {
            output = output + "\n Wrap: " + this.isWrap;
        }
        if (this.modulus != null) {
            output = output + "\n modulus: " + this.modulus.toString();
        }
        if (this.modulusBits != null) {
            output = output + "\n modulus bits: " + this.modulusBits.toString();
        }
        if (this.publicExponent != null) {
            output = output + "\n public exponent: " + this.publicExponent.toString();
        }
        return output;
    }

    public String getFormat() {
        return "PKCS#11";
    }

    public String getAlgorithm() {
        return "RSA";
    }

    private Object getValue(PKCS11Object pkcs11obj, int attr) {
        Object rtn;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getValue", (Object)pkcs11obj, (Object)new Integer(attr));
        }
        try {
            rtn = pkcs11obj.getAttributeValue(attr);
        }
        catch (Exception e) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "getValue", e.getMessage());
            }
            rtn = null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getValue");
        }
        return rtn;
    }

    private String genLabel() {
        byte[] labelName = new byte[33];
        byte[] labelSaltData = new byte[24];
        byte[] labelTmp = null;
        int labelLength = 0;
        try {
            SecureRandom random = SecureRandom.getInstance("IBMSecureRandom", "IBMPKCS11Impl");
            random.nextBytes(labelSaltData);
        }
        catch (Exception e) {
            // empty catch block
        }
        BigInteger bigInt = new BigInteger(1, labelSaltData);
        try {
            labelTmp = bigInt.toString().getBytes("8859_1");
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError("Can not convert string");
        }
        labelLength = bigInt.toString().length();
        if (labelLength > 24) {
            labelLength = 24;
        }
        System.arraycopy(labelTmp, 0, labelName, 9, labelLength);
        labelName[0] = 73;
        labelName[1] = 66;
        labelName[2] = 77;
        labelName[3] = 80;
        labelName[4] = 75;
        labelName[5] = 67;
        labelName[6] = 83;
        labelName[7] = 49;
        labelName[8] = 49;
        String label = null;
        try {
            label = new String(labelName, "8859_1");
        }
        catch (UnsupportedEncodingException e) {
            label = new String(labelName);
        }
        return label;
    }
}

